/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.zipio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.zipio.ZioEntryInputStream;
import kellinwood.zipio.ZioEntryOutputStream;
import kellinwood.zipio.ZipInput;
import kellinwood.zipio.ZipOutput;

public class ZioEntry
implements Cloneable {
    private ZipInput zipInput;
    private short versionMadeBy;
    private short versionRequired;
    private short generalPurposeBits;
    private short compression;
    private short modificationTime;
    private short modificationDate;
    private int crc32;
    private int compressedSize;
    private int size;
    private String filename;
    private byte[] extraData;
    private short numAlignBytes = 0;
    private String fileComment;
    private short diskNumberStart;
    private short internalAttributes;
    private int externalAttributes;
    private int localHeaderOffset;
    private long dataPosition = -1L;
    private byte[] data = null;
    private ZioEntryOutputStream entryOut = null;
    private static byte[] alignBytes = new byte[4];
    private static LoggerInterface log;

    public ZioEntry(ZipInput input) {
        this.zipInput = input;
    }

    public static LoggerInterface getLogger() {
        if (log == null) {
            log = LoggerManager.getLogger((String)ZioEntry.class.getName());
        }
        return log;
    }

    public ZioEntry(String name) {
        this.filename = name;
        this.fileComment = "";
        this.compression = (short)8;
        this.extraData = new byte[0];
        this.setTime(System.currentTimeMillis());
    }

    public ZioEntry(String name, String sourceDataFile) throws IOException {
        this.zipInput = new ZipInput(sourceDataFile);
        this.filename = name;
        this.fileComment = "";
        this.compression = 0;
        this.compressedSize = this.size = (int)this.zipInput.getFileLength();
        if (ZioEntry.getLogger().isDebugEnabled()) {
            ZioEntry.getLogger().debug(String.format("Computing CRC for %s, size=%d", sourceDataFile, this.size));
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8096];
        int numRead = 0;
        while (numRead != this.size) {
            int count = this.zipInput.read(buffer, 0, Math.min(buffer.length, this.size - numRead));
            if (count <= 0) continue;
            crc.update(buffer, 0, count);
            numRead += count;
        }
        this.crc32 = (int)crc.getValue();
        this.zipInput.seek(0L);
        this.dataPosition = 0L;
        this.extraData = new byte[0];
        this.setTime(new File(sourceDataFile).lastModified());
    }

    public ZioEntry(String name, String sourceDataFile, short compression, int crc32, int compressedSize, int size) throws IOException {
        this.zipInput = new ZipInput(sourceDataFile);
        this.filename = name;
        this.fileComment = "";
        this.compression = compression;
        this.crc32 = crc32;
        this.compressedSize = compressedSize;
        this.size = size;
        this.dataPosition = 0L;
        this.extraData = new byte[0];
        this.setTime(new File(sourceDataFile).lastModified());
    }

    public ZioEntry getClonedEntry(String newName) {
        ZioEntry clone;
        try {
            clone = (ZioEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("clone() failed!");
        }
        clone.setName(newName);
        return clone;
    }

    public void readLocalHeader() throws IOException {
        int signature;
        ZipInput input = this.zipInput;
        boolean debug = ZioEntry.getLogger().isDebugEnabled();
        input.seek(this.localHeaderOffset);
        if (debug) {
            ZioEntry.getLogger().debug(String.format("FILE POSITION: 0x%08x", input.getFilePointer()));
        }
        if ((signature = input.readInt()) != 67324752) {
            throw new IllegalStateException(String.format("Local header not found at pos=0x%08x, file=%s", input.getFilePointer(), this.filename));
        }
        short tmpShort = input.readShort();
        if (debug) {
            log.debug(String.format("Version required: 0x%04x", tmpShort));
        }
        tmpShort = input.readShort();
        if (debug) {
            log.debug(String.format("General purpose bits: 0x%04x", tmpShort));
        }
        tmpShort = input.readShort();
        if (debug) {
            log.debug(String.format("Compression: 0x%04x", tmpShort));
        }
        tmpShort = input.readShort();
        if (debug) {
            log.debug(String.format("Modification time: 0x%04x", tmpShort));
        }
        tmpShort = input.readShort();
        if (debug) {
            log.debug(String.format("Modification date: 0x%04x", tmpShort));
        }
        int tmpInt = input.readInt();
        if (debug) {
            log.debug(String.format("CRC-32: 0x%04x", tmpInt));
        }
        tmpInt = input.readInt();
        if (debug) {
            log.debug(String.format("Compressed size: 0x%04x", tmpInt));
        }
        tmpInt = input.readInt();
        if (debug) {
            log.debug(String.format("Size: 0x%04x", tmpInt));
        }
        short fileNameLen = input.readShort();
        if (debug) {
            log.debug(String.format("File name length: 0x%04x", fileNameLen));
        }
        short extraLen = input.readShort();
        if (debug) {
            log.debug(String.format("Extra length: 0x%04x", extraLen));
        }
        String filename = input.readString(fileNameLen);
        if (debug) {
            log.debug("Filename: " + filename);
        }
        byte[] extra = input.readBytes(extraLen);
        this.dataPosition = input.getFilePointer();
        if (debug) {
            log.debug(String.format("Data position: 0x%08x", this.dataPosition));
        }
    }

    public void writeLocalEntry(ZipOutput output) throws IOException {
        long dataPos;
        short dataPosMod4;
        if (this.data == null && this.dataPosition < 0L && this.zipInput != null) {
            this.readLocalHeader();
        }
        this.localHeaderOffset = output.getFilePointer();
        boolean debug = ZioEntry.getLogger().isDebugEnabled();
        if (debug) {
            ZioEntry.getLogger().debug(String.format("Writing local header at 0x%08x - %s", this.localHeaderOffset, this.filename));
        }
        if (this.entryOut != null) {
            this.entryOut.close();
            this.size = this.entryOut.getSize();
            this.data = ((ByteArrayOutputStream)this.entryOut.getWrappedStream()).toByteArray();
            this.compressedSize = this.data.length;
            this.crc32 = this.entryOut.getCRC();
        }
        output.writeInt(67324752);
        output.writeShort(this.versionRequired);
        output.writeShort(this.generalPurposeBits);
        output.writeShort(this.compression);
        output.writeShort(this.modificationTime);
        output.writeShort(this.modificationDate);
        output.writeInt(this.crc32);
        output.writeInt(this.compressedSize);
        output.writeInt(this.size);
        output.writeShort((short)this.filename.length());
        this.numAlignBytes = 0;
        if (this.compression == 0 && (dataPosMod4 = (short)((dataPos = (long)(output.getFilePointer() + 2 + this.filename.length() + this.extraData.length)) % 4L)) > 0) {
            this.numAlignBytes = (short)(4 - dataPosMod4);
        }
        output.writeShort((short)(this.extraData.length + this.numAlignBytes));
        output.writeString(this.filename);
        output.writeBytes(this.extraData);
        if (this.numAlignBytes > 0) {
            output.writeBytes(alignBytes, 0, this.numAlignBytes);
        }
        if (debug) {
            ZioEntry.getLogger().debug(String.format("Data position 0x%08x", output.getFilePointer()));
        }
        if (this.data != null) {
            output.writeBytes(this.data);
            if (debug) {
                ZioEntry.getLogger().debug(String.format("Wrote %d bytes", this.data.length));
            }
        } else {
            int numRead;
            if (debug) {
                ZioEntry.getLogger().debug(String.format("Seeking to position 0x%08x", this.dataPosition));
            }
            this.zipInput.seek(this.dataPosition);
            int bufferSize = Math.min(this.compressedSize, 8096);
            byte[] buffer = new byte[bufferSize];
            for (long totalCount = 0L; totalCount != (long)this.compressedSize; totalCount += (long)numRead) {
                numRead = this.zipInput.in.read(buffer, 0, (int)Math.min((long)this.compressedSize - totalCount, (long)bufferSize));
                if (numRead > 0) {
                    output.writeBytes(buffer, 0, numRead);
                    if (!debug) continue;
                    ZioEntry.getLogger().debug(String.format("Wrote %d bytes", numRead));
                    continue;
                }
                throw new IllegalStateException(String.format("EOF reached while copying %s with %d bytes left to go", this.filename, (long)this.compressedSize - totalCount));
            }
        }
    }

    public static ZioEntry read(ZipInput input) throws IOException {
        int signature = input.readInt();
        if (signature != 33639248) {
            input.seek(input.getFilePointer() - 4L);
            return null;
        }
        ZioEntry entry = new ZioEntry(input);
        entry.doRead(input);
        return entry;
    }

    private void doRead(ZipInput input) throws IOException {
        boolean debug = ZioEntry.getLogger().isDebugEnabled();
        this.versionMadeBy = input.readShort();
        if (debug) {
            log.debug(String.format("Version made by: 0x%04x", this.versionMadeBy));
        }
        this.versionRequired = input.readShort();
        if (debug) {
            log.debug(String.format("Version required: 0x%04x", this.versionRequired));
        }
        this.generalPurposeBits = input.readShort();
        if (debug) {
            log.debug(String.format("General purpose bits: 0x%04x", this.generalPurposeBits));
        }
        if ((this.generalPurposeBits & 0xF7F1) != 0) {
            throw new IllegalStateException("Can't handle general purpose bits == " + String.format("0x%04x", this.generalPurposeBits));
        }
        this.compression = input.readShort();
        if (debug) {
            log.debug(String.format("Compression: 0x%04x", this.compression));
        }
        this.modificationTime = input.readShort();
        if (debug) {
            log.debug(String.format("Modification time: 0x%04x", this.modificationTime));
        }
        this.modificationDate = input.readShort();
        if (debug) {
            log.debug(String.format("Modification date: 0x%04x", this.modificationDate));
        }
        this.crc32 = input.readInt();
        if (debug) {
            log.debug(String.format("CRC-32: 0x%04x", this.crc32));
        }
        this.compressedSize = input.readInt();
        if (debug) {
            log.debug(String.format("Compressed size: 0x%04x", this.compressedSize));
        }
        this.size = input.readInt();
        if (debug) {
            log.debug(String.format("Size: 0x%04x", this.size));
        }
        short fileNameLen = input.readShort();
        if (debug) {
            log.debug(String.format("File name length: 0x%04x", fileNameLen));
        }
        short extraLen = input.readShort();
        if (debug) {
            log.debug(String.format("Extra length: 0x%04x", extraLen));
        }
        short fileCommentLen = input.readShort();
        if (debug) {
            log.debug(String.format("File comment length: 0x%04x", fileCommentLen));
        }
        this.diskNumberStart = input.readShort();
        if (debug) {
            log.debug(String.format("Disk number start: 0x%04x", this.diskNumberStart));
        }
        this.internalAttributes = input.readShort();
        if (debug) {
            log.debug(String.format("Internal attributes: 0x%04x", this.internalAttributes));
        }
        this.externalAttributes = input.readInt();
        if (debug) {
            log.debug(String.format("External attributes: 0x%08x", this.externalAttributes));
        }
        this.localHeaderOffset = input.readInt();
        if (debug) {
            log.debug(String.format("Local header offset: 0x%08x", this.localHeaderOffset));
        }
        this.filename = input.readString(fileNameLen);
        if (debug) {
            log.debug("Filename: " + this.filename);
        }
        this.extraData = input.readBytes(extraLen);
        this.fileComment = input.readString(fileCommentLen);
        if (debug) {
            log.debug("File comment: " + this.fileComment);
        }
        this.generalPurposeBits = (short)(this.generalPurposeBits & 0x800);
        if (this.size == 0) {
            this.compressedSize = 0;
            this.compression = 0;
            this.crc32 = 0;
        }
    }

    public byte[] getData() throws IOException {
        int numRead;
        if (this.data != null) {
            return this.data;
        }
        byte[] tmpdata = new byte[this.size];
        InputStream din = this.getInputStream();
        for (int count = 0; count != this.size; count += numRead) {
            numRead = din.read(tmpdata, count, this.size - count);
            if (numRead >= 0) continue;
            throw new IllegalStateException(String.format("Read failed, expecting %d bytes, got %d instead", this.size, count));
        }
        return tmpdata;
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(null);
    }

    public InputStream getInputStream(OutputStream monitorStream) throws IOException {
        if (this.entryOut != null) {
            this.entryOut.close();
            this.size = this.entryOut.getSize();
            this.data = ((ByteArrayOutputStream)this.entryOut.getWrappedStream()).toByteArray();
            this.compressedSize = this.data.length;
            this.crc32 = this.entryOut.getCRC();
            this.entryOut = null;
            ByteArrayInputStream rawis = new ByteArrayInputStream(this.data);
            if (this.compression == 0) {
                return rawis;
            }
            return new InflaterInputStream(new SequenceInputStream(rawis, new ByteArrayInputStream(new byte[1])), new Inflater(true));
        }
        ZioEntryInputStream dataStream = new ZioEntryInputStream(this);
        if (monitorStream != null) {
            dataStream.setMonitorStream(monitorStream);
        }
        if (this.compression != 0) {
            dataStream.setReturnDummyByte(true);
            return new InflaterInputStream(dataStream, new Inflater(true));
        }
        return dataStream;
    }

    public OutputStream getOutputStream() {
        this.entryOut = new ZioEntryOutputStream(this.compression, new ByteArrayOutputStream());
        return this.entryOut;
    }

    public void write(ZipOutput output) throws IOException {
        boolean debug = ZioEntry.getLogger().isDebugEnabled();
        output.writeInt(33639248);
        output.writeShort(this.versionMadeBy);
        output.writeShort(this.versionRequired);
        output.writeShort(this.generalPurposeBits);
        output.writeShort(this.compression);
        output.writeShort(this.modificationTime);
        output.writeShort(this.modificationDate);
        output.writeInt(this.crc32);
        output.writeInt(this.compressedSize);
        output.writeInt(this.size);
        output.writeShort((short)this.filename.length());
        output.writeShort((short)(this.extraData.length + this.numAlignBytes));
        output.writeShort((short)this.fileComment.length());
        output.writeShort(this.diskNumberStart);
        output.writeShort(this.internalAttributes);
        output.writeInt(this.externalAttributes);
        output.writeInt(this.localHeaderOffset);
        output.writeString(this.filename);
        output.writeBytes(this.extraData);
        if (this.numAlignBytes > 0) {
            output.writeBytes(alignBytes, 0, this.numAlignBytes);
        }
        output.writeString(this.fileComment);
    }

    public long getTime() {
        int year = (this.modificationDate >> 9 & 0x7F) + 80;
        int month = (this.modificationDate >> 5 & 0xF) - 1;
        int day = this.modificationDate & 0x1F;
        int hour = this.modificationTime >> 11 & 0x1F;
        int minute = this.modificationTime >> 5 & 0x3F;
        int seconds = this.modificationTime << 1 & 0x3E;
        Date d = new Date(year, month, day, hour, minute, seconds);
        return d.getTime();
    }

    public void setTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        long dtime = year < 1980 ? 0x210000L : (long)(year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1);
        this.modificationDate = (short)(dtime >> 16);
        this.modificationTime = (short)(dtime & 0xFFFFL);
    }

    public boolean isDirectory() {
        return this.filename.endsWith("/");
    }

    public String getName() {
        return this.filename;
    }

    public void setName(String filename) {
        this.filename = filename;
    }

    public void setCompression(int compression) {
        this.compression = (short)compression;
    }

    public short getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public short getVersionRequired() {
        return this.versionRequired;
    }

    public short getGeneralPurposeBits() {
        return this.generalPurposeBits;
    }

    public short getCompression() {
        return this.compression;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public short getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public short getInternalAttributes() {
        return this.internalAttributes;
    }

    public int getExternalAttributes() {
        return this.externalAttributes;
    }

    public int getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    public long getDataPosition() {
        return this.dataPosition;
    }

    public ZioEntryOutputStream getEntryOut() {
        return this.entryOut;
    }

    public ZipInput getZipInput() {
        return this.zipInput;
    }
}

