/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.graphics.Point;
import android.graphics.Rect;
import android.service.wallpaper.WallpaperService;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

public class PWallpaper
extends WallpaperService
implements AppComponent {
    private Point size;
    private DisplayMetrics metrics;
    private WallpaperEngine engine;

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager wm = (WindowManager)this.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 1;
    }

    public PApplet createSketch() {
        return new PApplet();
    }

    @Override
    public void setSketch(PApplet sketch) {
        this.engine.sketch = sketch;
    }

    @Override
    public PApplet getSketch() {
        return this.engine.sketch;
    }

    @Override
    public boolean isService() {
        return true;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.engine;
    }

    @Override
    public void requestDraw() {
    }

    @Override
    public boolean canDraw() {
        return true;
    }

    @Override
    public void dispose() {
    }

    public void requestPermissions() {
    }

    public WallpaperService.Engine onCreateEngine() {
        this.engine = new WallpaperEngine();
        return this.engine;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.engine != null) {
            this.engine.onDestroy();
        }
    }

    public class WallpaperEngine
    extends WallpaperService.Engine
    implements ServiceEngine {
        private PApplet sketch;
        private float xOffset;
        private float xOffsetStep;
        private float yOffset;
        private float yOffsetStep;
        private int xPixelOffset;
        private int yPixelOffset;

        public WallpaperEngine() {
            super((WallpaperService)PWallpaper.this);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.sketch = PWallpaper.this.createSketch();
            this.sketch.initSurface(PWallpaper.this, this.getSurfaceHolder());
            if (this.isPreview()) {
                PWallpaper.this.requestPermissions();
            }
            this.setTouchEventsEnabled(true);
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            super.onSurfaceCreated(surfaceHolder);
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (this.sketch != null) {
                this.sketch.g.setSize(width, height);
            }
            super.onSurfaceChanged(holder, format, width, height);
        }

        public void onVisibilityChanged(boolean visible) {
            if (this.sketch != null) {
                if (visible) {
                    this.sketch.onResume();
                } else {
                    this.sketch.onPause();
                }
            }
            super.onVisibilityChanged(visible);
        }

        public void onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
            if (this.sketch != null) {
                this.sketch.surfaceTouchEvent(event);
            }
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
            if (this.sketch != null) {
                this.xOffset = xOffset;
                this.yOffset = yOffset;
                this.xOffsetStep = xOffsetStep;
                this.yOffsetStep = yOffsetStep;
                this.xPixelOffset = xPixelOffset;
                this.yPixelOffset = yPixelOffset;
            }
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
        }

        public void onDestroy() {
            super.onDestroy();
            if (this.sketch != null) {
                this.sketch.onDestroy();
            }
        }

        @Override
        public float getXOffset() {
            return this.xOffset;
        }

        @Override
        public float getYOffset() {
            return this.yOffset;
        }

        @Override
        public float getXOffsetStep() {
            return this.xOffsetStep;
        }

        @Override
        public float getYOffsetStep() {
            return this.yOffsetStep;
        }

        @Override
        public int getXPixelOffset() {
            return this.xPixelOffset;
        }

        @Override
        public int getYPixelOffset() {
            return this.yPixelOffset;
        }

        @Override
        public boolean isInAmbientMode() {
            return false;
        }

        @Override
        public boolean isRound() {
            return false;
        }

        @Override
        public Rect getInsets() {
            return null;
        }

        @Override
        public boolean useLowBitAmbient() {
            return false;
        }

        @Override
        public boolean requireBurnInProtection() {
            return false;
        }

        @Override
        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            if (this.sketch != null) {
                this.sketch.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }
}

