package tech.konata.phosphate.rendering.shader.uniform;

import org.lwjgl.opengl.GL20;
import tech.konata.phosphate.rendering.shader.ShaderProgram;

/**
 * @author IzumiiKonata
 * @since 2024/10/29 21:38
 */
public class Uniform2f {

    private final int location;
    private float value1, value2;

    public Uniform2f(ShaderProgram shader, String uniformName) {
        this.location = GL20.glGetUniformLocation(shader.getProgramId(), uniformName);
    }

    public void setValue(float value1, float value2) {

        if (this.value1 != value1 || this.value2 != value2) {
            GL20.glUniform2f(location, value1, value2);
            this.value1 = value1;
            this.value2 = value2;
        }

    }

}
