package tech.konata.phosphate.rendering.shader.uniform;

import org.lwjgl.opengl.GL20;
import tech.konata.phosphate.rendering.shader.ShaderProgram;

/**
 * @author IzumiiKonata
 * @since 2024/10/29 21:38
 */
public class Uniform1i {

    private final int location;
    private int value;

    public Uniform1i(ShaderProgram shader, String uniformName) {
        this.location = GL20.glGetUniformLocation(shader.getProgramId(), uniformName);
    }

    public void setValue(int value) {

        if (this.value != value) {
            GL20.glUniform1i(location, value);
            this.value = value;
        }

    }

}
