package tech.konata.phosphate.command.impl;

import tech.konata.phosphate.Phosphate;
import tech.konata.phosphate.command.Command;
import tech.konata.phosphate.management.EventManager;
import tech.konata.phosphate.management.Localizer;
import tech.konata.phosphate.management.ModuleManager;
import tech.konata.phosphate.management.WidgetsManager;
import tech.konata.phosphate.module.Module;
import tech.konata.phosphate.rendering.entities.impl.SVGImage;
import tech.konata.phosphate.rendering.shader.Shaders;
import tech.konata.phosphate.rendering.shader.impl.*;
import tech.konata.phosphate.widget.Widget;

/**
 * @author IzumiiKonata
 * @since 2024/9/17 19:26
 */
public class Reload extends Command {

    public Reload() {
        super("Reload", "reloads translations.", "reload", "r");
    }

    @Override
    public void execute(String[] args) {
        Localizer.loadLang();
        this.print("Reloaded translations!");

        SVGImage.map.clear();
        this.print("Cleared SVG images!");

//        PlayerAdapter.getInstances().clear();
//        this.print("Reloaded Cloud!");

        Phosphate.getInstance().getConfigManager().stop();

//        this.reloadModules();
//        this.print("Reloaded Modules!");

//        Phosphate.getInstance().getConfigManager().loadConfig();

        Shaders.POST_BLOOM_SHADER = new BloomShader();
        Shaders.BLOOM_3D = new BloomShader3D();
        Shaders.UI_BLOOM_SHADER = Shaders.POST_BLOOM_SHADER;
        Shaders.UI_POST_BLOOM_SHADER = Shaders.POST_BLOOM_SHADER;
        Shaders.GAUSSIAN_BLUR_SHADER = new GaussianBlurShader();
        Shaders.GAUSSIAN_BLUR_SHADER_SPECIAL = new GaussianBlurSpecialShader();
        Shaders.UI_GAUSSIAN_BLUR_SHADER = Shaders.GAUSSIAN_BLUR_SHADER;
        Shaders.BLEND = new BlendShader();
        Shaders.MOTION = new MotionShader();
        Shaders.COLOR = new ColorShader();

        Shaders.ROQ_SHADER = new ROQShader();
        Shaders.ROGQ_SHADER = new ROGQShader();
        Shaders.RQ_SHADER = new RQShader();
        Shaders.RQT_SHADER = new RQTShader();
        Shaders.RQG_SHADER = new RQGShader();

        this.print("Reloaded shaders!");

    }

    private void reloadModules() {

        for (Module module : ModuleManager.getModules()) {
            EventManager.unregister(module);
        }

        ModuleManager.getModules().clear();
        Phosphate.getInstance().getModuleManager().init();

        for (Widget widget : WidgetsManager.getWidgets()) {
            EventManager.unregister(widget);
        }

        WidgetsManager.getWidgets().clear();
        Phosphate.getInstance().getWidgetsManager().init();

    }
}
