package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRabbit;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderRabbit;
import net.minecraft.entity.passive.EntityRabbit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelAdapterRabbit extends ModelAdapter {
    private static Map<String, Integer> mapPartFields = null;

    public ModelAdapterRabbit() {
        super(EntityRabbit.class, "rabbit", 0.3F);
    }

    public ModelBase makeModel() {
        return new ModelRabbit();
    }

    public ModelRenderer getModelRenderer(ModelBase model, String modelPart) {
        if (!(model instanceof ModelRabbit)) {
            return null;
        } else {
            ModelRabbit modelrabbit = (ModelRabbit) model;
            Map<String, Integer> map = getMapPartFields();

            if (map.containsKey(modelPart)) {
                int i = map.get(modelPart);

                List<ModelRenderer> list = Arrays.asList(
                        modelrabbit.rabbitLeftFoot,
                        modelrabbit.rabbitRightFoot,
                        modelrabbit.rabbitLeftThigh,
                        modelrabbit.rabbitRightThigh,
                        modelrabbit.rabbitBody,
                        modelrabbit.rabbitLeftArm,
                        modelrabbit.rabbitRightArm,
                        modelrabbit.rabbitHead,
                        modelrabbit.rabbitRightEar,
                        modelrabbit.rabbitLeftEar,
                        modelrabbit.rabbitTail,
                        modelrabbit.rabbitNose
                );

                return list.get(i);
            } else {
                return null;
            }
        }
    }

    public String[] getModelRendererNames() {
        return new String[]{"left_foot", "right_foot", "left_thigh", "right_thigh", "body", "left_arm", "right_arm", "head", "right_ear", "left_ear", "tail", "nose"};
    }

    private static Map<String, Integer> getMapPartFields() {
        if (mapPartFields == null) {
            mapPartFields = new HashMap();
            mapPartFields.put("left_foot", 0);
            mapPartFields.put("right_foot", 1);
            mapPartFields.put("left_thigh", 2);
            mapPartFields.put("right_thigh", 3);
            mapPartFields.put("body", 4);
            mapPartFields.put("left_arm", 5);
            mapPartFields.put("right_arm", 6);
            mapPartFields.put("head", 7);
            mapPartFields.put("right_ear", 8);
            mapPartFields.put("left_ear", 9);
            mapPartFields.put("tail", 10);
            mapPartFields.put("nose", 11);
        }
        return mapPartFields;
    }

    public IEntityRenderer makeEntityRender(ModelBase modelBase, float shadowSize) {
        RenderManager rendermanager = Minecraft.getMinecraft().getRenderManager();
        return new RenderRabbit(rendermanager, modelBase, shadowSize);
    }
}
