package net.minecraft.command;

import net.minecraft.util.BlockPos;

import java.util.List;
import java.util.Map;

public interface ICommandManager {
    /**
     * Attempt to execute a command. This method should return the number of times that the command was executed. If the
     * command does not exist or if the player does not have permission, 0 will be returned. A number greater than 1 can
     * be returned if a player selector is used.
     *
     * @param sender     The person who executed the command. This could be an EntityPlayer, RCon Source, Command Block,
     *                   etc.
     * @param rawCommand The raw arguments that were passed. This includes the command name.
     */
    int executeCommand(ICommandSender sender, String rawCommand);

    List<String> getTabCompletionOptions(ICommandSender sender, String input, BlockPos pos);

    List<ICommand> getPossibleCommands(ICommandSender sender);

    Map<String, ICommand> getCommands();
}
