package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.Location;

public class RenderVillager extends RenderLiving<EntityVillager> {
    private static final Location villagerTextures = Location.of("textures/entity/villager/villager.png");
    private static final Location farmerVillagerTextures = Location.of("textures/entity/villager/farmer.png");
    private static final Location librarianVillagerTextures = Location.of("textures/entity/villager/librarian.png");
    private static final Location priestVillagerTextures = Location.of("textures/entity/villager/priest.png");
    private static final Location smithVillagerTextures = Location.of("textures/entity/villager/smith.png");
    private static final Location butcherVillagerTextures = Location.of("textures/entity/villager/butcher.png");

    public RenderVillager(RenderManager renderManagerIn) {
        super(renderManagerIn, new ModelVillager(0.0F), 0.5F);
        this.addLayer(new LayerCustomHead(this.getMainModel().villagerHead));
    }

    public ModelVillager getMainModel() {
        return (ModelVillager) super.getMainModel();
    }

    /**
     * Returns the location of an entity's texture. Doesn't seem to be called unless you call Render.bindEntityTexture.
     */
    protected Location getEntityTexture(EntityVillager entity) {
        switch (entity.getProfession()) {
            case 0:
                return farmerVillagerTextures;

            case 1:
                return librarianVillagerTextures;

            case 2:
                return priestVillagerTextures;

            case 3:
                return smithVillagerTextures;

            case 4:
                return butcherVillagerTextures;

            default:
                return villagerTextures;
        }
    }

    /**
     * Allows the render to do any OpenGL state modifications necessary before the model is rendered. Args:
     * entityLiving, partialTickTime
     */
    protected void preRenderCallback(EntityVillager entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375F;

        if (entitylivingbaseIn.getGrowingAge() < 0) {
            f = (float) ((double) f * 0.5D);
            this.shadowSize = 0.25F;
        } else {
            this.shadowSize = 0.5F;
        }

        GlStateManager.scale(f, f, f);
    }
}
