package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.renderer.entity.layers.LayerSnowmanHead;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.util.Location;

public class RenderSnowMan extends RenderLiving<EntitySnowman> {
    private static final Location snowManTextures = Location.of("textures/entity/snowman.png");

    public RenderSnowMan(RenderManager renderManagerIn) {
        super(renderManagerIn, new ModelSnowMan(), 0.5F);
        this.addLayer(new LayerSnowmanHead(this));
    }

    /**
     * Returns the location of an entity's texture. Doesn't seem to be called unless you call Render.bindEntityTexture.
     */
    protected Location getEntityTexture(EntitySnowman entity) {
        return snowManTextures;
    }

    public ModelSnowMan getMainModel() {
        return (ModelSnowMan) super.getMainModel();
    }
}
