package net.minecraft.client.renderer;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjglx.util.glu.GLU;
import tech.konata.phosphate.management.ModuleManager;
import tech.konata.phosphate.module.impl.render.Perspective;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ActiveRenderInfo {
    /**
     * The current GL viewport
     */
    public static final IntBuffer VIEWPORT = GLAllocation.createDirectIntBuffer(16);

    /**
     * The current GL modelview matrix
     */
    public static final FloatBuffer MODELVIEW = GLAllocation.createDirectFloatBuffer(16);

    /**
     * The current GL projection matrix
     */
    public static final FloatBuffer PROJECTION = GLAllocation.createDirectFloatBuffer(16);

    /**
     * The computed view object coordinates
     */
    public static final FloatBuffer OBJECTCOORDS = GLAllocation.createDirectFloatBuffer(3);
    private static Vec3 position = new Vec3(0.0D, 0.0D, 0.0D);

    /**
     * The X component of the entity's yaw rotation
     */
    private static float rotationX;

    /**
     * The combined X and Z components of the entity's pitch rotation
     */
    private static float rotationXZ;

    /**
     * The Z component of the entity's yaw rotation
     */
    private static float rotationZ;

    /**
     * The Y component (scaled along the Z axis) of the entity's pitch rotation
     */
    private static float rotationYZ;

    /**
     * The Y component (scaled along the X axis) of the entity's pitch rotation
     */
    private static float rotationXY;

    /**
     * Updates the current render info and camera location based on entity look angles and 1st/3rd person view mode
     */
    public static void updateRenderInfo(EntityPlayer entityplayerIn, boolean p_74583_1_) {
        GlStateManager.getFloat(2982, MODELVIEW);
        GlStateManager.getFloat(2983, PROJECTION);
        GL11.glGetIntegerv(GL11.GL_VIEWPORT, VIEWPORT);
        float f = (float) ((VIEWPORT.get(0) + VIEWPORT.get(2)) / 2);
        float f1 = (float) ((VIEWPORT.get(1) + VIEWPORT.get(3)) / 2);
        GLU.gluUnProject(f, f1, 0.0F, MODELVIEW, PROJECTION, VIEWPORT, OBJECTCOORDS);
        position = new Vec3(OBJECTCOORDS.get(0), OBJECTCOORDS.get(1), OBJECTCOORDS.get(2));
        int i = p_74583_1_ ? 1 : 0;
        float f2, f3;
        if (!ModuleManager.perspective.isEnabled()) {
            f2 = entityplayerIn.rotationPitch;
            f3 = entityplayerIn.rotationYaw;
        } else {
            f2 = Perspective.getCameraPitch();
            f3 = Perspective.getCameraYaw();
        }
        rotationX = MathHelper.cos(f3 * (float) Math.PI / 180.0F) * (float) (1 - i * 2);
        rotationZ = MathHelper.sin(f3 * (float) Math.PI / 180.0F) * (float) (1 - i * 2);
        rotationYZ = -rotationZ * MathHelper.sin(f2 * (float) Math.PI / 180.0F) * (float) (1 - i * 2);
        rotationXY = rotationX * MathHelper.sin(f2 * (float) Math.PI / 180.0F) * (float) (1 - i * 2);
        rotationXZ = MathHelper.cos(f2 * (float) Math.PI / 180.0F);
    }

    public static Vec3 projectViewFromEntity(Entity p_178806_0_, double p_178806_1_) {
        double d0 = p_178806_0_.prevPosX + (p_178806_0_.posX - p_178806_0_.prevPosX) * p_178806_1_;
        double d1 = p_178806_0_.prevPosY + (p_178806_0_.posY - p_178806_0_.prevPosY) * p_178806_1_;
        double d2 = p_178806_0_.prevPosZ + (p_178806_0_.posZ - p_178806_0_.prevPosZ) * p_178806_1_;
        double d3 = d0 + position.xCoord;
        double d4 = d1 + position.yCoord;
        double d5 = d2 + position.zCoord;
        return new Vec3(d3, d4, d5);
    }

    public static Block getBlockAtEntityViewpoint(World worldIn, Entity p_180786_1_, float p_180786_2_) {
        Vec3 vec3 = projectViewFromEntity(p_180786_1_, p_180786_2_);
        BlockPos blockpos = new BlockPos(vec3);
        IBlockState iblockstate = worldIn.getBlockState(blockpos);
        Block block = iblockstate.getBlock();

        if (block.getMaterial().isLiquid()) {
            float f = 0.0F;

            if (iblockstate.getBlock() instanceof BlockLiquid) {
                f = BlockLiquid.getLiquidHeightPercent(iblockstate.getValue(BlockLiquid.LEVEL).intValue()) - 0.11111111F;
            }

            float f1 = (float) (blockpos.getY() + 1) - f;

            if (vec3.yCoord >= (double) f1) {
                block = worldIn.getBlockState(blockpos.up()).getBlock();
            }
        }

        return block;
    }


    public static Vec3 rotateVectorCC(Vec3 vec, Vec3 axis, double theta) {
        double x, y, z;
        double u, v, w;
        x = vec.xCoord;
        y = vec.yCoord;
        z = vec.zCoord;
        u = axis.xCoord;
        v = axis.yCoord;
        w = axis.zCoord;
        double xPrime = u * (u * x + v * y + w * z) * (1d - Math.cos(theta))
                + x * Math.cos(theta)
                + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1d - Math.cos(theta))
                + y * Math.cos(theta)
                + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1d - Math.cos(theta))
                + z * Math.cos(theta)
                + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }


    public static Vec3 getPosition() {
        return position;
    }

    public static float getRotationX() {
        return rotationX;
    }

    public static float getRotationXZ() {
        return rotationXZ;
    }

    public static float getRotationZ() {
        return rotationZ;
    }

    public static float getRotationYZ() {
        return rotationYZ;
    }

    public static float getRotationXY() {
        return rotationXY;
    }
}
