/*
 * Copyright 2009 Phil Burk, Mobileer Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jsyn.unitgen;

import com.jsyn.io.AudioOutputStream;
import com.jsyn.ports.UnitInputPort;

import java.io.IOException;

/**
 * Write one sample per audio frame to an AudioOutputStream with no interpolation.
 *
 * Note that you must call start() on this unit because it does not have an output for pulling data.
 *
 * @author Phil Burk (C) 2009 Mobileer Inc
 */
public class MonoStreamWriter extends UnitStreamWriter {
    public MonoStreamWriter() {
        addPort(input = new UnitInputPort("Input"));
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = input.getValues();
        AudioOutputStream output = outputStream;
        if (output != null) {
            int count = limit - start;
            try {
                output.write(inputs, start, count);
            } catch (IOException ignored) {
            }
        }
    }

}
