#!/bin/bash

# Package Crawl4AI Assistant Chrome Extension

# Create a temporary directory
TEMP_DIR=$(mktemp -d)
EXTENSION_NAME="crawl4ai-assistant"
VERSION="1.2.1"

# Copy extension files
echo "Copying extension files..."
cp -r background "$TEMP_DIR/"
cp -r content "$TEMP_DIR/"
cp -r icons "$TEMP_DIR/"
cp -r popup "$TEMP_DIR/"
cp -r assets "$TEMP_DIR/"
cp manifest.json "$TEMP_DIR/"

# Create the zip file
echo "Creating zip file..."
cd "$TEMP_DIR"
zip -r "${EXTENSION_NAME}-v${VERSION}.zip" ./*

# Move the zip file to the original directory
mv "${EXTENSION_NAME}-v${VERSION}.zip" "$OLDPWD/"

# Clean up
cd "$OLDPWD"
rm -rf "$TEMP_DIR"

echo "Extension packaged successfully: ${EXTENSION_NAME}-v${VERSION}.zip"