/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VideoCapabilityParser {
    public Document loadWithDom(String xmlFilePath) {
        Document document = null;
        File file = new File(xmlFilePath);
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return document;
    }

    public ArrayList<HashMap<String, String>> parseWithTag(Document document, String tag) {
        if (document == null) {
            return null;
        }
        ArrayList<HashMap<String, String>> extraMediaCodecList = new ArrayList<HashMap<String, String>>();
        NodeList sList = document.getElementsByTagName(tag);
        for (int i = 0; i < sList.getLength(); ++i) {
            Element encoded = (Element)sList.item(i);
            NodeList nodeList = encoded.getElementsByTagName("MediaCodec");
            for (i = 0; i < nodeList.getLength(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                Node node = nodeList.item(i);
                map.put("name", node.getAttributes().getNamedItem("name").getNodeValue());
                map.put("type", node.getAttributes().getNamedItem("type").getNodeValue());
                extraMediaCodecList.add(map);
            }
        }
        return extraMediaCodecList;
    }

    public boolean isExtraHardwareSupported(String name, String type, ArrayList<HashMap<String, String>> extraMediaCodecMap) {
        boolean result = false;
        if (extraMediaCodecMap != null) {
            for (HashMap<String, String> item : extraMediaCodecMap) {
                if (!name.startsWith(item.get("name")) || !type.startsWith(item.get("type"))) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

