# maa的rust绑定，及http api

## rust绑定:

对unsafe ffi进行最基础的绑定，只依赖std

## http api

以下api调用方式均为http post  
使用方式:将server程序放入maa文件夹内并运行server

#### 接口名称 获取版本号

###### 1) 请求地址

> <http://127.0.0.1:11451/version>

###### 2) 请求参数: 无

###### 3) 返回结果示例:

```json
{
  "core": "2022-07-24-16-43-52-8218e7f",
  "result": 0,
  "server": "v0.0.1"
}
```

| 字段名称 | 字段说明       | 类型   | 备注 |
| -------- | -------------- | ------ | ---- |
| core     | maa本体版本号  | string | -    |
| server   | 本服务器版本号 | string | -    |

#### 接口名称 创建maa实例

###### 1) 请求地址

> <http://127.0.0.1:11451/instance/create>

###### 2) 请求参数: 无

###### 3) 返回结果示例:

```json
{
  "id": 1,
  "result": 0
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

---

#### 接口名称 删除maa实例

###### 1) 请求地址

> <http://127.0.0.1:11451/instance/delete>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 获取所有maa实例

###### 1) 请求地址

> <http://127.0.0.1:11451/instance/all>

###### 2) 请求参数:无

###### 3) 返回结果示例

```json
{
  "instances": [1],
  "result": 0
}
```

| 字段名称  | 字段说明       | 类型  | 备注 |
| --------- | -------------- | ----- | ---- |
| instances | 实例的id的列表 | []int | -    |

---

#### 接口名称 连接模拟器

###### 1) 请求地址

> <http://127.0.0.1:11451/connect/attach>

###### 2) 请求参数:

```json
{
  "id": 1,
  "adb_path": "adb.exe",
  "target": "127.0.0.1:62025",
  "config": null
}
```

| 字段名称 | 字段说明   | 类型   | 备注                |
| -------- | ---------- | ------ | ------------------- |
| id       | 实例的id   | int    | -                   |
| adb_path | adb的地址  | string | -                   |
| target   | 连接的地址 | string | -                   |
| config   | 设置       | object | 具体参考maa abi文档 |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 获取实例连接的adb地址

###### 1) 请求地址

> <http://127.0.0.1:11451/connect/target>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0,
  "target": "127.0.0.1:62025"
}
```

| 字段名称 | 字段说明   | 类型   | 备注 |
| -------- | ---------- | ------ | ---- |
| target   | 连接的地址 | string | -    |

---

#### 接口名称 获取最近nums条回调消息

###### 1) 请求地址

> <http://127.0.0.1:11451/message/get>

###### 2) 请求参数:

```json
{
  "uuid": "af01fba4f43da740\r\n",
  "nums": 5
}
```

| 字段名称 | 字段说明   | 类型        | 备注                             |
| -------- | ---------- | ----------- | -------------------------------- |
| uuid     | 设备的uuid | string      | -                                |
| nums     | 消息条数   | int or null | nums为null时，一次性返回所有消息 |

###### 3) 返回结果示例

```json
{
  "msgs": [
    {
      "body": {
        "details": {
          "adb": "adb.exe",
          "address": "127.0.0.1:62025",
          "config": "General"
        },
        "uuid": "af01fba4f43da740",
        "what": "Connected",
        "why": ""
      },
      "time": 1658687213962,
      "type": 2
    }
  ],
  "result": 0
}
```

| 字段名称 | 字段说明   | 类型     | 备注                |
| -------- | ---------- | -------- | ------------------- |
| msgs     | 消息的列表 | []object | -                   |
| msg.body | 消息正文   | object   | 具体参考maa回调文档 |
| msg.time | 时间戳     | int      | -                   |
| msg.type | 消息类型   | int      | 具体参考maa回调文档 |

---

#### 接口名称 删除uuid对应的所有消息

###### 1) 请求地址

> <http://127.0.0.1:11451/message/drop>

###### 2) 请求参数:

```json
{
  "uuid": "af01fba4f43da740\r\n"
}
```

| 字段名称 | 字段说明   | 类型   | 备注 |
| -------- | ---------- | ------ | ---- |
| uuid     | 设备的uuid | string | -    |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 获取数据库内所有uuid

###### 1) 请求地址

> <http://127.0.0.1:11451/uuid/all>

###### 2) 请求参数:无

###### 3) 返回结果示例

```json
{
  "result": 0,
  "uuid": ["af01fba4f43da740"]
}
```

| 字段名称 | 字段说明 | 类型     | 备注                                   |
| -------- | -------- | -------- | -------------------------------------- |
| uuid     | uuid列表 | []string | 即使uuid没有对应的实例，依旧会返回uuid |

---

#### 接口名称 获取实例对应的uuid

###### 1) 请求地址

> <http://127.0.0.1:11451/uuid/get>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0,
  "uuid": "af01fba4f43da740\r\n"
}
```

| 字段名称 | 字段说明   | 类型   | 备注 |
| -------- | ---------- | ------ | ---- |
| uuid     | 设备的uuid | string | -    |

---

#### 接口名称 创建任务

###### 1) 请求地址

> <http://127.0.0.1:11451/task/create>

###### 2) 请求参数:

```json
{
  "id": 1,
  "types": "StartUp",
  "params": {}
}
```

| 字段名称 | 字段说明 | 类型   | 备注                |
| -------- | -------- | ------ | ------------------- |
| id       | 实例的id | int    | -                   |
| types    | 任务类型 | string | -                   |
| params   | 任务参数 | object | 具体参考maa abi文档 |

###### 3) 返回结果示例

```json
{
  "result": 0,
  "task_id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| task_id  | 任务的id | int  | -    |

---

#### 接口名称 设置任务参数

###### 1) 请求地址

> <http://127.0.0.1:11451/task/set>

###### 2) 请求参数:

```json
{
  "id": 1,
  "task_id": 1,
  "params": {}
}
```

| 字段名称 | 字段说明 | 类型   | 备注                |
| -------- | -------- | ------ | ------------------- |
| id       | 实例的id | int    | -                   |
| task_id  | 任务的id | int    | -                   |
| params   | 任务参数 | object | 具体参考maa abi文档 |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 获取当前任务队列

###### 1) 请求地址

> <http://127.0.0.1:11451/task/all>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0,
  "tasks": {
    "1": {
      "params": "{}",
      "type": "StartUp"
    }
  }
}
```

| 字段名称 | 字段说明 | 类型     | 备注                                            |
| -------- | -------- | -------- | ----------------------------------------------- |
| tasks    | 任务队列 | []object | tasks字段内的键值对，键为task_id，不一定从1开始 |

---

#### 接口名称 开始运行

###### 1) 请求地址

> <http://127.0.0.1:11451/run/start>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 中止运行

###### 1) 请求地址

> <http://127.0.0.1:11451/run/stop>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---

#### 接口名称 获取安卓截图

###### 1) 请求地址

> <http://127.0.0.1:11451/device/screenshot>

###### 2) 请求参数:

```json
{
  "id": 1
}
```

| 字段名称 | 字段说明 | 类型 | 备注 |
| -------- | -------- | ---- | ---- |
| id       | 实例的id | int  | -    |

###### 3) 返回结果示例

| 字段名称 | 字段说明 | 类型              | 备注             |
| -------- | -------- | ----------------- | ---------------- |
| 无       | 无       | 一张截图(png格式) | 建议自己想象一个 |

---

#### 接口名称 点击安卓屏幕

###### 1) 请求地址

> <http://127.0.0.1:11451/device/click>

###### 2) 请求参数:

```json
{
  "id": 1,
  "x": 114,
  "y": 514
}
```

| 字段名称 | 字段说明 | 类型 | 备注                 |
| -------- | -------- | ---- | -------------------- |
| id       | 实例的id | int  | -                    |
| x        | 横坐标   | int  | 坐标原点在屏幕左上角 |
| y        | 纵坐标   | int  | -                    |

###### 3) 返回结果示例

```json
{
  "result": 0
}
```

---
