// <copyright file="App.xaml.cs" company="MaaAssistantArknights">
// Part of the MaaWpfGui project, maintained by the MaaAssistantArknights team (Maa Team)
// Copyright (C) 2021-2025 MaaAssistantArknights Contributors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License v3.0 only as published by
// the Free Software Foundation, either version 3 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY
// </copyright>

using System.Diagnostics;
using System.Windows;
using System.Windows.Documents;
using MaaWpfGui.WineCompat;
using MaaWpfGui.WineCompat.FontConfig;
using Serilog;

namespace MaaWpfGui;

/// <summary>
/// App.xaml 的交互逻辑
/// </summary>
public partial class App : Application
{
    private static readonly ILogger _logger = Log.ForContext<App>();

    public void Hyperlink_Click(object sender, RoutedEventArgs e)
    {
        Hyperlink link = sender as Hyperlink;
        if (!string.IsNullOrEmpty(link?.NavigateUri?.AbsoluteUri))
        {
            Process.Start(new ProcessStartInfo
            {
                FileName = link.NavigateUri.AbsoluteUri,
                UseShellExecute = true,
            });
        }
    }

    protected override void OnStartup(StartupEventArgs e)
    {
        if (WineRuntimeInformation.IsRunningUnderWine && MaaDesktopIntegration.Available)
        {
            // override buintin font map as early as possible
            FontConfigIntegration.Install();
        }

        base.OnStartup(e);
    }
}
