#include "AsstCaller.h"

#include <filesystem>
#include <iostream>
#include <stdio.h>
#include <string>
#include <thread>

int main([[maybe_unused]] int argc, char** argv)
{
    auto working_path = std::filesystem::path(argv[0]).parent_path();

    if (!std::filesystem::exists(working_path / "resource")) {
        std::cerr << "resource folder not found!" << std::endl;
        return -1;
    }

    // 可以将日志、调试图片等存到别的目录下,需要在最一开始调用。不调用默认保存到资源同目录
    // AsstSetUserDir(working_path.c_str());

    // 这里默认读取的是可执行文件同目录下 resource 文件夹里的资源
    if (!AsstLoadResource(working_path.string().c_str())) {
        std::cerr << "-------- load resource failed: official --------" << std::endl;
        return -1;
    }

#ifdef ASST_DEBUG
    if (argc > 1) {
        const std::string arg(argv[1]);

        if (arg == "Official") {
            std::cout << "Official type detected, using default resources." << std::endl;
        }
        else {
            std::cout << "load overseas_type: " << arg << std::endl;

            const auto overseas_path = working_path / "resource" / "global" / arg;
            if (!AsstLoadResource(overseas_path.string().c_str())) {
                std::cerr << "-------- load resource failed: " << arg << " --------" << std::endl;
                return -1;
            }
        }
    }
#endif

    auto ptr = AsstCreate();
    if (ptr == nullptr) {
        std::cerr << "create failed" << std::endl;
        return -1;
    }

#ifdef SMOKE_TESTING
    std::cout << "Ended early for smoke testing." << std::endl;
    AsstDestroy(ptr);
    return 0;
#endif

#ifndef ASST_DEBUG
    AsstAsyncConnect(ptr, "adb", "127.0.0.1:5555", nullptr, true);
#else
    AsstAsyncConnect(ptr, "adb", "127.0.0.1:5555", "DEBUG", true);
#endif
    if (!AsstConnected(ptr)) {
        std::cerr << "connect failed" << std::endl;
        AsstDestroy(ptr);
        return -1;
    }

#ifdef ASST_DEBUG
    AsstAppendTask(ptr, "Debug", nullptr);
#else
    /* 详细参数可参考 docs / 集成文档.md */
    AsstAppendTask(ptr, "StartUp", nullptr);

    AsstAppendTask(ptr, "Fight", R"(
    {
        "stage": "1-7"
    }
    )");

    AsstAppendTask(ptr, "Recruit", R"(
    {
        "select":[4],
        "confirm":[3,4],
        "times":4
    }
    )");

    AsstAppendTask(ptr, "Infrast", R"(
    {
        "facility": ["Mfg", "Trade", "Power", "Control", "Reception", "Office", "Dorm"],
        "drones": "Money"
    }
    )");

    AsstAppendTask(ptr, "Mall", R"(
    {
        "shopping": true,
        "buy_first": [
            "许可"
        ],
        "black_list": [
            "家具",
            "碳"
        ]
    }
    )");

    AsstAppendTask(ptr, "Award", R"(
    {
        "award": true,
        "mail": true,
        "recruit": true,
        "orundum": true,
        "mining": true,
        "specialaccess": true
    }
    )");

    AsstAppendTask(ptr, "Roguelike", R"(
    {
        "theme": "Sarkaz",
        "mode": 1,
        "squad": "蓝图测绘分队",
        "roles": "稳扎稳打",
        "core_char": "维什戴尔"
    }
    )");
#endif

    AsstStart(ptr);

    while (AsstRunning(ptr)) {
        std::this_thread::yield();
    }

    AsstStop(ptr);
    AsstDestroy(ptr);

    return 0;
}
