---
order: 5
icon: ri:game-fill
---

# 集成戰略協議

::: tip
請注意 JSON 檔是不支援註解的，下方的註解僅用於說明，請勿直接複製使用
:::

## 肉鴿資源儲存位置

- `resource/roguelike/` 下按照主題儲存各個肉鴿的作業資源
  - 主題資料夾：`Phantom/` 為傀影肉鴿資源，`Mizuki/` 為水月肉鴿資源，`Sami/` 為薩米肉鴿資源
    - `autopilot/` 內是各個關卡的作戰 json
      - `關卡名.json` 關卡的作戰邏輯
    - `encounter/` 不期而遇事件邏輯
      - `default.json` 刷等級模式
      - `deposit.json` 邏輯刷源石錠模式
    - `recruitment.json` 幹員招募邏輯
    - `shopping.json` 商店購買藏品邏輯

## 肉鴿第一步--幹員招募

`resource/roguelike/主題名/recruitment.json` 描述了幹員招募的邏輯

```json
{
    "theme": "Phantom",              //肉鴿主題（這裡是傀影）
    "priority": [                    //群組的優先度，有序
             ...
        ],
    "team_complete_condition": [     //陣容完備度檢測
             ...
        ]
}
```

### 幹員分類

按照你的遊戲理解將幹員分成不同的 **_groups_** （群組，相關概念參考 [戰鬥流程協議](../protocol/copilot-schema.md)

::: info 注意

1. 同一 group 內的幹員和召喚物必須部署方式一致（即同為近戰或者同為高台）

2. 允許同一幹員或者召喚物根據用法不同，被分類至不同的 group

3. 請不要修改已經存在的 group 名稱，以免在 MAA 更新時導致之前版本的作業無法使用

4. 請盡量不要新增 group，盡量將新增進作業的單位按照用法納入已經存在的 group

:::

```json
{
    "theme": "Phantom",
    "priority": [                     // 群組，有序
        {
            "name": "棘刺",           // 群組名（這個群組名是棘刺）
            "opers": [                // 群組包含的幹員，有序，代表部署優先度，
                                      // （比如需要部署該組幹員時，先檢測有沒有棘刺，有棘刺就部署棘刺，沒有棘刺再檢測有沒有號角）
                {
                    "name": "棘刺",   // 幹員名
                    ...
                },
                {
                    "name": "號角",
                    ...
                }
            ]
        },
       "team_complete_condition": [
             ...
        ]
    ]
}
```

1. 已有群組介紹

   以傀影肉鴿的作業為例：主要將幹員分為了

   | 分組           | 主要考量         | 主要包括職業 | 舉例幹員                                                         |
   | :------------- | :--------------- | :----------- | :--------------------------------------------------------------- |
   | **_地面阻擋_** | 站場和清雜       | 重裝、近衛   | 奶盾、基石、羽毛筆、山、M3、令和稀音的召喚物、斑點、重裝預備幹員 |
   | **_地面單切_** | 單獨對戰精英怪   | 處決者特種   | 史爾特爾、異德、麒麟R夜刀、M3、紅                                |
   | **_高台C_**    | 常態和決戰輸出   | 狙擊、術士   | 假日威龍陳、澄閃、艾雅法拉、肥鴨                                 |
   | **_高台輸出_** | 對空和常態輸出   | 狙擊、術士   | 空弦、能天使、克洛絲、史都華德                                   |
   | **_奶_**       | 治療能力         | 治療、輔助   | 凱爾希、濁心斯卡蒂、芙蓉、安賽爾                                 |
   | **_回費_**     | 回復 cost        | 先鋒         | 桃金娘、伊內絲、芬、香草                                         |
   | **_炮灰_**     | 吸收炮彈、再部署 | 特種、召喚物 | M3、紅、桃金娘、預備幹員                                         |
   | **_高台預備_** | 有一定輸出能力   |              | 梓蘭、預備幹員                                                   |

2. 需要特殊操作的群組

   除了上面那些比較籠統的分組，我們有時候需要對一些幹員或者幹員種類進行一些定制的精細化操作，比如

   | 分組       | 包括幹員         | 主要特點                                                                    |
   | :--------- | :--------------- | :-------------------------------------------------------------------------- |
   | 棘刺       | 棘刺、號角       | 地面遠程輸出，有些圖有非常適合的位置                                        |
   | 召喚類     | 凱爾希、令、稀音 | 自帶地面阻擋，有的圖需要優先部署，召喚物可以當阻擋也可以當炮灰              |
   | 情報官     | 曉歌、伊內絲     | 既可以回費、可以側面輸出，還可以單切                                        |
   | 濁心斯卡蒂 | 濁心斯卡蒂       | 低壓時奶量尚可，但是範圍特殊，一些圖有比較適合的位置                        |
   | 焰葦       | 焰影葦草         | 薩米肉鴿常用開局幹員，兼具治療和輸出，一些圖有比較適合的位置                |
   | 銀灰       | 銀灰、瑪恩納     | 地面大範圍決戰輸出，可以針對 boss 進行部署                                  |
   | 史爾特爾   | 史爾特爾         | 由於精二後固定攜帶 3 技能，這時站場能力幾乎為零，需要阻擋位的部署優先度極低 |
   | 骰子       | 骰子             | 水月肉鴿中的骰子需要單獨操作                                                |

::: tip
目前固定將未辨識到的地面幹員歸入倒數第二個編組後面，未辨識到的高台幹員歸入倒數第一個編組後面
:::

### 預設陣容--陣容完備檢測

在你預計能夠通關或者打到高層的隊伍中，哪些幹員屬於基本核心陣容？是必不可少的？又需要幾個？

::: info 注意
目前腳本的招募邏輯是在陣容未滿足陣容完備度之前，只招募 0 希望和 key 幹員，存希望給高星 key 幹員
所以不要將完備度數字設定太高，建議所有需要的幹員數量（基本核心陣容）加起來在 4-8
:::

```json
{
    "theme": "Phantom",              //肉鴿主題
    "priority": [                    //群組
             ...
        ],
    "team_complete_condition": [     //陣容完備度檢測
             {
            "groups": [              //需要哪些群組中的幹員
                "高台C"
            ],
            "threshold": 1           //這些幹員需要多少數量
        },                           //（這裡表示需要高台組的幹員 1 名）
        {
            "groups": [
                "棘刺",              //（這裡表示棘刺、地面阻擋、地面單切、炮灰分組的幹員最少需要 2 個）
                "地面阻擋",
                "地面單切",
                "炮灰"
            ],
            "threshold": 2
        },
        ...
        ]
}
```

### 調整幹員招募參數

1. 群組內的順序代表部署檢測的優先度

2. 群組內幹員各個欄位的意思和腳本相關的邏輯

   ```json
   {
   "theme": "Phantom",
   "priority": [
           "name": "地面阻擋",                                // 群組名（這裡是地面阻擋組）
           "doc": "標準線為 1 檔（清雜能力或者站場能力比山強）> 山 > 2 檔（阻擋 >2，可自回）> 斑點，站場能力小於斑點放到單切或者炮灰組",
                                                             // 帶 “doc” 欄位均為 json 內註解檔案，對程序執行沒有影響
           "opers": [                                        // 該包括哪些幹員，有序，代表部署優先度
               {
                   "name": "百煉嘉維爾",                      // 幹員名稱（這裡是百嘉，在組內第 1 位，表示需要部署地面阻擋組的時候，首先檢測是不是百嘉）
                   "skill": 3,                               // 使用幾技能（這裡舉例使用 3 技能）
                   "skill_usage": 2,                         // 技能使用模式，參考 3-3 戰鬥流程協議，不填或者 1 為自動放，2 為只放 x 次（ x 通過 "skill_times" 欄位設定），3 暫時不支援
                   "skill_times": 2,                         // 技能使用次數，預設為 1，在 "skill_usage" 欄位為 2 時生效
                   "alternate_skill": 2,                     // 當沒有指定技能時使用的備選技能，一般是 6 星幹員未精二且精二後使用 3 技能時才需要指定（這裡指沒有 3 技能時使用 2 技能）
                   "alternate_skill_usage": 1                // 備選技能的技能使用模式（該欄位尚未實現）
                   "alternate_skill_times": 1                // 備選技能的技能使用次數（該欄位尚未實現）
                   "recruit_priority": 900,                  // 招募優先級，數字越大優先級越高，900 以上屬於看到必招，400 以下招募優先級比一些關鍵幹員精二優先度還低
                   "promote_priority": 600,                  // 進階優先級，數字越大優先級越高，900 以上屬於有希望就精二，400 以下招募優先級低於招募普通三星幹員
                   "is_key": true,                           // true 為 key（關鍵）幹員，false 或省略為非 key 幹員。在陣容完備檢測未通過時，僅招募 key 幹員與 0 希望幹員，保留希望。
                   "is_start": true,                         // true 為開局選擇幹員，false 或省略為非開局幹員。在隊伍中沒有 start 幹員時，僅招募 start 幹員與 0 希望幹員，用戶填寫的幹員會強制為 start 幹員
                   "promote_priority_when_team_full": 850,
                   "recruit_priority_offsets": [             // 按當前陣容調控招募優先級
                           {
                           "groups": [                       // 需要哪些組滿足條件
                               "凱爾希",
                               "地面阻擋",
                               "棘刺"
                           ],
                           "is_less": false，                // 條件是大於還是小於，false 或者省略是大於，true 是小於
                           "threshold": 2,                   // 滿足條件的數量
                           "offset": -300                    // 滿足後對招募優先級的調整
                                                             // （這裡表示當 凱爾希、地面阻擋、棘刺 這三個群組中有2名以上幹員時，百煉嘉維爾的招募優先級減 300）
                       }
                   ]
               },
            ...
       ],
   "team_complete_condition": [
            ...
       ]
   }
   ```

3. 按照你的理解新增群組和幹員

   新增群組後，你可以從已有的群組中複製幹員過來，參考大佬們已有的評分，在此基礎上修改

## 肉鴿第二步--戰鬥邏輯

`resource/roguelike/主題名/autopilot/關卡名.json` 描述了每個關卡的作戰策略

### MAA肉鴿基本戰鬥邏輯--牛牛高血壓之源

1. 根據地圖上格子類型進行基本的戰鬥操作
   - MAA 會根據地圖上的格子是藍門還是紅門，是高台還是地面，能不能被部署來進行基本的戰鬥操作

   - MAA 僅根據地圖名稱或者編號決定使用哪份作業，不會判斷地圖的 **普通**、**緊急**、**路網**、**密文板使用** 等情況

   - MAA 不會判斷 **作戰中地圖上無法確定的格子的情況**，比如 `馴獸小屋` 的祭壇位置，`從眾效應` 是從左邊還是從右邊出怪

   所以在後面，你需要盡量設計一套能夠應付一個地圖名 **所有不同情況**（上面提到的幾種情況）的戰鬥邏輯，小心被大家掛到 issue 上說這張圖操作高血壓哦（笑）

2. MAA 的基本作戰策略--堵藍門
   1. 地面幹員會優先部署在藍門的格子上（為什麽是格子上，請往下看）或者周圍，方向朝向紅門（自動計算），

   2. 優先部署地面，然後部署治療幹員和高台幹員，一圈一圈的由藍門向四周部署，

   3. 會不停的按照上面的邏輯部署可以部署的東西（幹員和召喚物）

### 優化基本戰鬥策略

1. 藍門替代方案

   僅僅把幹員堆在藍門門口顯然不太聰明，有些關卡有格子是一夫當關萬夫莫開，防守在這裡顯然效率很高，

   或者有些關卡有多個藍門，MAA 不知道哪個藍門對應哪個紅門，也會胡亂部署，

   這個時候你需要打開[地圖 wiki](https://map.ark-nights.com/areas) 一邊對著地圖一邊在腦海裡指揮作戰了

   首先在 `設定` 裡將 `坐標展示` 切換為 `MAA`

   然後根據你的經驗尋找需要優先防守的點的坐標和朝向，寫入到 json 的 `"replacement_home"` 裡面

   ```json
   {
   "stage_name": "蓄水池",        // 關卡名
   "replacement_home": [         // 重要防守點（藍門替代點），至少需要填寫 1 個
       {
           "location": [         // 格子坐標，從地圖 wiki 獲得
               6,
               4
           ],
           "direction_Doc1": "優先朝向，但並不代表絕對是這個方向（算法自行判斷）",
           "direction_Doc2": "不填預設 none，即沒有推薦方向，完全由算法自行判斷",
           "direction_Doc3": "none / left / right / up / down / 無 / 上 / 下 / 左 / 右",
           "direction": "left"   // （這裡表示將幹員優先部署到坐標 6,4 的格子朝左）
       }
   ],
   ```

2. 部署格子黑名單

   有優先防守的點就有優先不部署幹員的點，比如大火球經過的位置，boss 腳底下，一些不好輸出的位置，

   這個時候我們引入了 `"blacklist_location"` 將不想讓他部署幹員的格子加到黑名單裡

   ::: info 注意
   這裡加入的格子，就算在後面的部署策略裡面寫進去的話，也是無法部署的
   :::

   ```json
       ...
       "blacklist_location_Doc": "這裡是用法舉例，不是說蓄水池這個圖需要 ban 這兩個點",
       "blacklist_location": [  // 禁止程序進行部署的位置
           [
               0,
               0
           ],
           [
               1,
               1
           ]
       ],
   ```

3. 其他地圖策略

   比如水月肉鴿中如果藍門進怪了是不是要用骰子，緩解堆怪壓力

   ```json
       "not_use_dice_Doc": "藍門幹員撤退時是否需要用骰子，不寫預設 false",
       "not_use_dice": false,
   ```

### 還是高血壓？是時候展現你真正的而技術了--定制作戰策略！

使用 `"deploy_plan"` 和 `"retreat_plan"` 實現定制化操作

定制化策略優先與基本戰鬥策略，當定制化策略中的所有步驟都嘗試執行完畢後，省下的幹員或者倒下再部署的幹員會按照基本戰鬥策略不斷部署

有時候不需要設定太多的定制策略，完成關鍵步驟後再交給 MAA，兩者結合可能效果更好

1. 使用各個群組部署幹員

   ```json
    "deploy_plan": [ // 部署邏輯，按從上到下、從左到右的順序進行檢索，並嘗試部署找到的第一個幹員，如果沒有就跳過
           {
               "groups": [ "百嘉", "基石", "地面C", "號角", "擋人先鋒" ], //這一步從這些群組中尋找幹員
               "location": [ 6, 4 ],             //遍歷百嘉群組、基石群組、地面 C 群組等等群組
               "direction": "left"               //將找到的第一個幹員部署到 6,4 這個坐標上並朝向左邊
           },                                    //沒找到就進行下一個部署操作
           {
               "groups": [ "召喚" ],
               "location": [ 6, 3 ],
               "direction": "left"
           },
           {
               "groups": [ "單奶", "群奶" ],
               "location": [ 6, 2 ],
               "direction": "down"
           }
       ]

   ```

2. 在某個時間點部署幹員
   ::: tip
   適用於某些單切幹員或者需要炮灰的使用場景
   :::

   ```json
   "deploy_plan": [
           {
               "groups": [ "異德", "刺客", "擋人先鋒", "其他地面" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 0, 3 ]       // 該操作僅在擊殺數為 0-3 時進行
           },
           {
               "groups": [ "異德", "刺客", "擋人先鋒", "其他地面" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 6, 10 ]
           },
           ...
       ]
   ```

3. 在某個時間點撤退幹員
   ::: tip
   有時候炮灰過強站住場或者需要部署位騰挪陣容怎麽辦，撤退！
   :::

   ```json
    "retreat_plan": [  // 在特定時間點撤退目標
           {
               "location": [ 4, 1 ],
               "condition": [ 7, 8 ] // 在擊殺數為 7-8 時，撤去位置 [4,1] 的幹員，沒有就跳過
           }
       ]
   ```

4. 在某個時間點釋放技能（to do）

5. 一些其他的欄位（不推薦使用）

   ```json
       "role_order_Doc": "幹員類型部署順序，未寫出部分以近衛，先鋒，醫療，重裝，狙擊，術士，輔助，特種，召喚物的順序補全，輸入英文",
       "role_order": [ // 不推薦使用，請配置 deploy_plan 欄位
           "warrior",
           "pioneer",
           "medic",
           "tank",
           "sniper",
           "caster",
           "support",
           "special",
           "drone"
       ],
       "force_air_defense_when_deploy_blocking_num_Doc": "場上有 10000 個阻擋單位時就開始強制部署總共 1 個對空單位（填不填寫均不影響正常部署邏輯），在此期間不禁止部署醫療單位（不寫預設 false）",
       "force_air_defense_when_deploy_blocking_num": { // 不推薦使用，請配置 deploy_plan 欄位
           "melee_num": 10000,
           "air_defense_num": 1,
           "ban_medic": false
       },
       "force_deploy_direction_Doc": "這些點對某些職業強制部署方向",
       "force_deploy_direction": [ // 不推薦使用，請配置 deploy_plan 欄位
           {
               "location": [
                   1,
                   1
               ],
               "role_Doc": "填入的職業適用強制方向",
               "role": [
                   "warrior",
                   "pioneer"
               ],
               "direction": "up"
           },
           {
               "location": [
                   3,
                   1
               ],
               "role": [
                   "sniper"
               ],
               "direction": "left"
           }
       ],
   ```

### 對某個幹員打法有特殊理解？--精細化操作特定幹員

請將這位幹員單獨分組

編寫作業時請考慮這位幹員與現有作業的順序優先度

你也可以不考慮那麽多，單獨為這個幹員寫一份作戰邏輯

僅使用一位幹員也是可行的！使用 MAA 來凹單人通關吧（由於其他邏輯的不完善，可能性很低）

參考例子：1.傀影肉鴿的棘刺 2.水月肉鴿的異德 3.薩米肉鴿的焰葦

## 肉鴿第三步--不期而遇類節點邏輯

`resource/roguelike/主題名/encounter/default.json` 描述了刷等級模式下不期而遇事件選擇的策略

`resource/roguelike/主題名/encounter/deposit.json` 描述了刷源石錠模式下不期而遇事件選擇的策略

### MAA現有對不期而遇的判斷方法

OCR 辨識不期而遇事件，但是選項是操作固定的位置

沒有辨識到時間的話會點最下面的選項

一般只需要微調或者不調整（大佬都寫好了嘛）

### 優化不期而遇選項的優先度

請結合 [prts.wiki](https://prts.wiki/w/%E9%9B%86%E6%88%90%E6%88%98%E7%95%A5) 查看各個事件的選項效果，注意選項不一定固定

可以自己修改不期而遇事件選項以指引 MAA 走向某些圖的特殊結局

```json
{
    "theme": "Sami",                              //肉鴿主題
    "stage": [                                    //不期而遇類事件
        {
            "name": "低地市集",                    //不期而遇事件名稱
            "option_num": 3,                      //總共有幾個選項（這裡是 3）
            "choose": 3,                          //優先選擇第幾個選項（這裡優先選第三個），如果選不到就選跑路選項（基本上是最後一個）
            "choice_require": [                   //選擇選項的要求
                {
                    "name": "選擇碎草藥",          //選項的名字
                    "ChaosLevel": {               //壓力等級
                        "value": "3",             //要求的數字
                        "type": ">"               //是大於還是小於（這裡表示壓力大於 3 時才啟動選擇碎草藥選項）
                    }
                },
                {
                    "name": "選擇好看的織物",
                    "ChaosLevel": {
                        "value": "3",
                        "type": ">"
                    }
                },
                ...
```

### 根據隊伍情況動態調整某些選項的優先度(TODO)

## 肉鴿第四步--商店藏品的優先度

`resource/roguelike/主題名/shopping.json` 描述了商店購買藏品（和戰鬥後選擇藏品？）的策略

```json
{
    "theme": "Phantom",                                       //肉鴿主題名（這裡是傀影）
    "priority": [                                             //優先度，有序，順序即為優先級，越在前面越優先購買，但優先級判斷在 chars、roles 的篩選之前，可能出現高優先級商品被篩掉，什麽都不買的情況
        {
            "name": "金酒之杯",                                //藏品名字（這裡金杯）
            "no_longer_buy": true,                             //true 表示獲得該藏品後不在花錢買藏品，false 或者省略表示繼續花錢買藏品
            "ignore_no_longer_buy": true,                      //true 表示商店有該藏品時忽略 "no_longer_buy"，就是還會買它，false 或者省略表示拿到有 "no_longer_buy" 的藏品後不會購買這個藏品
            "effect": "每有5源石錠，所有我方單位的攻擊速度+7",    //藏品效果
            "no": 167                                          //藏品編號，wiki 可查
        },

        ...
        {
            "name": "擴散之手",
            "chars": [                                         //隊伍中有這些幹員的時候買這件藏品
                "異客"                                         //（這裡表示隊伍中有異客時，遇到擴散之手，就會嘗試購買）
            ],
            "effect": "【擴散術師】、【鏈術師】和【轟擊術師】每對一個單位造成傷害就回覆2點技力值",
            "no": 136
        },
        ...

        {
            "name": "折戟-破釜沈舟",
            "roles": [                                         //隊伍中有這些職業的時候買這件藏品
                "WARRIOR"                                      //（這裡表示隊伍中有近衛幹員時，遇到折戟-破釜沈舟，就會嘗試購買）
            ],
            "effect": "所有【近衛】幹員的防禦力-40%，但攻擊力+40%，攻擊速度+30",
            "no": 16
        },
        ...

        {
            "name": "Miss.Christine摸摸券",
            "promotion": 2,                                   //隊伍中有 2 個幹員要晉升的時候購買（吧？）
            "effect": "立即進階兩個幹員（不消耗希望）",
            "no": 15
        },
```

## 希望實現的邏輯(todo)

### 自動編隊邏輯

1. 可以根據不同地圖設定不同的地圖陣容完備性檢測和技能優先度

2. 可以根據現有陣容避開一些難度高的作戰

### 優化尋路算法

比如可以實現前三層多戰，後面的少戰，這樣發育會更好

### 技能保留

某格部署的幹員，技能轉好後等待 x 秒再開，方便對軸，可以寫 Deploy_plan 下的 Skill_hold，也可以寫 Skill_hold_plan

### 技能關閉

對彈藥類幹員有用

<!-- markdownlint-disable-file MD026 -->
