---
order: 3
icon: ph:sword-bold
---

# 戰鬥流程協議

`resource/copilot/*.json` 的使用方法及各欄位說明

::: tip
請注意 JSON 文件是不支持注釋的，文本中的注釋僅用於示範，請勿直接複製使用
:::

## 完整欄位一覽

```json
{
    "stage_name": "暴君", // 關卡名，必選。關卡中文名、code、stageId、levelId等，只要能保證唯一均可。
    "opers": [
        // 指定幹員
        {
            "name": "重岳", // 幹員名
            "skill": 3, // 技能序號。可選，預設為 1，取值範圍 [1, 3]
            "skill_usage": 2, // 技能用法。可選，預設為 0
            // 0 - 不自動使用（依賴 "actions" 欄位）
            // 1 - 好了就用，有多少次用多少次（例如幹員 棘刺 3 技能、桃金孃 1 技能等）
            // 2 - 使用 X 次（例如幹員 山 2 技能用 1 次、重岳 3 技能用 5 次，通過 "skill_times" 欄位設置）
            // 3 - 自動判斷使用時機（畫餅.jpg）
            // 如果是全自動的技能，填 0
            "skill_times": 5, // 技能使用次數。可選，預設為 1
            "requirements": {
                // 練度要求。保留介面，暫未實現。可選，預設為空
                "elite": 2, // 精英化等級。可選，預設為 0, 不要求精英化等級
                "level": 90, // 幹員等級。可選，預設為 0
                "skill_level": 10, // 技能等級。可選，預設為 0
                "module": 1, // 模組編號。可選，預設為 0
                "module_level": 3, // 模組等級，可選，預設為 0
                "potential": 1 // 潛能要求。可選，預設為 0
            }
        }
    ],
    "groups": [
        {
            "name": "任意正常群奶", // 群組名，必選
            // 自己隨便取名字，與下面 deploy 中的 name 對應起來就行
            "opers": [
                // 幹員任選其一，無序，會優先選練度高的，用法同上述 opers 欄位
                {
                    "name": "夜鶯",
                    "skill": 3,
                    "skill_usage": 2 // 若是指定時刻，不同的幹員技能 cd 可能不同，請留意
                },
                {
                    "name": "白面鴞",
                    "skill": 2,
                    "skill_usage": 2
                }
            ]
        }
    ],
    "actions": [
        // 戰鬥中的操作。有序，執行完前一個才會去執行下一個。必選
        {
            "type": "部署", // 操作類型，可選，預設為 "Deploy"
            // "Deploy" | "Skill" | "Retreat" | "SpeedUp" | "BulletTime" | "SkillUsage" | "Output" | "SkillDaemon" | "MoveCamera" | "ResetStopwatch"
            // "部署"   |  "技能"  |  "撤退"   | "二倍速"   |  "子弹时间"  |  "技能用法"   | "打印"  |  "摆完挂机" | "移动镜头" | "重置全局计时器"
            // 中英文皆可，效果相同
            // 若為 "部署", 當費用不夠時，會一直等待到費用夠（除非 timeout）
            // 若為 "技能", 當技能 cd 沒轉好時，一直等待到技能 cd 好（除非 timeout）
            // "二倍速" 是可切換的，即使用一次變成二倍速，再次使用又變回一倍速
            // "子弹时间" 即點擊任意幹員後的 1/5 速度，再進行任意 action 會恢復正常速度
            //      "name" 或 "location" 必填一項，即點哪個幹員進入子彈時間，戰場上的幹員或待部署區的幹員均可（會自動判斷）
            //      若下一個動作是 "技能" / "撤退"，需要填與下一個動作相同的 "name" 或 "location"
            //      若下一個動作是 "部署"，隨便填誰（但最好不要填待部署的那個人，頭像被點了會影響識別）
            // "打印" 界面不顯示這條步驟，僅用於輸出 doc 裡的內容（用來做字幕之類的）
            // "摆完挂机" 僅使用 "好了就用" 的技能，其他什麼都不做，直到戰鬥結束
            // "移动镜头" 用於 “引航者試煉” 模式，還需要填寫 distance 欄位
            // "重置全局计时器" 重設全局計時器，請參考 “time_elapsed” 條件
            // 目前下面五個條件是且的關係，即 &&
            "kills": 0, // 擊殺數條件，如果沒達到就一直等待。可選，預設為 0，直接執行
            "costs": 50, // 費用條件，如果沒達到就一直等待。可選，預設為 0，直接執行
            // 費用受潛能等影響，可能並不完全正確，僅適合對時間軸要求不嚴格的戰鬥。
            // 否則請使用下面的 cost_changes
            // 另外僅在費用是兩位數的時候識別的比較准，三位數的費用可能會識別錯，不推薦使用
            "cost_changes": 5, // 費用變化量條件，如果沒達到就一直等待。可選，預設為 0，直接執行
            // 注意是從開始執行本 action 開始計算的（即前一個 action 結束時的費用作為基準）
            // 支持負數，即費用變少了（例如“孑”等吸費幹員使得費用變少了）
            // 另外僅在費用是兩位數的時候識別的比較准，三位數的費用可能會識別錯，不推薦使用
            "cooling": 2, // CD 中幹員數量條件，如果沒達到就一直等待。可選，預設為 -1，不識別
            "time_elapsed": 1000, // 以毫秒為單位全局計時條件，如果沒達到就一直等待。可選，預設為 0，直接執行
            // 注意是從上一次執行 type:ResetStopwatch 的 action 開始計算的
            // 使用前必須執行過 type:ResetStopwatch 的 action 重設計時器，不然會卡住
            // TODO: 其他條件
            // TODO: "condition_type": 0,    // 執行條件間的關係，可選，預設為 0
            //                        // 0 - 且； 1 - 或
            "name": "棘刺", // 幹員名 或 群組名， type 為 "部署" 時必選，為 "技能" | "撤退" 時可選
            "location": [
                5,
                5
            ], // 部署幹員的位置。
            // type 為 "部署" 時必選。
            // type 為 "技能" | "撤退" 時可選，
            // "技能"：僅推薦場地上自動的裝置等，不填寫 name，並使用 location 開啟技能。正常部署的幹員推薦使用 name 開啟技能
            // 撤退"：僅推薦有多個同名召喚物時，不填寫 name, 並使用 location 進行撤退。正常部署的幹員推薦 name 進行撤退
            "direction": "左", // 部署幹員的幹員朝向。 type 為 "部署" 時必選
            // "Left" | "Right" | "Up" | "Down" | "None"
            // "左"   |  "右"   | "上"  | "下"   |  "無"
            // 中英文皆可，效果相同
            "skip_if_not_ready": false, // 僅在 type 為 "技能" 時有效, 允許在技能不可用時跳過當前行動，主要用於關閉未打完的彈藥技能。可選，預設為 false
            "skill_usage": 1, // 修改技能用法。當 type 為 "技能用法" 時必選
            // 舉例：剛下桃金孃需要她幫忙打幾個怪，不能自動開技能，中後期平穩了需要她自動開技能
            // 則可以在對應時刻設置為 1
            "skill_times": 5, // 技能使用次數。可選，預設為 1
            "pre_delay": 0, // 前置延時。可選，預設為 0, 單位毫秒
            // 當前 action 的所有條件參數全部滿足後開始計時，計時結束後執行 type 對應動作
            "post_delay": 0, // 後置延時。可選，預設為 0, 單位毫秒
            // 當前 action 的 type 對應動作執行完成後開始計時，計時結束後開始下一個 action
            //
            // "timeout": 999999999,   // 保留欄位，暫未實現。
            // 超時時間。當 type 為 "部署" | "技能" 時可選。默認 INT_MAX, 單位毫秒
            // 等待超時則放棄當前動作, 轉而執行下一個動作
            "distance": [
                4.5,
                0
            ], // type 為 "移动镜头" 時必選
            // [ x 移動格子數，y 移動格子數 ]，可為小數
            // 注意 "移动镜头" 時是識別不到正在站場中的，需要用 sleep 完整覆蓋整個移動動畫
            "doc": "下棘刺了！", // 描述，可選。會顯示在界面上，沒有實際作用
            "doc_color": "orange" // 描述文字的顏色，可選，默認灰色。會顯示在界面上，沒有實際作用。
        },
        // 舉例 1
        {
            "name": "任意正常群奶",
            "location": [
                5,
                6
            ],
            "direction": "右"
        },
        // 舉例 2
        {
            "name": "史爾特爾",
            "location": [
                4,
                5
            ],
            "direction": "左",
            "doc": "你史爾特爾奶奶來啦！",
            "doc_color": "red"
        },
        // 舉例 3
        {
            "type": "二倍速"
        }
    ],
    "minimum_required": "v4.0", // 最低要求 maa 版本號，必選。保留欄位，暫未實現
    "doc": {
        // 描述，可選。
        "title": "低練度高成功率作業",
        "title_color": "dark",
        "details": "對練度要求很低balabala……", // 建議在這裡寫上你的名字！（作者名）、參考的影片攻略連結等
        "details_color": "dark"
    },
    "difficulty": 0 // 作業對應難度，可選，預設值為0。
    // 0: 預設，未設置
    // 1: 支持普通難度
    // 2: 支持突襲難度
    // 3: 支持普通、突襲難度
}
```

## 舉例

[OF-1](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/master/resource/copilot/OF-1_credit_fight.json)
