---
order: 0
icon: ic:baseline-article
---

# 功能介紹（舊）

## 功能介紹

### 一鍵長草：刷理智

- 若關卡選擇中沒有你需要的關卡，請在 MAA 中選擇 `當前/上次`，然後在遊戲中手動定位關卡，確保畫面停留在有 **開始按鈕** 和 **代理指揮** 的關卡詳情介面。
  - 若目前不在此介面，則 `當前/上次` 會自動進入遊戲中 “上次作戰” 的關卡（以終端首頁右下角記錄為準）。
  - 也可以在 `任務設定` - `刷理智` - `高級設定` 中啟用 `手動輸入關卡名` 手動輸入關卡編號。目前支援導航的關卡有：
    - 全部主線關卡，可在關卡末尾添加 `-NORMAL` 或 `-HARD` 來切換標準或磨難關卡。
    - 龍門幣、作戰記錄的 5 / 6 關，但必須輸入 `CE-6` / `LS-6` ，會在第六關無法代理的情況下自動切換至第五關。
    - 技能書、採購憑證、碳本第 5 關，必須輸入 `CA-5` / `AP-5` / `SK-5`。
    - 晶片本，必須輸入完整關卡編號，如 `PR-A-1`。
    - 剿滅作戰，必須輸入 `Annihilation`。
    - 部分別傳，只支援 `OF-1` / `OF-F3` / `GT-5`。
    - 當期 SideStory 後三關，在自動訪問 [API](https://api.maa.plus/MaaAssistantArknights/api/gui/StageActivity.json) 下載更新後，會在主介面下方顯示相應提示。
    <!--對於復刻的 SideStory，可以輸入 `SSReopen-XX` ，來一次性刷完 XX-1 ~ XX-9 關。如 `SSReopen-IC`。-->

::: details 範例畫面
![範例畫面](/images/zh-cn/combat-start-interface-example.png)
:::

- 主介面上的 `吃理智+吃石頭`、`指定次數`、`指定材料` 三者為 **短路開關（或門）**，即 **三者中的任一條件** 達到，均會視為任務完成，停止刷理智。
  - 其中：
    - `吃理智` 指定吃幾瓶理智藥（一次可能吃多瓶）
    - `吃石頭` 指定碎石多少次（每次 1 顆）；使用源石回復理智時如果仍擁有理智藥則不會碎石
    - `指定次數` 指定刷多少次圖（例如 “刷 15 次後停止” ）
    - `指定材料` 指定刷多少個指定的材料（例如 “獲取 5 個固源岩後停止” ）

| 例  | 吃理智藥 | 吃石頭 | 指定次數 |  指定材料  | 結果                                                                                                                                                                   |
| :-: | :------: | :----: | :------: | :--------: | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  A  |   999    |   10   |    1     |     x      | 會嘗試吃理智藥或石頭，直到刷滿 **一次**，滿足了 `指定次數：1` 的條件，即視為任務完成，停止刷理智；如果一開始理智藥不夠、石頭不夠、現有的理智也不夠就會不刷圖自動結束。 |
|  B  |    x     |   x    |   100    |     x      | 會嘗試刷滿 100 次，但在目前可用理智全部刷完後（可能只刷了幾次），由於滿足了 `不吃理智藥` 、 `不吃石頭` 的條件，無理智可用，視為任務完成，停止刷理智。                  |
|  C  |    1     |   x    |   100    |     x      | 會嘗試刷滿 100 次，期間最多吃 1 次理智藥，如果吃了一次理智藥理智也刷完了，由於滿足了 `吃理智藥：1` 、 `不吃石頭` 的條件，無理智可用，視為任務完成，停止刷理智。        |
|  D  |   999    |   x    |   100    | 3 個固源岩 | 會嘗試刷滿 100 次，期間會吃 999 次理智藥，但如果在這期間累計刷出了3個固源岩，由於滿足了 `指定材料：3 個固源岩` 的條件，視為任務完成，停止刷理智。                      |

- `指定材料` 與 `關卡選擇` 是兩個互相獨立的邏輯。
  - `指定材料` 只是以材料個數作為任務完成依據，並不是說你指定了材料就會幫你導航到對應關卡。
- 支援未勾選 `代理指揮` 時自動勾選，避免你蹭信賴後忘記勾選的尷尬~
- 支援辨識並顯示材料掉落，且會自動上傳 [企鵝物流數據統計](https://penguin-stats.io/)，並可設定企鵝物流用戶 ID。
- 斷線後或凌晨 4 點閃斷後會自動重連，繼續刷遊戲中的 **上次** 關卡，如需跨天請注意檢查上次關卡選擇。
- 支援打完升級的情況；支援代理失敗的情況，會自動放棄本次行動。
- 剿滅相關：
  - 支援剿滅模式自動使用 `全權委託`。
  - MAA 會點擊終端首頁右上角剿滅按鈕進行跳轉，請確保當期剿滅已成功解鎖 `全權委託` 並 400 殺。
  - 每當當期剿滅刷新或重新安裝明日方舟時，從剿滅 `開始戰鬥` 頁面返回會自動展開 `情報匯總`，請提前關閉此頁面以防止任務卡住。
- 支援剩餘理智清空：
  - 主任務刷完後，自動跳到指定關卡清理剩餘的 “邊角” 理智（如剩下的理智拿來刷 1-7）。
  - 如果剩餘理智不夠清空（比如要刷 1-7 但連 6 理智都不夠）則會立即結束任務。

### 一鍵長草：基建換班

#### 換班策略

- 自動計算並選擇 **單設施內的最優解**，支援所有通用類技能和特殊技能組合；支援辨識經驗書、赤金、源石碎片、晶片，分別使用不同的幹員組合！

#### 基建工作心情閾值

- 自動辨識心情進度條的百分比。如幹員心情小於該閾值，不會再去上班，直接進駐宿舍。

#### 特殊說明

- 基建換班目前均為單設施最優解，但非跨設施的全局最優解。例如 `巫戀 + 龍舌蘭`、`紅雲 + 稀音` 等這類單設施內的組合，都是可以正常辨識並使用的；`迷迭香`、`紅松騎士團` 這類多個設施間聯動的體系，暫不支援使用。
- 若 `無人機用途` 選擇 `貿易站-龍門幣` ，則將額外辨識是否有 `巫戀組`，並優先為其使用。
- 會客室僅缺一個線索時，會選擇對應流派的幹員；否則會選擇通用幹員。
- 會客室僅當自有線索滿時，才會送出線索，並且只送三個。有需要的同學可自行修改 `resource/tasks/tasks.json` 中 `ClueSelected` - `maxTimes` 欄位，自定義送出個數。
- 若不希望 `艾麗妮` 等幹員在訓練室未訓練時被進駐到宿舍，可在設定中打開 `不將已進駐幹員放入宿舍`。但可能會帶來加工站中心情不滿的幹員也不進駐宿舍的問題。
- 控制中樞策略太過複雜，目前只考慮 `阿米婭`、`詩懷雅`、`凱爾希`、`彩虹小隊` 及其他心情 +0.05 的幹員，後續會逐步優化。

#### 自定義基建換班（測試功能）

- 一圖流的大佬們幫忙寫了一個 [排班產生器](https://ark.yituliu.cn/tools/schedule)，可參考 [基建排班協議](../../protocol/base-scheduling-schema.md) 使用。
- 在 MAA 資料夾 `/resource/custom_infrast/` 下內建了幾套極限效率的作業，可用作參考。（全幹員且精二大佬可以試著直接用）

### 一鍵長草：獲取信用及購物

- 會自動訪問好友獲取信用點。
- 借助戰賺信用：
  - 使用助戰幹員通關一次火藍之心 `OF-1` 關卡，如果未解鎖該關卡請不要勾選該選項。
  - 可以透過編輯 `resource\copilot\OF-1_credit_fight.json` 來修改 OF-1 自動戰鬥流程（一般來說不建議修改）。
  - 關卡選擇為 `當前/上次` 時不生效。

### 一鍵長草：自動肉鴿

- 請在 MAA `任務設定` - `自動肉鴿` 中選擇要探索的主題，否則可能會因為預設選擇最新一期主題而出現問題。
  - 請在遊戲內將對應肉鴿主題置頂在終端處。
  - 如果存在非目標主題的探索（比如你打算用 MAA 刷水月，但現在還有一個未完成的傀影主題探索），請手動結束它。
  - 如果 MAA 在難度選擇介面卡住 / 反覆進出，請先手動選好難度再啟動本功能。
- 設定中可選擇分隊、開局幹員（僅單個幹員名）等。
- 支援自動辨識幹員及練度，並自動選擇較優幹員及技能。
- 支援辨識商店物品，優先購買更厲害的收藏品。
- 支援斷線重連、支援凌晨 4 點更新後繼續回去刷。
- 戰鬥過程中如果刮痧了一直打不完，超過 5 分鐘會自動撤退所有地面單位；超過 6 分鐘會自動放棄當局戰鬥，不會卡住。
- 如果任務出現問題卡住了，會自動放棄當次探索並重試。但如果經常在某個地方卡住然後放棄、嚴重影響效率的，歡迎提個 issue 反饋一下~

### 切換賬號

- 僅支持切換至已登錄的賬號，使用登錄名進行查找，保證輸入內容在所有已登錄賬號唯一即可
  - 官服：`123****4567`，可輸入 `123****4567`、`4567`、`123`、`3****4567`
  - B服：`張三`，可輸入 `張三`、`張`、`三`

### 自動戰鬥

- 歡迎使用作業分享站 [prts.plus](https://prts.plus) 使用 & 分享作業檔案！

#### 抄作業

- 本功能需要在有 `開始行動` 的編隊選擇介面開始執行。
- 若需要選擇助戰等，關閉 `自動編隊` 功能並手動編隊後再執行即可。
- 記得在作業分享站上給好用的作業點讚哦！

![image](/images/zh-cn/copilot-click-like.png)

#### 寫作業

- 可以在 [作業編輯器](https://prts.plus/create) 上製作，可參考 [戰鬥流程協議](../../protocol/copilot-schema.md) 使用。
- 地圖座標獲取：填寫 `stage_name` 後直接開一局，會在目錄下產生 `map.png`，可以用於參考。也可參考 [PRTS.Map](https://map.ark-nights.com/areas) 網站，在設定中將 `座標展示` 修改為 `MAA` 後使用。
- 支援演習模式，不用一直浪費理智測試的。
- 推薦在作業描述裡填上你的署名（作者名）、參考的攻略影片連結、其他想說的等等。
- 歡迎與我們一起討論作業製作等問題 [作業企鵝群 1169188429](https://jq.qq.com/?_wv=1027&k=QZcGcJ9G)。

#### 作業影片辨識

- 將影片檔案放入自動戰鬥中，點擊 “開始” 啟動作業影片辨識。
- 僅支援 16:9 的 720p 或更高解析度的影片。影片內容不能出現黑框、異形螢幕校正、模擬器邊框等其他元素。

### 公開招募

- **自動公招和公招辨識是兩個獨立的功能！**
- 自動公招支援使用 `加急許可`，全自動連續公招！請進入 `任務設定` - `自動公招` 中選擇 `自動使用加急許可` ，並修改 `每次執行時最大招募次數` 。
- 出 1、5、6 星都會彈出通知提示。
- 自動公招時自動選取數據上傳 [企鵝物流數據統計](https://penguin-stats.io/) 和 [材料一圖流](https://ark.yituliu.cn/)。

### 倉庫辨識（測試功能）

- 若自動跳轉失敗，請手動切換到倉庫 `養成材料` 介面開始功能。目前僅支援匯出到[企鵝物流刷圖規劃器](https://penguin-stats.io/planner)、[明日方舟工具箱](https://arkntools.app/#/material)、[明日方舟 - 幹員培養表](https://ark-nights.com/settings)，後面可能會用來做一些更實用的功能。（畫餅
- 如您是某個數據站站長，也歡迎聯繫我們適配貴站的材料 JSON 協議~

## 設定介紹

除了 `設定` 選項 ，Windows MAA 裡還有 `任務設定` ，點擊 `一鍵長草` 的任務列表右側的 `齒輪` ，就可以在一鍵長草介面裡切換不同的任務設定啦~

要注意點擊 `常規設定`、`高級設定` 也會切換 `任務設定` 喲~

### 自定義連接

#### 獲取 adb 路徑

- 方式 1 : 下載 adb 並手動設定連接
  - （僅 Windows 用戶）下載 [adb](https://dl.google.com/android/repository/platform-tools-latest-windows.zip) 並解壓縮。推薦解壓縮到 MAA 目錄下。
  - 進入軟體 `設定` - `連接設定`，選擇 `adb.exe` 的檔案路徑，填寫 adb 地址（需要填寫 IP + 通訊埠，例如 `127.0.0.1:5555`），並選擇模擬器類型。

- 方式 2 : 查找模擬器 adb 執行通訊埠並連接
  - 對於本身帶有 adb 的模擬器，可按照 [確認 adb 地址一節](../../manual/faq.md#方式-1-確認-adb-及連接地址正確) 找到 adb 執行檔位置。
  - Mac 安卓模擬器一般安裝在 `/Application/` 目錄下，右鍵點擊 `[模擬器名稱].app` 後選擇顯示檔案內容，在目錄下查找 adb 執行檔即可。

#### 獲取通訊埠號

- 方式 1 : 直接使用 adb 命令查看執行通訊埠號

  **使用找到的 adb 執行檔名稱替代下面命令中的 adb** ，而後執行：

  ```sh
  # mac/linux/windows cmd
  adb devices
  # windows PowerShell
  .\adb devices
  ```

  大部分模擬器 adb 執行命令後將會按如下形式輸出， `[ADBPORT]` 為具體數字：

  ```sh
  List of devices attached
        127.0.0.1:[ADBPORT] device
  # may be more output like the above one
  ```

  使用 `127.0.0.1:[ADBPORT]` 作為連接地址即可（ `[ADBPORT]` 替換為實際數字）

- 方式 2 : 使用系統命令查看模擬器除錯通訊埠號

  若使用 adb 命令的輸出結果並不能顯示 `127.0.0.1:[port]` 形式的通訊埠資訊，可以採取下面的方式查看：
  1. 首先執行一遍 adb 可執行程式（需要啟動 adb daemon 程式），並且執行需要打開明日方舟應用的模擬器。
  2. 然後使用系統命令查看 adb 程式的通訊埠資訊。

  Windows 命令

  可以使用 `win` + `R` 輸入 `cmd` 打開命令列，使用如下命令查看:

  ```sh
  for /F "tokens=1,2" %A in ('"tasklist | findstr "adb""') do ( ^
  netstat -ano | findstr "%B" |)
  ```

  Mac / Linux 命令

  啟動模擬器後在終端機中輸入：

  ```sh
  tmp=$(sudo ps aux | grep "[a]db" | awk '{print $2}') && \
  sudo netstat -vanp tcp | grep -e "\b$tmp"
  ```

  將會輸出如下形式結果，其中 `[PID]` 為 adb 實際執行的進程號，`[ADBPORT]` 為目標模擬器 adb 的遠端連接通訊埠，`[localport]` 為程式本地地址，無需關心（Mac 執行結果中也會有其他無需關心的指標）：

  ```sh
  > ( netstat -ano | findstr "[PID]" )
  TCP  127.0.0.1:[localport]   127.0.0.1:0.0.0.0     LISTENING   [PID]
  TCP  127.0.0.1:[localport]   127.0.0.1:[ADBPORT]   ESTABLISHED [PID]
  # ...
  # maybe more output like the above line
  ```

  使用結果中 `127.0.0.1:[ADBPORT]` （替換 `[ADBPORT]` 為實際數字）作為模擬器 adb 實際連接地址填入 `設定` - `連接設定` - `連接地址`。

### 自動啟動多開模擬器

- 若需要多開模擬器同時操作，可將 MAA 資料夾複製多份，使用 **不同的 MAA**、**同一個 adb.exe**、**不同的連接地址** 來進行連接。
- **以[藍疊國際版](../../manual/device/windows.md##✅-完美支援)為例**，介紹兩種啟動多開模擬器的方式。
  - 通過為 `HD-Player.exe` 附加命令來進行多開操作。
    1. 單獨啟動對應的模擬器
    2. 打開工作管理員，找到對應模擬器程式，切換到詳細資料頁籤，在標題列點擊右鍵，選擇 `選取欄位`，把 `命令列` 勾選起來。
    3. 在新出現的 `命令列` 欄位找到 `...\Bluestacks_nxt\HD-Player.exe"` 後的內容。
    4. 將找到的類似於 `--instance Nougat32` 的內容填寫到 `啟動設定` - `附加命令` 中。

    註：操作結束後，建議重新隱藏 `步驟 2` 中打開的 `命令列` 列以防止卡頓。
    - 例子：

      ```bash
      多開1:
      模擬器路徑: C:\Program Files\BlueStacks_nxt\HD-Player.exe
      附加命令: --instance Nougat32 --cmd launchApp --package "com.hypergryph.arknights"
      多開2:
      模擬器路徑: C:\Program Files\BlueStacks_nxt\HD-Player.exe
      附加命令: --instance Nougat32_1 --cmd launchApp --package "com.hypergryph.arknights.bilibili"
      ```

      其中 `--cmd launchApp --package` 部分為啟動後自動執行指定檔案名稱應用，可自行更改。

  - 通過使用模擬器或應用的快捷方式來進行多開操作。
    1. 打開多開管理器，新增對應模擬器的快捷方式。
    2. 將模擬器快捷方式的路徑填入 `啟動設定` - `模擬器路徑` 中。

    註：部分模擬器支援建立應用快捷方式，可直接使用應用的快捷方式直接啟動模擬器並打開明日方舟。
    - 例子：

      ```bash
      多開1:
      模擬器路徑: C:\ProgramData\Microsoft\Windows\Start Menu\Programs\BlueStacks\多開1.lnk
      多開2:
      模擬器路徑: C:\ProgramData\Microsoft\Windows\Start Menu\Programs\BlueStacks\多開2-明日方舟.lnk
      ```

    若使用 `模擬器路徑` 進行多開操作，建議將 `啟動設定` - `附加命令` 留空。

### 開始前 / 結束後腳本

- v4.13.0 後支援設定開始前 / 結束後腳本，可在任務前後自動執行批次檔。
- 需填寫批次檔即 `.bat` 的路徑。

## 其他說明

- 主介面上要執行的任務，是可以拖動改變順序的。同樣設定中基建換班的順序，也是可以拖動改變的。
- 主介面和設定中更改的配置一般都會自動保存，含有 `*` 號的選項除外。
- 所有點擊操作，都是點擊按鈕內隨機位置，並模擬泊松分佈（按鈕偏中間位置點的機率大，越往旁邊點到的機率越小）。
- 底層演算法純 C++ 開發，並設計了多重快取技術，最大限度降低 CPU 和記憶體佔用。
- 軟體支援自動更新 ✿✿ヽ(°▽°)ノ✿ ，推薦非槓精的同學使用公測版，一般來說更新快且 bug 少。（什麼 MIUI (╯‵□′)╯︵┻━┻
- 如果新版本自動下載失敗，可手動下載 OTA 壓縮檔後直接放到 MAA 目錄下，會自動更新的。
- 在 Windows 版本中，MAA 目錄下 `config` 資料夾中的 `gui.json` 記錄了各種設定，如果下載了新的完整檔案，可以將此資料夾複製到新的 MAA 目錄下。（如果複製完啟動報錯，可嘗試恢復 `bak` 備份檔案或刪除後重新設定）。
