---
order: 8
icon: iconoir:code-brackets
---

# 專用 VSCode 插件教學

- [插件商店](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support)
- [倉庫](https://github.com/neko-para/maa-support-extension)

## 安裝

推薦直接在 VSCode 的插件列表中搜索 `Maa` 來安裝.

## 功能

### 控制面板

左側添加了專用控制面板, 圖示 ![MaaSupport ControlPanel](/images/maa-support-panel.svg)

插件的絕大部分功能均基於 `interface.json` 配置. 在控制面板最頂部可以選擇生效的 `interface.json`.

插件有 `Maa` 相容模式. 當在打開文件夾下檢測到存在 `src/MaaCore` 文件夾時, 會自動啟用.

### 語義化資源分析

通過切換控制面板中的 `資源` 下拉框, 選擇預期的資源. 插件會根據對應路徑來進行索引和診斷.

如果發現想要編輯的 json 文件沒有插件提示, 請檢查是否啟用的資源並沒有包含該文件.

> 所謂 `任務的定義`, 指任務對象的鍵
>
> 所謂 `任務的引用`, 指其它任務中可以填入任務名稱的值 (例如 `next` 中)

#### 查詢任務定義/引用

插件支持跳轉到定義, 跳轉到引用, 查看任務定義.

開啟 `Maa` 相容模式時, 可以解析 `模板任務`, 支持同步基類查詢任務定義和引用; 懸停任務定義, 可以查看同名圖片.

#### 查詢/打開圖片

插件支持打開圖片.

開啟 `Maa` 相容模式時, 允許圖片路徑進行遞迴搜索.

#### 補全任務

插件支持根據所有已知任務進行自動補全.

開啟 `Maa` 相容模式時, 輸入 `@` 將會觸發補全.

#### 補全圖像路徑

插件支持根據所有已知圖片路徑進行自動補全.

開啟 `Maa` 相容模式時, 允許圖片路徑進行遞迴搜索.

#### 校驗任務/圖像路徑

插件支持定時掃描並分析所有任務.

- 檢查是否有重名任務定義
- 檢查是否有未知任務引用
- 檢查是否有未知圖片引用
- 檢查單個任務中是否有重複的任務引用

#### 多路徑資源支持

插件支持資源包含多個路徑, 會按照指定順序進行邏輯覆蓋, 即後載入的可以引用到前載入的內容.

### 計算任務 / 任務列表表達式 (僅 Maa)

通過控制面板, 可以計算任務實際展開的內容, 以及每一項的來源; 可以計算任務列表表達式展開的結果

### MaaPiCli 功能 (僅 MaaFramework 項目)

通過控制面板, 可以掃描並選擇控制器, 選擇資源, 添加並管理任務, 以及執行任務.

### 截圖裁剪功能

在 VSCode 的命令面板中搜索執行 `Maa: 打開截圖工具`, 可打開 `截圖 / 裁剪` 面板.

> 使用 `Ctrl+Shift+P` (MacOS 上則是 `Command+Shift+P`) 呼出命令面板

- 選擇並連接控制器後, 可使用 `截圖` 按鈕直接獲取截圖
- 可使用 `上傳` 按鈕手動上傳
- 按住 `Ctrl` 鍵, 框選需要裁剪的區域
- 使用滾輪可進行縮放
- 裁剪完成後, 使用 `下載` 按鈕, 可自動將裁剪結果保存到啟用資源的最頂層的圖片目錄

### 底部狀態欄

#### MaaSupport \[插件版本\]

點擊可聚焦控制面板

#### MaaFramework \[MaaFw版本\]

點擊可切換插件使用的 `MaaFramework` 版本

> 首次使用時, 插件會自動下載預設版本.
>
> 搜索命令 `Maa: 選擇下載源`, 可切換下載源 (npm / cnpm)
