---
order: 3
icon: hugeicons:brain-02
---

# 刷理智

## 常规设置

- `吃理智药` + `吃源石` 和 `指定次数`、`指定材料` 三个选项为短路开关（或门），即达成三个选项中的任一条件，均会视为任务完成，停止刷理智。
  - `吃理智药` 指定补充几次理智（可能一次吃多瓶药）。
  - `吃源石` 指定碎几颗石头（一次一颗），当仓库中有理智药时不会碎石。
  - `指定次数` 指定刷多少次指定关卡（例如“刷 15 次后停止”）。
  - `指定材料` 指定刷多少个指定材料（例如“获取 5 个固源岩后停止”）。

- `指定材料` 与 `关卡选择` 是两个互相独立的逻辑。`指定材料` 只是以材料个数作为任务完成依据，并不会自动导航到相应关卡。
- `吃源石` 只会在 `吃理智药` 之后判断，因为 MAA 只有在没有理智药时才会使用源石补充理智。所以在勾选 `吃源石` 之后，MAA 会将 `吃理智药` 的次数锁定为 999，确保将理智药吃光，以避免跳过 `吃源石` 判断。

::: details 例子

| 吃理智药 | 吃源石 | 指定次数 | 指定材料 | 结果                                                                                                                                                    |
| :------: | :----: | :------: | :------: | ------------------------------------------------------------------------------------------------------------------------------------------------------- |
|          |        |          |          | 刷完现有理智即结束。                                                                                                                                    |
|    2     |        |          |          | 先刷完现有理智，然后吃一次理智药，一共吃 `2` 次，刷完理智后结束。                                                                                       |
|  _999_   |   2    |          |          | 先刷完现有理智，并吃光理智药后，再碎石，一共碎 `2` 次，刷完理智后结束。                                                                                 |
|          |        |    2     |          | 刷 `2` 次选择的关卡即结束。                                                                                                                             |
|          |        |          |    2     | 掉落统计刷到 `2` 个指定的材料即结束。                                                                                                                   |
|    2     |        |    4     |          | 在最多吃 `2` 次理智药的情况下，刷 `4` 次选择的关卡即结束。                                                                                              |
|    2     |        |          |    4     | 在最多吃 `2` 次理智药的情况下，掉落统计刷到 `4` 个指定的材料即结束。                                                                                    |
|    2     |        |    4     |    8     | 在最多吃 `2` 次理智药的情况下，刷 `4` 次选择的关卡即结束。但如果在没刷完 `4` 次之前就获得了 `8` 个指定材料，则会提前结束。                              |
|  _999_   |   4    |    8     |    16    | 在最多吃光理智药并碎 `4` 次石头的情况下，刷 `8` 次选择的关卡即结束。但如果在没刷完 `8` 次之前就获得了 `16` 个指定材料，则会提前结束。                   |
|          |   2    |          |          | 先刷完现有理智，如果仓库中有理智药则结束，如果没有理智药则碎 `2` 次石，刷完理智后结束。_非 MAA GUI 行为_                                                |
|    2     |   4    |          |          | 先刷完现有理智，如果吃完 `2` 次理智药后还有理智药，则结束；如果吃完 ≤`2` 次理智药后没有理智药了，则继续碎 `4` 次石头，刷完理智后结束。_非 MAA GUI 行为_ |

:::

### 关卡选择

- 若关卡选择中没有你需要的关卡，请在 MAA 中选择 `当前/上次`，然后在游戏中手动定位关卡
  确保画面停留在 右上角有关卡名和剩余理智，右下角有代理指挥和开始行动 的关卡详情界面。
- 若当前不处于此界面，则 `当前/上次` 会自动进入终端首页右下角“上次作战”的关卡。
- 也可以在 `任务设置` - `刷理智` - `高级设置` 中启用 `手动输入关卡名` 手动输入关卡编号。目前支持导航的关卡有：
  - 全部主线关卡。可在关卡末尾添加 `-NORMAL` 或 `-HARD` 来切换标准或磨难关卡。
  - 龙门币、作战记录的 5 / 6 关，但必须输入 `CE-6` / `LS-6`。MAA 会在第六关无法代理的情况下自动切换至第五关。
  - 技能书、采购凭证、碳本第 5 关，必须输入 `CA-5` / `AP-5` / `SK-5`。
  - 所有芯片本。必须输入完整关卡编号，如 `PR-A-1`。
  - 剿灭模式支持以下传入值，必须使用对应的 Value：
    - 当期剿灭：Annihilation
    - 切尔诺伯格：Chernobog@Annihilation
    - 龙门外环：LungmenOutskirts@Annihilation
    - 龙门市区：LungmenDowntown@Annihilation

  - 别传中的 `OF-1` / `OF-F3` / `GT-5`。
  - 当期 SS 活动 后三关。在自动访问 [API](https://api.maa.plus/MaaAssistantArknights/api/gui/StageActivity.json) 下载更新后会在界面下方显示。
  - 复刻的 SS 活动。输入 `SSReopen-<关卡前缀>` ，可一次性刷完 XX-1 ~ XX-9 关，如 `SSReopen-IC`。

::: details 示例画面
![示例画面](/images/zh-cn/combat-start-interface-example.png)
:::

### 剿灭模式

- MAA 仅通过终端首页右上角的剿灭按钮跳转，请确保所选择的剿灭关卡已解锁 `全权委托`，并持有足够数量的 `PRTS 剿灭代理卡`。
- 仅建议已达成 ｢400 杀｣ 的关卡使用自动剿灭功能。

## 高级设置

### 备选关卡

备选关卡根据当天关卡开放情况决定战斗关卡，即选择第一个开放关卡进行战斗。
这是一个类似于日程表的功能，并不能当做关卡选择任务失败时的备用关卡。

1. 例子：关卡选择 `龙门币-6/5`，备选选择 `1-7` 和 `经验-6/5`：
   - 如果当天开放 `龙门币-6/5`，就会前往 `龙门币-6/5`，不会前往 `1-7` 和 `经验-6/5`。如果玩家此时未解锁 `龙门币-6/5` 代理，则刷理智任务出错。
   - 如果当天未开放 `龙门币-6/5`，则会前往 `1-7`，不会前往 `龙门币-6/5`。如果玩家此时未解锁 1-7 代理，则刷理智任务出错。
   - 由于 `经验-6/5` 前存在常驻关卡 `1-7`，在这种情况下，MAA 永远也不会前往 `经验-6/5` 战斗。
2. 若关卡选择为 `剿灭模式`，则：
   - 不会因为剿灭的结果影响其余备选关卡的选择逻辑，即使剿灭出错，刷理智任务也不会出错。
   - 剩余的备选关卡只会继承 `吃理智药` 和 `代理倍率` 的设置，不受 `吃源石`、`指定次数`、`指定材料` 的控制。

### 剩余理智

在 `刷理智` 任务结束后启动，不受 `吃理智药`、`吃源石`、`指定次数`、`指定材料`、`代理倍率` 的控制，刷完当前剩余理智即结束。

- 适用于在 `关卡选择` 关卡理智不足后，继续前往 `剩余理智` 关卡清理剩余的“边角”理智（如前往 1-7）。
- 亦适用于在代理倍率设置过高而理智不足时自动以单次连战刷光理智收尾（设置 1-7 连战 6 次，但只有 30 理智，于是自动转为刷 5 次不连战的 1-7）。
- 若剩余理智仍然不足则会结束任务（如少于 6 理智）。
- 如果剩余理智选择关卡为未开放关卡，则刷理智任务出错。

### 代理倍率

MAA 会根据用户设定的代理倍率进行战斗：

- **AUTO模式**（0）：
  - 自动识别关卡最大代理倍率, 保持最大代理倍率且理智不溢出
  - 完成后进入`剩余理智`流程（若设置）

- **数值模式**（1~6）：
  - 按设定倍率执行代理
  - 若当前理智不足完成设定次数（如仅够5次但设为6次）, 会直接结束任务并进入`剩余理智`流程（若设置）

- **禁用模式**（-1）：
  - 不调整游戏内代理倍率设置
  - 若理智不足完成游戏内当前设定次数, 直接结束任务进入`剩余理智`流程（若设置）

### 指定次数

MAA 将最多执行指定次数的战斗。

示例: 假设当前 100 理智, 关卡消耗 6 理智

- 指定次数设为 10, 代理倍率设为 4: 将执行 2 (次开始行动) x 4(倍代理) = 8 次作战(floor(10 / 4) x 4 = 8), 消耗 8 x 6 = 48 理智。此时若再进行一次4倍代理则达到 12 次作战, 超过设定的 10 次, 故不再执行, 以 8 次作战结束任务
- 指定次数设为 10, 代理倍率设为 AUTO: 将执行 一次6倍代理 + 一次4倍代理 = 10 次作战(6 x floor(10 / 6) + (10 % 6) = 10), 消耗 10 x 6 = 60 理智

### 掉落识别

- 支持自动识别并统计材料掉落，同时上传 [企鹅物流数据统计](https://penguin-stats.cn/) 和 [一图流](https://ark.yituliu.cn/)。
- 支持自定义企鹅物流用户 ID。

## 异常检测

- 支持自动勾选 `代理指挥`。
- 支持掉线后或凌晨 4 点闪断后自动重连并继续任务。
- 支持等级提升后继续任务。
- 代理失败时会放弃本次行动并重新战斗。
