---
order: 4
icon: mingcute:android-fill
---

# Android 实体设备

::: warning
此方法涉及 ADB 命令行，稳定性较低且仍需与电脑连接，**不推荐** 0 基础玩家尝试。
:::

::: info 注意

0. 需同时参阅 [连接设置](../connection.md)。
1. 从 Android 10 开始，Minitouch 在 SELinux 为 `Enforcing` 模式时不再可用，请切换至其他触控模式，或将 SELinux **临时**切换为 `Permissive` 模式。
2. 由于 Android 生态极为复杂，可在 MAA `设置` - `连接设置` 中尝试将 `连接配置` 修改为 `通用模式` 或 `兼容模式` 或 `第二分辨率` 或 `通用模式（屏蔽异常输出）`，直到某个模式可以正常使用。
3. 由于 MAA 仅支持 `16:9` 比例的分辨率，所以非 `16:9` 或 `9:16` 屏幕比例的设备需要强制修改分辨率，这包含大多数现代设备。若被连接设备屏幕分辨率比例原生为 `16:9` 或 `9:16`，则可跳过 `更改分辨率` 部分。
4. 请将设备导航方式切换为除 `全面屏手势` 以外的方式，如 `经典导航键` 等以避免误操作。
5. 请将游戏内设置中的 `异形屏UI适配` 一项调整为 0 以避免任务出错。

:::

::: tip
典型的 `16:9` 比例的分辨率有 `3840*2160` (4K)、`2560*1440` (2K)、`1920*1080` (1080P)、`1280*720` (720P)。
:::

## 下载、运行 ADB 调试工具并连接设备

1. 下载 [ADB](https://dl.google.com/android/repository/platform-tools-latest-windows.zip) 并解压。
2. 打开解压后的文件夹，清空地址栏并输入 `cmd` 后回车。
3. 在弹出的命令提示符窗口中输入 `adb` ，若给出大量英文帮助文本则运行成功。
4. 手机开启 `USB 调试`，每个品牌的手机进入方式可能不同，请善用搜索引擎。厂商可能会提供有关 USB 调试的额外选项，如 MIUI 中的 `USB安装` 和 `USB调试（安全设置）`，请同时开启。
5. 将手机通过数据线连接至电脑，在刚刚的命令提示符窗口中输入以下命令。

   ```bash
   adb devices
   ```

- 成功执行后会给出已连接 `USB 调试` 设备的信息。
  - 连接成功的例子：

    ```bash
    List of devices attached
    VFNDU1682100xxxx        device
    ```

  - **`device` 前的英文数字组合为设备序列号，同时也作为 MAA 的 `连接地址`。**

- 现代安卓设备进行 `USB调试` 需在被调试设备上点击弹窗授权，若未授权则例子如下：

  ```bash
  List of devices attached
  VFNDU1682100xxxx        unauthorized
  ```

- 若无论如何都提示未授权或设备序列号后显示 `offline`，则需重启设备及电脑后重试。如仍未解决问题，可删除当前用户个人文件夹下的 `.android` 文件夹并再次重启后重试，具体位置请自行搜索。

## 更改分辨率

::: tip
手机屏幕分辨率为 `短边*长边`，而非电脑显示器的 `长边*短边`。具体数值请根据目标设备自行确定。
:::

- 如果上文设备列表内仅有一台设备，则可直接运行以下命令更改/还原分辨率。

  ```bash
  # 查看当前分辨率
  adb shell wm size
  #还原默认分辨率
  adb shell wm size reset

  # 更改分辨率为 720p
  adb shell wm size 720x1280
  # 更改分辨率为 1080p
  adb shell wm size 1080x1920
  ```

- 若存在多台设备，则需在 `adb` 和 `shell` 中间添加参数 `-s <目标设备序列号>`，例子如下。

  ```bash
  # 查看当前分辨率
  adb -s VFNDU1682100xxxx shell wm size
  # 还原默认分辨率
  adb -s VFNDU1682100xxxx shell wm size reset

  # 更改分辨率为 720p
  adb -s VFNDU1682100xxxx shell wm size 720x1280
  # 更改分辨率为 1080p
  adb -s VFNDU1682100xxxx shell wm size 1080x1920
  ```

- 部分设计不规范的应用可能在还原分辨率后内容布局仍然错乱，一般重启对应应用或设备即可解决。

::: danger 注意
强烈建议在**下次重启设备前**还原分辨率，否则因设备而定可能会导致不可预料的后果，~~包括但不限于布局混乱，触控错位，应用闪退，无法解锁等~~。
:::

::: danger 注意

已知在部分实体设备上 `账号切换` 功能可能无法正常工作。MAA 主要在电脑端模拟器环境工作，所以并无计划修复该问题。

如果你遇到这个问题，可以通过以下任意一种方式修改屏幕密度（DPI）（建议取值为 `[100-800]`）：

- 使用指令 `adb shell wm density <DPI>` 直接修改 DPI
- 调整 `开发者选项→最小宽度`，通过修改 `最小宽度` 间接修改 DPI

  注：`DPI` 和 `最小宽度` 成反比，换算关系为 `最小宽度 = 屏幕宽度(px) / (DPI / 160)`

**注意该操作存在风险，可能使设备工作异常。请确保你知道自己在做什么，设备故障后果自负。**

强烈建议在**下次重启设备前**还原这些更改。如忘记默认值，无论使用何种方式修改，均可使用指令 `adb shell wm density reset` 还原。

:::

## 自动化更改分辨率

1. 在 MAA 目录下新建两个文本文件，分别在其中填入以下内容。

   ```bash
   # 调整分辨率为 1080p
   adb -s <目标设备序列号> shell wm size 1080x1920
   # 降低屏幕亮度（可选）
   adb -s <目标设备序列号> shell settings put system screen_brightness 1
   ```

   ```bash
   # 还原分辨率
   adb -s <目标设备序列号> shell wm size reset
   # 提高屏幕亮度（可选）
   adb -s <目标设备序列号> shell settings put system screen_brightness 20
   # 返回桌面（可选）
   adb -s <目标设备序列号> shell input keyevent 3
   # 锁屏（可选）
   adb -s <目标设备序列号> shell input keyevent 26
   ```

2. 将第一个文件重命名为 `startup.bat`，第二个文件重命名为 `finish.bat`。
   - 如果重命名后没有弹出修改扩展名的二次确认对话框，且文件图标没有变化，请自行搜索“Windows 如何显示文件扩展名”。

3. 在 MAA 的 `设置` - `连接设置` - `开始前脚本` 和 `结束后脚本` 中分别填入 `startup.bat` 和 `finish.bat`。

## 连接 MAA

### 有线连接

::: tip
使用有线连接不需要任何 IP 地址或端口，只需要 `adb devices` 给出的设备序列号。
:::

1. 将上文获取到的目标设备序列号填入 MAA `设置` - `连接设置` - `连接地址` 中。
2. Link Start!

### 无线连接

- 请确保设备与电脑处在同一局域网环境下且能互相通信。诸如 `AP 隔离`、`访客网络` 等设置会阻止设备间通信，具体请查阅对应路由器文档。
- 无线调试在设备重启后失效，需要重新设置。

#### 使用 `adb tcpip` 开启无线端口

1. 在刚刚的命令提示符窗口中输入以下命令以开启无线调试。

   ```bash
   adb tcpip 5555
   # 存在多台设备则添加参数 -s 以指定序列号
   ```

2. 查看设备 IP 地址。
   - 进入手机 `设置` - `WLAN`，点击当前已连接的无线网络查看 IP 地址。
   - 各类品牌设备设置位置不同，请自行查找。

3. 将 `<IP>:5555` 填入 MAA `设置` - `连接设置` - `连接地址` 中，如 `192.168.1.2:5555`。
4. Link Start!

#### 使用 `adb pair` 开启无线端口

::: tip
`adb pair` 无线配对，即使用安卓 11 及更新版本中开发者选项内的 `无线调试` 进行配对后连接，与 `adb tcpip` 相比可以避免有线连接。
:::

1. 进入手机开发者选项，点击 `无线调试` 并开启，点击确定，点击 `使用配对码配对设备`，在配对完成前不要关闭出现的弹窗。

2. 进行配对。
   1. 在命令提示符中输入 `adb pair <设备弹窗给出的 IP 地址和端口>`，回车。
   2. 输入 `<设备弹窗给出的六位配对码>`，回车。
   3. 窗口出现 `Successfully paired to <IP:端口>` 等内容，同时设备上的弹窗自动消失，底部已配对的设备中出现计算机名称。

3. 将当前设备屏幕上给出的 `<IP 地址和端口>` 填入 MAA `设置` - `连接设置` - `连接地址` 中，如 `192.168.1.2:11451`，**一定和刚刚填写的不一样**。
4. Link Start!

#### 使用 root 权限开启无线端口

~~都接触到 root 了还用得着看这段文档吗~~

1. 下载、安装 [WADB](https://github.com/RikkaApps/WADB/releases) 并授予其 root 权限。
2. 打开 WADB，启动无线 adb。
3. 将 WADB 提供的 IP 地址及端口填入 MAA `设置` - `连接设置` - `连接地址` 中，如 `192.168.1.2:5555`。
4. Link Start!
