---
order: 8
icon: iconoir:code-brackets
---

# 专用 VSCode 插件教程

该插件针对 MaaAssistantArknights/MaaFramework 提供了一系列方便开发的能力，包括但不限于以下功能：

- tasks.json 支持，包含 `template 预览`，`next 跳转`，`任务引用` 等等
- 截取/裁剪图片

具体内容可以前往 [插件商店](https://marketplace.visualstudio.com/items?itemName=nekosu.maa-support) 或是 [仓库](https://github.com/neko-para/maa-support-extension) 查看

## 安装

推荐直接在 VSCode 的插件列表中搜索 `Maa` 来安装

::: tip
首次使用时, 插件会自动下载预设版本的资源
搜索命令 `Maa: 选择下载源`, 可切换下载源 (npm / cnpm)
:::

## 功能

### 控制面板

左侧添加了专用控制面板, 图标 ![MaaSupport ControlPanel](/images/maa-support-panel.svg)

插件的绝大部分功能均基于 `interface.json` 配置. 在控制面板最顶部可以选择生效的 `interface.json`.

插件有 `Maa` 兼容模式. 当在打开文件夹下检测到存在 `src/MaaCore` 文件夹时, 会自动启用.

### 语义化资源分析

通过切换控制面板中的 `资源` 下拉框, 选择预期的资源. 插件会根据对应路径来进行索引和诊断.

如果发现想要编辑的 json 文件没有插件提示, 请检查是否激活的资源并没有包含该文件.

> 所谓 `任务的定义`, 指任务对象的键
>
> 所谓 `任务的引用`, 指其它任务中可以填入任务名称的值 (例如 `next` 中)

#### 查询任务定义/引用

插件支持跳转到定义, 跳转到引用, 查看任务定义.

开启 `Maa` 兼容模式时, 可以解析 `模板任务`, 支持联动基类查询任务定义和引用; 悬停任务定义, 可以查看同名图片.

#### 查询/打开图片

插件支持打开图片.

开启 `Maa` 兼容模式时, 允许图片路径进行递归搜索.

#### 补全任务

插件支持根据所有已知任务进行自动补全.

开启 `Maa` 兼容模式时, 输入 `@` 将会触发补全.

#### 补全图像路径

插件支持根据所有已知图片路径进行自动补全.

开启 `Maa` 兼容模式时, 允许图片路径进行递归搜索.

#### 校验任务/图像路径

插件支持定时扫描并分析所有任务.

- 检查是否有重名任务定义
- 检查是否有未知任务引用
- 检查是否有未知图片引用
- 检查单个任务中是否有重复的任务引用

#### 多路径资源支持

插件支持资源包含多个路径, 会按照指定顺序进行逻辑覆盖, 即后加载的可以引用到前加载的内容.

### 计算任务 / 任务列表表达式 (仅 Maa)

通过控制面板, 可以计算任务实际展开的内容, 以及每一项的来源; 可以计算任务列表表达式展开的结果

### MaaPiCli 功能 (仅 MaaFramework 项目)

通过控制面板, 可以扫描并选择控制器, 选择资源, 添加并管理任务, 以及执行任务.

### 截图裁剪功能

在 VSCode 的命令面板中搜索执行 `Maa: 打开截图工具`, 可打开 `截图 / 裁剪` 面板.

> 使用 `Ctrl+Shift+P` (MacOS 上则是 `Command+Shift+P`) 呼出命令面板

- 选择并连接控制器后, 可使用 `截图` 按钮直接获取截图
- 可使用 `上传` 按钮手动上传
- 按住 `Ctrl` 键, 框选需要裁剪的区域
- 使用滚轮可进行缩放
- 裁剪完成后, 使用 `下载` 按钮, 可自动将裁剪结果保存到激活资源的最顶层的图片目录

### 底部状态栏

#### MaaSupport <插件版本>

点击可聚焦控制面板

#### MaaFramework <MaaFw版本>

点击可切换插件使用的 `MaaFramework` 版本
