---
order: 8
icon: mdi:remote-desktop
---

# 원격 제어 프로토콜

MAA를 원격으로 제어하려면 http(s) 서비스를 제공해야 합니다. 이 서비스는 아래 두 가지 익명 엔드포인트를 제공해야 합니다. 이 두 엔드포인트는 웹 엔드포인트이며 http(s) 프로토콜이어야 합니다.

::: warning
엔드포인트가 http 프로토콜인 경우 MAA는 연결시마다 안전하지 않음 경고를 발생시킵니다. **공개 네트워크에 프로토콜을 배포하는 것은 매우 권장되지 않으며 위험합니다. 테스트 용도로만 사용하세요!**
:::

::: tip
주의: JSON 형식은 주석을 지원하지 않으므로 아래의 예시에서 주석은 제거해주시기 바랍니다.
:::

## 작업 엔드포인트 가져오기

MAA는 이 엔드 포인트를 계속하여 폴링하여 실행해야하는 작업을 시도하고 가져와야합니다. 그리고 가져온 목록에 따라 순서대로 실행합니다.

엔드 포인트 경로는 자유롭지만 반드시 http(s) 엔드 포인트 여야합니다. 예를 들어: `https://your-control-host.net/maa/getTask`

제어 대상 MAA는 이 엔드포인트를 MAA 설정의 `작업 가져오기 엔드포인트` 텍스트 상자에 작성해야합니다.

이 엔드포인트는 `Content-Type=application/json`의 POST 요청을 수락해야하며, 이 요청은 다음과 같은 JSON을 요청 본문으로 수락 할 수 있어야합니다.

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // 사용자가 MAA 설정에 제공한 사용자 식별자.
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec"         // MAA가 생성 한 장치 식별자.
    ...     // 이 엔드포인트에 다른 용도가 있는 경우 선택적 매개 변수를 추가 할 수 있지만 MAA는 user 및 device 만 전달합니다.
}
```

이 엔드포인트는 JSON 형식의 응답을 반환해야하며 최소한 다음 형식을 충족해야합니다.

```json
{
    "tasks":                            // MAA가 실행해야하는 Task 목록입니다. 현재 지원되는 유형은 아래 예시와 같습니다. 작업이없는 경우 연결이 무효로 간주됩니다.
    [
        // 순차 실행 작업: 아래 작업은 전달된 순서대로 대기열에 들어갑니다
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "CaptureImage",                         //스크린샷 작업입니다. 현재 에뮬레이터의 스크린샷을 캡처하고 작업 보고서의 페이로드에 Base64 문자열로 넣습니다. 이러한 유형의 작업을 발행해야하는 경우 요청하는 엔드 포인트가 수용 할 수 있는 최대 요청 크기에 주의하세요. 스크린샷은 수십 메가바이트가 있으며 일반적인 게이트웨이의 기본 크기 제한을 초과할 수 있습니다.
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "LinkStart",                            //원 클릭 모의 농장 시작
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "LinkStart-Recruiting",                 //현재 구성에 따라 원 클릭 모의 농장의 해당 하위 기능을 독립적으로 실행합니다. 주 요구 사항에 대한 이러한 타입의 옵션은 아래에 나와 있습니다.
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "Toolbox-GachaOnce",                    //툴박스에서의 하나의 카드 뽑기 작업입니다. 이 유형의 선택할 수 있는 값은 Toolbox-GachaOnce, Toolbox-GachaTenTimes입니다.
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "Settings-ConnectionAddress",           //설정 항목을 수정하는 작업입니다. ConfigurationHelper.SetValue("ConnectionAddress", params);를 실행하는 것과 동일합니다. 안전을 위해 모든 구성이 수정 가능한 것은 아닙니다. 수정 가능한 구성에 대한 자세한 내용은 아래를 참조하세요.
            "params": "value"                               //수정할 값
        },
        //즉시 실행 작업: 아래 작업은 순차 실행 작업 중 실행되며, MAA는 아래의 모든 작업이 가능한 한 빨리 결과를 반환 할 것임을 보장합니다. 이러한 작업은 일반적으로 원격 제어 기능 자체의 제어에 사용됩니다.
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "CaptureImageNow",                      //즉시 스크린샷 작업입니다. 위의 스크린샷 작업과 기본적으로 동일하지만 이 작업은 다른 작업을 기다리지 않고 즉시 실행됩니다.
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "StopTask",                             //현재 작업을 종료하는 작업입니다. 현재 실행중인 작업을 종료하려고 시도합니다. 목록에 다른 작업이있는 경우 다음 작업을 계속하여 실행합니다. 이 작업은 현재 작업이 중지되고 확인되기를 기다리지 않으므로 중지 명령이 적용되었는지 확인하기 위해 하트비트 작업을 사용하세요.
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //작업의 고유 ID, 문자열 형식입니다. 작업 보고서에 사용됩니다.
            "type": "HeartBeat",                            //하트비트 작업은 즉시 반환되며, 현재 "순차 실행 작업" 대기열에서 실행 중인 작업의 ID를 페이로드로 반환합니다. 현재 작업이 없으면 빈 문자열을 반환합니다.
        },
    ],
    ...     //이 엔드포인트에 다른 용도가 있는 경우 선택적 반환 값을 추가 할 수 있지만 MAA는 작업 만 읽습니다.
}
```

이러한 작업은 순서대로 실행되므로 먼저 공개 인수를 내보내고 나중에 스크린샷을 보내면 스크린샷이 공개 인수 이후에 실행됩니다.
이 엔드 포인트는 재진입이 가능하고 반복적으로 작업을 반환해야합니다. MAA는 작업 ID를 자동으로 기록하며 동일한 ID의 경우 작업을 다시 실행하지 않습니다.

::: note

- LinkStart-[TaskName] 유형의 작업 유형의 LinkStart의 선택 가능한 값은 LinkStart-Base, LinkStart-WakeUp, LinkStart-Combat, LinkStart-Recruiting, LinkStart-Mall, LinkStart-Mission, LinkStart-AutoRoguelike, LinkStart-Reclamation입니다.
- Settings-[SettingsName] 작업 유형의 유형 매개 변수의 선택 가능한 값은 Settings-ConnectionAddress, Settings-Stage1입니다.
- 설정 시리즈 작업은 여전히 순서대로 실행되며 작업을 받은 즉시 실행되지 않으며 이전 작업 뒤에 배치됩니다.
- 여러 즉시 실행 작업은 순서대로 실행되지만 이러한 작업은 모두 빠르게 실행되므로 순서에 관심을 두지 않아도됩니다.

:::

## 작업 보고 엔드 포인트

MAA가 작업을 완료하면 작업의 실행 결과를 원격에 보고해야합니다.

엔드 포인트 경로는 자유롭지만 반드시 http(s) 엔드 포인트 여야합니다. 예를 들어: `https://your-control-host.net/maa/reportStatus`

제어 대상 MAA는이 엔드 포인트를 MAA 설정의 `작업 보고 엔드포인트` 텍스트 상자에 작성해야합니다

이 엔드포인트는 `Content-Type=application/json`의 POST 요청을 수락해야하며, 이 요청은 다음과 같은 JSON을 요청 본문으로 수락 할 수 있어야합니다.

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // 사용자가 MAA 설정에 제공한 사용자 식별자.
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec",        // MAA가 생성 한 장치 식별자.
    "task":"15be4725-5bd3-443d-8ae3-0a5ae789254c",          // 보고 할 작업의 ID는 작업을 가져올 때의 ID와 일치합니다.
    "status":"SUCCESS",                                     // 작업 실행 결과는 SUCCESS 또는 FAILED입니다. 일반적으로 작업이 성공하든 실패하든 SUCCESS 만 반환됩니다. 특별한 경우에만 실패를 반환합니다. 실패한 경우 상세 내용은 해당 작업 소개에서 명확하게 설명됩니다.
    "payload":"",                                           // 보고서에 대한 데이터는 문자열 형식입니다. 작업 유형에 따라 달라집니다. 예를 들어 스크린샷 작업 보고서는 여기에 스크린샷의 Base64 문자열을 가져옵니다.
    ...     // 이 엔드포인트에 다른 용도가 있는 경우 선택적 매개 변수를 추가 할 수 있지만 MAA는 user 및 device 만 전달합니다.
}
```

이 엔드 포인트의 반환 내용은 상관 없습니다. 그러나 200OK를 반환하지 않으면 MAA 측에서 `업로드 실패`라는 알림이 표시됩니다.

## 예시 워크플로우 - QQBot을 사용하여 MAA 제어

A 개발자는 자신의 QQBot을 사용하여 MAA를 제어하려고합니다. 따라서 공개 네트워크에서 노출 된 백엔드를 개발하여 다음 두 가지 엔드포인트를 제공합니다.

> [!tip]
> https://myqqbot.com/maa/getTask
> https://myqqbot.com/maa/reportStatus

사용자의 편의를 위해 getTask 인터페이스는 어떤 매개 변수를 받더라도 기본적으로 200OK와 비어있는 작업 목록을 반환합니다.
요청이 수신되면 A는 데이터베이스에서 중복 장치를 확인하고 그렇지 않으면 해당 장치와 사용자를 데이터베이스에 기록합니다.
즉,이 워크플로우에서는이 엔드포인트가 사용자 등록을 담당합니다.

그는 QQBot에 사용자의 장치 ID를 제출하는 명령을 제공했습니다.

그의 QQBot 사용 설명서에는 MAA의 `사용자 식별자`에 자신의 QQ 번호를 입력하고 `장치 식별자`를 QQ 채팅으로 보내도록 지시합니다.

A는 장치 ID를 수신하면 QQBot이 메시지의 사용자 QQ 번호를 기준으로 데이터베이스에서 해당 레코드를 찾아보고 없으면 사용자가 먼저 MAA를 구성하라고 알립니다.
MAA를 구성 한 후 사용자가 MAA를 구성하면 MAA가 지속적으로 요청을 보내기 때문에 사용자가 MAA를 구성하면 메시지를 제출 할 때 데이터베이스에 일치하는 레코드가 있어야합니다.

이후 Bot은 데이터베이스의 해당 레코드를 확인하고 검증 된 플래그를 설정하여이 장치 및 사용자가 빠른 getTask 요청에 대한 진정한 작업 목록을 반환하도록합니다.

사용자가 QQBot을 통해 명령을 제출하면 Bot은 데이터베이스에 작업을 작성하므로 getTask가 이러한 작업을 반환합니다. 또한 사용자가 명령을 제출할 때마다,이 QQBot은 기본적으로 스크린 샷 작업 하나를 추가합니다.

작업이 완료되면 MAA가 reportStatus를 호출하여 결과를 보고하면 Bot은 결과를받고 사용자에게 메시지를 보내고 스크린 샷을 표시합니다.

## 예시 워크플로우 - 웹 사이트를 사용하여 MAA 제어

B 개발자는 웹 사이트를 작성했으며 웹 사이트를 통해 MAA를 대량으로 관리하려고합니다. 따라서 공개 네트워크에서 자체 사용자 관리 시스템을 보유하고 두 가지 익명 엔드 포인트를 제공하는 백엔드를 개발했습니다.

> [!tip]
> https://mywebsite.com/maa/getTask
> https://mywebsite.com/maa/reportStatus。

웹 사이트에는 MAA 인스턴스에 대한 연결을 표시하는 페이지가 있습니다. B 개발자는 랜덤 문자열을 `사용자 키`라고하는 이 페이지에 표시하고 장치 ID를 입력할 수있는 텍스트 상자가 있습니다.

웹 사이트는 MAA의 `사용자 식별자`에 사용자 키를 입력하고 `장치 식별자`를 웹 사이트에 입력하도록 요구합니다.

MAA의 설정에 올바르게 MAA 연결을 만들려면 웹 사이트에서 사용자 키 및 장치 ID가 정확해야합니다.

사용자가 웹 사이트를 통해 MAA에 대한 제어 명령을 제출하면 웹 사이트는 데이터베이스에 작업을 작성합니다.

웹 사이트는이 페이지를 공개하기 때문에 누구나 사용자 키를 복사하여 사용할 수 있지만 장치 ID가 없으면 적절한 데이터베이스 레코드를 찾을 수 없으므로 getTask 호출에 대한 결과는 빈 목록입니다.

작업이 완료되면 MAA가 reportStatus를 호출하여 결과를 보고하면 웹 사이트는 결과를받고 사용자에게 페이지를 업데이트하여 작업 결과를 표시합니다.

<!-- markdownlint-disable-file MD034 -->
