---
order: 5
icon: ri:game-fill
---

# 통합전략 스키마

::: tip
주의: JSON 형식은 주석을 지원하지 않으므로 아래의 예시에서 주석은 제거해주시기 바랍니다.
:::

## 로그라이크 리소스 파일 위치

- `resource/roguelike/`아래에 테마별 로그라이크 작업의 리소스를 저장합니다.
  - 테마 폴더: `Phantom/` 팬텀 로그라이크, `Mizuki/` 미즈키 로그라이크, `Sami/` 사미 로그라이크, `Sarkaz/` 살카즈 로그라이크, `JieGarden/` 쉐이 로그라이크
    - `autopilot/` 내에는 각 레벨의 작전 json이 있습니다.
      - `关卡名.json` 레벨의 작전 로직
    - `encounter/` 우연한 만남의 로직 (모든 비전투 및 상점이 아닌 노드)
      - `default.json` 레벨링 모드
      - `deposit.json` 오리지늄 주괴 모드
    - `recruitment.json` 오퍼레이터 모집 로직
    - `shopping.json` 상점 구매 수집품 로직

- 특별히, `Sami/` 아래의
  - `foldartal.json`은 사미 로그라이크의 암호판의 사용 로직을 나타냅니다.
  - `collapsal_paradigms.json`은 사미 로그라이크 붕괴 패러다임의 유형을 나타냅니다.
  - `autopilot/关卡名_collapse.json` 레벨의 작전 로직 (붕괴 패러다임 모드)
  - `encounter/collapse.json` 붕괴 패러다임 모드 우연한 만남 로직

- `Sarkaz/` 아래의
  - `fragments.json`은 살카즈 로그라이크 사념의 기본 정보를 저장합니다.
  - `map.json`은 살카즈 로그라이크 청사진 통과용 템플릿 이미지 정보를 저장합니다.

## 로그라이크 첫 단계 - 오퍼레이터 모집

`resource/roguelike/主题名/recruitment.json` 은 오퍼레이터 모집의 로직을 설명합니다.

```json
{
    "theme": "Phantom",              //로그라이크 테마 (팬텀)
    "priority": [                    //그룹의 우선순위, 순서대로
             ...
        ],
    "team_complete_condition": [     //팀의 완성도 검사
             ...
        ]
}
```

### 오퍼레이터 분류

게임 이해에 따라 오퍼레이터를 다양한 **_groups_** (관련 개념은 [전투 스키마](./copilot-schema.md)를 참고)으로 분류합니다

::: info 주의

1. 같은 그룹 내의 오퍼레이터와 소환물은 배치 방식이 일치해야 합니다(즉, 근접이거나 원거리로 동일).

2. 같은 오퍼레이터나 소환물을 다르게 사용할 수 있게 다른 그룹으로 분류할 수 있습니다.

3. 기존의 그룹 이름을 수정하지 마세요. MAA 업데이트 시 이전 버전의 작업을 사용할 수 없게 될 수 있습니다.

4. 새로운 그룹을 가능한 한 추가하지 마시고, 새로 추가하는 단위를 기존 그룹에 편입시키세요.

:::

::: tip
기본적으로 1정 55레벨 이상의 오퍼레이터만 모집합니다.
:::

```json
{
    "theme": "Phantom",
    "priority": [                     // 그룹, 순서대로
        {
            "name": "棘刺",           // 그룹 이름(이 그룹 이름은 쏜즈)
            "opers": [                // 그룹에 포함된 오퍼레이터, 순서대로, 오퍼레이터 배치 시 우선순위 표시,
                                      // (예를 들어 이 그룹의 오퍼레이터를 배치할 때, 먼저 가시가 있는지 확인하고, 가시가 있으면 가시를 배치하고, 없으면 다음 오퍼레이터를 확인)
                {
                    "name": "棘刺",   // 오퍼레이터 이름
                    ...
                },
                {
                    "name": "号角",
                    ...
                }
            ]
        },
       "team_complete_condition": [
             ...
        ]
    ]
}
```

1. 기존 그룹 소개

   팬텀의 로그라이크를 예로 들어 설명: 오퍼레이터는 주로 다음과 같이 분류됩니다.

   | Group                     | Considerations       | Class            | Operators                                                          |
   | :------------------------ | :------------------- | :--------------- | :----------------------------------------------------------------- |
   | **_Ground block_**        | 전장과 잡몹 정리     | 디펜더, 가드     | 라 플루마, 마운틴, 몬3터, 링과 씬의 소환물, 스팟, 디펜더 예비 인원 |
   | **_Ground single-block_** | 단독으로 보스와 교전 | 처형자, 스페셜   | 수르트, 키린R 야토, 몬3터, 레드                                    |
   | **_Ranged C_**            | 일반과 결전          | 스나이퍼, 캐스터 | 첸 더 홀룽데이, 골든글로우, 에이야퍄들라, 피아메타                 |
   | **_Ranged DPS_**          | 대공 및 일반         | 스나이퍼, 캐스터 | 아르케토, 엑시아, 크루스, 스튜어드                                 |
   | **_힐러_**                | 치료 능력            | 힐러, 서포터     | 켈시, 스카디 더 커럽팅 하트, 히비스커스, 안셀                      |
   | **_코스트 회복_**         | 코스트 회복          | 뱅가드           | 머틀, 이네스, 팽, 바닐라                                           |
   | **_포탄 흡수_**           | 포탄 흡수, 재배치    | 특수, 소환물     | 몬3터, 레드, 머틀, 예비 인원                                       |
   | **_고지대 예비_**         | 일정한 공격 능력     |                  | 오키드, 예비 인원                                                  |

2. 특별 취급이 필요한 그룹

   위의 일반적인 그룹 외에도 일부 오퍼레이터나 유형에 대한 맞춤형 조정이 필요할 수 있습니다.

   | Group       | Operators             | Features                                                                                             |
   | :---------- | :-------------------- | :--------------------------------------------------------------------------------------------------- |
   | Thorns      | 쏜즈, 혼              | 장거리 근접, 많은 맵에서 좋음                                                                        |
   | Summoners   | 켈시, 링, 씬          | 근접 블록, 일부 맵은 배치 우선순위 필요, 소환물은 블록 또는 포드로 사용 가능                         |
   | Agent       | 칸타빌레, 이네스      | 코스트 회복 가능, DPS 제공 및 단일 블록                                                              |
   | Skadi Alter | 스카디 더 커럽팅 하트 | 낮은 DP 비용, 특별한 범위, 일부 맵에서 최적의 위치                                                   |
   | Reed Alter  | 리드 더 플레임 섀도우 | 사미 로그라이크에서 개막 캐스터, DPS 및 치유로 자주 사용, 일부 맵에서 최적의 위치                    |
   | SilverAsh   | 실버애쉬, 무에나      | 큰 범위의 지상 오퍼레이터, 보스에게 매우 유용                                                        |
   | Surtr       | 수르트                | 수르트는 항상 세 번째 스킬을 사용하므로 위치 선정 능력이 거의 없으며, 배치 우선순위가 매우 낮습니다. |
   | Dice        | 주사위                | 미즈키 로그라이크에서 주사위는 별도로 작동해야 합니다.                                               |

::: info
현재 정해진 그룹을 알 수 없는 지상 크루는 마지막 전형 (다른 지상) 뒤에, 고지대 그룹는 마지막 전형 (다른 고지대) 뒤에 고정되어 있습니다.
:::

### 사전 설정 그룹--완전한 라인업 테스트

높은 계층을 통과하거나 도달하기 위해 기본 핵심 플레이어가 필요한 팀에서는 어떤 오퍼레이터가 필수적일까요? 몇 명이 필요할까요?

::: info
현재 스크립트의 모집 로직은 라인업 완성도를 충족하기 전에 0 희망과 코어 오퍼레이터를 모집하며, 높은 레어도의 코어 오퍼레이터를 위해 희망을 존버합니다.
따라서 너무 높은 임계값 수치를 설정하지 마시고, 필요한 모든 오퍼레이터 수 (기본 핵심 라인업)가 4-8 자릿수가 되도록 권장합니다.
:::

```json
{
    "theme": "Phantom",              // 로그라이크 테마
    "priority": [                    // 그룹
             ...
        ],
    "team_complete_condition": [     // 라인업 완성도 검사
        {
            "groups": [              // 필요한 그룹 멤버
                "C-team"
            ],
            "threshold": 1           // 필요한 오퍼레이터 수
        },                           // (이것은 C팀의 고지대 오퍼레이터이 필요하다는 것을 나타냅니다)
        {
            "groups": [
                "Thorns",              // (최소 2명의 오퍼레이터가 필요합니다 Thorns, GroundBlock, Ground1Block, Fodder)
                "GroundBlock",
                "Ground1Block",
                "Fodder"
            ],
            "threshold": 2
        },
        ...
        ]
}
```

### 오퍼레이터 모집을 위한 매개변수 조정

1. 그룹 내의 순서는 배치 검사 우선순위를 나타냅니다.

2. 그룹 멤버의 각 필드와 스크립트 관련 로직의 의미

   ```json
    {
        "theme": "Phantom",
        "priority": [
            "name": "GroundBlocking",                         // 그룹 이름 (이 경우 GroundBlocking)
            "doc": "기준 라인은 1단 기어 (청소 능력 또는 필드 능력이 산보다 우수) > 산 > 2단 기어 (블록>2, 자체 회복 가능) > Spot, 필드 능력이 Spot보다 적은 경우 단일 절단 또는 포드 그룹",
                                                            // Doc 필드는 노트입니다. 프로그램에는 영향을 미치지 않습니다.
            "opers": [                                        // 포함된 오퍼레이터, 순서대로 배치 우선순위를 나타냅니다.
                {
                    "name": "가비알 디 인빈서블",          // 오퍼레이터 이름 (가비알 디 인빈서블, 그룹 내 첫 번째 위치는
                                                            // 지상 블로킹 그룹 배치 시 우선적으로 이격 가비알의 여부를 확인합니다.)
                    "skill": 3,                               // 사용할 스킬 (이 경우 스킬 3)
                    "skill_usage": 2,                         // 스킬 사용 모드, 3.3COPILOT_SCHEMA 참조, 비어 있으면 기본값은 1, 2는 지정된 횟수만큼 사용
                                                            // (x는 "skill_times" 필드에 설정됨), 3은 아직 지원되지 않음.
                    "skill_times": 2,                         // 스킬 사용 횟수, 기본값은 1, "skill_usage" 필드가 2일 때 유효합니다.
                    "alternate_skill": 2,                     // 지정된 스킬이 없을 때 사용하는 대체 스킬, 일반적으로 6성 오퍼레이터가 E2를 달성하지 않았고
                                                            // 승진 후 3 스킬을 사용하는 경우
                                                            // (이 경우 3 스킬이 없을 때 2 스킬을 사용).
                    "alternate_skill_usage": 1                // 대체 스킬의 사용 모드 (이 필드는 아직 구현되지 않음)
                    "alternate_skill_times": 1                // 대체 스킬의 사용 횟수 (이 필드는 아직 구현되지 않음)
                    "recruit_priority": 900,                  // 모집 우선순위, 큰 숫자일수록 우선순위가 높으며, 900 이상은 반드시 모집
                                                            // 400 이하의 우선순위는 일부 핵심 오퍼레이터의 우선순위보다 낮음
                                                            // 임시로 모집된 오퍼레이터 우선순위는 자동으로 +800
                    "promote_priority": 600,                  // 승진 우선순위, 큰 숫자일수록 우선순위가 높으며, 900 이상은 충분한 희망이 있으면 보장된 E2
                                                            // 400 이하의 우선순위는 일반 3성 오퍼레이터보다 낮음
                                                            // 팁: 모집 우선순위를 낮추거나 작성하지 않고, 일부 E2의 우선순위를 높이면
                                                            // 임시로 모집된 오퍼레이터의 우선순위를 높이는 것입니다.
                    "is_key": true,                           // true인 경우, 오퍼레이터는 핵심 요소입니다. 비어 있으면 기본값은 false.
                                                            // 라인업 완성도 검사를 통과하지 못하면, 핵심 오퍼레이터와 0 희망 오퍼레이터만 모집하여 희망을 절약합니다.
                    "is_start": true,                         // true인 경우, 오퍼레이터는 시작 오퍼레이터입니다. 비어 있으면 기본값은 false. 팀에 시작 오퍼레이터이 없으면,
                                                            // 시작 오퍼레이터과 0 희망 오퍼레이터만 모집하고, 사용자로부터 작성된 오퍼레이터을 모집합니다.
                    "auto_retreat": 0,                        // 배치 후 몇 초 동안 자동 후퇴, 0보다 큰 경우 유효, 주로 특수 오퍼레이터 및 전위에 사용,
                                                            // 로그라이크는 보통 2배 속도로 시작하므로 스킬 지속 시간을 2로 나누는 것이 좋습니다.
                    "promote_priority_when_team_full": 850,
                    "recruit_priority_offsets": [             // 현재 라인업에 따라 우선순위 조정
                        {
                            "groups": [                       // 조건을 충족해야 하는 그룹
                                "Kaltsit",
                                "GroundBlocking",
                                "Thorns"
                            ],
                            "is_less": false,                 // true는 미만, false는 초과. 비어 있으면 기본값은 false
                            "threshold": 2,                   // 조건 충족 횟수
                            "offset": -300                    // 충족 후 모집 우선순위 조정
                                                            // (이것은 Kaltsit, GroundBlocking, Thorns에서 2명 이상의 오퍼레이터가 있을 때,
                                                            // 가비알 디 인빈서블의 모집 우선순위가 300 감소한다는 것을 의미합니다.)
                        }
                    ]
                },
                ...
            ],
        ],
        "team_complete_condition": [
            ...
        ]
    }
   ```

3. 그룹과 오퍼레이터를 필요에 따라 추가합니다.

   새로운 그룹을 추가할 때 기존 그룹에서 오퍼레이터를 복사할 수 있습니다. 개발자가 이미 부여한 평가를 참고하고, 이를 바탕으로 수정합니다.

## 통합 전략 2단계 - 전투 로직

`resource/roguelike/theme_name/autopilot/level_name.json` 은 각 레벨의 전투 전략을 설명합니다.

### MAA의 기본 로그라이크 전투 로직

1. 맵의 그리드 유형에 따라 기본 전투 작업 수행
   - MAA는 맵의 그리드가 목표 지점인지 적 출현 지점인지, 고지대인지 지상인지, 배치 가능한지 여부에 따라 기본 전투 작업을 수행합니다.

   - MAA는 맵 이름이나 번호를 기준으로 직업을 결정하며, 맵의 **표준**, **긴급**, **분기점**, **아이템 사용** 등의 상황을 판단하지 않습니다.

   - MAA는 전투 중 **맵의 정의되지 않은 그리드**을 판단하지 않습니다. 예를 들어, `Taming Hut`의 제단 위치, 왼쪽이나 오른쪽에서 나오는 몬스터의 `팔로워 효과` 등을 판단하지 않습니다.

   따라서 미래에는 **맵 이름의 모든 시나리오**에 대응할 수 있는 전투 로직을 설계해야 하며, 이 맵이 긴급 모드에서 작동하는 문제에 주의해야 합니다.

2. MAA의 기본 전투 전략 -- 목표 지점 진입 막기
   1. 지상 크루는 우선적으로 목표 지점 (그리드)를 중심으로 (또는 주변) 배치되며, 적 출현 지점을 향해 배치됩니다 (자동으로 계산됨). 적 출현 지점에는 배치되지 않습니다.

   2. 고지대보다 지상을 우선 배치하고, 목표 지점에서 주변으로 원형으로 배치됩니다.

   3. 위의 로직에 따라 배치할 수 있는 것들 (오퍼레이터, 소환물, 지원 아이템 등)을 계속 배치합니다.

### 기본 전투 전략 최적화

1. 목표 지점 대체

   목표 지점 앞에 오퍼레이터를 쌓는 것은 분명히 현명하지 않습니다. 일부 레벨에는 통과할 수 없는 그리드가 있으며, 이러한 위치에서는 방어가 매우 효율적입니다.

   또는 여러 목표 지점이 있는 레벨에서 MAA가 어떤 목표 지점가 어떤 적 출현 지점와 대응되는지 모를 경우, 무작위로 배치할 수 있습니다.

   이 경우 [map wiki](https://map.ark-nights.com/areas?coord_override=maa)를 열고 전투를 상상하면서 방어해야 할 우선순위 그리드와 방향을 찾아 `replacement_home`에 작성합니다.

   이 링크를 사용하세요. 그렇지 않으면 `설정`에서 `좌표 표시`를 `MAA`로 전환하세요.

   그런 다음, 경험을 바탕으로 방어 우선순위가 필요한 지점의 좌표와 방향을 찾아 json의 `replacement_home`에 작성하세요.

   ```json
   {
       "stage_name": "蓄水池",        // 레벨 이름 (중국어)
       "replacement_home": [         // 진입 지점 (목표 지점 대체 지점),
                                   // 최소 1개 이상이어야 완전합니다.
           {
               "location": [         // 그리드 좌표, 맵 위키에서 얻을 수 있음
                   6,
                   4
               ],
               "direction_Doc1": "선호 방향, 반드시 해당 방향이라는 의미는 아님 (알고리즘이 자체적으로 판단함)",
               "direction_Doc2": "기본값은 없음, 즉 추천 방향이 없으며, 완전히 알고리즘에 의해 결정됨",
               "direction_Doc3": "none / left / right / up / down / 无 / 上 / 下 / 左 / 右",
               "direction": "left"   // (이것은 그리드 6,4에서 왼쪽으로 오퍼레이터를 우선 배치함을 나타냅니다.)
           }
       ],
       ...
   ```

2. 배치 그리드 블랙리스트

   방어를 우선해야 할 지점과 오퍼레이터를 배치하지 않아야 할 지점이 있습니다. 예를 들어 화염구가 지나가는 곳, 보스의 발 밑, 배치하기 좋지 않은 위치 등입니다.

   이 경우 `blacklist_location`을 도입하여 MAA가 오퍼레이터를 배치하지 않도록 그리드를 블랙리스트에 추가합니다.
   ::: info
   여기에 추가된 그리드는 나중에 배치 전략에 포함되더라도 배치되지 않습니다.
   :::

   ```json
       ...
       "blacklist_location_Doc": "이것은 사용 예시이며, 맵 '蓄水池'가 필요로 하는 것은 아님.",
       "blacklist_location": [ // 오퍼레이터 배치 금지 위치
           [
               0,
               0
           ],
           [
               1,
               1
           ]
       ],
   ```

3. 대체 맵 전략

   예를 들어, 미즈키 로그라이크에서 목표 지점에 몬스터가 있다면 주사위를 사용하여 몬스터 쌓이는 상황을 완화할 수 있습니다.

   ```json
       "not_use_dice_Doc": "목표 지점 오퍼레이터가 후퇴할 때 MAA가 주사위를 사용할 필요가 있는지 여부. 비어 있으면 기본값은 false입니다.",
       "not_use_dice": false,
   ```

### 이제 긴급 작전인가요? 이제 진정한 실력을 발휘할 때에요! - 맞춤형 전투 전략

`"deploy_plan"` 및 `"retreat_plan"`을 사용하여 맞춤 설정

맞춤형 전략은 기본 전투 전략보다 우선하며, 맞춤형 전략의 모든 단계를 시도한 후 저장되거나 퇴각한 오퍼레이터가 기본 전투 전략에 따라 배치됩니다.

문제가 발생했을 때 맞춤형 계획을 너무 많이 설정할 필요는 없습니다. 중요한 단계를 완료한 후 MAA에 맡기거나 둘 다 결합하는 것이 더 나을 수 있습니다.

1. 그룹을 사용하여 오퍼레이터 배치

   ```json
   "deploy_plan": [ // 배치 로직: 위에서 아래로, 왼쪽에서 오른쪽으로 순서대로
                   // 첫 번째 오퍼레이터를 찾고, 찾지 못하면 건너뜁니다.
       {

           "groups": ["GavialAlter", "Mudrock", "GroundC", "Horn", "Vanguard"], // 이 그룹에서 오퍼레이터를 찾습니다.
           "location": [ 6, 4 ],                     // 첫 번째 오퍼레이터을 그리드 6,4에 배치하고 왼쪽을 향합니다.
           "direction": "left",                      // 찾지 못하면 다음 배치 작업으로 넘어갑니다.
       },
       {
           "groups": [ "Summoner" ],
           "location": [ 6, 3 ],
           "direction": "left"
       },
       {
           "groups": [ "单奶", "群奶" ],
           "location": [ 6, 2 ],
           "direction": "down"
       }
   ]
   ```

   ::: info
   MAA는 모든 배치 명령을 평탄화한 후 가장 높은 우선순위 배치 작업을 실행합니다.
   예: [ "Gavial", "Cornerstone", "GroundC"]를 [6,4]에 배치하고, [ "Cornerstone", "GroundC"]를 [6,3]에 배치한 후 MAA는 배치 명령을 포매팅하여 [ "Gavial", "Cornerstone", "GroundC", "Cornerstone", "GroundC"]로 만듭니다.
   전투 중 [6,4]에 있는 "Gavial" 오퍼레이터가 후퇴하면, "Cornerstone" 오퍼레이터가 있다면 [6,4]에 배치되며 [6,3]에는 배치되지 않습니다.
   :::

2. 특정 시간에 오퍼레이터 배치
   ::: tip
   특정 단일 절단 오퍼레이터나 포드가 필요한 사용 시나리오에 적합합니다.
   :::

   ```json
   "deploy_plan": [
           {
               "groups": [ "StrangeVirtue", "Assassin", "Vanguard", "OtherFloors" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 0, 3 ]   // 처치 수가 0 - 3일 때만 이 작업을 수행합니다.
           },
           {
               "groups": [ "StrangeVirtue", "Assassin", "Vanguard", "OtherFloors" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 6, 10 ]
           },
           ...
       ]
   ```

3. 특정 시간에 오퍼레이터 퇴각
   ::: tip
   때때로 포드가 너무 강해 필드를 유지하거나 라인업을 이동하기 위해 배치해야 할 때가 있습니다. 이때 퇴각하세요!
   :::

   ```json
   "retreat_plan": [                  // 특정 시간에 오퍼레이터 퇴각 대상
           {
               "location": [ 4, 1 ],
               "condition": [ 7, 8 ]   // 처치 수가 7 - 8일 때 [4,1]에 있는 오퍼레이터를 제거합니다. 없으면 건너뜁니다.
           }
       ]
   ```

4. 특정 시간에 스킬 비활성화 (_TODO_)

5. 추가 필드 (권장하지 않음)

   ```json
       "role_order_Doc": "오퍼레이터 유형 배치 순서, 지정되지 않은 부분은 Guard, Vanguard, Medic, Defender, Sniper, Caster, Supporter, Specialist, Summoner 순서로 채워집니다.",
       "role_order": [                 // 권장하지 않음, deploy_plan 필드를 구성하세요.
           "warrior",
           "pioneer",
           "medic",
           "tank",
           "sniper",
           "caster",
           "support",
           "special",
           "drone"
       ],
       "force_air_defense_when_deploy_blocking_num_Doc": "필드에 10000개의 블록 유닛이 있을 때 강제적으로 총 1쌍의 공중 유닛을 배치합니다 (기본 배치 로직에는 영향을 미치지 않음), 이 기간 동안 의료 유닛 배치는 금지되지 않습니다 (기본값은 false).",
       "force_air_defense_when_deploy_blocking_num": { // 권장하지 않음, deploy_plan 필드를 구성하세요.
           "melee_num": 10000,
           "air_defense_num": 1,
           "ban_medic": false
       },
       "force_deploy_direction_Doc": "특정 직업에 대한 강제 배치 방향",
       "force_deploy_direction": [     // 권장하지 않음, deploy_plan 필드를 구성하세요.
           {
               "location": [
                   1,
                   1
               ],
               "role_Doc": "입력된 직업에 대한 강제 배치 방향 적용",
               "role": [
                   "warrior",
                   "pioneer"
               ],
               "direction": "up"
           },
           {
               "location": [
                   3,
                   1
               ],
               "role": [
                   "sniper"
               ],
               "direction": "left"
           }
       ],
   ```

### 오퍼레이터의 플레이 스타일에 대한 특별한 이해가 있습니까? -- 특정 오퍼레이터의 정교한 운영

이 오퍼레이터를 별도로 그룹화하세요.

과제를 작성할 때 이 오퍼레이터가 기존 과제와의 우선순위를 고려하세요.

또는 이 오퍼레이터에 대한 전투 로직을 따로 작성할 수도 있습니다.

오퍼레이터 한 명만 사용해도 됩니다! MAA로 레벨을 클리어하세요 (다른 논리의 불완전성 때문에 가능성은 매우 낮습니다).

참고 예시: 1. 팬텀 로그라이크의 Thorns 2. 미즈키 로그라이크의 Texas the Omertosa 3. 사미 로그라이크의 Reed the Flame Shadow

## 통합 전략 단계 3: 조우 노드 로직

`resource/roguelike/theme_name/encounter/default.json` 레벨링 모드에서 조우 이벤트 선택에 대한 전략

`resource/roguelike/theme_name/encounter/deposit.json` 투자 모드에서 조우 이벤트 선택에 대한 전략

### MAA가 조우를 판단하는 방법

OCR이 조우를 인식하지만 선택은 고정된 위치에서 이루어집니다.

조우를 인식하지 못하면 하단의 선택지를 클릭합니다.

일반적으로 약간의 조정만 필요하거나 조정이 필요 없습니다 (개발자가 이미 처리했습니다).

### 조우 옵션의 우선순위 최적화

각 조우 옵션의 효과를 확인하려면 [prts.wiki](https://prts.wiki/w/%E9%9B%86%E6%88%90%E6%88%98%E7%95%A5)를 참조하세요. 옵션이 반드시 고정되지 않습니다.

조우 옵션을 수정하여 MAA가 특별한 결말로 향하도록 유도할 수 있습니다.

```json
{
    "theme": "Sami",                              // 로그라이크 테마
    "stage": [                                    // 조우 이벤트
        {
            "name": "低地市集",                    // 조우 이름
            "option_num": 3,                      // 총 몇 개의 옵션이 있는지 (이 경우: 3)
            "choose": 3,                          // 어떤 옵션을 먼저 선택해야 하는지 (여기서는 세 번째 옵션을 우선 선택함)
                                                  // 선택할 수 없으면 도주 옵션을 선택합니다 (기본적으로 마지막 옵션)

            "choice_require": [                   // 옵션 선택 요구 사항
                                                  // (프로그램 운영에는 영향을 미치지 않음
                                                  // 적용 가능한 상황만 표시하여 수정하기 쉽게 함)
                {
                    "name": "약초 선택",          // 옵션 이름
                    "ChaosLevel": {               // 면역 / 가벼운 수준
                        "value": "3",             // 필요한 수
                        "type": ">"               // 초과인지 미만인지
                                                  //(여기서는 면역 / 가벼운 수준이 3을 초과하는 경우만
                                                  // "약초 선택" 옵션이 활성화됨)
                    }
                },
                {
                    "name": "보기 좋은 천 선택",
                    "ChaosLevel": {
                        "value": "3",
                        "type": ">"
                    }
                },
                ...
```

### 팀 상황에 따라 특정 옵션의 우선순위 동적으로 설정 (_TODO_)

## 통합 전략 단계 4: 무역 상점 수집 우선순위

`resource/roguelike/theme_name/shopping.json` 상점에서 수집품 구매에 대한 전략을 설명 (전투 후 수집품 선택?)

```json
{
    "theme": "Phantom",                                       // 로그라이크 테마
    "priority": [                                             // 순서가 우선순위
                                                              // 순서가 높을수록 구매 우선순위가 높음.
                                                              // 그러나 우선순위 판단은 오퍼레이터 및 역할의 스크리닝 이전에 이루어집니다.
                                                              // 고우선순위 제품이 스크리닝되어 아무것도 구매하지 않는 경우가 발생할 수 있습니다.
        {
            "name": "Golden Chalice",                          // 수집품 이름 (이 경우 Golden Chalice)
            "no_longer_buy": true,                             // true는 아이템을 획득한 후 더 이상 돈을 쓰지 않음을 의미
                                                               // false 또는 비어 있으면 아이템을 계속 구매함
            "ignore_no_longer_buy": true,                      // true는 상점에 수집품이 있을 때 "no_longer_buy"를 무시함
                                                               // 즉, 구매함
                                                               // false 또는 생략된 경우, 상점에 있음
            "effect": "每有5源石锭, 所有我方单位的攻击速度+7",    // 수집품 효과 (운영에는 영향을 미치지 않으며 정렬에 유용함)
            "no": 167                                          // 수집품 번호 (위키에서 찾을 수 있으며, 운영에는 영향을 미치지 않음)
        },

        ...
        {
            "name": "Hand of Diffusion",
            "chars": [                                         // 팀에 이러한 오퍼레이터가 있을 때 이 아이템을 구매함
                "Passenger"                                    // (이 경우 팀에 패신저가 있으면,
                                                               // Hand of Diffusion을 만났을 때 구매하려고 시도함)
            ],
            "effect": "[Diffusion Artist], [Chain Artist], and [Blast Artist] regain 2 SP for each unit they deal damage to.",
            "no": 136
        },
        ...

        {
            "name": "Folding the halberd - Breaking the cauldron",
            "roles": [                                         // 팀에 이러한 직군이 있을 때 이 수집품을 구매함
                "WARRIOR"                                      // (이 경우 팀에 가드 오퍼레이터가 있으면
                                                               // Halberd-Breaker를 만났을 때 구매하려고 시도함)
            ],
            "effect": "All [Guard] Operators members have -40% Defence, but +40% Attack Power and +30% Attack Speed.",
            "no": 16
        },
        ...

        {
            "name": "Miss.Christine Touch coupon",
            "promotion": 2,                                   // 팀에 승진할 오퍼레이터가 2명 있을 때 구매함
            "effect": "Immediate promote two operators (Does not consume Hope)",
            "no": 15
        },
```

## 원하는 로직 (_TODO_)

### 자동 포메이션 로직

1. 다양한 맵의 포메이션 완성도 테스트 및 스킬 우선순위를 설정할 수 있습니다.

2. 사용할 수 있는 라인업에 따라 일부 어려운 전투를 피할 수 있습니다.

### 경로 찾기 알고리즘 최적화

예를 들어, 첫 3개의 스테이지에서는 더 많은 전투를 달성하고 나중에는 적은 전투를 달성하여 개발을 더 좋게 만들 수 있습니다.

### 스킬 유지

특정 프레임에 배치된 오퍼레이터는 스킬이 켜진 후 x초 동안 대기하며, 축에 맞추기 쉽습니다. `Skill_hold` 를 `Deploy_plan` 아래에 작성하거나 `Skill_hold_plan`을 작성할 수 있습니다.

### 스킬 종료

탄약 스킬이 있는 오퍼레이터에게 유용합니다.

<!-- markdownlint-disable-file MD026 -->
