---
order: 6
icon: material-symbols:view-quilt-rounded
---

# 기반시설 스키마

`resource/custom_infrast/*.json` 파일들의 사용법과 각 필드에 대한 설명입니다.

::: tip
주의: JSON 형식은 주석을 지원하지 않으므로 아래의 예시에서 주석은 제거해주시기 바랍니다.
:::

[기반시설 시각적 표 제작도구(yituliu)](https://ark.yituliu.cn/tools/schedule)

## 완전한 필드 목록

```json
{
    "title": "小号的换班方案",       // 구성 제목, 선택 사항
    "description": "哈哈哈哈",       // 구성 설명, 선택 사항
    "plans": [
        {
            "name": "早班",         // 계획 이름, 선택 사항, 2~4교대로 돌릴 때의 각 파트별 구성이 헷갈리지 않도록 해줍니다.
            "description": "lol",   // 계획 설명, 선택 사항
            "description_post": "", // 계획 실행 후에 표시할 설명, 선택 사항
            "period": [             // 교대 기간, 선택 사항
                                    // 현재 시간이 이 범위 안에 있는 경우, 계획은 자동으로 선택됩니다 (전체 JSON 파일에 여러 계획이 있을 수 있음)
                                    // 이 필드가 없으면 각 실행 후 자동으로 다음 계획으로 전환됩니다.
                                    // Core에서 이 필드를 처리하지 않습니다. MAA와 인터페이스 통합을 사용하는 경우, 이 논리를 직접 구현하세요.
                [
                    "22:00",        // hh:mm 형식으로 표시되며 현재는 단순 숫자 비교만 사용됩니다. 자정을 넘어가는 경우 이 파일의 예시를 참조하세요.
                    "23:59"
                ],
                [
                    "00:00",
                    "06:00"
                ]
            ],
            "duration": 360,        // 근무 기간 (분 단위), 예약 필드로 현재는 사용되지 않습니다. 나중에 시간이 되면 알림이나 자동 교대 기능이 추가될 수 있습니다.
            "Fiammetta": {          // "Fiammetta"를 사용하는 오퍼레이터, 선택 사항. 사용하지 않는 경우 필요하지 않습니다.
                "enable": true,     // "Fiammetta"를 사용할지 여부, 선택 사항. 기본값은 true입니다.
                "target": "巫恋",   // 대상 오퍼레이터, 이는 OCR을 통해 얻어지며, 해당 클라이언트 언어에서 오퍼레이터 이름을 전달해야 합니다.
                "order": "pre",     // 전체 교대 전에 사용할지 후에 사용할지 여부, 선택 사항. 값 범위는 "pre" / "post"입니다. 기본값은 "pre"입니다.
            },
            "drones": {              // 드론 사용에 대한 정보입니다. 선택 사항이며, 지정하지 않으면 드론은 사용되지 않습니다.
                "enable": true,      // 드론을 사용할지 여부. 선택 사항입니다. 기본값은 true입니다.
                "room": "trading",   // 어떤 유형의 방에 드론을 사용할지를 지정합니다. 가능한 값으로는 "trading(무역소)" / "manufacture(제조소)"가 있습니다.
                "index": 1,          // 드론을 사용할 방의 인덱스입니다. 왼쪽의 탭과 대응됩니다. 가능한 값으로는 [1 ~ 5]가 있습니다.
                "rule": "all",       // 사용 규칙입니다. 예약 필드로 현재는 사용되지 않지만 플러그인 등의 작업 지원을 위해 나중에 사용될 수 있습니다.
                "order": "pre"       // 오퍼레이터 교대 전에 드론을 사용할지 후에 사용할지 여부입니다. 선택 사항입니다. 가능한 값으로는 "pre" / "post"가 있습니다. 기본값은 "pre"입니다.
            },
            "groups": [
                // "control" / "manufacture" / "trading"에 대해 오퍼레이터 그룹을 설정할 수 있습니다.
                {
                    "name": "古+银",
                    "operators": ["古米", "银灰", "梅"]
                },
                {
                    "name": "清流",
                    "operators": ["清流", "森蚺", "温蒂"]
                }
            ],
            "rooms": {
                           // 방 정보입니다. 필수 항목입니다.
                           // 가능한 값으로는 "control(제어 센터)" / "manufacture(제조소)" / "trading(무역소)" / "power(발전소)" / "meeting(응접실)" / "hire(사무소)" / "dormitory()"가 있습니다.
                           // 방이 지정되지 않은 경우 기본 알고리즘으로 오퍼레이터 교대를 수행합니다.
                           // 특정 방에서 오퍼레이터 교대를 하지 않으려면 "skip" 필드를 사용하거나 소프트웨어의 인프라 설정에서 해당 시설을 선택 해제하세요.
                "control": [
                    {
                        "operators": [  // 이 방에 할당된 오퍼레이터들입니다. OCR을 통해 식별되며 해당 클라이언트 언어로 오퍼레이터 이름을 전달해야 합니다.
                            "夕",
                            "令",
                            "凯尔希",
                            "阿米娅",
                            "玛恩纳"
                        ]
                    }
                ],
                "manufacture": [
                    {
                        "operators": ["芬", "稀音", "克洛丝"],
                        "sort": false,   // 오퍼레이터들을 위의 순서에 따라 정렬할지 여부입니다. 선택 사항입니다. 기본값은 false입니다.
                        // 예를 들어 "稀音", "帕拉斯", "巫恋"(씬, 팔라스, 샤마르)와 같은 오퍼레이터를 사용하는 경우
                        // "sort": false로 설정하면 순서가 뒤바뀔 수 있으며, 특히 시간이 지남에 따라 효율이 상승하는 오퍼레이터의 효과가 초기화되어 손실로 이어질 수 있습니다.
                        // "sort": true를 사용하면 이러한 문제를 피할 수 있습니다.
                    },
                    {
                        "skip": true    // 이 방을 건너뛸지 여부를 나타냅니다 (배열 인덱스에 해당). 선택 사항입니다. 기본값은 false입니다.
                        // true로 설정하면 다른 모든 필드를 비워둘 수 있습니다. 오퍼레이터 변경만 건너뛰게 됩니다. 드론 사용 및 단서 교환과 같은 다른 작업은 계속 진행됩니다.
                    },
                    {
                        "operators": ["Castle-3"],
                        "autofill": true, // 원래 알고리즘을 사용하여 나머지 위치를 자동으로 채울지 여부를 나타냅니다. 선택 사항입니다. 기본값은 false입니다.
                        // 오퍼레이터 배열이 비어있는 경우 방 전체의 스케줄링은 원래 알고리즘을 기반으로 합니다.
                        // 오퍼레이터 배열이 비어 있지 않은 경우 개별 오퍼레이터의 효율성만 고려되며 전체 조합의 효율성은 고려되지 않습니다.
                        // 이후에 정의된 사용자 정의 오퍼레이터들과 충돌할 수 있으므로 주의해야 합니다. 예를 들어, 이후에 필요한 오퍼레이터들이 여기서 사용되는 경우에는 주의해서 사용하거나, 자동채우기를 하는 방의 순서를 뒤로 미루세요.
                        "product": "Battle Record" // 현재 제조되는 제품, 선택 사항.
                        // 시설에서 인식된 제품이 작업에 설정된 제품과 일치하지 않으면 인터페이스에 빨간색 경고 메시지가 표시됩니다. 미래에 추가 기능이 추가될 수 있습니다.
                        // 가능한 값으로는 "Battle Record()" | "Pure Gold(순금)" | "Dualchip(듀얼 칩)" | "Originium Shard(오리지늄 조각)" | "LMD(용문폐)" | "Orundum()"가 있습니다.
                    },
                    {
                        "operators": [
                            "多萝西"
                        ],
                        "candidates": [
                            // 선택적 후보 오퍼레이터입니다. 모든 위치가 채워질 때까지 목록에 있는 오퍼레이터들을 사용합니다.
                            // autofill=true와 호환되지 않습니다. 이 배열이 비어 있지 않은 경우 autofill을 false로 설정하세요.
                            "星源",
                            "白面鸮",
                            "赫默"
                        ]
                    },
                    {
                        "use_operator_groups": true, // groups에 있는 오퍼레이터 그룹을 사용하려면 true로 설정, 기본값은 false
                        "operators": [
                            // 활성화되면, operators에 있는 이름이 그룹 이름으로 해석됩니다.
                            "古+银", // 컨디션 임계값 및 설정 순서에 따라 그룹 선택
                            "清流" // 만약 古+银 그룹의 오퍼레이터 컨디션이 임계값 이하인 경우 清流 그룹 사용
                       ]
                    }
                ],
                "meeting": [
                    {
                        "autofill": true // 방 전체에 autofill을 사용합니다.
                    }
                ]
            }
        },
        {
            "name": "晚班"
            // ...
        }
    ]
}
```

## 예시

[243_layout_3_times_a_day](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/master/resource/custom_infrast/243_layout_3_times_a_day.json) 243 3교대

[153_layout_3_times_a_day](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/master/resource/custom_infrast/153_layout_3_times_a_day.json) 153 3교대
