---
order: 4
icon: mingcute:android-fill
---

# Android 디바이스 지원

::: warning
이 방법은 ADB 디버깅이 포함되며 여전히 컴퓨터와 연결해야 하므로, **초보자에게는 권장하지 않습니다**.
:::

::: info 주의사항

0. [연결 설정](../connection.md)을 동시에 참조해야 합니다.
1. Android 10부터 `Minitouch`는 `SELinux`가 `Enforcing` 모드인 경우 더 이상 사용할 수 없습니다. 다른 터치 모드로 전환하거나 `SELinux`를 일시적으로 `Permissive` 모드로 전환하세요.
2. Android 생태계가 매우 복잡하기 때문에 `MAA 설정` - `연결 설정`에서 `연결 구성`을 `일반 모드` 또는 `호환 모드` 또는 `두 번째 해상도` 또는 `일반 모드(이상 출력 차단)`로 변경하여 작동하는 모드를 찾을 수 있습니다.
3. MAA는 오직 `16:9` 비율의 해상도만 지원하므로, `16:9` 또는 `9:16` 화면 비율이 아닌 장치는 해상도를 강제로 변경해야 합니다. 이는 대부분의 현대적인 장치에 해당됩니다. 연결된 장치의 화면 비율이 원래 `16:9` 또는 `9:16`인 경우에는 해상도 변경 부분을 건너뛸 수 있습니다.
4. 잘못된 조작을 피하기 위해 기기 내비게이션 방식을 `기본 네비게이션 키` 등으로 변경하세요.
5. 게임 내 설정의 UI 위치 조절을 0으로 조정하여 작업 오류를 피하세요.

:::

::: tip
기본적인 `16:9` 비율 해상도에는 `3840*2160` (4K)、`2560*1440` (2K)、`1920*1080` (1080P)、`1280*720` (720P)등이 있습니다.
:::

## adb 디버깅 도구 다운로드 및 장치 연결

1. [adb](https://dl.google.com/android/repository/platform-tools-latest-windows.zip)를 다운로드하고 압축을 해제합니다.
2. 압축 해제한 폴더를 열고 주소 표시줄을 지우고 `cmd`를 입력한 후 Enter 키를 누릅니다.
3. 나타나는 명령 프롬프트 창에 `adb`를 입력하고 많은 영어 도움말 텍스트가 표시되면 실행이 성공한 것입니다.
4. 핸드폰에서 `USB 디버깅`을 활성화합니다. 각 브랜드의 핸드폰은 다른 방식으로 진입할 수 있으며 검색 엔진을 적극 활용하세요. 제조사는 MIUI에서처럼 추가적인 USB 디버깅 옵션을 제공할 수 있습니다. 이 경우 `USB 설치` 및 `USB 디버깅(보안 설정)`과 같은 옵션을 동시에 활성화하세요.
5. 핸드폰을 컴퓨터에 데이터 케이블로 연결한 후 방금 열었던 명령 프롬프트 창에 다음 명령을 입력합니다.

   ```bash
   adb devices
   ```

- 성공적으로 실행되면 연결된 `USB 디버깅` 장치 정보가 표시됩니다.
  - 예시:

    ```bash
    List of devices attached
    VFNDU1682100xxxx        device
    ```

  - **`device` 앞의 영숫자 조합은 장치 시리얼 번호이자 MAA의 `연결 주소`입니다.**

- 현재, 안드로이드 장치에서 `USB 디버깅`을 하려면 디버깅을 허용하는 팝업을 터치해야 합니다. 허가되지 않은 경우 다음과 같이 표시됩니다:

  ```bash
  List of devices attached
  VFNDU1682100xxxx        unauthorized
  ```

- 디바이스가 계속 허가되지 않거나 장치 시리얼 번호 뒤에 `offline`이 표시되면 장치와 컴퓨터를 재부팅한 후 다시 시도해야 합니다. 여전히 문제가 해결되지 않으면 사용자의 현재 사용자 폴더 아래의 `.android` 폴더를 삭제하고 다시 시작한 후 다시 시도하세요. 구체적인 위치는 스스로 검색하세요.

## 해상도 변경

::: tip
스마트폰 화면 해상도는 `가로*세로`로 표시되며, 이는 컴퓨터 모니터의 `가로*세로`와는 다릅니다. 목표 장치에 따라 구체적인 값은 직접 확인하세요.
:::

- 위의 장치 목록에 하나의 장치만 표시된 경우 아래 명령을 실행하여 해상도를 변경하거나 복원할 수 있습니다.

  ```bash
   :: 현재 해상도 확인
   adb shell wm size
   :: 기본 해상도로 복원
   adb shell wm size reset

   :: 해상도를 720p로 변경
   adb shell wm size 720x1280
   :: 해상도를 1080p로 변경
   adb shell wm size 1080x1920
  ```

- 여러 장치가 있는 경우 `adb`와 `shell` 사이에 `-s <대상 장치 시리얼 번호>` `매개변수`를 추가해야 합니다. 아래는 예시입니다.

  ```bash
   :: 현재 해상도 확인
   adb -s VFNDU1682100xxxx shell wm size
   :: 기본 해상도로 복원
   adb -s VFNDU1682100xxxx shell wm size reset

   :: 해상도를 720p로 변경
   adb -s VFNDU1682100xxxx shell wm size 720x1280
   :: 해상도를 1080p로 변경
   adb -s VFNDU1682100xxxx shell wm size 1080x1920
  ```

- 일부 설계가 부적절한 앱은 해상도를 복원해도 내용 레이아웃이 여전히 잘못 표시될 수 있습니다. 일반적으로 해당 앱이나 장치를 다시 시작하면 문제가 해결됩니다.

::: danger 주의
장치 재부팅 전에 해상도를 **반드시 복구하는 것**이 좋습니다. 그렇지 않으면 장치에 따라 예기치 않은 결과가 발생할 수 있습니다.
레이아웃 위치 오류, 터치 위치 오류, 앱 충돌, 잠금 해제 불가 등의 오류가 발생할 수 있습니다!
:::

::: danger 주의

일부 실제 장치에서 `계정 전환` 기능이 정상적으로 작동하지 않을 수 있습니다. MAA는 주로 PC 에뮬레이터 환경에서 작동하므로 이 문제를 수정할 계획은 없습니다.

이 문제가 발생하면 다음 방법 중 하나를 통해 화면 밀도(DPI)를 수정할 수 있습니다 (권장 값: `[100-800]`):

- 명령어 `adb shell wm density <DPI>`를 사용하여 DPI를 직접 수정
- `개발자 옵션 → 최소 너비`를 조정하여 `최소 너비` 수정을 통해 DPI를 간접적으로 수정

  참고: `DPI`와 `최소 너비`는 반비례 관계이며, 상호 관계는 `최소 너비 = 화면 너비(px) / (DPI / 160)` 입니다

**이 작업은 위험이 있으며 장치가 비정상적으로 작동할 수 있습니다. 무엇을 하고 있는지 확인하고, 장치 고장에 대한 책임은 본인에게 있습니다.**

**다음 장치 재부팅 전에** 이러한 변경 사항을 복원하는 것을 강력히 권장합니다. 기본값을 잊어버린 경우, 어떤 방식으로 수정했든 명령어 `adb shell wm density reset`을 사용하여 복원할 수 있습니다.

:::

## 해상도 자동 변경

1. MAA 폴더 아래에 두 개의 텍스트 파일을 생성하고 다음 내용을 입력합니다.

   ```bash
   :: 해상도를 1080p로 조정
   adb -s <대상 장치 시리얼 번호> shell wm size 1080x1920
   :: 화면 밝기 낮추기 (선택 사항)
   adb -s <대상 장치 시리얼 번호> shell settings put system screen_brightness 1
   ```

   ```bash
   :: 해상도 복원
   adb -s <대상 장치 시리얼 번호> shell wm size reset
   :: 화면 밝기 높이기 (선택 사항)
   adb -s <대상 장치 시리얼 번호> shell settings put system screen_brightness 20
   :: 홈 화면으로 이동 (선택 사항)
   adb -s <대상 장치 시리얼 번호> shell input keyevent 3
   :: 잠금 화면 (선택 사항)
   adb -s <대상 장치 시리얼 번호> shell input keyevent 26
   ```

2. 첫 번째 파일을 `startup.bat`으로 이름을 바꾸고, 두 번째 파일을 `finish.bat`으로 이름을 바꿉니다.
   - 이름을 바꾼 후 파일 아이콘이 변경되지 않고 확장명을 변경하는 이중 확인 대화 상자가 표시되지 않는 경우 "Windows에서 파일 확장명 표시하는 방법"을 검색하세요.

3. MAA의 `설정` - `연결 설정` - `시작 전 스크립트` 및 `종료 후 스크립트`에 각각 `startup.bat`과 `finish.bat`을 입력합니다.

## MAA에 연결하기

### 유선 연결

::: tip
유선 연결을 사용하면 IP 주소나 포트가 필요하지 않습니다. 단지 `adb devices` 명령으로 얻은 장치 시리얼 번호만 필요합니다.
:::

1. 방금 얻은 대상 장치의 시리얼 번호를 MAA `설정` - `연결 설정` - `연결 주소`에 입력합니다.
2. Link Start!

### 무선 연결

- 장치가 컴퓨터와 동일한 LAN 환경에 있고 서로 통신할 수 있는지 확인하세요. `AP 격리`, `게스트 네트워크` 등의 설정은 장치 간 통신을 차단할 수 있습니다. 관련 라우터 문서를 참조하세요.
- 장치를 다시 시작하면 무선 디버깅이 비활성화되므로 다시 설정해야 합니다.

#### `adb tcpip`를 사용하여 무선 포트를 엽니다

1. 방금 열린 명령 프롬프트 창에 다음 명령을 입력하여 무선 디버깅을 활성화합니다.

   ```bash
   adb tcpip 5555
   :: 여러 장치가 있는 경우 -s 매개변수를 추가하여 시리얼 번호를 지정합니다.
   ```

2. 장치 IP 주소를 확인합니다.
   - 장치의 `설정` - `WLAN`으로 이동하여 현재 연결된 무선 네트워크를 클릭하여 IP 주소를 확인합니다.
   - 각 브랜드의 장치는 설정 위치가 다를 수 있으므로 검색하여 찾으세요.

3. MAA `설정` - `연결 설정` - `연결 주소에` `<IP>:5555`와 같이 현재 장치의 IP 주소를 입력합니다. (예: `192.168.1.2:5555`)
4. Link Start!

#### `adb pair`를 사용하여 무선 포트를 엽니다

::: tip
`adb pair`는 안드로이드 11 이상에서 개발자 옵션의 `무선 디버깅`을 사용하여 페어링한 후 연결하는 것으로, 유선 연결을 안할 수 있습니다.
:::

1. 휴대폰의 개발자 옵션으로 이동하여 `무선 디버깅`을 클릭하여 활성화하고 확인을 클릭한 후 `페어링 코드로 디바이스 페어링`을 클릭하고 페어링이 완료될 때까지 나타나는 팝업을 닫지 마세요.

2. 페어링을 시작합니다.
   1. 명령 프롬프트에서 `adb pair <장치에 표시된 IP 주소와 포트>`를 입력하고 엔터를 누릅니다.。
   2. `<장치에 표시된 6자리 페어링 코드>`를 입력하고 엔터를 누릅니다.
   3. 창에 `Successfully paired to <IP:포트>`와 같은 내용이 나타나면서 장치에서 팝업이 자동으로 닫히고 페어링된 장치 아래에 컴퓨터 이름이 표시됩니다.

3. 현재 장치 화면에 나타나는 `<IP 주소 및 포트>`를 MAA `설정` - `연결 설정` - `연결 주소`에 입력합니다. (예: `192.168.1.2:11451`), **이전에 입력한 것과 반드시 다르게 입력하세요.**
4. Link Start!

#### 루트 권한을 사용하여 무선 포트를 엽니다

~~root를 했으면 이 문서를 더이상 보지 않아도 됩니다~~

1. [WADB](https://github.com/RikkaApps/WADB/releases)를 다운로드하고 루트 권한을 부여하여 설치합니다.
2. WADB를 열고 무선 adb를 시작합니다.
3. WADB에서 제공하는 IP 주소 및 포트를 MAA `설정` - `연결 설정` - `연결 주소`에 입력합니다. (예: `192.168.1.2:5555`)
4. Link Start!
