---
order: 2
icon: material-symbols:summarize
---

# 사용법

maa-cli의 주요 기능은 MaaCore를 호출하여 명일방주의 게임 작업을 자동화하는 것입니다. 또한 사용의 편의성을 위해 MaaCore 관리 기능도 제공합니다.

## MaaCore 관리

maa-cli는 MaaCore 및 리소스를 설치하고 업데이트할 수 있습니다. 다음 명령어를 실행하세요:

```bash
maa install # MaaCore 및 리소스 설치
maa update # MaaCore 및 리소스 업데이트
```

## maa-cli 자체 업데이트

maa-cli는 자체 업데이트가 가능합니다. 다음 명령어를 실행하세요:

```bash
maa self update
```

**주의**: 패키지 관리자를 통해 maa-cli를 설치한 사용자는 이 명령어가 작동하지 않으므로, 패키지 관리자를 통해 업데이트하세요.

## 초기화 구성

MaaCore 설치가 완료되면 일반적으로 추가 구성 없이 바로 작업을 실행할 수 있습니다. 기본 구성이 모든 사용자에게 적용되지 않을 수 있으므로 다음 명령으로 구성을 초기화할 수 있습니다:

```bash
maa init
```

이 명령으로 [MaaCore 관련 구성][config-core]를 대화형으로 구성할 수 있습니다.

## 작업 실행

MaaCore의 설치 및 구성을 완료하면 작업을 실행할 준비가 된 것입니다. maa-cli는 사전 정의된 작업과 사용자 지정 작업의 두 가지 유형의 작업을 지원합니다.

### 사전 정의 작업

일반적인 작업에 대해 maa-cli는 몇 가지 사전 정의 작업을 제공합니다:

- `maa startup [client]`: 게임을 시작하고 메인 화면으로 이동합니다. `[client]`는 클라이언트 유형이며, 생략하면 게임 클라이언트를 시작하지 않습니다.
- `maa closedown [client]`: 게임 클라이언트를 종료합니다. `[client]`는 클라이언트 유형이며, 기본값은 `Official`입니다.
- `maa fight [stage]`: 전투 작업을 실행합니다. `[stage]`는 스테이지 이름이며, 예를 들어 `1-7`입니다. 생략하면 이전 또는 현재 스테이지를 선택합니다.
- `maa copilot <maa_uri>...`: 자동 전투 작업을 실행합니다. `<maa_uri>`는 작업의 URI이며, 여러 URI는 순차적으로 실행됩니다. `maa_uri`는 `maa://1234` 또는 로컬 파일 경로 `./1234.json`일 수 있습니다.
- `maa sscopilot <maa_uri>`: 자동 보안 파견을 실행합니다. `<maa_uri>`는 보안 파견 작업의 URI입니다.
- `maa roguelike <theme>`: 자동 통합 전략을 실행합니다. `<theme>`는 통합 전략의 주제이며, 선택 가능한 값은 `Phantom`, `Mizuki`, `Sami`, `Sarkaz`, `JieGarden`입니다.
- `maa reclamation <theme>`: 자동 생활 게임을 실행합니다. `<theme>`는 생활 게임의 주제이며, 현재 사용 가능한 값은 `Tales`입니다.

위 작업들은 몇 가지 매개변수를 받습니다. `maa <task> --help` 명령어를 통해 자세한 매개변수를 확인할 수 있습니다.

예를 들어, 공식 서버 사용자가 게임을 열고, BB-7을 3번 플레이하고, 게임을 종료하려면 다음 명령어를 실행할 수 있습니다:

```bash
maa startup Official && maa fight BB-7 -m 3 && maa closedown
```

### 사용자 정의 작업

MAA가 지원하는 작업이 많기 때문에, maa-cli는 모든 작업에 대한 미리 정의된 옵션을 제공할 수 없습니다. 위 예시처럼 여러 작업을 실행해야 할 수도 있습니다. 이를 해결하기 위해 maa-cli는 사용자 정의 작업 기능을 제공합니다. 사용자 정의 작업은 다양한 작업을 조합하고 각 작업의 매개변수와 실행 순서를 세부적으로 제어할 수 있습니다. 또한, 조건 판단을 통해 특정 작업을 실행할지 여부나 어떤 매개변수를 사용할지 결정할 수 있습니다. 이를 통해 일상 작업을 자동화할 수 있습니다. 사용자 정의 작업은 설정 파일을 통해 정의되며, 설정 파일의 위치와 작성 방법은 [사용자 정의 작업 문서][custom-task]를 참고하세요. 설정 파일 작성이 완료되면 `maa run <task>` 명령어를 통해 사용자 정의 작업을 실행할 수 있습니다. 여기서 `<task>`는 확장자를 제외한 사용자 정의 작업 파일 이름입니다.

### 작업 요약

미리 정의된 작업이든 사용자 정의 작업이든, maa-cli는 작업이 종료되면 작업 요약 정보를 출력합니다. 여기에는 각 하위 작업의 실행 시간(시작 시간, 종료 시간, 실행 기간)이 포함됩니다. 일부 작업의 경우 결과 요약도 출력됩니다:

- `fight` 작업: 스테이지 이름, 실행 횟수, 사용된 약물 수량 및 드롭 통계.
- `infrast`: 각 시설에 배치된 오퍼레이터, 제조소 및 무역소의 경우 생성된 아이템 유형 포함.
- `recruit`: 각 모집의 태그, 별 등급 및 상태, 총 모집 횟수.
- `roguelike`: 탐험 횟수, 투자 횟수.

작업 요약을 원하지 않는 경우 `--no-summary` 매개변수를 통해 비활성화할 수 있습니다.

### 작업 로그

maa-cli는 로그를 출력하며, 로그 출력 레벨은 `Error`, `Warn`, `Info`, `Debug`, `Trace` 순으로 낮은 레벨에서 높은 레벨로 나뉩니다. 기본 로그 출력 레벨은 Warn입니다. 로그 레벨은 `MAA_LOG` 환경 변수를 통해 설정할 수 있으며, 예를 들어 `MAA_LOG=debug`와 같이 설정할 수 있습니다. `-v` 또는 `-q`를 통해 로그 출력 레벨을 높이거나 낮출 수도 있습니다.

maa-cli는 기본적으로 표준 오류(stderr)에 로그를 출력합니다. `--log-file` 옵션을 사용하여 로그를 파일에 출력할 수 있습니다. 로그는 `$(maa dir log)/YYYY/MM/DD/HH:MM:SS.log` 경로에 저장됩니다. `$(maa dir log)`는 로그 디렉토리로 `maa dir log` 명령어를 통해 확인할 수 있습니다. `--log-file=path/to/log` 옵션을 사용하여 로그 파일의 경로를 지정할 수도 있습니다.

기본적으로 모든 출력 로그는 타임스탬프와 로그 레벨의 접두사를 포함합니다. `MAA_LOG_PREFIX` 환경 변수를 통해 이 동작을 변경할 수 있습니다. `Always`로 설정하면 항상 접두사를 포함하고, `Auto`로 설정하면 로그 파일 출력 시에만 접두사를 포함하며, 표준 오류 출력 시에는 포함하지 않습니다. `Never`로 설정하면 로그 파일 출력 시에도 접두사를 포함하지 않습니다.

### 기타 하위 명령어

위 명령어 외에도 maa-cli는 다음과 같은 하위 명령어를 제공합니다:

- `maa list`: 모든 사용 가능한 작업을 나열합니다.
- `maa dir <dir>`:특정 디렉토리의 경로를 확인합니다. 예: `maa dir config`는 설정 디렉토리의 경로를 확인합니다.
- `maa version`: `maa-cli` 및 `MaaCore`의 버전 정보를 확인합니다.
- `maa convert <input> [output]`: `JSON`, `YAML`, `TOML` 형식 파일을 다른 형식으로 변환합니다.
- `maa complete <shell>`: 자동 완성 스크립트를 생성합니다.
- `maa activity [client]`: 게임의 현재 이벤트 정보를 확인합니다. `client`는 클라이언트 유형이며, 기본값은 `Official`입니다.
- `maa cleanup`: `maa-cli` 및 `MaaCore`의 캐시를 정리합니다.
- `maa import <file> [-t <type>]:` 설정 파일을 가져옵니다. `file`은 설정 파일의 경로입니다. `-t` 옵션을 통해 설정 파일의 유형(`cli`, `profile`, `infrast` 등)을 지정할 수 있습니다.

더 많은 명령어 사용 방법은 `maa help`를 통해 확인할 수 있으며, 특정 명령어의 사용 방법은 `maa help <command`>를 통해 확인할 수 있습니다.

[config-core]: config.md#maacore-관련-설정
[custom-task]: config.md#사용자-정의-작업
