---
order: 5
icon: ri:earth-fill
---

# 해외 클라이언트 현지화 가이드

## 준비

이 튜토리얼을 시작하기 전에 다음 사항이 준비되었는지 확인해야 합니다.

1. 필요한 소프트웨어를 설치하고 올바르게 구성했습니다. ZH-CN 클라이언트 또는 해당 클라이언트의 `readme.md` 에 지원되는 기능이 제대로 작동하는지 확인할 수 있는 정보가 있어야 합니다.
2. [작업 스키마](../protocol/task-schema.md) 를 읽고 각 필드의 의미와 사용법을 기본적으로 이해해야 합니다. 코드에서 `@` 와 `#` 의 의미와 용법도 이해해야 합니다.
3. ZH-CN 클라이언트의 `task.json` 파일과 템플릿 이미지는 해외 클라이언트에 대해 언급되지 않았거나 누락된 경우의 대안으로 사용된다는 점을 이해해야합니다. 해외 클라이언트에 대한 `task.json` 의 내용은 ZH-CN 작업 필드에 따라 다시 작성해야 합니다.
4. 영어 실력이 있고, 영어 로그를 읽을 수 있으며, 로그를 통해 누락된 사진과 다른 정보를 찾을 수 있는 역량이 있으면 좋습니다.
5. 작업 체인에 따라 개별적으로 수정을 수행하는 것이 좋습니다. 예를 들어, Award 작업을 수정하려면 `next` 필드의 순서에 따라 `template image`, `text`, 그리고 `roi` 를 단계적으로 수정해야 합니다. 이렇게 하면 수정 후 모든 작업이 정상적으로 작동하고 오류를 쉽게 발견할 수 있습니다. 또한 이렇게 하면 한 번에 너무 많은 콘텐츠가 수정될 때 소프트웨어가 어떤 작업에 고정되어 있는지 혼동하거나 잊어버리는 것을 방지할 수 있습니다.

### 변경 전 준비사항

변경하기 전에 다음과 같은 몇 가지 준비 사항에 유의해야 합니다:

1. ZH-CN 클라이언트의 `task.json` 을 참조하여 해외 클라이언트를 위한 템플릿 이미지와 텍스트 콘텐츠를 준비했는지 확인해야 합니다.
2. 이러한 이미지와 텍스트 콘텐츠에 올바르게 접근할 수 있는지 확인해야 합니다.

## 스크린샷 얻기

고품질의 스크린샷을 얻으려면 다음 지침을 따르세요:

1. 에뮬레이터와 함께 제공된 스크린샷 도구를 사용하여 스크린샷을 만들고 저장합니다.
2. 스크린샷의 크기가 `1280*720` 이상이고 종횡비는 반드시 `16:9` 이어야 합니다.
3. 스크린샷에 작업 표시줄, 상태 표시줄 또는 알림 표시줄과 같은 관련 없는 내용이 포함되어 있지 않은지 확인해야 합니다.
4. 스크린샷에 인식해야 할 내용이 모두 포함되어 있는지 확인해야합니다.

이미지를 잘라내고 관심 텍스트/이미지 영역(ROI)을 얻으려면, `MaaAssistantArknights/tools/ImageCropper` 도구를 사용해야 합니다.

**ImageCropper** 는 미리 준비된 스크린샷 또는 ADB를 통해 연결된 장치에서 ROI 영역의 자르기, 저장, 색상 추출 작업을 지원하는 강력한 스크린샷 도구입니다.

### 환경 설정

`Python` 환경이 필요하며, 권장 버전은 `3.11`, 최소 버전은 `3.9` 이상입니다.

### 의존성 설치

Windows 사용자는 `install.bat` 을 직접 실행하는 것을 권장하거나, 수동으로 설치:

```shell
python -m pip install -r requirements.txt
```

### 사용 단계

1. 미리 준비된 스크린샷이 있는 경우, `./src/` 디렉토리에 저장합니다
2. `start.bat` 또는 `python main.py [device serial]` 을 실행합니다 (장치 주소는 선택 사항)
   - 도구는 연결된 ADB 장치를 자동으로 검색하고, 프롬프트에 따라 장치를 선택합니다 (ENTER를 눌러 건너뛰기)
   - `python main.py [device serial]` 을 사용하여 특정 장치에 직접 연결할 수도 있습니다
3. 팝업 창에서 왼쪽 클릭으로 대상 영역을 선택하고, 스크롤 휠로 확대/축소하고, 오른쪽 클릭으로 이미지를 이동합니다
4. 키보드 단축키 사용:
   - `S` 또는 `ENTER` 를 눌러 대상 영역 저장
   - `F` 를 눌러 전체 화면 표준화 스크린샷 저장
   - `R` 를 눌러 ROI 범위만 출력 (저장하지 않음)
   - `C` 를 눌러 ROI 범위와 ColorMatch 필드 출력 (저장하지 않음)
   - `Z`, `DELETE` 또는 `BACKSPACE` 를 눌러 실행 취소
   - `0` ~ `9` 를 눌러 창 확대/축소
   - `Q` 또는 `ESC` 를 눌러 종료
   - 다른 키를 눌러 현재 스크린샷 건너뛰기/새로 고침
5. 대상 영역 스크린샷은 `./dst/` 디렉토리에 저장됩니다

예를 들어, 자르기를 완료한 후의 출력은 다음과 같습니다:

```log
src: Screenshot_xxx.png
dst: Screenshot_xxx.png_426,272,177,201.png
original roi: 476, 322, 77, 101,
amplified roi: 426, 272, 177, 201
```

이 예시에서, `Screenshot_xxx.png` 는 `src` 폴더에 배치된 전체 스크린샷의 이름이고, `Screenshot_xxx.png_426,272,177,201.png` 는 잘라낸 이미지의 이름입니다.

원래의 `original roi` 는 마우스가 선택한 영역이고, `amplified roi` 는 확대된 영역입니다. 확대된 영역이 필요하므로, `amplified roi` 값을 사용하여 task.json 의 roi 필드를 입력해야 합니다.

## 템플릿 이미지 수정

템플릿 이미지를 수정하기 전에 해당 클라이언트의 템플릿 이미지 폴더와 ZH-CN 클라이언트의 템플릿 이미지 폴더를 열어야 합니다.

예시:

- KR 클라이언트의 템플릿 이미지 폴더 위치는 `MaaAssistantArknights\resource\global\YoStarKR\resource\template` 입니다.
- ZH-CN 클라이언트의 템플릿 이미지 폴더 위치는 `MaaAssistantArknights\resource\template` 입니다.

`task.json` 파일에 언급된 템플릿 이미지를 참조하여 ZH-CN 클라이언트와 해외 클라이언트의 템플릿 이미지를 비교하고, 해외 클라이언트에서 누락된 템플릿이 있는지 확인합니다.

일반적으로 텍스트가 포함된 템플릿 이미지는 로고와 같은 이미지를 제외하고 스크린샷으로 대체해야 합니다. 이미지의 크기가 ZH-CN 클라이언트의 해당 템플릿 이미지보다 상당히 큰 경우 `roi`의 크기를 수정해야 할 수 있습니다.

템플릿 이미지를 캡처하고 이름을 변경한 후에는 해당 클라이언트의 템플릿 이미지 폴더에 배치할 수 있습니다.

## 텍스트 내용 수정

텍스트 내용을 수정하기 전에 해당 서버와 ZH-CN 클라이언트 모두에 대해 `task.json` 파일을 열어야 합니다.

예시:

- KR 클라이언트에서 `task.json` 의 위치는 `MaaAssistantArknights\resource\global\YoStarKR\resource\tasks.json` 입니다.
- ZH-CN 클라이언트의 `task.json` 위치는 `MaaAssistantArknights\resource\tasks.json` 입니다.

텍스트를 수정하려면 해당 작업을 찾은 후 `text` 필드를 해당 서버에 표시된 내용으로 변경합니다. 식별된 콘텐츠는 게임 내 전체 콘텐츠의 하위 문자열이 될 수 있습니다. 일반적으로 텍스트가 포함된 `text` 는 순수 ASCII 문자로 인식되지 않는 한 대체해야 합니다.

텍스트 길이가 ZH-CN 클라이언트 버전보다 상당히 긴 경우, `roi` 필드의 크기를 수정해야 할 수 있습니다. 예를 들어 `"任务"`(임무)와 한글 단어 `"임무"` 의 길이 차이가 너무 큰 경우, 해외 클라이언트에서 해당 단어의 `roi` 크기를 수정해야 할 수 있습니다.

해당 해외 서버의 `task.json` 파일에 작업이 없으면 추가해야 합니다. `text` 필드에 적절한 내용을 입력합니다.

## ROI 범위 수정

ROI 범위를 수정하는 방법:

1. 해당 서버의 `task.json` 파일을 엽니다. 예를 들어 KR 클라이언트의 `task.json` 파일 위치는 `MaaAssistantArknights\resource\global\YoStarKR\resource\tasks.json` 입니다.
2. 수정해야 할 ROI 범위에 해당하는 작업을 찾고 해외 게임 인터페이스의 스크린샷을 사용하여 증폭된 ROI에 따라 `roi` 범위의 크기를 조정합니다.
3. 일반적으로, `roi` 범위를 수정할 필요가 없지만 텍스트와 중국어 클라이언트 버전 간의 크기 차이가 너무 클 경우 수정해야 할 수도 있습니다.
4. 해당 해외 클라이언트의 `task.json` 파일에 작업이 없는 경우 작업을 추가하고 적절한 값으로 `roi` 필드를 작성합니다.

## 설정 저장 및 소프트웨어 재시작

변경한 후 변경 내용을 적용하려면 설정을 저장하고 소프트웨어를 다시 시작해야 합니다. 이렇게 하려면 소프트웨어를 다시 시작하고 파일을 다시 로드하거나 소프트웨어 디렉터리에 새 `DEBUG.txt` 파일을 생성합니다. 이렇게 하면 "Link Start!" 단추를 누를 때마다 템플릿과 파일이 다시 로드되므로 소프트웨어를 다시 시작할 필요가 없습니다.

성공 여부 확인하기:

1. 소프트웨어의 작동 여부 확인을 통해 해외 서버에서 제대로 작동하는지 확인합니다.
2. 제대로 작동하지 않는 경우 변경 사항이 올바른지 확인하거나 로그를 보고 무엇이 잘못되었는지 확인해야 합니다.

## 로그 분석

`task.json` 파일을 수정했지만 프로그램이 여전히 제대로 작동하지 않는 경우 로그를 확인하여 오류를 찾고 그에 따라 해당 작업을 수정하는 것이 도움이 될 수 있습니다. 로그 파일은 일반적으로 소프트웨어의 루트 디렉터리에 있으며 이름은 `asst.log` 입니다. MAA를 직접 컴파일한 경우, 컴파일할 때 선택한 컴파일 모드에 따라 `\x64\Release` 또는 `\x64\RelWithDebInfo` 디렉터리에 있을 수 있습니다.

로그를 분석하면 프로그램의 문제를 식별하는 데 도움이 될 수 있습니다. 다음은 로그 예제입니다:

```log
[2022-12-18 17:43:17.535][INF][Px7ec][Tx15c8] {"taskchain":"Award","details":{"to_be_recognized":["Award@ReturnTo","Award","ReceiveAward","DailyTask","WeeklyTask","Award@CloseAnno","Award@CloseAnnoTexas","Award@TodaysSupplies","Award@FromStageSN"],"cur_retry":10,"retry_times":20},"first":["AwardBegin"],"taskid":2,"class":"asst::ProcessTask","subtask":"ProcessTask","pre_task":"AwardBegin"}
[2022-12-18 17:43:18.398][INF][Px7ec][Tx15c8] Call ` C:\Program Files\BlueStacks_nxt\. \HD-Adb.exe -s 127.0.0.1:5555 exec-out "screencap | gzip -1" ` ret 0 , cost 862 ms , stdout size: 2074904 , socket size: 0
[2022-12-18 17:43:18.541][TRC][Px7ec][Tx15c8] OcrPack::recognize | roi: [ 500, 50, 300, 150 ]
[2022-12-18 17:43:18.541][TRC][Px7ec][Tx15c8] Ocr Pipeline with asst::WordOcr | enter
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] Ocr Pipeline with asst::WordOcr | leave, 93 ms
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] OcrPack::recognize | raw: [{ : [ 0, 0, 300, 150 ], score: 0.000000 }]
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] OcrPack::recognize | proc: []
[2022-12-18 17:43:18.637][TRC][Px7ec][Tx15c8] asst::ProcessTask::_run | leave, 1101 ms
[2022-12-18 17:43:18.638][TRC][Px7ec][Tx15c8] ready to sleep 500
[2022-12-18 17:43:19.144][TRC][Px7ec][Tx15c8] end of sleep 500
[2022-12-18 17:43:19.144][TRC][Px7ec][Tx15c8] asst::ProcessTask::_run | enter
```

이 로그에서 다음 사실을 확인할 수 있습니다:

- `taskchain` 는 현재 진행 중인 작업을 나타냅니다.
- `details` 는 인식할 필드(`to_be_recognized`)와 현재 재시도 횟수 (`cur_retry`), 그리고 총 재시도 횟수(`retry_times`)를 나타냅니다.
- `first` 는 작업의 시작을 나타냅니다.
- `taskid` 는 작업에 부여된 ID 번호입니다.
- `class` 와 `subtask` 는 각각 작업의 클래스와 하위 작업을 나타냅니다.
- `pre_task` 는 이전 작업을 나타냅니다.
  또한, 명령의 실행 (예: `Call`) 과 `OCR` 정보 (예: `OcrPack::recognize`) 가 로그에 기록됩니다.

예를 들어, 이 로그에서, `"to_be_recognized"`,`"cur_retry":3,"retry_times":20` 은 작업이 10번 인식 시도되었음을 의미하며, 최대 횟수는 20회입니다. 최대 횟수에 도달하면 작업을 건너뛰고 오류가 보고되고 다음 작업이 수행됩니다. 이전 작업에 문제가 없으면 여기 인식에 문제가 있을 가능성이 높습니다. 이 문제를 해결하려면 로그에 언급된 작업에 해당하는 `템플릿` 파일이 있는지, 해당 작업의 `text` 필드가 잘못되었는지, 작업 인식을 위한 `roi` 범위가 잘못되었는지 확인하고 필요한 수정을 수행할 수 있습니다.

해당 템플릿 이미지를 보면, EN 클라이언트 템플릿 폴더에 이 이미지에 대한 템플릿이 있지만 크기가 ZH-CN 클라이언트의 템플릿 폴더에 있는 이미지보다 클 수 있습니다. 이로 인해 ZH-CN 클라이언트의 `roi` 가 EN 클라이언트에서 인식되지 않을 수 있으므로 EN 클라이언트의 `task.json` 파일에서 해당 작업의 `roi` 를 EN 클라이언트의 이미지 크기와 일치하도록 수정해야 할 수 있습니다.

## 변경사항 제출

[Github Pull Request 가이드](./pr-tutorial.md)를 참고하세요!
