---
order: 8
icon: mdi:remote-desktop
---

# リモートコントロールAPI

MAA のリモートコントロールを実装するには、http(s) であり、匿名でアクセスできる次の 2 つのエンドポイントを提供するサービスを提供する必要があります。 これら 2 つのエンドポイントは、HTTP(S) プロトコルの Web エンドポイントである必要があります。

::: warning
エンドポイントがhttpプロトコルの場合、MAA は接続するたびにセキュリティ不足について警告します。**パブリックネットワークに平文転送サービスを導入することは、テスト用としてのみ非常に推奨されておらず、危険な行為です。**
:::

::: tip
JSONファイルはコメントをサポートしておらず、テキスト内のコメントはデモンストレーションのみを目的としており、直接コピーしないでください
:::

## タスク エンドポイントを取得する

MAA は、エンドポイントを 1 秒間隔で継続的にポーリングして、実行するタスクを取得しようとし、取得したリストの順序で実行します。

エンドポイント パスは任意ですが、http(s) エンドポイントである必要があります。 たとえば：`https://your-control-host.net/maa/getTask`

操作されたMAAは、MAA設定の `タスクエンドポイントの取得` テキスト ボックスにエンドポイントを入力する必要があります。

エンドポイントは、 `Content-Type=application/json` の POST 要求を受け入れることができ、要求は要求の内容として次の json を受け入れることができる必要があります：

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // ユーザーがMAA設定に入力するユーザー識別子。
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec"         // MAA によって自動的に生成されるデバイス識別子。
    ...     // このエンドポイントに他の用途がある場合は、オプションのパラメーターを自分で追加できますが、MAA は user と device のみを渡します
}
```

エンドポイントは JSON 形式で応答を返す必要があり、少なくとも次の形式を満たす必要があります：

```json
{
    "tasks":                            // MAA によって実行する必要があるタスクのリストは、例に示すように現在サポートされており、タスクがない場合、接続は無効と見なされます。
    [
        // シーケンシャル タスク: 次のタスクは、配信された順序で実行のためにキューに入れられます
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "CaptureImage",                         //スクリーンショット タスクは、現在のシミュレーターのスクリーンショットを撮り、それを Base64 文字列の形式でデブリーフィング タスクのペイロードに配置します。 このタイプのタスクを配信する必要がある場合は、スクリーンショットが数十メガバイトになり、一般的なゲートウェイの既定のサイズ制限を超えるため、エンドポイントが受け入れることができる最大要求サイズに注意することが重要です。
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "LinkStart",                            //ワンクリックで周回を始める
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "LinkStart-Recruiting",                 //対応するサブ機能を、現在の構成に従って個別にワンクリックで実行し、メインインターフェイスのその機能のチェックボックスを無視します。 このタイプのオプションの値を以下で説明します
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "Toolbox-GachaOnce",                    //ツールボックス内の本物のガチャタスク、種類の選択可能な値は次のとおりです：Toolbox-GachaOnce, Toolbox-GachaTenTimes
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "Settings-ConnectionAddress",           //構成項目を変更するタスク、ConfigurationHelper.SetValue("ConnectionAddress", params) を実行することと同じです; セキュリティ上の理由から、すべての構成を変更できるわけではなく、変更できる構成を以下に詳しく説明します。
            "params": "value"                               //要修改的值
        },
        // タスクの即時実行: 次のタスクは、順次実行タスク実行で実行でき、MAA は、通常、リモートコントロール機能自体を制御するために使用される、次のタスクのいずれかができるだけ早く結果を返すことを保証します。
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "CaptureImageNow",                      //すぐにスクリーンショットタスクは基本的に上記のスクリーンショットタスクと同じですが、唯一の違いは、タスクが他のタスクを待たずにすぐに実行されることです。
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "StopTask",                             //「現在のタスクの終了」タスクは、現在実行中のタスクの終了を試みます。 タスクリストに他のタスクがある場合は、次のタスクが先に進みます。 タスクは、現在のタスクが停止されたことを確認してから戻るのを待たないため、ハートビートタスクを使用して、停止コマンドが有効になったことを確認します。
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   //タスクの一意の ID である文字列型、タスクがデブリーフィングされるのときに使用されます
            "type": "HeartBeat",                            //ハートビートタスクは、即時に返却され、現在の「シーケンシャルタスク」キューで実行中のタスクのIDをPayloadとして返却し、現在実行中のタスクがない場合は空文字列を返します。
        },
    ],
    ...     // このエンドポイントに他の用途がある場合は、オプションの戻り値を自分で追加できますが、MAA は"tasks"を読み取るだけです
}
```

これらのタスクは順番に実行されるため、次の公開採用タスクを最初に送信してから次のスクリーンショットタスクを送信すると、公開採用タスクの終了後にスクリーンショットが実行されます。
エンドポイントは再入可能であり、繰り返し実行する必要があるタスクを返す必要があり、MAAはタスクIDを自動的に記録し、同じIDに対しては繰り返されません。

::: note

- LinkStart-[TaskName] タイプのタスクtypeのオプション値は LinkStart-Base，LinkStart-WakeUp，LinkStart-Combat，LinkStart-Recruiting，LinkStart-Mall，LinkStart-Mission，LinkStart-AutoRoguelike，LinkStart-Reclamation
- Settings-[SettingsName] タイプのタスクtypeのオプション値は Settings-ConnectionAddress, Settings-Stage1
- Settings シリーズのタスクは、タスクを受け取ったときにすぐに実行するのではなく、前のタスクの後ろに配置されています。
- すぐに実行される複数のタスクも送信順序で実行されますが、これらのタスクの実行速度は速いため、通常、彼らの順序に注目する必要はありません。

:::

## タスクデータの報告エンドポイント

MAAは、タスクの実行を終了するたびに、エンドポイントを介してリモート エンドに報告します。

エンドポイント パスは任意ですが、http(s) エンドポイントである必要があります。 たとえば：`https://your-control-host.net/maa/reportStatus`

制御対象の MAA は、MAA 設定の `タスクデータの報告エンドポイント` テキスト ボックスにエンドポイントを入力する必要があります。

エンドポイントは、 `Content-Type=application/json` の POST 要求を受け入れることができ、この要求は次のJsonを要求のcontentとして受け入れることができる必要があります：

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // ユーザーがMAA設定に入力するユーザー識別子。
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec",        // MAA によって自動的に生成されるデバイス識別子。
    "task":"15be4725-5bd3-443d-8ae3-0a5ae789254c",          // 報告するタスクのID、取得するタスクのIDに対応します。
    "status":"SUCCESS",                                     // タスクの実行結果、 SUCCESS または FAILED 。一般的には、タスクが正常に実行されたかどうかに関係なく、 FAILED のみが返され、 FAILED は上記のタスク紹介で明確に述べられている特別な場合にのみ返されます。
    "payload":"",                                           // 報告時に運ばれるデータ、文字列型。 タスクの種類によって異なり、たとえば、スクリーンショットタスクを報告する場合、スクリーンショットの Base64 文字列がここに運ばれます。
    ...     // このエンドポイントに他の用途がある場合は、オプションのパラメーターを自分で追加できますが、MAA は "user" と "device" のみを渡します
}
```

エンドポイントは任意に戻りますが、 200OK を返さない場合は、 MAA 側に `アップロードに失敗しました` という通知がポップアップ表示されます

## ワークフローの例 - QQBot を使用した MAA の制御

開発者Aは、 QQBot で MAA を制御したいので、パブリックネットワークで公開されるバックエンドを開発し、2つのエンドポイントを提供します：

```text
https://myqqbot.com/maa/getTask
https://myqqbot.com/maa/reportStatus。
```

ユーザーが使いやすくするために、 getTask インタフェースは、受け取った引数に関係なく、デフォルトで 200OK と空のタスク リストを返します。
要求を受信するたびに、データベースにアクセスして重複するデバイスがあるかどうかを確認し、重複していない場合は、デバイスとユーザーをデータベースに記録します。
つまり、このワークフローでは、このインターフェイスはユーザー登録の機能も担います。

彼は、ユーザーが deviceId を送信するための QQBot に関するディレクティブを提供します。

QQBot の指示では、 MAA の `ユーザ識別子` フィールドに QQ 番号を入力し、その後 `デバイス識別子` を QQ チャットを通じて Bot に送信するようにユーザーに伝えた。

QQBot は識別子を受信した後、メッセージのユーザーQQ番号に基づいて、データベースに対応するデータがあるかどうかを探し、ない場合は、 MAA を設定するようにユーザーに伝えます。

MAA は設定が完了すると継続的に要求を送信するため、ユーザーが MAA を設定していれば、QQで送信するときにデータベース内に一致するレコードがあるはずです。

Bot がデータベース内のこのレコードに検証済みフラグを設定し、getTask が今後このデバイスとユーザーの要求を使用すると、実際のタスク　リストが返されます。

ユーザーが QQBot を介して命令を送信すると、 Bot はタスクをデータベースに書き込み、後でgetTaskがタスクを返すようにします。 さらに、この QQbot はとても親切で、ユーザーが指示を送信するたびに、デフォルトで別のスクリーンショットタスクが添付されます。

タスクの実行後、 MAA は reportStatus を呼び出して結果を報告し、結果を受け取った後、 Bot は QQ 側でメッセージを送信してユーザーに通知し、スクリーンショットを表示します。

## ワークフローの例 - ウェブサイトを使用した MAA の制御

B開発者はサイトを通じて MAA を一括管理することを想定したサイトを書いているので、独自のユーザー管理システムを持っています。しかし、バックエンドはパブリックネットワーク上にあり、匿名でアクセスできる2つのエンドポイントを提供します。

```text
https://mywebsite.com/maa/getTask
https://mywebsite.com/maa/reportStatus。
```

ウェブサイトには、 MAA インスタンスに接続するインタフェースがあり、B開発者が `ユーザ鍵` と呼ぶランダム文字列が表示され、デバイスIDを入力するテキストボックスがあります。

ウェブサイトは、ユーザが MAA の `ユーザ識別子` に自分のユーザ鍵を記入し、その後 `デバイス識別子` をウェブサイトに記入することを要求する。

ウェブサイト上でMAA接続の作成に成功した場合のみ、getTask は 200OK を返し、その他の場合は 401 Unauthorized を返します。

そのため、ユーザーが MAA を間違えて「接続テスト」ボタンを押すと、テストが失敗したことを示すメッセージが表示されます。

ユーザーは、ウェブサイトでタスクを配信したり、タスクをキューに入れたり、スクリーンショットを表示したりできます。これらの関数の実装は、上記の QQBot の例と似ており、getTask と reportStatus の組み合わせによって行われます。
