---
order: 5
icon: ri:game-fill
---

# 統合戦略プロトコル

::: tip
JSONファイルはコメントをサポートしていません。テキスト内のコメントはプレゼンテーション用にのみ使用されます。直接コピーして使用しないでください。
:::

## ローグリソースの保存場所

- `resource/roguelike/` には、各ローグテーマに応じての運用リソースが格納されています
  - テーマフォルダ： `Phantom/` はファントム、 `Mizuki/` はミヅキ `Sami/` はサーミ
    - `autopilot/` には、各ステージの戦闘jsonが含まれます
      - `ステージ名.json` ステージの戦闘ロジック
    - `encounter.json/` 思わぬ遭遇イベントロジック
      - `default.json` 経験値モード
      - `deposit.json` 源石錐モード
    - `recruitment.json` オペレーター招集ロジック
    - `shopping.json` ストア購入ロジック

特に、 `Sami/` の下の `foldartal.json` は、サーミの暗号文板の使用ロジックを表す

## ローグの始め--オペレーター招集

`resource/roguelike/テーマ名/recruitment.json` にオペレーター招集ロジックを記述しました

```json
{
    "theme": "Phantom",              // ローグテーマ（ここはファントム）
    "priority": [                    // グループの優先度、順序
             ...
        ],
    "team_complete_condition": [     // ラインアップの完備度チェック
             ...
        ]
}
```

### オペレーターの分類

ゲーム理解に基づいて、オペレーターを異なる **_groups_** （グループ、関連概念は[自動戦闘フロープロトコル](./copilot-schema.md)を参照）に分類します

::: info 注意

1. 同じグループ内のオペレーターと召喚物は、配置方法が同じである必要があります（つまり、両方が近接か、両方が高所に配置されている）

2. 同じオペレーターや召喚物でも、使用方法に応じて異なるグループに分類されることがあります

3. 既存のグループ名を変更しないでください。 MAA の更新時に以前のバージョンの作業が使用できなくなる可能性があります

4. 新しいグループを追加しないようにし、新しく追加されたユニットを使用法に基づいて既存のグループに組み込むようにしてください

:::

::: tip
デフォルトでは、エリート1以上のレベル55のオペレーターのみを募集します
:::

```json
{
    "theme": "Phantom",
    "priority": [                     // グループ、順序付け
        {
            "name": "棘刺",           // グループ名（このグループ名は "棘刺"/ソーンズ ）
            "opers": [                // グループに含まれるオペレーター、順序付け、このグループのオペレーターを配置する際の優先度を表します，
                                      // （このグループのオペレーターを配置する必要がある場合、まずスパインを配置し、スパインがない場合はホーンがあるかどうかを確認した後、ホーンがない場合は他のグループを確認します）
                {
                    "name": "棘刺",   // オペレーター名
                    ...
                },
                {
                    "name": "号角",
                    ...
                }
            ]
        },
       "team_complete_condition": [
             ...
        ]
    ]
}
```

1. 既存のグループの紹介

   ファントムテーマを例に取ると：主にオペレーターを以下のように分類しています

   | グループ       | 主な考慮事項                   | 主に職種を含む     | オペレーターの例                                                                                 |
   | :------------- | :----------------------------- | :----------------- | :----------------------------------------------------------------------------------------------- |
   | **_地面阻挡_** | 場に立つことと雑魚を清掃       | 重装、前衛         | 庇護衛士、基石、ラ・プルマ、マウンテン、M3、リィンとシーンの召喚ユニット、スポット、重装予備隊員 |
   | **_地面单切_** | 一人でエリートモンスターと戦う | 執行者-特殊        | スルト、血掟テキサス、キリンRヤトウ、M3、レッド                                                  |
   | **_高台 C_**   | 常態と決戦DPS                  | 狙撃、術師         | 遊龍チェン、ゴールデングロー、エイヤフィヤトラ、フィアメッタ                                     |
   | **_高台输出_** | 対空および通常DPS              | 狙撃、術師         | アルケット、エクシア、クルース、スチュワード                                                     |
   | **_奶_**       | 治療能力                       | 医療、補助         | ケルシ、濁心スカジ、ハイビスカス、アンセル                                                       |
   | **_回费_**     | cost 回復                      | 先鋒               | テンニンカ、イネス、フェン、バニラ                                                               |
   | **_炮灰_**     | 砲弾吸収、再配置               | 特殊、召喚ユニット | M3、レッド、テンニンカ、予備隊員                                                                 |
   | **_高台预备_** | DPS能力を持っています          |                    | オーキッド、予備隊員                                                                             |

2. 特別な操作が必要なグループ

   上記のような一般的なグループ以外に、時折、特定のオペレーターやオペレーターの種類に対して細かいカスタマイズが必要な場合があります。例えば

   | グループ   | 含まれるオペレーター         | 主な特徴                                                                                                            |
   | :--------- | :--------------------------- | :------------------------------------------------------------------------------------------------------------------ |
   | 棘刺       | ソーンズ、ホルン             | 地上遠隔攻撃、特定の位置に非常に適したマップがあります                                                              |
   | 召唤类     | ケルシ、リィン、シーン       | 地上ブロックを持ち、一部のマップでは優先的に配置する必要があり、召喚物はブロックまたは死体として使用できます        |
   | 情报官     | カンタービレ、イネス         | コスト回収やサイドアウトプット、シングルカットが可能                                                                |
   | 浊心斯卡蒂 | 濁心スカジ                   | 低圧時の回復量はまあまあですが、範囲が特殊で、一部のマップには特に適しています                                      |
   | 焰苇       | 焔影リード                   | サーミローグはよく開局オペレーターを使い、治療と輸出を兼ねており、いくつかの図には比較的適切な位置がある            |
   | 银灰       | シルバーアッシュ、ムリナール | 地上の大規模な戦闘出力、ボスに対して配置できます                                                                    |
   | 史尔特尔   | スルト                       | 精二後、3スキルを固定搭載するため、この時点でのスタンバイ能力はほぼゼロで、ブロック位置の配置優先度は非常に低いです |
   | 骰子       | ダイス                       | ミヅキテーマの中のダイスは個別に操作する必要があります                                                              |

::: info 注意
現在、識別されていない近距離オペレーターは最後から2番目のグループ（其他地面）に分類され、識別されていない遠距離オペレーターは最後から1番目のグループ（其他高台）に分類されます
:::

### 預設陣容--陣容完備檢測

あなたがクリアできるか、高層まで進むことが期待されるチームの中で、どのオペレーターが基本的なコアメンバーに属していますか？欠かせないものは何ですか？

::: info 注意
現在のスクリプトの勧誘ロジックは、陣容が完全でない限り、0希望とkeyオペレーターだけを勧誘し、希望を高星のkeyオペレーターに渡します
したがって、完全度の数字を高く設定しないようにし、必要なすべてのオペレーターの数（基本的なコアメンバー）を合計して、4〜8人にしてください
:::

```json
{
    "theme": "Phantom",              //ローグテーマ
    "priority": [                    //グループ
             ...
        ],
    "team_complete_condition": [     //陣容完備度検査
             {
            "groups": [              //必要なグループ
                "高台C"
            ],
            "threshold": 1           //これらのオペレーターのうちいくつが必要か
        },                           //（つまり、高台Cグループから1名のオペレーターが必要）
        {
            "groups": [
                "棘刺",              //（つまり、以下のグループには最低2人のオペレーターが必要です）
                "地面阻挡",
                "地面单切",
                "炮灰"
            ],
            "threshold": 2
        },
        ...
        ]
}
```

### オペレーター募集パラメータの調整

1. グループ内の順序は配置検出の優先度を表します

2. グループ内のオペレーターの各フィールドの意味とスクリプト関連のロジック

   ```json
   {
       "theme": "Phantom",
       "priority": [
           "name": "地面阻挡",                              // グループ名（ここは近距離ブロックグループ）
           "doc": "標準ラインは1ギア(雑魚を除去する能力または戦場に立て能力がマウンテンよりも強い)、>マウンテン>2ギア(ブロック>2、自身回復力持て)>スポットであり、戦場に立て能力はスポットよりも少なく、单切または炮灰グループに入れます",
                                                           // "doc" フィールドを持つものは、プログラムの実行に影響を与えません
           "opers": [                                      // これにはどのオペレーターが含まれ、順序があり、配置の優先度を表します
               {
                   "name": "百炼嘉维尔",                    // オペレーター名（ここでは百錬ガヴィル、グループ内で1番目、地上阻止グループを配置する際に、最初に百錬ガヴィルかどうかを確認します）
                   "skill": 3,                             // 何技能を使用するか（ここでは3技能を使用する例）
                   "skill_usage": 2,                       // スキル使用モード、自動戦闘プロトコルを参照してください、空白または1は自動、2はX回だけ使用（Xは"skill_times" フィールドで設定）、3は現在サポートされていません
                   "skill_times": 2,                       // スキルの使用回数、デフォルトは1、"skill_usage" フィールドが2の場合に有効
                   "alternate_skill": 2,                   // 指定されたスキルがない場合に使用される代替スキル、通常は6星オペレーターがE2になってから3技能を使用する場合に指定する必要があります（ここでは3技能がない場合に2技能を使用する）
                   "alternate_skill_usage": 1,             // 代替スキルのスキル使用モード（このフィールドはまだ実装されていません）
                   "alternate_skill_times": 1,             // 代替スキルのスキル使用回数（このフィールドはまだ実装されていません）
                   "recruit_priority": 900,                // 募集優先度、数字が大きいほど優先度が高くなり、900以上は必ず募集することを示し、400以下は一部の重要なオペレーターのE2優先度よりも低い
                                                           // 臨時オペレーターの募集優先度は自動的に+800
                   "promote_priority": 600,                // 昇格優先度、数字が大きいほど優先度が高くなり、900以上はE2を取得する可能性があり、400以下は普通の3星オペレーターの募集優先度よりも低い
                                                           // Tips: 募集優先度を下げたり書かないで精英度を高めると、実際にはこれらのオペレーターのE2優先度を高めています
                   "is_key": true,                         // true はキーオペレーター、false または省略すると非キーオペレーターです。陣形完全性チェックに合格しない場合、キーオペレーターおよび0希望オペレーターのみを募集し、希望を保存します。
                   "is_start": true,                       // true は開幕選択オペレーター、false または省略すると非開幕選択オペレーターです。チームに start オペレーターがいない場合、start オペレーターおよび0希望オペレーターのみを募集し、ユーザーが入力したオペレーターは強制的に start オペレーターになります
                   "auto_retreat": 0,                      // 配置後何秒で自動撤退するか、整数で、0 より大きい場合に有効です、主に特殊オペレーターや投錨に使用されます、肉鳩は通常2倍速ですので、スキルの持続時間/2 に設定することをお勧めします
                   "promote_priority_when_team_full": 850,
                   "recruit_priority_offsets": [           // 現在の陣形に応じた募集優先度の調整
                       {
                           "groups": [                     // 条件を満たすためにどのグループが必要か
                               "凯尔希",
                               "地面阻挡",
                               "棘刺"
                           ],
                           "is_less": false,               // 条件は大きいか小さいか、false または省略した場合は大きいです、true の場合は小さいです
                           "threshold": 2,                 // 条件を満たす数
                           "offset": -300                  // 条件を満たした後の募集優先度の調整
                                                           // （ここでは、凯尔希、地面阻挡、棘刺の3つのグループに2人以上のオペレーターがいる場合、バイランカジュビールの募集優先度が300減少します）
                       }
                   ]
               },
               ...
           ],
       ],
       "team_complete_condition": [
           ...
       ]
   }
   ```

3. あなたの理解に基づいて新しいグループとオペレーターを追加してください

   新しいグループを追加すると、既存のグループからオペレーターをコピーして、エキスパートの評価を参考にして、それを基に変更できます

## ローグ第2ステップ--戦闘ロジック

`resource/roguelike/テーマ名/autopilot/ステージ名.json` には各ステージの戦略が記述されています。

### MAA ローグの基本戦闘ロジック--パラスちゃんの高血圧の源

1. マップ上のタイルの種類に基づいた基本的な戦闘操作
   - MAA はマップ上のタイルが青い扉か赤い扉か、高台か地面か、配置可能かどうかに基づいて基本的な戦闘操作を行います。

   - MAA はマップの名前や番号に基づいてどの作業を使用するかを決定し、マップの**一般**、**緊急**、**ルートネット**、**暗号板使用**などの状況を判断しません。
   - MAA は**戦闘中に確定できないマスの状況**を判断しません。例：`猛獣小屋`の祭壇の位置、`パブリック・エネミー`が左から出るか右から出るか

   したがって、後で、**すべての異なる状況**（上記で言及した状況）に対処できる戦闘ロジックを設計する必要があります。皆に「このマップの操作は高血圧だ！」とissueで言われないように気をつけてください（笑）

2. MAA の基本的な作戦戦略--青い扉を封鎖
   1. 地面オペレーターは青い扉のタイルに優先して配置されます（なぜタイル上なのかは後で説明）、またはその周囲に配置され、方向は赤い扉に向けられます（自動計算）。

   2. 地面を優先して配置し、その後治療オペレーターや高台オペレーターを配置し、青い扉から周囲に向かって一周ずつ配置します。

   3. 上記のロジックに従って配置可能なもの（オペレーター、召喚物、支援アイテムなど）を連続して配置します。

### 基本戦闘戦略の最適化

1. 青い扉の代替案

   オペレーターを単に青い扉の前に集めるのは明らかに賢明ではありません。いくつかのステージには、1人で立ちはだかることができるタイルがあるため、ここでの防御は非常に効果的です。

   また、複数の青い扉があるステージでは、MAA はどの青い扉がどの赤い扉に対応するかわからず、乱雑に配置します。

   この場合、[地図ウィキ](https://map.ark-nights.com/areas?coord_override=MAA)を開いて、地図を見ながら脳内で指示を出す必要があります。

   まず、`設定`で`座標表示`を`MAA`に切り替えます。

   次に、優先的に防御するポイントの座標と方向を経験に基づいて見つけ、json の`"replacement_home"`に記入します。

   ```json
   {
   "stage_name": "蓄水池",        // ステージ名、必須（CN版準拠での入力）
   "replacement_home": [         // 重要なディフェンスポイント（青い扉の交代ポイント）、少なくとも1つを埋める必要があります
       {
           "location": [         // 地図ウィキから取得したグリッド座標
               6,
               4
           ],
           "direction_Doc1": "優先方向ですが、絶対にこの方向であるという意味ではありません（アルゴリズムが独自の裁量を決定します）",
           "direction_Doc2": "デフォルトのnoneを入力しない場合、つまり、推奨される方向はなく、アルゴリズム自体が判断するのは完全にアルゴリズム次第です",
           "direction_Doc3": "none / left / right / up / down / 无 / 上 / 下 / 左 / 右",
           "direction": "left"   // （これは、オペレーターが最初に座標 6,4 に配置され、グリッドが左を向いていることを示しています）
       }
   ],
   ```

2. 配置タイルのブラックリスト

   優先的に防御するポイントがあれば、それ以外にオペレーターを配置しないポイントも存在します。例：大きな火が通る場所、ボスの足元、出力が難しい位置

   この時、`"blacklist_location"`を導入し、配置したくないタイルをブラックリストに追加します。

   ::: info 注意
   ここに追加されたタイルは、後続の配置戦略に記述されていても配置できません
   :::

   ```json
       ...
       "blacklist_location_Doc": "これは使用例であり、貯水池でこれら 2 つのポイントを禁止する必要はありません",
       "blacklist_location": [  // プログラムの展開が禁止されている場所
           [
               0,
               0
           ],
           [
               1,
               1
           ]
       ],
   ```

3. 他のマップ戦略

   例えば、ミヅキテーマでは青い扉から敵が出る場合にダイスを使う必要があるか、敵のプレッシャーを和らげる

   ```json
       "not_use_dice_Doc": "青い扉のオペレーターが撤退時にダイスを使う必要があるかどうかにかかわらず、デフォルトはfalse",
       "not_use_dice": false,
   ```

### まだ高血圧？本当の技術を見せる時が来ました--カスタム作戦戦略！

`"deploy_plan"` と `"retreat_plan"` を使用してカスタマイズ操作を実現します。

カスタム戦略は基本戦闘戦略よりも優先されます。カスタム戦略のすべてのステップを試行した後、残ったオペレーターまたは倒れた後に再度配置されるオペレーターは、基本戦闘戦略に従って継続的に配置されます。

多くの場合、多くのカスタム戦略を設定する必要はありません。重要なステップが完了した後、MAA に任せると良い結果が得られるかもしれません。

1. グループを使用してオペレーターを配置する

   ```json
   "deploy_plan": [ // 上から下、左から右の順序で取得するロジックを配置し、最初に見つかったオペレーターの配置を試み、そうでない場合はスキップします
       {
           "groups": [ "百嘉", "基石", "地面C", "号角", "挡人先锋" ],//これらのグループからオペレーターを検索します
           "location": [ 6, 4 ],             //これらのグループを巡回する
           "direction": "left"               //見つかった最初のオペレーターを 6,4 という座標上に配置し、左を向く
       },                                    //見つからない場合は次の配置操作に進みます
       {
           "groups": [ "召唤" ],
           "location": [ 6, 3 ],
           "direction": "left"
       },
       {
           "groups": [ "单奶", "群奶" ],
           "location": [ 6, 2 ],
           "direction": "down"
       }
   ]
   ```

   ::: info 注意
   MAAは、すべてのデプロイ命令をフラット化し、最優先のデプロイ操作を実行します。
   例：[6,4]に[ "百嘉", "基石", "地面 C"]を配置し、[6,3]に[ "基石", "地面 C"]を配置する場合、MAAはデプロイ命令を[ "百嘉", "基石", "地面 C"，"基石", "地面 C"]としてフラット化します。
   戦闘中に[6,4]の位置にある"百嘉"が倒れ、配置可能な"基石"が手元にある場合、MAAは[6,4]ではなく[6,3]に優先的に配置します。
   :::

2. 特定の時間にオペレーターを配置する
   ::: tip
   これは、シングルカットオペレーターまたは大砲の飼料が必要な一部のユースケースに適しています
   :::

   ```json
   "deploy_plan": [
           {
               "groups": [ "异德", "刺客", "挡人先锋", "其他地面" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 0, 3 ]       // この操作は、キル数が0〜3の場合にのみ実行されます
           },
           {
               "groups": [ "异德", "刺客", "挡人先锋", "其他地面" ],
               "location": [ 5, 3 ],
               "direction": "left",
               "condition": [ 6, 10 ]
           },
           ...
       ]
   ```

3. 特定の時間にオペレーターを撤退させる
   ::: tip
   肉壁が強すぎてスタンドに留まりたい場合や、配置スペースを移動したい場合は、撤退します！
   :::

   ```json
    "retreat_plan": [  // 特定の時間に対象のオペレーターを撤退させます
           {
               "location": [ 4, 1 ],
               "condition": [ 7, 8 ] // キル数が7〜8の場合、位置[4,1]のオペレーターを撤去します。存在しない場合はスキップします
           }
       ]
   ```

4. 特定の時間にスキルを発動する（to do）

5. その他のフィールド（おすすめではありません）

   ```json
       "role_order_Doc": "オペレーターのタイプデプロイ順序。未記入の部分は前衛、先鋒、医療、重装、狙撃、術師、補助、特殊、召喚ユニットの順で補完されます。英語で入力してください。",
       "role_order": [ // おすすめしません。deploy_plan フィールドを設定してください
           "warrior",
           "pioneer",
           "medic",
           "tank",
           "sniper",
           "caster",
           "support",
           "special",
           "drone"
       ],
       "force_air_defense_when_deploy_blocking_num_Doc": "フィールド上に10000個のブロックユニットがある場合、合計1つの対空ユニットを強制的にデプロイします（記入の有無は正常なデプロイロジックに影響しません）。この期間中、医療ユニットのデプロイは禁止されません（指定しない場合はデフォルトでfalse）",
       "force_air_defense_when_deploy_blocking_num": { // おすすめしません。deploy_plan フィールドを設定してください
           "melee_num": 10000,
           "air_defense_num": 1,
           "ban_medic": false
       },
       "force_deploy_direction_Doc": "これらのポイントは、特定の職業に対して強制的にデプロイする方向です",
       "force_deploy_direction": [ // おすすめしません。deploy_plan フィールドを設定してください
           {
               "location": [
                   1,
                   1
               ],
               "role_Doc": "指定された職業は強制的な方向に適用されます",
               "role": [
                   "warrior",
                   "pioneer"
               ],
               "direction": "up"
           },
           {
               "location": [
                   3,
                   1
               ],
               "role": [
                   "sniper"
               ],
               "direction": "left"
           }
       ],
   ```

### 特定のオペレーターの戦術に特別な理解がありますか？- 特定のオペレーターに対する高度な操作

このオペレーターを単独でグループ化してください。

作業を記述する際に、このオペレーターと既存の作戦の優先順位を考慮してください。

また、このオペレーターに対して個別に作戦ロジックを記述することもできます。

1人のオペレーターだけを使用することも可能です！MAAを使用して個別のクリアを目指しましょう（他のロジックが不完全なため、確率は低いです）。

参考例：1. ファントムテーマのソーンズ 2. ミヅキテーマの血掟テキサス 3. サーミテーマの焔影リード

## ローグ第3ステップ--思わぬ遭遇イベントのノードロジック

`resource/roguelike/テーマ名/encounter/default.json` は、経験値モードの思わぬ遭遇イベントの選択戦略を記述しています

`resource/roguelike/テーマ名/encounter/deposit.json` は、源石錐モードの思わぬ遭遇イベントの選択戦略を記述しています

### MAAの現在の思わぬ遭遇判定方法

OCRで思わぬ遭遇イベントを認識しますが、選択肢は固定された位置を操作します

時間が認識されない場合、最も下の選択肢を選択します

通常、微調整するか調整しないことが必要です（高手はすでに書いているでしょう）

### 思わぬ遭遇オプションの優先度を最適化する

[prts.wiki](https://prts.wiki/w/%E9%9B%86%E6%88%90%E6%88%98%E7%95%A5) を参照して、各イベントのオプション効果を確認してください。ただし、選択肢は必ずしも固定ではありません

思わぬ遭遇イベントオプションを変更して、MAAを特定のマップの特殊エンディングに向かわせることもできます

```json
{
    "theme": "Sami",                              //ローグテーマ
    "stage": [                                    //思わぬ遭遇イベント
        {
            "name": "低地市集",                    //思わぬ遭遇イベント名
            "option_num": 3,                      //全部でいくつかのオプションがあります（ここでは3つあります）
            "choose": 3,                          //最初のいくつかのオプション（ここでは3番目のオプション）に優先順位を付け、できない場合は逃げるオプション（基本的に最後のオプション）を選択します
            "choice_require": [                   //オプションを選択するための要件（一時的にプログラムの動作に影響を与えず、簡単に変更できるように該当する状況をマークするのみ）
                {
                    "name": "选择碎草药",          //オプションの名
                    "ChaosLevel": {               //干渉抵抗/灯火レベル
                        "value": "3",             //必要な数値
                        "type": ">"               //より大きいか小さいか（ここでは、砕いたハーブを選択するオプションをアクティブにするために、干渉抵抗/灯火が3より大きいことを意味します）
                    }
                },
                {
                    "name": "选择好看的织物",
                    "ChaosLevel": {
                        "value": "3",
                        "type": ">"
                    }
                },
                ...
```

### チームの状況に応じて特定の選択肢の優先度を動的に調整する(TODO)

## ローグ第4ステップ--商店の秘宝の優先度

`resource/roguelike/テーマ名/shopping.json` は、秘宝を商店に購入する(戦闘後に秘宝を選択する)の戦略を表します。

```json
{
    "theme": "Phantom",                                     //ローグテーマ名（ここはファントム）
    "priority": [                                           //優先度、有序、順序はすべて優先度を表し、前にあるほど優先的に購入されます
                                                            //ただし、優先度の判定はchars、rolesの選択よりも前に行われるため、高い優先度の商品が除外され、何も買わない状況が発生する可能性があります
        {
            "name": "金酒之杯",                              //秘宝名（ここは金酒の杯）
            "no_longer_buy": true,                          //trueは、この秘宝を手に入れた後、もうお金を使って秘宝を買わないことを示します。falseまたは省略された場合、引き続きお金を使って秘宝を買います
            "ignore_no_longer_buy": true,                   //trueは、店にこの秘宝がある場合、"no_longer_buy"を無視してそれを買うことを示します。falseまたは省略された場合、"no_longer_buy"の秘宝が手に入った後、その秘宝を購入しなくなります
            "effect": "每有5源石锭，所有我方单位的攻击速度+7", //秘宝の效果（プログラムの実行に影響しません。並べ替えるのに便利です）
            "no": 167                                       //秘宝番号（wikiで確認できます。プログラムの実行に影響しません。並べ替えるのに便利です）
        },

        ...
        {
            "name": "扩散之手",
            "chars": [                                      //これらのオペレーターがチームにいるとき、この秘宝を購入します
                "异客"                                      //（ここでは、チームにパッセンジャーがいる場合、拡散の手と出会えた場合、購入を試みます）
            ],
            "effect": "【扩散术师】、【链术师】和【轰击术师】每对一个单位造成伤害就回复2点技力值",
            "no": 136
        },
        ...

        {
            "name": "折戟-破釜沉舟",
            "roles": [                                      //これらの職業がチームにいるとき、この秘宝を購入します
                "WARRIOR"                                   //（ここでは、チームに前衛干員がいる場合、折戟-破釜沉舟に遭遇した場合、購入を試みます）
            ],
            "effect": "所有【近卫】干员的防御力-40%，但攻击力+40%，攻击速度+30",
            "no": 16
        },
        ...

        {
            "name": "Miss.Christine摸摸券",
            "promotion": 2,                                 //2人のオペレーターが昇進する必要があるときにこの秘宝を購入します（かな？）
            "effect": "立即进阶两个干员（不消耗希望）",
            "no": 15
        },
```

## 個別のローグテーマ カスタムロジック

### サーミテーマ--密文板

`resource/roguelike/Sami/foldartal.json` はサーミテーマの密文板の戦術を記述しています。

```json
{
    "theme": "Sami",                                         //ローグテーマ名（ここはサーミ）
    "groups": [                                              //使用状況と用法のグループ化
        {
            "usage": "SkipBattle",                           //用法（ここでは戦闘をスキップして、源石錐ためや電気ケトルための作戦ノードに使用します。板を使用して戦闘をスキップして時間を節約します）
            "doc": "跳过战斗,刷钱和烧开水模式",
            "pairs": [                                       //板のペア（対応するノードに遭遇した場合、以下の板のペアが一致するかどうかを判断し、一致する場合は使用可能なものをすべて使用し、一致しない場合は直接ポイントに進みます）
                {                                            //（ここでは、"伤痕"と"空无"のみが連結できます）
                    "up": [                                  //上板
                        "伤痕"
                    ],
                    "down": [                                //下板
                        "空无"
                    ]
                },
                {                                            //（ここでは、順番に "黜人"+"惊讶","黜人"+ "疑惑","黜人"+...,"猎手"+"惊讶","猎手"+ "疑惑","猎手"+... , ... などを検索します）
                    "up": [
                        "黜人",
                        "猎手",
                        ...
                    ],
                    "down": [
                        "惊讶",
                        "疑惑",
                        ...
                    ]
                }
            ]
        },
        {
            "usage": "Boss",                                 //（ここでは、ボスポイントに遭遇した場合に使用される板のペアを示します）
            "doc": "あるものは全部使った",
            ...
        }
    ],
    "foldartal": [                                          //密文板の効果の注釈（ここでは、板の効果を参照用に記述し、プログラムの実行には影響しません）
        {
            "name": "布局",                                  //密文板の種類（上板か下板か）
            "foldartal": [
                {
                    "name": "黜人",                           //密文板の名前
                    "effect": "选择所有右侧邻近的战斗节点"       //密文板の効果
                },

```

## 実現したいロジック（todo）

### 自動編成ロジック

1. 異なるマップに応じて、異なるマップ配置の完全性検査とスキル優先度の設定が可能です

2. 現在の配置に基づいて、いくつかの難しい戦闘を避けることができます。

### ~~経路探索アルゴリズムの最適化~~（初期実装済み）

例えば、最初の3層で多くの戦闘を行い、後ろの層では少ない戦闘を行うようにすると、成長がより良くなります。

### スキル保持

特定の位置に配置されたオペレータのスキルが準備できた後、x秒待ってから使用します。これは軸に対して便利です。Deploy_plan の下に Skill_hold を記述することもできます。

### スキル停止

弾薬消費系のオペレータに便利です。

<!-- markdownlint-disable-file MD026 -->
