---
order: 3
icon: ph:sword-bold
---

# 自動戦闘プロトコル

`resource/copilot/*.json` の使用方法とフィールドの説明。

::: tip
JSONファイルはコメントをサポートしておらず、テキスト内のコメントはデモンストレーションのみを目的としており、直接コピーしないでください
:::

## Overview

```json
{
    "stage_name": "暴君",           // ステージ名、必須。CN版のステージ名、コード、ステージID、レベルID、他。これらは全てサポート範囲です、一意であることが保証されている限り。
    "opers": [                      // オペーレーターリスト
        {
            "name": "ソーンズ",      // オペーレーター名

            "skill": 3,             // スキルID と範囲 [1, 3], オプション, 1 がデフォルト

            "skill_usage": 0,       // スキルの使用, オプション, デフォルトは 0
                                    // 0 - `パッシブ`
                                    // 1 - 準備次第使用 (例 ソーンズ: デストレッツァ, テンニンカ: 支援指令β)
                                    // 2 - X回使用（例えば、マウンテン スキル2は1回、チョンユエ スキル3は5回、"skill_times" フィールドで設定）
                                    // 3 - 自動判定 (未実装)
                                    // 自動発動のスキルであれば0を記入

            "skill_times": 5,       // スキル使用回数。オプション、デフォルトは1

            "requirements": {       // 要件、予約フィールド、未実装、オプション、デフォルトは空白
                "elite": 2,         // 昇進要件、オプション、デフォルトは 0
                "level": 90,        // レベル要件、オプション、デフォルトは 0
                "skill_level": 10,  // スキルレベル要件、オプション、デフォルトは 0
                "module": 1,        // モジュール要件、オプション、デフォルトは 0
                "module_level": 3,  // モジュールレベル、オプション、デフォルトは 0
                "potential": 1      // 潜在要件、オプション、デフォルトは 0
            }
        },
    ],
    "groups": [
        {
            "name": "一般群体ヒーラー",  // グループ名、必須
                                     // `name` フィールドと `deploy` が一致していればどのような名前でも構いません

            "opers": [               // ランダムに選ばれるオペレーター、 `opers` フィールドと同様。レベルの高いオペレータほど優先されます。
                {
                    "name": "ナイチンゲール",
                    "skill": 3,
                    "skill_usage": 2 // スキルのCDは異なる場合があり、注意してください
                },
                {
                    "name": "フィリオプシス",
                    "skill": 2,
                    "skill_usage": 2
                }
            ]
        }
    ],
    "actions": [                    // 順番に行動、必須. 順次実行されます
        {
            "type": "Deploy",       // 行動タイプ、オプション、デフォルトは "Deploy"
                                    // "Deploy" | "Skill" | "Retreat" | "SpeedUp" | "BulletTime" | "SkillUsage" | "Output" | "SkillDaemon" | "MoveCamera" | "ResetStopwatch"
                                    // "部署"   |  "技能"  |  "撤退"   | "二倍速"   |  "子弹时间"  |  "技能用法"   | "打印"  |  "摆完挂机" | "移动镜头" | "重置全局计时器"
                                    // 英語と中国語のみサポート
                                    // "Deploy" はコストが補充されるまで待つ（タイムアウトしない限り）
                                    // "Skill" はスキルの準備ができるまで待つ（タイムアウトしない限り）
                                    // "SpeedUp" は切替式、例 使用後は2倍速になり、再度使用すると通常速度に戻ります
                                    // "BulletTime" 予約フィールド、未実装、任意のオペレータをクリックした後の1/5の速度です。他の操作を進めると通常の速度に戻ります
                                    // "Output" は、ドキュメントの内容をプリントアウト（字幕などのため）
                                    // "SkillDaemon" は、スキルの準備ができるとスキルを使用し、終了まで何もしない
                                    // "MoveCamera" は「導灯の試練」モードで使用され、distanceフィールドにも入力する必要があります
                                    // "ResetStopwatch" — グローバルタイマーをリセットします。「time_elapsed」条件を参照してください。

            // 以下の5つのフィールドの関係は AND, 例 &&
            "kills": 0,             // 必要なキル数に達するまで待機、オプション、デフォルトは 0

            "costs": 50,            // コスト条件を満たすまで待ちます。 省略可能で、デフォルトは 0 で、実行は直接です
                                    // コストは、潜在やその他の要因により完全に正しいとは限らない場合があり、厳密なタイムライン要件がない戦闘にのみ適しています。
                                    // それ以外の場合は、以下の cost_changes を使用します
                                    // また、コストが2桁の数字の場合のみ識別する方が正確であり、3桁のコストは誤認識される可能性があるため、お勧めできません

            "cost_changes": 5,      // 指定された量のコストが変更されるまで待機, オプション, デフォルトは 0
                                    // アクションが始まってから計算することに注意（直前のアクションのコストに基づく）
                                    // 負の数のサポート、つまりコストが削減されます(例: “ジェイ”やその他のコスト吸収オペレーターはコストを低くします)
                                    // コストが2桁の場合、正確に認識されます。3桁のコストでは推奨しません。

            "cooling": 2,           // オペレーターの CD が指定数になるまで待つ, オプション, "ignore" の場合デフォルトは -1.

            "time_elapsed": 1000,   // ミリ秒単位のグローバルタイマー条件。指定時間に達していない場合は待機し続けます。省略可能で、デフォルトは 0（すぐに実行）。
                                    // 注意：この時間は直前の type:ResetStopwatch アクションの実行時点から計測されます。
                                    // 使用する前に必ず type:ResetStopwatch アクションでタイマーをリセットしておく必要があります。そうしないと動作が停止します。

            // TODO: Other conditions
            // TODO: "condition_type": 0,    // 条件集約型, オプション, デフォルトは 0
            //                        // 0 - AND； 1 - OR

            "name": "ソーンズ",      // オペレーター/グループ名, `type` が "Deploy" の場合必須, "Skill" か "Retreat" の場合はオプション

            "location": [ 5, 5 ],   // 配置位置
                                    // `type` が "Deploy" の場合必須.
                                    // `type` が "Skill" か "Retreat" の場合はオプション,
                                    // "Skill": マップ内設備（灯台など）の使用での推奨, name ではなく location を指定してスキルを使用することを推奨します, 通常のオペレーターがスキルを使用する場合は name を使用するだけにしてください
                                    // "Retreat"： 複数の召喚ユニットがいる場合のみ推奨, name ではなく location で退却, 通常のオペレーターは単純に name で退却してください

            "direction": "Left",    // 配置方向, `type` が "Deploy" の場合必須
                                    // "Left" | "Right" | "Up" | "Down" | "None"
                                    // "左"   |  "右"   | "上"  | "下"   |  "无"
                                    // 英語と中国語のみサポート

            "skip_if_not_ready": false, // type が "Skill" の場合のみ有効。スキルが使用できない場合に現在のアクションをスキップ可能。主に未完了の弾薬スキルを無効にするために使用。省略可能で、デフォルトは false。

            "skill_usage":  1,      // スキルの使用方法を上書き, `type` が "SkillUsage" の場合必須
                                    // 例: テンニンカは設置時にスキルを使わず攻撃し、後で自動的にスキルを使う必要があります.
                                    // 上記例の場合 1 に設定してください

            "skill_times": 5,       // スキル使用回数。オプション、デフォルトは1

            "pre_delay": 0,         // 事前遅延 ms（ミリ秒）, オプション, デフォルトは 0
            "post_delay": 0,        // 事後遅延 ms（ミリ秒）, オプション, デフォルトは 0

            // "timeout": 999999999,  // 予約フィールド, 未実装
                                    // タイムアウト時間 ms（ミリ秒）, `type` が "Deploy" | "Skill" の場合オプション, デフォルトは INT_MAX
                                    // タイムアウト時に次のアクションを実行する
            "distance": [4.5, 0],   // type が "move camera" の場合が必要です
                                    // [ x 移動ブロック数, y 移動ブロック数 ]、小数点数にすることができます
                                    // 注意 "move camera" では、フィールドに立っていることは認識されず、移動アニメーション全体をsleepで完全にカバーする必要があります

            "doc": "ソーンズ使え！",  // 説明文、オプション、UIの表示のみで効果はありません
            "doc_color": "orange"   // 説明文の色、オプション、UIの表示のみで効果はありません
        },
                                    // 例 1
        {
            "name": "一般群体ヒーラー",
            "location": [ 5, 6 ],
            "direction": "Right"
        },
                                    // 例 2
        {
            "name": "スルト",
            "location": [ 4, 5 ],
            "direction": "Left",
            "doc": "スルト来た！",
            "doc_color": "red"
        },
                                    // 例 3
        {
            "type": "SpeedUp"
        }
    ],
    "minimum_required": "v4.0",     // 最低要求の MAA バージョン、必須、予約フィールド、未実装
    "doc": {                        // 説明文、オプション
        "title": "低レベル高成功率タスク",
        "title_color": "dark",
        "details": "レベル要求低い〇〇〇…",      // 個々に名前や、動画へのリンク、攻略へのリンクなどお書きください。
        "details_color": "dark"
    },
    "difficulty": 0 // タスクの難易度。オプション。デフォルト値は 0。
    // 0: デフォルト、未設定
    // 1: 通常の難易度をサポート
    // 2: レイド難易度をサポート
    // 3: 通常の難易度とレイド難易度をサポート
}
```

## 実例

[OF-1](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/master/resource/copilot/OF-1_credit_fight.json)
