---
order: 0
icon: ic:baseline-article
---

# 使用説明書（古い）

## 詳細な説明

### ワンクリックで周回：理性を有効活用

- ステージ選択に必要なステージがない場合ならば、MAAで `現在/前回` を選択し、ゲーム内で手動でステージを選択し、**任務開始**と**自動指揮**がゲーム画面に存在することを確認してください。
- 現在この画面が表示されていない場合、 `現在/前回` は自動的に端末のホームページの右下隅にある「前回の参加作戦へ」ステージに入ります。
- `タスク設定` - `作戦` - `高度な設定` の `ステージ名を入力する` を有効にすることで、ステージ番号を手動で入力することもできます。 現在サポートされているナビゲーションステージは以下の通りです：
  - すべてのメインストーリーステージ。通常または厄難奮戦に切り替えるには、ステージの末尾に `-NORMAL` または `-HARD` を追加します。
  - 龍門幣、作戦記録の5/6ステージ。ただし、 `CE-6` / `LS-6` を入力する必要があります。6ステージを実行できない場合は、自動的に5ステージに移行します。
  - アーツ学、購買資格証、建築資材。 `CA-5` / `AP-5` / `SK-5` を入力する必要があります。
  - SoCの場合のみ、完全なステージ番号を入力する必要があります。例： `PR-A-1` 。
  - `Annihilation`（殲滅作戦）。
  - `OF-1` / `OF-F3` / `GT-5` のみサポートされます。
  - 現在のSSイベントの最後の3つのステージ。 [API](https://api.maa.plus/MaaAssistantArknights/api/gui/StageActivity.json) で更新が自動的にダウンロードされた後、メイン画面に対応するメッセージが表示されます。
    - 再刻印SSアクティビティは `SSReopen-XX` と入力するとXX-1～XX-9ステージを一度にクリアできます。 `SSReopen-IC` など。

::: details 画面例
![画面例](/images/ja-jp/combat-start-interface-example.png)
:::

- スタート画面の `理性剤使用数 + 割る源石の数`、`周回数指定`、`素材を限定` の3つのオプションはショートスイッチですので、**3つのオプションのいずれかを達成した場合**、それはタスクの完了と見なされます。
  - 以下のうち：
    - `理性剤使用数` 理性剤使用数量制限（複数のボトルを一度に使用できます）
    - `割る源石の数` 源石を割る回数を指定（1回につき 1 個）; 源石を使用して正気度を回復する場合、正気度のポーションが残っている場合、原石は使用されません。
    - `周回数指定` ステージを何回周回するか指定（例“15 周 で停止”）
    - `素材を限定` 特定の素材のドロップ数が手に入るまで周回（例“5 個 初級源岩獲得で停止”）

| 例  | 理性剤使用数 | 割る源石の数 | 周回数指定 | 素材を限定  | 結果                                                                                                                                                                                               |
| :-: | :----------: | :----------: | :--------: | :---------: | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  A  |     999      |      10      |     1      |     ✖      | 理性材/純正源石を**1回**以上摂取し、`周回数：1`回の条件を完了すると、即座に停止。理性不足の状態で純正源石か理性剤が不足している場合は摂取せずに自動的に終了します。                                |
|  B  |      ✖      |      ✖      |    100     |     ✖      | 100回ステージを実行しようとしますが、現在使用可能な理性を消費後（おそらく数回）に、`理性剤`、`純正源石`なしの条件が達成されるため、理性を消費できず、タスクは完了されます。                        |
|  C  |      1       |      ✖      |    100     |     ✖      | 100回ステージを実行しようとしますが、理性剤を 1 個消費した後に理性が不足した場合、`理性剤使用数：1`、`割る源石の数0`の条件を達成したためタスクは完了します。                                       |
|  D  |     999      |      ✖      |    100     | 3個初級源岩 | 100回ステージを実行しようとし、最大 999 の理性剤を消費しようとしますが、実行中に3個の初級源岩を獲得した場合、`素材を限定：3個の初級源岩`の条件を達成するため、その時点でタスクを完了し停止します。 |

- `素材を限定` と `ステージ選択` は2つの別々のロジックです。
  - `素材を限定` は、タスクを完了するための素材の数に基づいており、対応するステージに自動的に移動しません。
- `自動指揮` を自動的にチェックするサポート。
- クリアした後 [penguin-stats](https://penguin-stats.io/) と [Yituliu](https://ark.yituliu.cn/) に自動的にアップロードすることができます。penguin-statsのIDはカスタマイズ可能です。
- 接続が切断された場合や午前4時に切断された場合は、自動的に再接続され、前回のステージを続けてプレイできます。
- クリアした後にドクターレベルがアップした場合でもサポートされています。
- 自動指揮に失敗した場合は、その作戦を自動的に放棄して待機画面へ戻ります。
- 殲滅作戦関連：
  - MAA は端末のホームページの右上隅にある `殲滅作戦` ボタンから進むので、現在の殲滅作戦で `全権委任` のロックを解除し、充分な数の `PRTS殲滅代理カード` を保持していることを確認してください。
  - 現在の殲滅作戦がリフレッシュ後、アークナイツを再インストールした後、殲滅作戦の `行動開始` ページから戻ると自動的に「情報の概要」が展開されますので、タスクが停滞しないように、事前にこのページを閉じてください。
  - MAA は、現在の期間に**「400キル」を達成した**プレイヤーのみ、このタスクを使用することをお勧めします。
- 余剰理性の消費関連：
  - `ステージ選択` のステージで理性を切れになった後、自動的に `余剰理性の消費` に指定したステージに移動し“余剰”理性を消費します。（例：余剰理性を 1-7 に指定した場合）
  - 実行に必要な理性がない場合（例 1-7 を指定し、理性が6未満の場合）即座にタスクを停止します。

### 公開求人認識

- **`スタート画面の公開求人` と `公開求人認識` は別々の2つの機能です！**
- 公開求人は `緊急招集票` が利用でき、自動的に継続して求人が行われます。 `タスク設定` - `公開求人` から `緊急招集票を自動的に使用` を選択し、 `1回の実行あたりの求人の最大回数` を変更してください。
- 星1、星5、星6が確定した場合はポップアップ通知が表示されます。
- `スタート画面の公開求人` 中に [PenguinStats](https://penguin-stats.io/) と [Yituliu](https://ark.yituliu.cn/) へ公開求人データを自動的にアップロードすることができます。

### 基地のシフトの切り替え

#### ストラテジー

- **単一施設内での最適解**を自動的に計算して選択した上で全てのスキルとスキルの組み合わせをサポートしています。
- 作戦記録・純金・源石の欠片・SoCに対応したオペレーターの組み合わせを変えて配置することをサポートします！

#### 基地で働く体力をパーセントで指定可能

体力のパーセントをを自動的に認識するし、体力がしきい値未満のオペレーターは出勤せず、宿舎に進駐します。

#### 特別な注意事項

- 基地のシフトは現時点では単一施設内での最適解ですが、施設全体の最適解ではありません。
  - 例えば、`シャマレ+テキーラ`、`ヴァーミル+シーン` などの組み合わせは認識され、通常どおり使用できます；
  - `ロスモンティス`、`レッドパイン騎士団(フレイムテイル/ファートゥース/ワイルドメイン/アッシュロック)` などの多くの施設間で連携する組合せは一時的にサポートできません。
- `ドローンの使用` で `貿易所-龍門幣` を選択した場合。 `シャマレの組合せ` があるかどうかを識別し、優先的に使用します。
- 応接室の手がかりが1つだけ欠けている場合は、該当するスキルのあるオペレーターが選ばれ、そうでない場合は一般オペレーターが選ばれます。
- 応接室は自分の手がかりが溢れた際、手がかり3つのみを譲り渡します。必要な場合、`resource/tasks/tasks.json` の `ClueSelected` - `maxTimes` フィールドを変更して、譲渡する数をカスタマイズできます。
- 訓練所を使用していない場合 `アイリーニ` などのオペレーターを宿舎に移動させたくない場合は、設定で `作業中のオペレーターを宿舎に移動しない` にチェックしてください。 ただし、この場合、疲労が蓄積していないオペレータも宿舎に入れなくなる可能性があります。
- 制御中枢のストラテジーが複雑すぎるため。現在では `アーミヤ` `スワイヤー` `ケルシー` `レインボー小隊` および体力値が+0.05のスキルのオペレーターのみが考慮されており、今後徐々に最適化される予定です。

### カスタム基地設定（テスト中）

- [Yituliu](https://ark.yituliu.cn/)のエキスパートが、基地シフトをドキュメントでエクスポートできる[ジェネレーター](https://ark.yituliu.cn/tools/schedule)の作成に協力しました。[ドキュメント](../../protocol/base-scheduling-schema.md)を参照して使用できます。
- `/resource/custom_infrast/`のフォルダに、非常に効率的なタスクのセットがいくつか組み込まれており、参考として使用することができます。(昇進2の該当オペレーターがいれば、直接使用可能です。)

### FPと購買部

- 戦友の基地訪問は自動的に行われ、FPポイントを獲得します。
- ワルファリンの金の助けで:
  - サポートオペレーターを使用し、「青く燃ゆる心」の`OF-1`ステージをクリアします（理性消費無し）。ステージがアンロックされていない場合は、このオプションを選択しないでください。
  - ステージ選択が`現在/前回`に設定されている場合は、反映されません。

### 自動統合戦略（ローグライク）

- MAA設定で `スタート` - `自動ローグライク` にチェックし「ファントム/ミヅキ/サーミ」を選択しスタートします。選択次第ではデフォルトで最新のテーマが選択されているため、問題が発生する可能性があります。
  - ゲーム内で対応するテーマを「PIN UP」しないと、デフォルトで最新のテーマが表示されるため、不具合が発生する可能性があります。
  - 固定しない場合は、現在の画面がテーマのロビーページ（「探索を始める」/「探索を続ける」ボタンがある）であることを確認してから、この機能を起動してください。
  - 対象外の条件がある場合（例：MAAでミヅキをプレイする予定だが、未達のファントムのセーブがある）、その場合は手動で終了させてください。
  - MAAがスタックしたり、難易度選択画面を何度も出たり入ったりする場合は、手動で難易度を選択してからこの機能を有効にしてください。

::: details 固定方法「PIN UP」
![固定方法](/images/ja-jp/introduction-i.s.-pin-up.png)
:::

- 設定は分隊、最初の職業選択（最初に一つのオペレーターを指定する）等を設定できます。
- オペレーターや昇進レベルを自動認識し、最適なオペレーターやスキルを自動選択。
- ショップアイテムの識別と、より強力な秘宝の購入の優先順位のサポート。
- 午前4時のアップデート後、ドロップ後の再接続と周回の継続に対応。
- 5分経っても戦闘が終わらない場合は、すべての地上部隊が自動的に退却。6分経つと自動的に戦闘放棄し、無限ループを防ぎます。
- アプリがバグで立ち往生した場合は、現在の冒険を自動的に放棄して再試行します。ですが、特定のポイントでスタックする場合や、効率に深刻な影響を与えることが多い場合は、Issueを提出してフィードバックをお寄せください。

### アカウントの切り替え（CNサーバーのみ）

- ログイン済みアカウントへの切り替えのみをサポートし、ログイン名を使用して検索することで、入力内容がすべてのログイン済みアカウントで一意であることを保証します

### 自動戦闘（現在JP未対応）

- 適応していないことが示されていますが、自動攻略ファイル内の中国語の指示を理解できる限り、ほとんどの機能を使用できます。アプリがバグで立ち往生した場合は、Issueを提出してフィードバックをお寄せください。
- 自動攻略ファイルのシェアは大歓迎です！
- [prts.plus](https://prts.plus) をご利用ください!

#### 使い方

`編成可能のステージ` と `保全駐在` モードでの自動戦闘をサポートします。

- この機能は、`行動開始` のある画面で開始する必要があります。  
  その後、 `攻略ファイルパス` または `ミステリーコード` をMAAの左上にあるボックスに入力するで、ジョブをインポートできます。
  - さらに、ビデオ認識がサポートされており（テスト中）、ビデオファイルをドラッグすることでアクティブ化できます。  
    アスペクト比16:9、解像度720p以上の動画にのみ対応しています。動画には、黒枠、歪み補正、エミュレータの枠などが含まれていないことが必須です。
- `自動編成` 機能は、**現在の編成をクリアし**、ジョブに必要なオペレーターに基づいて編成を自動的に完了します。
  - `自動編成` は、必要に応じてキャンセルして（たとえば、必要に応じて `戦友サポート` を使用する場合）、手動編成後に開始する。
  - `カスタムオペレーターを追加する` と `信頼性の低いオペレーターを追加する` は、ミッションの必要に応じて自動編成に追加できます。
  - 「逆理演算」ステージでは、 `自動編成` をオフにし、スキルを手動で選択した後、**演算開始**ボタンのインターフェイスで自動戦闘を開始する必要があります。
  - 「保全駐在」ステージでは、 `自動編成` は無効であり、ステージ詳細に**配置開始**ボタンがある画面で自動戦闘を開始できるようになるまで、**初期**ミッションの準備を手動で完了する必要があります。
- 自動戦闘の「サイクル数」を設定できます（例：保全駐在）。
- `バトルリスト` 機能を使用して、同じエリア内のステージの連続した自動戦闘をキューに入れることができます。
  - ジョブをインポートしたら、以下のリストのステージコードが正しいことを確認してから、ステージを追加します（代わりに右クリックして強襲作戦を追加します）。  
    追加後、対応するステージの作戦を行うかどうかのオンとオフを切り替えることができます。
  - この機能をオンにすると、**ステージが配置されているマップ画面**で自動戦闘を開始できます。 自動戦闘キューは、理性不足/戦闘失敗した/星3以外で完了の場合に停止します。
  - リスト内のステージが同じエリアにあることを確認してください（マップ画面を左右にスワイプすることでのみナビゲートできます）。
- **攻略ファイルの採点を高め、クリエイターを激励するために、必ず良質な攻略ファイルに「いいね！」を押してください。**

![image](/images/zh-cn/copilot-click-like.png)

#### 攻略ファイルの作成

- [ジョブエディター](https://prts.plus/create)を使用して作成してください、[自動戦闘API](../../protocol/copilot-schema.md)を参照してください。
- マップ座標の取得：
  - ジョブエディターでステージ名を入力すると、ドラッグ可能な座標マップが左下隅に自動的にロードされ、クリックして現在のオペレーターの位置を設定できます。
  - ステージ名を入力して JSON をエクスポートすると、直接行動開始され、座標情報で覆われたマップのスクリーンショットが MAA ディレクトリの `debug\map` ディレクトリに生成されます。
  - [PRTS.map](https://map.ark-nights.com/) の `設定` から座標を `MAA` に変更し使います。
- 演習モードをサポートしている。
- 説明文には、自分の名前（作者名）、参考動画のURL、その他言いたいことなどを記入することをお勧めします
- QQディスカッショングループ [1169188429](https://jq.qq.com/?_wv=1027&k=QZcGcJ9G)（中国語のみ） に参加して、攻略ファイルの作成やその他の問題について私たちと議論することを歓迎します。

### 倉庫アイテム認識（テスト中）

- 自動ジャンプに失敗した場合は、倉庫の `材料` インターフェースに手動で切り替え、**左端にスワイプ**して機能を開始してください。
- 現在の対応データサイトは、 [Arkplanner](https://penguin-stats.io/planner) 、 [アークナイツ ツールボックス](https://arkntools.app/#/material) 、 [ARK-NIGHTS.com](https://ark-nights.com/settings)。
- もしかしたら、後でもっと便利な機能を実行するために使われるかもしれません、多分。
- あなたがデータサイトのウェブマスターであるならば、あなたのサイトの材料JSONプロトコルを適応させるために私達に連絡することも大歓迎です。

## 設定の紹介

Windows MAAには `設定` タブの他に `タスク設定` もあります。 `スタート` のタスクリスト右側の `歯車` をクリックするとスタート内の異なるタスク設定に切り替えることができます〜

`一般設定` `高度な設定` をクリックすると、 `タスク設定` も切り替わるので注意してください~

### カスタム接続

#### adbパスの取得

- [エミュレータの組み込みadb](../../manual/faq.md#adbと接続アドレスが正しいことを確認する) を使用するか、 [adb](https://dl.google.com/android/repository/platform-tools-latest-windows.zip) を自分でダウンロードして解凍します。
- ソフトウェアの `設定` - `接続設定` に進み、`adb.exe`のファイルパスを選択し、adbアドレス（IP +ポートを入力する必要があります。例：`127.0.0.1:5555`）を記入し、エミュレータのタイプを選択します。

#### ポート番号の取得

- 方法1：adbコマンドを使用して実行ポートを直接確認する
  1. **一つの**エミュレータを起動し、このコンピューターに他の Android デバイスが接続されていないことを確認します。
  2. ADB実行可能ファイルが保存されているフォルダ内のコマンドウィンドウを起動します。
  3. 以下のコマンドを実行します：

  ```sh
  # Windows cmd
  adb devices
  # Windows PowerShell
  .\adb devices
  ```

  以下の形式で出力されます：

  ```sh
  List of devices attached
  127.0.0.1:[ADBPORT] device
  ```

  接続アドレスとして `127.0.0.1:[ADBPORT]` を使用します（`[ADBPORT]`を実際の数字に置き換えます）。 `emulator-****` を出力する場合は、方法2を参照してください。

- 方法2: 確立されたADB接続を確認する
  1. 方法1 を実行します。
  2. `Logo Key + S` を押して検索バーを開き、 `Resource Monitor` と入力すると開きます。
  3. `ネットワーク` タブに切り替えて、 `listening port` の `名前` 列でエミュレータ プロセス名 (`HD-Player.exe` など) を探します。
  4. エミュレータ プロセスのすべての `listening port` を記録します。
  5. `TCP connection` の `名前` 列で `adb.exe` を探し、 `remote port` 列のエミュレータの `listening port` と一致するポートがエミュレータのデバッグ ポートです。

### マルチインスタンスでのエミュレータの自動起動

- 複数のエミュレータを同時に操作する必要がある場合は、MAAフォルダを複製し、**別のMAA**、**同じadb.exe**、**異なる接続アドレス**を使用して接続します。
- **[BlueStacks International Version](../../manual/device/windows.md#-完全サポート)を例にして**、2つのマルチインスタンスでのエミュレータ起動方法を紹介します。

#### エミュレータexeにコマンドを付加することによるマルチインスタンスを実行する方法

1. 対応するエミュレーターを単独で起動します。
2. タスクマネージャーを開き、対応するエミュレータープロセスを見つけて、詳細情報タブに移動し、上部の列を右クリックして、「列の選択」をクリックします。
3. 追加された `Command Line` 列から、 `...\Bluestacks_nxt\HD-Player.exe"` の後にある内容を見つけます。
4. `起動設定` - `追加コマンド` に、 `--instance Nougat32` のような見つかった内容を入力します。

::: tip
操作が完了したら、カクつきを防止するために、`ステップ2`で開いた `Command Line` 列を再び非表示にすることをお勧めします。
:::

::: details 示例

```text
複数の起動方法1：
シミュレーターパス：C:\Program Files\BlueStacks_nxt\HD-Player.exe
追加コマンド：--instance Nougat32 --cmd launchApp --package "com.hypergryph.arknights"
複数の起動方法2：
シミュレーターパス：C:\Program Files\BlueStacks_nxt\HD-Player.exe
追加コマンド：--instance Nougat32_1 --cmd launchApp --package "com.hypergryph.arknights.bilibili"
```

`--cmd launchApp --package` 部分は、起動後に特定のパッケージ名を持つアプリケーションを自動実行するためのもので、自由に変更できます。
:::

#### エミュレータやアプリのショートカットを使用することによるマルチインスタンス操作を実行する方法

1. マルチインスタンスマネージャーを開き、対応するエミュレータのショートカットを追加します。
2. エミュレータのショートカットのパスを `起動設定` - `エミュレータパス` に入力します。

::: tip
一部のエミュレータは、アプリのショートカットを作成できます。アプリのショートカットでエミュレータを直接起動してArknightsを開くことができます。
:::

::: details 示例

```text
マルチインスタンス1：
エミュレータのパス：C:\ProgramData\Microsoft\Windows\Start Menu\Programs\BlueStacks\マルチインスタンス1.lnk
マルチインスタンス2：
エミュレータのパス：C:\ProgramData\Microsoft\Windows\Start Menu\Programs\BlueStacks\マルチインスタンス2-Arknights.lnk
```

`エミュレータパス` を使用してマルチインスタンス操作を行う場合、 `起動設定` - `追加コマンド` を空白のままにすることをお勧めします。

### 開始前/終了後のスクリプト

- v4.13.0 以降、開始前/終了後のスクリプトを設定できるようになりました。これにより、タスクの前後にバッチファイルを自動的に実行できます。
- バッチファイルのパスを記入する必要があります。拡張子は `.bat` である必要があります。

## その他の注意事項

- スタート画面の左側のタスクのタグは、ドラッグして順序を変更できます。同様に、設定の基地設定のタグの順番もドラッグで変更可能です。
- スタートと設定画面で変更された構成は通常、自動的に保存されます。`*`番号または`（1回のみ）`が付いたオプションと、チェックボックスを右クリックしたハーフスイッチは、MAAの再起動後にリセットされます。
- すべてのクリック操作は、ボタン内のランダムな位置でのクリックであり、ポアソン分布をシミュレートします（ボタンの中心がクリックされる確率が高く、中心から離れるほどクリックされる確率が小さくなります）。
- 基礎となるアルゴリズムは純粋なC++で開発され、CPUとメモリの使用を最小限に抑えるように複数のキャッシュテクで設計されています。
- アプリは自動更新がサポートされています✿✿ヽ(°▽°)ノ✿、気にならないユーザーはベータ版の使用をお勧めします（更新も速く、バグもほとんどありません）。
- 新しいバージョンの自動ダウンロードが失敗した場合は、OTA パッケージを手動でダウンロードして同じディレクトリに配置すると、自動的に更新されます。
- Windows版では、MAAディレクトリの`config`フォルダにある`gui.json`に設定が記録されているので、新しいフルパッケージをダウンロードしたら、このフォルダを新しいMAAディレクトリにコピーしてください。（コピー後に起動エラーが発生した場合は、`bak`から復元するか、削除してリセットしてみてください）。
