---
order: 3
icon: hugeicons:brain-02
---

# 作戦

## 一般設定

- `理性剤使用数` と `割る源石の数`、および `周回数指定`・`素材の指定` はいずれもショートサーキット的なスイッチ（OR条件）です。これら3つの条件のうちいずれかを満たした時点でタスク達成とみなし、作戦を停止します。
  - `理性剤使用数` は理性を何回分補充するかを指定します（1回で複数本使う場合あり）。
  - `割る源石の数` は源石を何個割るかを指定します（1回につき1個）。倉庫に理性剤がある場合は源石を割りません。
  - `周回数指定` は選択したステージを何回周回するかを指定します（例：「15回周回後に停止」）。
  - `素材の指定`→`ドロップ数` は特定素材を何個入手したら停止するかを指定します（例：「中級源岩を5個入手したら停止」）。

- `素材の指定` と `ステージ` は互いに独立したロジックです。`素材の指定` は素材個数を達成条件に用いるだけで、該当ステージへ自動遷移はしません。
- `割る源石の数` は `理性剤使用数` の後にのみ判定されます。MAA は理性剤がない場合にのみ源石で理性を補充するため、`割る源石の数` にチェックを入れると `理性剤使用数` は 999 に固定され、理性剤を使い切ってからでないと源石を割らないようにします。

::: details 例

| 理性剤使用数 | 割る源石の数 | 周回数指定 | 素材の指定→ドロップ数 | 結果                                                                                                                                                                                   |
| :----------: | :----------: | :--------: | :-------------------: | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|              |              |            |                       | 所持理性を消費し切ったら終了。                                                                                                                                                         |
|      2       |              |            |                       | まず所持理性を使い切り、その後理性剤を1回使用。合計 `2` 回分の補充後、理性を使い切って終了。                                                                                           |
|    _999_     |      2       |            |                       | まず所持理性を使い切り、理性剤を使い切ってから源石を割る。源石は合計 `2` 回。理性を使い切って終了。                                                                                    |
|              |              |     2      |                       | 選択ステージを `2` 回周回して終了。                                                                                                                                                    |
|              |              |            |           2           | ドロップ統計で指定素材を `2` 個入手した時点で終了。                                                                                                                                    |
|      2       |              |     4      |                       | 最大 `2` 回まで理性剤を使用する前提で、選択ステージを `4` 回周回して終了。                                                                                                             |
|      2       |              |            |           4           | 最大 `2` 回まで理性剤を使用する前提で、ドロップ統計で指定素材を `4` 個入手したら終了。                                                                                                 |
|      2       |              |     4      |           8           | 最大 `2` 回まで理性剤を使用する前提で、`4` 回周回したら終了。ただし `4` 回に到達する前に指定素材を `8` 個入手した場合は前倒しで終了。                                                  |
|    _999_     |      4       |     8      |          16           | 理性剤を使い切り、さらに源石を `4` 回割る前提で、`8` 回周回したら終了。ただし `8` 回に到達する前に指定素材を `16` 個入手した場合は前倒しで終了。                                       |
|              |      2       |            |                       | まず所持理性を使い切る。倉庫に理性剤があればそこで終了。理性剤がなければ源石を `2` 回割り、理性を使い切って終了。_MAA GUIの動作ではありません_                                         |
|      2       |      4       |            |                       | まず所持理性を使い切る。`2` 回分の理性剤を使い終えても理性剤が残っていれば終了。`2` 回以内で理性剤が尽きた場合は源石を `4` 回割り、理性を使い切って終了。_MAA GUIの動作ではありません_ |

:::

### ステージ

- ステージに目的の候補がない場合は、MAA で `現在/前回` を選び、ゲーム内で手動で目的ステージへ移動してください。
  画面は、右上にステージ名と残り理性、右下に自動指揮と作戦開始が表示されるステージ詳細に留めてください。
- この画面にいない場合、`現在/前回` は端末ホーム右下の「前回作戦」のステージへ自動で入ります。
- `作戦` → `高度な設定` で `ステージ名を入力する` を有効にし、手動でステージ番号を入力することもできます。現在ナビ可能なステージは以下の通りです：
  - すべてのメインステージ。末尾に `-NORMAL` または `-HARD` を付けて標準／磨難を切り替え可能。
  - 龍門幣・作戦記録の 5 / 6 ステージ。ただし `CE-6` / `LS-6` を入力してください。6 が連戦不可の場合、自動で 5 に切り替えます。
  - アーツ学・購買資格証・炭素材の第 5 ステージ。`CA-5` / `AP-5` / `SK-5` を入力してください。
  - すべてのSoCステージ。`PR-A-1` のように完全な番号を入力してください。
  - 殲滅作戦は以下の入力値に対応し、対応する Value を使用してください：
    - 当期殲滅作戦：Annihilation
    - チェルノボーグ：Chernobog@Annihilation
    - 龍門郊外：LungmenOutskirts@Annihilation
    - 龍門市街：LungmenDowntown@Annihilation

  - サイドストーリー内の `OF-1` / `OF-F3` / `GT-5`。
  - 当期 SS イベントの後半 3 ステージ。自動で [API](https://api.maa.plus/MaaAssistantArknights/api/gui/StageActivity.json) から更新を取得後、画面下部に表示されます。
  - 復刻 SS イベント。`SSReopen-<ステージ接頭辞>` を入力すると、XX-1 ～ XX-9 を一括周回します（例：`SSReopen-IC`）。

::: details サンプル画面
![サンプル画面](/images/ja-jp/combat-start-interface-example.png)
:::

### 殲滅作戦

- MAA は端末ホーム右上の殲滅ボタンからのみ遷移します。選択した殲滅ステージが `完全委任` を解放済みで、`PRTS 殲滅代理カード` を十分に所持していることを確認してください。
- 「400体撃破」を達成済みのステージのみ自動殲滅の使用を推奨します。

## 高度な設定

### 代替ステージ

代替ステージは当日の開放状況に応じて戦闘ステージを決定し、最初に開放されているステージを選びます。
これはスケジュールに近い機能であり、「ステージ選択に失敗したときの予備候補」にはなりません。

1. 例：ステージ選択が `龍門幣-6(CE-6)`、代替が `1-7` と `作戦記録-6(LS-6)` の場合：
   - 当日に `龍門幣-6(CE-6)` が開放されていれば `龍門幣-6(CE-6)` に向かい、`1-7` と `作戦記録-6(LS-6)` には向かいません。この時点で `龍門幣-6(CE-6)` の自動指揮を解放していなければ、作戦タスクはエラーになります。
   - 当日に `龍門幣-6(CE-6)` が開放されていなければ `1-7` に向かい、`龍門幣-6(CE-6)` には向かいません。この時点で `1-7` の自動指揮を解放していなければ、作戦タスクはエラーになります。
   - `作戦記録-6(LS-6)` より前に常設の `1-7` が存在するため、この構成では MAA は `作戦記録-6(LS-6)` には決して向かいません。
2. ステージ選択が `殲滅作戦` の場合：
   - 殲滅の結果にかかわらず、他の代替ステージの選択ロジックには影響しません。殲滅がエラーでも作戦タスクはエラーになりません。
   - 残りの代替ステージは `理性剤使用数` と `連戦回数` の設定のみを継承し、`割る源石の数`・`周回数指定`・`素材の指定` の制御は受けません。

### 余剰理性の消費

`作戦` タスク終了後に起動します。`理性剤使用数`・`割る源石の数`・`周回数指定`・`素材の指定`・`連戦回数` の制御は受けず、現在残っている理性を使い切った時点で終了します。

- `ステージ` の理性不足後に、`余剰理性の消費` 用ステージで残りの“端数”理性を処理する用途に適します（例：1-7 へ行く）。
- 連戦回数の設定が高すぎて理性が不足した場合に、自動で単発周回に切り替えて理性を使い切って締める用途にも適します（例：1-7 を連戦 6 回に設定したが理性が 30 のため、自動的に連戦なしの 1-7 を 5 回に切り替え）。
- 残り理性がなお不足している場合（例：理性は 6 未満）にはタスクを終了します。
- `余剰理性の消費` で選んだステージが未開放の場合、作戦タスクはエラーになります。

### 連戦回数

MAA はユーザーが設定した連戦回数に基づいて戦闘を行います：

- **AUTOモード**（0）：
  - ステージの最大連戦回数を自動認識し、理性が溢れない範囲で最大を維持
  - 完了後は（設定していれば）`余剰理性の消費` フローへ移行

- **数値モード**（1～6）：
  - 設定した回数で連戦を実行
  - 現在の理性で設定回数を満たせない場合（例：5 回分しかないのに 6 回を設定）には、その時点で終了し（設定していれば）`余剰理性の消費` フローへ移行

- **切り替えない**（-1）：
  - ゲーム内の連戦回数設定を変更しません
  - 現在のゲーム内設定回数を満たす理性が不足している場合は、その時点で終了し（設定していれば）`余剰理性の消費` フローへ移行

### 周回数指定

MAA は最大で指定回数まで戦闘を実行します。

例：現在の理性が 100、ステージ消費が 6 の場合

- 周回数指定を 10、連戦回数を 4 に設定：`2（作戦開始回数） × 4（連戦） = 8 回` の作戦を実行（`floor(10 / 4) × 4 連戦 = 8`）。消費理性は `8 × 6 = 48`。さらに 4 連戦を 1 回行うと合計 12 回となり上限 10 を超えるため実行せず、8 回で終了。
- 周回数指定を 10、連戦回数を AUTO に設定：`6 連戦 × floor(10 / 6) + (10 % 6)` となり、`6 連戦 1 回 + 4 連戦 1 回 = 10 回` を実行。消費理性は `10 × 6 = 60`。

### スクショ認識

- 素材ドロップの自動認識と統計に対応。あわせて [ペンギン急便データ統計処理部門](https://penguin-stats.io/) と [ワンシート攻略](https://ark.yituliu.cn/) にアップロードします（**ご注意：「ワンシート攻略」は実質的に簡体字中国語のみのため、翻訳ツールと併用してください**）。
- Penguin-Stats のレポート ID をカスタマイズ可能（`設定` → `実行設定`）。

## 異常検知

- `自動指揮` に自動でチェックを入れます。
- 回線切断や午前4時の瞬断後に自動再接続し、タスクを継続します。
- レベルアップ後もタスクを継続します。
- 自動指揮が失敗した場合はその回の行動を放棄し、再戦します。
