---
order: 4
icon: mingcute:android-fill
---

# 物理的な**Android**デバイス

::: warning
この方法は ADB デバッグを伴い、さらに PC との接続が必要なため、**初心者には非推奨**です。
:::

::: info 注意

1. Android 10 以降、SELinux が `Enforcing` モードの場合、Minitouch は使用できません、別のタッチモードに切り替えてください。または SELinux を **一時的に** `Permissive` モードに切り替え。
2. Androidエコシステムは複雑なため、モードが正常に使用できるようになるまで、MAAの `設定` - `接続設定` で `接続構成` を `一般モード` 、 `互換モード` 、 `2番目の決議` または `一般モード（ブロックされた例外出力）`に変更してみてください。
3. MAAは `16:9` 比率の `720p` 以上の解像度にしか対応していません、ほとんどの近代的なデバイスを含む、`16:9` または `9:16` の画面比率でないデバイスは解像度を強制的に変更する必要があります。接続されているデバイスの画面解像度の比率がネイティブで `16:9` または `9:16`，の場合は、`解像度の変更` セクションをスキップできます。
4. 誤操作を避けるため、デバイスのナビゲーションモードを `クラシックナビゲーションキー` など、 `フルスクリーンジェスチャー` 以外の方法に切り替えてください。
5. エラーを避けるため、ゲーム内設定の `異形スクリーンUI対応` 項目を0に調整してください。

:::

::: tip
典型的な `16:9` 比率の解像度は、 `3840*2160`(4K)、`2560*1440`(2K)、`1920*1080`(1080P)、`1280*720`(720P)などです。
:::

## adbデバッグ・ツールをダウンロードして実行し、デバイスに接続する

1. [adb](https://dl.google.com/android/repository/platform-tools-latest-windows.zip) をダウンロードし、解凍する。
2. 解凍したフォルダを開き、アドレスバーをクリアし`cmd` と入力しエンターキーを押します。
3. ポップアップしたコマンドプロンプトウィンドウに`adb`と入力し、英語のヘルプテキストがたくさん表示されれば、実行は成功です。
4. Googleで `<モデル> + USBデバッグを有効にする` を検索し、お使いの携帯電話で `USBデバッグ` を有効にします。一部のメーカーでは、MIUIの `USBインストール` や `USBデバッグ（セキュリティ設定）` など、USBデバッグに関する追加オプションを提供する場合があります。同時にオンにしてください。
5. デバイスをコンピューターに接続し、先ほどのコマンドプロンプトウィンドウで以下のコマンドを入力します。

   ```bash
   adb devices
   ```

- 実行に成功すると `USB デバッグ` デバイスが接続されたというメッセージが表示される。
  - 成功した接続例：

    ```bash
    List of devices attached
    VFNDU1682100xxxx        device
    ```

  - **`device` の前の英数字の組み合わせはデバイスのシリアル番号で、MAAの `接続アドレス` としても機能します。**

- `USBデバッグ` のための最新のAndroidデバイスは、ポップアップウィンドウの認証でデバッグデバイスをクリックする必要があります：

  ```bash
  List of devices attached
  VFNDU1682100xxxx        unauthorized
  ```

- 未承認のプロンプトが表示されたり、デバイスのシリアル番号が`offline`と表示された場合は、デバイスとコンピュータを再起動してもう一度試してください。 それでも問題が解決しない場合は、現在のユーザーの個人フォルダの下にある`.android` フォルダを削除し、再起動後に再試行することができます。

## 解像度の変更

::: tip
デバイスの画面解像度は `短辺*長辺` であり、パソコンのモニターの `長辺*短辺` ではありません。 正確な解像度は、ご利用の端末に合わせてご判断ください。
:::

- 上記のデバイスリストにデバイスが1つしかない場合は、以下のコマンドを直接実行して解像度を変更/復元することができます。

  ```bash
  :: 現在の解像度を表示
  adb shell wm size
  :: 解像度をデフォルトに戻す
  adb shell wm size reset

  :: 解像度を 720p に変更
  adb shell wm size 720x1280
  :: 解像度を 1080p に変更
  adb shell wm size 1080x1920
  ```

- 複数のデバイスがある場合は、以下の例のように `adb` と `shell` の間に `-s <対象デバイスのシリアル番号>` というパラメーターを追加する必要があります。

  ```bash
  :: 現在の解像度を表示
  adb -s VFNDU1682100xxxx shell wm size
  :: 解像度をデフォルトに戻す
  adb -s VFNDU1682100xxxx shell wm size reset

  :: 解像度を 720p に変更
  adb -s VFNDU1682100xxxx shell wm size 720x1280
  :: 解像度を 1080p に変更
  adb -s VFNDU1682100xxxx shell wm size 1080x1920
  ```

- 一部の不規則なデザインのアプリケーションでは、解像度を元に戻した後もコンテンツのレイアウトが正しくない場合がありますが、該当するアプリケーションまたはデバイスを再起動することで解決できます。

::: danger 注意
この作業を行う前に**必ずデバイスを再起動し**解像度を元に戻さないと、デバイスによっては予期せぬ結果を招く可能性があります ~~，レイアウトミス、アプリ点滅、起動の失敗などをありえるが、それだけじゃないかも~~
:::

::: danger 警告

`アカウント切り替え`機能は、一部の実際のデバイスでは正常に動作しないことが報告されています。MAAは主にPCエミュレーター環境で動作するため、この問題を修正する予定はありません。

この問題が発生した場合は、以下のいずれかの方法で画面密度（DPI）を変更できます（推奨値範囲： `[100-800]`）：

- コマンド `adb shell wm density <DPI>` を使用して直接DPIを変更する
- `開発者向けオプション → 最小幅` を調整して、`最小幅` を変更することで間接的にDPIを変更する

  注意：`DPI` と `最小幅` は逆比例の関係にあり、変換式は以下の通りです：`最小幅 = 画面幅(px) / (DPI / 160)`

**この操作にはリスクが伴い、デバイスが正常に動作しなくなる可能性があります。操作内容を十分に理解したうえで行ってください。デバイスの故障については自己責任となります。**

次回デバイス再起動前に、これらの変更を元に戻すことを強く推奨します。デフォルト値を忘れた場合でも、どの方法で変更したかに関わらず、コマンド `adb shell wm density reset` を使用すれば元に戻すことができます。

:::

## 解像度の自動変更

1. MAAディレクトリに2つの新しいテキストファイルを作成し、以下の内容で埋めてください。

   ```bash
   :: 解像度を 1080p に調整する
   adb -s <ターゲット・デバイスのシリアル番号> shell wm size 1080x1920
   :: 画面の輝度を下げる（オプション）
   adb -s <ターゲット・デバイスのシリアル番号> shell settings put system screen_brightness 1
   ```

   ```bash
   :: 解像度の復元
   adb -s <ターゲット・デバイスのシリアル番号>> shell wm size reset
   :: 画面の明るさを上げる（オプション）
    adb -s <ターゲット・デバイスのシリアル番号> shell settings put system screen_brightness 20
    :: ホームに戻る（オプション）
    adb -s <ターゲット・デバイスのシリアル番号> shell input keyevent 3
    :: ロック画面（オプション）
    adb -s <ターゲット・デバイスのシリアル番号> shell input keyevent 26
   ```

2. 最初のファイルを `startup.bat` に、2番目のファイルを `finish.bat` にリネームする。
   - リネーム後、拡張子を変更するための2回目の確認ダイアログボックスが表示されず、ファイルアイコンも変更されない場合は、“Windowsでファイルの拡張子を表示する方法“をご自身で検索してください。

3. MAA の `設定` - `接続設定` - `スクリプトを使用して始めます` と `終了時にスクリプトを使用します` にそれぞれ `startup.bat` と `finish.bat` を記入してください。

## MAAとの接続

### 有線接続

::: tip
有線接続を使用する場合、IPアドレスやポートは必要なく、 `adb devices` で指定されたデバイスのシリアル番号のみが必要です。
:::

1. MAAの `設定` - `接続設定` - `接続先アドレス` に上記で取得したターゲットデバイスのシリアル番号を入力します。
2. Link Start!

### ワイヤレス接続

- デバイスとパソコンが同じLAN環境にあり、相互に通信できることを確認してください。 `隔離 AP` 、 `ゲストネットワーク` などの設定は、機器間の通信を妨げることがありますので、対応するルーターのマニュアルを参照してください。
- ワイヤレスデバッグは、デバイスの再起動後に無効になり、再度設定する必要があります。

#### `adb tcpip` を使用してワイヤレスポートをオンにします

1. 先ほど開いたコマンドプロンプトウィンドウに以下のコマンドを入力し、ワイヤレスデバッグを有効にします。

   ```bash
   adb tcpip 5555
   :: 複数のデバイスがある場合、上記のようにadbとtcpipの間にパラメータを追加することができます
   ```

2. デバイスのIPアドレスを表示します。
   - デバイスの `設定` - `WLAN` を開き、現在接続されているワイヤレスネットワークをタップしてIPアドレスを表示します。
   - セッティング位置は各機器ブランドによって異なるので、各自で確認してほしい。

3. `<IP>:5555` を MAAの `設定` - `接続設定` - `接続先アドレス` に入力してください。例 `192.168.1.2:5555`。
4. Link Start!

#### `adb pair` を使用してワイヤレスポートをオンにします

::: tip
`adb pair` ワイヤレス ペアリング、つまり Android 11 以降の開発者向けオプションで `ワイヤレスデバッグ` を使用すると、 `adb tcpip` と比較して有線接続が不要になります。
:::

1. デバイスの開発者向けオプションに移動し、 `ワイヤレスデバッグ` をクリックしてオンにし、OKをクリックして、 `ペアリングコードでデバイスをペアリング` をクリックして、ペアリングが完了するまで表示されるポップアップウィンドウを閉じないでください。

2. ペアリングします。
   1. コマンドプロンプトウィンドウに `adb pair <デバイスのポップアップで指定されたIPアドレスとポート>` 、Enter キーを押します。
   2. `<デバイスのポップアップウィンドウに表示される6桁のペアリングコード>` と入力し、Enter キーを押します。
   3. ウィンドウに `Successfully paired to <IP:ポート>` と表示され、デバイスのポップアップウィンドウが自動的に消え、ペアリングされたデバイスの下部にコンピューター名が表示されます。

3. 現在のデバイス画面に表示される `<IP アドレスとポート>` を MAAの `設定` - `接続設定` - `接続アドレス` に入力します（ `192.168.1.2:11451` など）、**さっき記入したものとは違うに違いない**。
4. Link Start!

#### ルート権限でワイヤレスポートをオンにします

~~ルート権限を使用できますが、このドキュメントを読む必要がありますか~~

1. [WADB](https://github.com/RikkaApps/WADB/releases) をダウンロードしてインストールし、ルート化します。
2. WADBを起動して、ワイヤレスadbを起動します。
3. WADBから提供された `<IP アドレスとポート>` を MAAの `設定` - `接続設定` - `接続アドレス` に入力します（ `192.168.1.2:5555` など）。
4. Link Start!
