---
order: 5
icon: ri:earth-fill
---

# グローバル版を含む海外クライアントの対応について

## 準備

このチュートリアルを始める前に、以下の内容を確認してください。

1. 必要なソフトウェアをインストールし、正しく設定されていること。大陸版クライアントまたは海外版クライアントの `readme.md` に、サポートされている機能が正しく動作するための情報があるはずです。
2. [タスクAPI](../protocol/task-schema.md) を読み、各フィールドの意味と使い方の基本を理解していること。また、コード中の `@` と `#` の意味と使い方を理解しておくこと。
3. 大陸版クライアントの `task.json` ファイルとテンプレート画像が海外クライアントに記載されていない、または不足している場合、代替手段として使用されることを理解していること。海外クライアントの `task.json` の内容は、大陸版のタスクのフィールドに合わせて書き換える必要があります。
4. ある程度の英語力があり、英語のログを読むことができ、ログから不足している画像やその他の情報を見つけることができること。
5. タスクチェーンに従って、個別に修正を行うことが推奨されることを理解していること。例えば、Awardタスクを修正する場合、`template image`, `text`, `roi` をその `next` フィールドの順序に従って段階的に修正する必要があります。こうすることで、すべてのタスクが修正後に正常に動作することを確認し、エラーを簡単に発見することができます。また、一度に多くのコンテンツを修正した場合に、どのタスクで止まっているのか忘れてしまうといった混乱も防ぐことができます。

### 変更前の準備

変更する前に、下記の注意すべきことあります。

1. 大陸版クライアントの `task.json` を参照し、海外クライアント用のテンプレート画像とテキストコンテンツが用意されていることを確認します。
2. これらの画像やテキストコンテンツにすぐにアクセスできるようにしておく。

## スクリーンショットを取得

高品質のスクリーンショットを得るためには、以下のガイドラインに従ってください。

1. エミュレータに付属のスクリーンショットツールを使って、スクリーンショットを撮影し保存します。
2. スクリーンショットのサイズが `1280*720` 以上、アスペクト比が `16:9` であることを確認する。
3. スクリーンショットにタスクバー、ステータスバー、通知バーなどの余計なコンテンツが含まれていないことを確認する。
4. スクリーンショットに、認識される必要があるすべてのコンテンツが含まれていることを確認します。

画像を切り出して、テキストや画像の関心領域（ROI）を得るためには、`MaaAssistantArknights/tools/ImageCropper` ツールを使用する必要があります。

**ImageCropper** は、事前に準備したスクリーンショットや ADB 接続されたデバイスから、ROI 領域の切り取り、保存、カラーピッキング操作をサポートする強力なスクリーンショットツールです。

### 環境設定

`Python` 環境が必要で、推奨バージョンは `3.11`、最小バージョンは `3.9` 以上です。

### 依存関係のインストール

Windows ユーザーは `install.bat` を直接実行することをお勧めします。または手動でインストール：

```shell
python -m pip install -r requirements.txt
```

### 使用手順

1. 事前に準備したスクリーンショットがある場合は、`./src/` ディレクトリに保存します
2. `start.bat` または `python main.py [device serial]` を実行します（デバイスアドレスはオプション）
   - ツールは接続された ADB デバイスを自動的に検索し、プロンプトに従ってデバイスを選択します（ENTER を押してスキップ）
   - `python main.py [device serial]` で直接特定のデバイスに接続することもできます
3. ポップアップウィンドウで、左クリックで対象範囲を選択し、スクロールホイールでズーム、右クリックで画像を移動します
4. キーボードショートカットを使用：
   - `S` または `ENTER` を押して対象範囲を保存
   - `F` を押してフルスクリーン標準化スクリーンショットを保存
   - `R` を押して ROI 範囲のみを出力（保存しない）
   - `C` を押して ROI 範囲と ColorMatch フィールドを出力（保存しない）
   - `Z`、`DELETE`、または `BACKSPACE` を押して元に戻す
   - `0` ~ `9` を押してウィンドウをズーム
   - `Q` または `ESC` を押して終了
   - その他のキーを押して現在のスクリーンショットをスキップ/更新
5. 対象範囲のスクリーンショットは `./dst/` ディレクトリに保存されます

例えば、切り取られた後の出力は次のようになる。

```log
src: Screenshot_xxx.png
dst: Screenshot_xxx.png_426,272,177,201.png
original roi: 476, 322, 77, 101,
amplified roi: 426, 272, 177, 201
```

この例では、`Screenshot_xxx.png` が `src` フォルダに置かれたフルスクリーンショットの名前、`Screenshot_xxx.png_426,272,177,201.png` が切り出した画像の名前になります。

`original roi` はマウスで選択された領域で、`amplified roi`は拡大された領域である。拡大された領域が必要なので、task.json の roi フィールドに記入する際には `amplified roi` の値を使用する必要がある。

## テンプレート画像の修正

テンプレート画像を修正する前に、該当するクライアントのテンプレート画像フォルダと大陸版クライアントのテンプレート画像フォルダを開いておく必要があります。

例

- ENクライアントのテンプレートイメージフォルダの場所は `MaaAssistantArknights\resource\global\YoStarEN\resource\template`.
- 大陸版クライアントのテンプレートイメージフォルダの場所は `MaaAssistantArknights\resource\template`.

task.json`ファイルに記載されているテンプレート画像を参照し、大陸版クライアントと海外クライアントのテンプレート画像を比較し、海外クライアントに不足しているテンプレートを特定します。

一般的に、テキストを含むテンプレート画像は、ロゴなどの画像を除いて、スクリーンショットに置き換える必要があります。もし、画像のサイズが大陸版クライアントの対応するテンプレート画像よりも著しく大きい場合は、`roi`のサイズを修正する必要があるかもしれません。

テンプレート画像を取り込み、名前を変更したら、対応するクライアントのテンプレート画像フォルダに配置することができます。

## テキストの内容を変更する

テキスト内容を修正する前に、対応するサーバと大陸版クライアントの両方で `task.json` ファイルを開く必要があります。

例

- ENクライアントの `task.json` の場所は `MaaAssistantArknights\resource\global\YoStarEN\resource\tasks.json`.
- 大陸版クライアントの `task.json` の場所は `MaaAssistantArknights\resource\tasks.json`.

テキストを変更するには、対応するタスクを探し、`text`フィールドを対応するサーバーに表示されている内容に変更します。特定された内容は、ゲーム内の完全な内容の部分文字列である可能性があることに留意してください。一般的には、純粋なASCII文字として認識されない限り、テキストを含む`text`はすべて置き換える必要があります。

もし、テキストの長さが大陸版クライアントバージョンよりかなり長い場合、`roi`フィールドのサイズを修正する必要があるかもしれません。例えば、`"任务"`(中国語の任務)と英語の`"Mission"`の長さの差が大きすぎる場合、海外のクライアントではミッションの`roi`サイズを修正する必要があるかもしれません。

該当する海外サーバーの `task.json` ファイルにタスクが存在しない場合は、追加する必要があります。`text` フィールドに適切な内容を入力するだけです。

## ROIの範囲を変更する

ROIの範囲を変更するには

1. 対応するサーバーの `task.json` ファイルを開く。例えば、ENクライアントの `task.json` ファイルの場所は `MaaAssistantArknights\resource\global\YoStarEN\resource\tasks.json`。
2. 修正したいROI範囲に対応するタスクを探し、該当クライアントのスクリーンショットを使用して、増幅されたROIに応じて`roi`範囲のサイズを調整する。
3. 通常、`roi`の範囲を修正する必要はありませんが、テキストと大陸版のサイズの差が大きすぎる場合、修正する必要があるかもしれません。
4. 対応する海外クライアントの `task.json` ファイルにタスクが存在しない場合、タスクを追加し、 `roi` フィールドに適切な値を書き込みます。

## 設定を保存して、ソフトウェアを再起動する

変更を行った後、設定を保存し、変更を有効にするためにソフトウェアを再起動する必要があります。これを行うには、ソフトウェアを再起動してファイルを再読み込みするか、ソフトウェアディレクトリに新しい `DEBUG.txt` ファイルを作成します。これにより、"Link Start "ボタンをクリックするたびにテンプレートとファイルが再読み込みされますので、ソフトウェアを再起動する必要はありません。

成功を見届けるためには

1. 海外サーバーでソフトウェアが正常に動作することを確認するための動作確認。
2. 正常に動作しない場合は、変更内容が正しいか、ログ出力を確認し、何が問題だったかを判断する必要があります。

## ログの解析

もし、`task.json`ファイルを修正しても、プログラムが正しく機能しない場合、ログをチェックしてエラーを見つけ、それに応じて対応するタスクを修正することが有効な場合があります。ログファイルは通常、ソフトウェアのルートディレクトリにあり、`asst.log`という名前になっています。MAAを自分でコンパイルした場合は、コンパイル時に選択したコンパイルモードに応じて、 `x64Release` または `x64RelWithDebInfo` ディレクトリに配置されるかもしれません。

ログを解析することは、プログラムに関する問題を特定するのに役立ちます。以下はログの例

```log
[2022-12-18 17:43:17.535][INF][Px7ec][Tx15c8] {"taskchain":"Award","details":{"to_be_recognized":["Award@ReturnTo","Award","ReceiveAward","DailyTask","WeeklyTask","Award@CloseAnno","Award@CloseAnnoTexas","Award@TodaysSupplies","Award@FromStageSN"],"cur_retry":10,"retry_times":20},"first":["AwardBegin"],"taskid":2,"class":"asst::ProcessTask","subtask":"ProcessTask","pre_task":"AwardBegin"}
[2022-12-18 17:43:18.398][INF][Px7ec][Tx15c8] Call ` C:\Program Files\BlueStacks_nxt\. \HD-Adb.exe -s 127.0.0.1:5555 exec-out "screencap | gzip -1" ` ret 0 , cost 862 ms , stdout size: 2074904 , socket size: 0
[2022-12-18 17:43:18.541][TRC][Px7ec][Tx15c8] OcrPack::recognize | roi: [ 500, 50, 300, 150 ]
[2022-12-18 17:43:18.541][TRC][Px7ec][Tx15c8] Ocr Pipeline with asst::WordOcr | enter
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] Ocr Pipeline with asst::WordOcr | leave, 93 ms
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] OcrPack::recognize | raw: [{ : [ 0, 0, 300, 150 ], score: 0.000000 }]
[2022-12-18 17:43:18.634][TRC][Px7ec][Tx15c8] OcrPack::recognize | proc: []
[2022-12-18 17:43:18.637][TRC][Px7ec][Tx15c8] asst::ProcessTask::_run | leave, 1101 ms
[2022-12-18 17:43:18.638][TRC][Px7ec][Tx15c8] ready to sleep 500
[2022-12-18 17:43:19.144][TRC][Px7ec][Tx15c8] end of sleep 500
[2022-12-18 17:43:19.144][TRC][Px7ec][Tx15c8] asst::ProcessTask::_run | enter
```

このログでは、以下のことがわかります。

- `"taskchain"` は現在進行中のタスクを表します。
- `"details"`はタスクの内容であり、認識すべきフィールド (`to_be_recognized`) と現在のリトライ回数 (`cur_retry`) とリトライ回数の合計 (`retry_times`) を含みます。
- `"first"` はタスクの開始を表す。
- `"taskid"` はタスク番号です。
- `"class"` と `subtask` はそれぞれ、タスクのクラスとサブタスクを表す。
- `"pre_task"` は一つ前のタスクを表す。

さらに、コマンドの実行結果 (例: `Call`) と `OCR` の情報 (例: `OcrPack::recognize`) がログに記録されます。

例えば、このログの `"to_be_recognized"`,`"cur_retry":3, "retry_times":20` は、タスクの認識を10回試行し、最大回数は20回であることを意味しています。最大回数に達すると、そのタスクはスキップされ、エラーが報告され、次のタスクが実行されます。前のタスクで問題がない場合、ここで認識に問題がある可能性があります。この問題をトラブルシューティングするには、ログに記載されているタスクに対応するテンプレートファイルがあるか、対応するタスクの `text` フィールドが正しくないか、タスク認識のための `roi` 範囲が正しくないかを確認し、必要な修正を加えてください。

対応するテンプレート画像を見ると、ENクライアントのテンプレートフォルダにこの画像のテンプレートがありますが、サイズが 大陸版クライアントのテンプレートフォルダの画像より大きいことがあります . この場合、大陸版クライアントの `roi` がENクライアントで認識されない可能性があるので、ENクライアントの `task.json` ファイル内の対応するタスクの `roi` を、ENクライアントの画像サイズに合わせて修正する必要があるかもしれません。

## 変更を送信する

[Github Pull Requst ガイド](../develop/development.md#github-pull-request-プロセス概要)を参照してください。
