---
order: 7
icon: devicon-plain:githubactions
---

# CI システム解析

MAA は Github Action を活用して、ウェブサイトの構築、自動リソース更新、最終ファイルの構築とリリースなど、大量の自動化作業を完了しました。時間の経過とともに、これらの CI は徐々にネスト化し始め、一部は他のリポジトリにリンクされています。このドキュメントは、MAA の CI システムを改善したい人のために簡単な紹介を提供することを目的としています。

このドキュメントを読む前に、MAA のプロジェクト構造と構成について基本的な概念を持っていることが推奨されます。

::: tip
このページ内で CI ファイル名を検索することで、見たい部分に素早く移動できます
:::

ワークフローファイルはすべて `.github/workflows` の下に保存されており、各ファイルは機能ごとに以下の部分に分けることができます：

- [コードテスト](#コードテスト)
- [コード構築](#コード構築)
- [コードセキュリティスキャン](#コードセキュリティスキャン)
- [バージョンリリース](#バージョンリリース)
- [リソース更新](#リソース更新)
- [ウェブサイト構築](#ウェブサイト構築)
- [Issues 管理](#issues-管理)
- [Pull Requests 管理](#pull-requests-管理)
- [MirrorChyan 関連](#mirrorchyan-関連)
- [その他](#その他)

さらに、[pre-commit.ci](https://pre-commit.ci/) を通じてコードの自動フォーマットと画像リソースの自動最適化を実現しており、PR を作成した後に自動的に実行されるため、通常は特に注意する必要はありません。

## Github Action 部分

### コードテスト

`smoke-testing.yml`

このワークフローは主に MaaCore の基本的な検出を担当し、リソースファイルのロード、一部の簡単なタスクの実行テストなどが含まれます。

テストケースが長い間更新されていないため、このワークフローは現在、リソースファイルにエラーが発生しないこと、および MaaCore のコードにビルドに影響する致命的なエラーが発生しないことを保証するためのものです。

### コード構築

`ci.yml`

このワークフローは、コードの完全なビルド作業を担当し、MAA のすべてのコンポーネントを含み、ビルド成果物は実行可能な MAA です。

必要な MaaCore に加えて、Windows ビルド成果物には MaaWpfGui が含まれ、MacOS ビルド成果物には MaaMacGui が含まれ、Linux ビルド成果物には MaaCLI が含まれます。

このワークフローは、新しい Commit や PR が発生したときに自動的に実行され、リリース PR によってトリガーされた場合、このビルド成果物は直接リリースに使用され、Release が作成されます。

### コードセキュリティスキャン

コードセキュリティスキャンは CodeQL を使用してコードとワークフローのセキュリティ分析を行い、以下のワークフローがあります：

`codeql-core.yml`

このワークフローは MaaCore と MaaWpfGui の C++ および C# コードのセキュリティ分析を担当し、潜在的なセキュリティ脆弱性を検出します。

このワークフローは関連するソースコードを変更する PR で自動的に実行され、また毎日 UTC 時間 11:45 に定期チェックが実行されます。

`codeql-wf.yml`

このワークフローは GitHub Actions ワークフローファイル自体のセキュリティ分析を担当し、CI/CD プロセスのセキュリティを確保します。

このワークフローはワークフローファイルを変更する PR で自動的に実行され、また毎日 UTC 時間 12:00 に定期チェックが実行されます。

### バージョンリリース

バージョンリリース、略してリリースは、ユーザーに更新を公開するために必要な操作で、以下のワークフローで構成されます：

- `release-nightly-ota.yml` 内部テスト版のリリース
- `release-ota.yml` 正式版/公測版のリリース
  - `release-preparation.yml` 正式版/公測版の changelog の生成とリリース準備
  - `pr-auto-tag.yml` 正式版/公測版の tag を生成

::: tip
上記のファイル名内の ota は Over-the-Air を意味し、我々がよく言う「増分更新パッケージ」です。したがって、MAA のリリースプロセスには、実際には過去のバージョンに対して OTA パッケージを構築するステップが含まれています。
:::

#### 内部テスト版

`release-nightly-ota.yml`

このワークフローは、毎日 UTC 時間 22 時に自動的に実行され、内部テスト版のリリース頻度を保証します。もちろん、変更を加えて検証する必要があるときは手動でリリースすることもできます。

注意すべき点は、内部テスト版のリリースは Windows ユーザーのみを対象としており、MacOS と Linux ユーザーは内部テスト更新を受信できません。

#### 正式版/公測版

これら 2 つのチャネルのリリースプロセスは比較的複雑です。リリース手順をシミュレートして、各ワークフローの役割を説明します：

1. `dev` から `master` ブランチへの pr を作成し、この pr の名前は `Release v******` である必要があります
2. `release-preparation.yml` が最近の正式版/公測版から現在のバージョンまでの changelog を生成します（新しい pr の形式で）
3. changelog を手動で調整し、簡単な説明を追加します
4. pr をマージし、`pr-auto-tag.yml` をトリガーして、tag を作成し、ブランチを同期します
5. Release イベントが `release-ota.yml` をトリガーし、master に tag を付けた後、ota パッケージの構築と添付ファイルのアップロードを実行します

### リソース更新

この部分のワークフローは主に MAA のリソース更新と最適化を担当し、具体的なワークフローは以下の通りです：

- `res-update-game.yml` 定期的に実行し、指定されたリポジトリからゲームリソースを取得します
- `sync-resource.yml` リソースを MaaResource リポジトリに同期し、リソース更新に使用します
- `optimize-templates.yml` テンプレート画像を含む画像のサイズを最適化します

### ウェブサイト構築

`website-workflow.yml`

このワークフローは主に MAA ドキュメントサイトの構築と公開を担当します。

ウェブサイトの公開はリリースと強く結びついていることに注意してください。通常、ウェブページコンポーネントを変更するときは、エラーがないことを確認するためにビルドのみが行われ、リリース時にのみ GitHub Pages に正式にデプロイされます。

### Issues 管理

`issue-checker.yml`

正規表現マッチングを通じて各 Issue に Tag を付け、Issue の内容を分類してマークし、閲覧と管理を容易にします。

`issue-checkbox-checker.yml`

正規表現マッチングを通じて「私は注意深く読んでいません」をチェックした Issue を自動的に閉じます。「私は注意深く読んでいません」がチェックされていない場合は、すべてのチェックボックスを折りたたみます。

`stale.yml`

90 日以上活動のない Bug Issue をチェックし、マークして通知を送信し、7 日後もまだ活動がない場合は閉じます。

### Pull Requests 管理

`pr-checker.yml`

このワークフローは、PR の Commit Message が [Conventional Commits](https://www.conventionalcommits.org/ja/v1.0.0/) に準拠しているか、および Merge Commit が含まれているかどうかをチェックし、上記の条件が満たされている場合は警告を出します。

### MirrorChyan 関連

MirrorChyan は有料の更新ミラーサービスで、関連するワークフローは以下の通りです：

- `release-package-distribution.yml` 更新パッケージを MirrorChyan に同期します
- `mirrorchyan_release_note.yml` MirrorChyan の Release Note を生成します

### その他

`markdown-checker.yml`

リポジトリ内のすべての Markdown ファイルに無効なリンクが含まれているかどうかをチェックします。

`blame-ignore.yml`

Commit Message に `blame ignore` が含まれているコミットを自動的に無視し、リポジトリの履歴をクリーンに保ちます。

`cache-delete.yml`

PR マージ後に関連するキャッシュをクリーンアップして、キャッシュの使用量を節約します。

`update-submodules.yml`

MaaMacGui や maa-cli などのサブモジュールを定期的に最新バージョンに更新します。このワークフローは毎日 UTC 時間 21:50 に自動的に実行され（毎日の内部テストリリースの前）、サブモジュールが最新の状態を保つことを確保します。
