---
order: 8
icon: mdi:remote-desktop
---

# Remote Control Schema

To implement remote control of MAA, you need to provide a service that must be an HTTP(S) service and offer the following two anonymously accessible endpoints. These endpoints must be HTTP(S) web endpoints.

::: warning
If the endpoint uses HTTP protocol, MAA will issue a security warning with each connection. **Deploying plaintext transmission services on public internet is highly discouraged and dangerous, for testing purposes only.**
:::

::: tip
Please note that JSON files do not support comments. The comments in this document are for demonstration purposes only. Do not copy them directly.
:::

## Task Retrieval Endpoint

MAA continuously polls this endpoint at 1-second intervals, attempting to retrieve tasks to execute and executing them in the order received.

The endpoint path is arbitrary but must be an HTTP(S) endpoint. For example: `https://your-control-host.net/maa/getTask`

The controlled MAA must enter this endpoint in the `Task Retrieval Endpoint` text box in MAA's configuration.

This endpoint must accept a POST request with `Content-Type=application/json` and must accept the following JSON as request content:

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // User identifier entered in MAA settings
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec"         // Device identifier automatically generated by MAA
    ...     // If your endpoint has other uses, you can add optional parameters, but MAA only transmits user and device
}
```

This endpoint must return a JSON-formatted response that meets at least the following format:

```json
{
    "tasks":                            // List of tasks for MAA to execute, currently supported types shown in example, if tasks doesn't exist connection is considered invalid
    [
        // Sequential execution tasks: these tasks are queued for execution in the order issued
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "CaptureImage",                         // Screenshot task, captures current emulator screen and includes as Base64 string in task report payload. If issuing this task type, note your endpoint's maximum request size limit, as screenshots can be tens of MB, exceeding typical gateway defaults
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   // Unique task ID, string type, used when reporting task status
            "type": "LinkStart",                            // Start one-click farming
        },
        {
            "id": "15be4725-5bd3-443d-8ae3-0a5ae789254c",   // Unique task ID, string type, used when reporting task status
            "type": "LinkStart-Recruiting",                 // Immediately execute specific one-click farming sub-function based on current configuration, ignoring main interface checkbox. Optional values detailed below
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "Toolbox-GachaOnce",                    // Toolbox gacha task, optional values: Toolbox-GachaOnce, Toolbox-GachaTenTimes
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "Settings-ConnectionAddress",           // Configuration modification task, equivalent to ConfigurationHelper.SetValue("ConnectionAddress", params); For security, not all settings can be modified, see below for allowed settings
            "params": "value"                               // Value to modify
        },
        // Immediate execution tasks: these tasks can execute during sequential tasks and MAA guarantees any of these will return results quickly, typically used for controlling the remote control function itself
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "CaptureImageNow",                      // Immediate screenshot task, similar to screenshot task above but executes immediately without waiting for other tasks
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "StopTask",                             // "Stop current task" task, attempts to end currently running task. If task list contains other tasks, continues with next task. This task doesn't wait to confirm current task has stopped before returning, use heartbeat task to confirm stop command effectiveness
        },
        {
            "id": "b353c469-b902-4357-bd8f-d133199eea31",   // Unique task ID, string type, used when reporting task status
            "type": "HeartBeat",                            // Heartbeat task, returns immediately with currently executing sequential task's ID as payload, or empty string if no task executing
        }
    ],
    ...     // If your endpoint has other uses, you can add optional return values, but MAA only reads tasks
}
```

These tasks execute in sequence, meaning if you first send a recruitment task followed by a screenshot task, the screenshot will execute after the recruitment task completes.
The endpoint should be reentrant and repeatedly return tasks to execute, as MAA automatically tracks task IDs and won't re-execute tasks with the same ID.

::: note

- LinkStart-[TaskName] task types include LinkStart-Base, LinkStart-WakeUp, LinkStart-Combat, LinkStart-Recruiting, LinkStart-Mall, LinkStart-Mission, LinkStart-AutoRoguelike, LinkStart-Reclamation
- Settings-[SettingsName] task types include Settings-ConnectionAddress, Settings-Stage1
- Settings series tasks still execute sequentially rather than immediately, queuing behind previous tasks
- Multiple immediate execution tasks also execute in issued order, though since these tasks execute quickly, their order generally doesn't matter

:::

## Task Reporting Endpoint

When MAA completes a task, it reports the execution result to the remote server through this endpoint.

The endpoint path is arbitrary but must be an HTTP(S) endpoint. For example: `https://your-control-host.net/maa/reportStatus`

The controlled MAA must enter this endpoint in the `Task Reporting Endpoint` text box in MAA's configuration.

This endpoint must accept a POST request with `Content-Type=application/json` and must accept the following JSON as request content:

```json
{
    "user":"ea6c39eb-a45f-4d82-9ecc-33a7bf2ae4dc",          // User identifier entered in MAA settings
    "device":"f7cd9682-3de9-4eef-9137-ec124ea9e9ec",        // Device identifier automatically generated by MAA
    "task":"15be4725-5bd3-443d-8ae3-0a5ae789254c",          // Task ID being reported, corresponding to ID from task retrieval
    "status":"SUCCESS",                                     // Task execution result, SUCCESS or FAILED. Generally returns SUCCESS regardless of task execution success, FAILED only in special cases noted in task descriptions
    "payload":"",                                           // Data included in report, string type. Depends on task type, e.g., screenshot task includes Base64 string of screenshot
    ...     // If your endpoint has other uses, you can add optional parameters, but MAA only transmits user and device
}
```

This endpoint's response content is arbitrary, but if not returning 200 OK, a notification will appear in MAA displaying "Upload failed"

## Example Workflow - Controlling MAA with QQ Bot

Developer A wants to control MAA with their QQ Bot, so they developed a backend exposed on public internet providing two endpoints:

```text
https://myqqbot.com/maa/getTask
https://myqqbot.com/maa/reportStatus
```

For user convenience, their getTask interface returns 200 OK and an empty tasks list regardless of received parameters.
Each time they receive a request, they check the database for duplicate devices, and if none found, record the device and user in the database.
In this workflow, this interface also serves as user registration.

They provide a command on their QQ Bot for users to submit deviceId.

In the QQ Bot's usage instructions, they tell users to enter their QQ number in MAA's `User Identifier` field and send their `Device Identifier` to the Bot via QQ chat.

Upon receiving the identifier, the QQ Bot checks the database for corresponding data based on the message's QQ number, instructing the user to configure MAA if not found.

Since MAA continuously sends requests once configured, if the user has properly configured MAA, matching records should exist in the database when they submit via QQ.

The Bot then marks the database record as verified, so future getTask requests with this device and user combination will return actual task lists.

When users submit commands via QQ Bot, the Bot writes a task to the database, which getTask will return shortly. Additionally, the Bot thoughtfully adds a screenshot task after each user command.

After executing tasks, MAA calls reportStatus to report results, and the Bot sends QQ messages notifying users and displaying screenshots.

## Example Workflow - Controlling MAA with Website

Developer B created a website for batch MAA management with their own user management system. Their backend is publicly accessible with two anonymously accessible endpoints:

```text
https://mywebsite.com/maa/getTask
https://mywebsite.com/maa/reportStatus
```

On the website, a MAA instance connection interface displays what Developer B calls a `User Key` (random string) and has a text box for entering device ID.

The website instructs users to enter their user key in MAA's `User Identifier` field and their `Device Identifier` on the website.

Only after successfully creating a MAA connection on the website will getTask return 200 OK; otherwise it returns 401 Unauthorized.

If users enter incorrect information in MAA and press the test connection button, they'll receive a connection test failure notification.

Users can issue tasks on the website, queue tasks, view screenshots, etc., with implementation similar to the QQ Bot example, using getTask and
