---
order: 3
icon: teenyicons:linux-alt-solid
---

# Linux Emulators and Containers

## Preparation

Choose one of the following installation methods:

### Using maa-cli

[maa-cli](https://github.com/MaaAssistantArknights/maa-cli) is a simple command-line tool for MAA written in Rust. Please read the [CLI User Guide](../cli/) for installation and usage instructions.

### Using Wine

The MAA WPF GUI can currently be run through Wine.

#### Installation Steps

1. Go to the [.NET download page](https://dotnet.microsoft.com/en-us/download/dotnet/8.0) and download/install the Windows version of .NET **Desktop** Runtime.

2. Download the Windows version of MAA, extract it, and run `wine MAA.exe`.

::: info Note
You need to set the ADB path to the [Windows version of `adb.exe`](https://dl.google.com/android/repository/platform-tools-latest-windows.zip) in the connection settings.

If you need to connect to USB devices via ADB, first run `adb start-server` outside of Wine to connect to the native ADB server through Wine.
:::

#### Using Linux Native MaaCore (Experimental)

Download and build the [MAA Wine Bridge](https://github.com/MaaAssistantArknights/MaaAssistantArknights/tree/dev/src/MaaWineBridge) source code, replace the Windows version with the generated `MaaCore.dll` (ELF file), and place the Linux native dynamic libraries (`libMaaCore.so` and dependencies) in the same directory.

When running `MAA.exe` through Wine, it will load the Linux native libraries.

::: info Note
When using the Linux native MaaCore, you need to set the ADB path to the Linux native ADB in the connection settings.
:::

#### Linux Desktop Integration (Experimental)

Desktop integration provides native desktop notification support and maps fontconfig font configurations to WPF.

Place the `MaaDesktopIntegration.so` generated by MAA Wine Bridge in the same directory as `MAA.exe` to enable this feature.

#### Known Issues

- Wine DirectWrite forces hinting and doesn't pass DPI to FreeType, resulting in poor font display.
- When not using native desktop notifications, popup notifications grab the system-wide mouse focus, making it impossible to interact with other windows. You can mitigate this by enabling virtual desktop mode in `winecfg` or disabling desktop notifications.
- Wine-staging users need to disable the `Hide Wine version` option in `winecfg` for MAA to correctly detect the Wine environment.
- Wine's Light theme causes text color issues in WPF. We recommend using no theme (Windows Classic theme) in `winecfg`.
- Wine uses the old XEmbed tray icon system, which may not work properly under GNOME.
- When using Linux native MaaCore, automatic updates are not supported (~~the updater thinks: I should download a Windows version~~)

### Using Python

#### 1. Installing MAA Dynamic Library

1. Download and extract the Linux dynamic library from the [MAA website](https://maa.plus/), or install from a software repository:
   - AUR: [maa-assistant-arknights](https://aur.archlinux.org/packages/maa-assistant-arknights), follow the post-installation instructions
   - Nixpkgs: [maa-assistant-arknights](https://github.com/NixOS/nixpkgs/blob/nixos-unstable/pkgs/by-name/ma/maa-assistant-arknights/package.nix)

2. Navigate to `./MAA-v{version}-linux-{architecture}/Python/` and open the `sample.py` file

::: tip
The precompiled version includes dynamic libraries compiled on relatively new Linux distributions (Ubuntu 22.04). If your system has an older libstdc++ version, you might encounter ABI incompatibility issues.
You can refer to the [Linux Compilation Tutorial](../../develop/linux-tutorial.md) to recompile or use a container solution.
:::

#### 2. ADB Configuration

1. Find the line [`if asst.connect('adb.exe', '127.0.0.1:5554'):`](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/b4fc3528decd6777441a8aca684c22d35d2b2574/src/Python/sample.py#L62)

2. ADB Tool Configuration
   - If using `Android Studio`'s `AVD` emulator, it comes with ADB. You can directly specify the ADB path to replace `adb.exe`, typically found in `$HOME/Android/Sdk/platform-tools/`, for example:

   ```python
   if asst.connect("/home/foo/Android/Sdk/platform-tools/adb", "emulator's ADB address"):
   ```

   - For other emulators, first install ADB: `$ sudo apt install adb`, then either specify the path or simply use `adb` if it's in your `PATH` environment variable.

3. Getting the Emulator's ADB Address
   - Use the ADB tool directly: `$ adb_path devices`, for example:

   ```shell
   $ /home/foo/Android/Sdk/platform-tools/adb devices
   List of devices attached
   emulator-5554 device
   ```

   - The returned `emulator-5554` is the emulator's ADB address. Replace `127.0.0.1:5555` with it, for example:

   ```python
   if asst.connect("/home/foo/Android/Sdk/platform-tools/adb", "emulator-5554"):
   ```

4. Now you can test with `$ python3 sample.py`. If it returns "Connection successful," you're ready to proceed.

#### 3. Task Configuration

Custom tasks: Refer to the [Integration Documentation](../../protocol/integration.md) and modify the [`# Task parameters can be found in docs/integration.md`](https://github.com/MaaAssistantArknights/MaaAssistantArknights/blob/722f0ddd4765715199a5dc90ea1bec2940322344/src/Python/sample.py#L54) section in `sample.py`

## Emulator Support

### ✅ [AVD](https://developer.android.com/studio/run/managing-avds)

Requirements: 16:9 screen resolution larger than 720p

Recommended configuration: x86_64 architecture (R - 30 - x86_64 - Android 11.0) with MAA's Linux x64 dynamic library

Note: Starting from Android 10, Minitouch is no longer available when SELinux is in `Enforcing` mode. Please switch to other touch modes, or **temporarily** switch SELinux to `Permissive` mode.

### ⚠️ [Genymotion](https://www.genymotion.com/)

High Android versions include x86_64 framework. Lightweight but tends to crash when running Arknights.

Not thoroughly tested yet, but ADB functionality and path retrieval work without issues.

## Containerized Android Support

::: tip
The following solutions typically require specific kernel modules. Please install the appropriate modules according to your distribution and the particular solution.
:::

### ✅ [Waydroid](https://waydro.id/)

After installation, you need to reset the resolution (to 16:9 ratio and greater than 720p, then restart):

```shell
waydroid prop set persist.waydroid.width 1280
waydroid prop set persist.waydroid.height 720
```

To set up ADB IP address: Go to `Settings` - `About` - `IP address`, note the first `IP`, and use `${recorded IP}:5555` in `sample.py` for the ADB IP.

If using amdgpu, the `screencap` command might output messages to stderr, causing image decoding failures.
You can run `adb exec-out screencap | xxd | head` and check if there's text like `/vendor/etc/hwdata/amdgpu.ids: No such file...` in the output.
If present, try changing the screenshot command in `resource/config.json` from `adb exec-out screencap` to `adb exec-out 'screencap 2>/dev/null'`.

### ✅ [redroid](https://github.com/remote-android/redroid-doc)

Android 11 version images can run the game normally. Make sure to expose port 5555 for ADB.
