if (BUILD_XCFRAMEWORK)
    add_custom_command(OUTPUT MaaCore.xcframework
        COMMAND rm -rf MaaCore.xcframework
        COMMAND xcodebuild -create-xcframework -library libMaaCore.dylib -headers ${PROJECT_SOURCE_DIR}/include -output MaaCore.xcframework
        DEPENDS MaaCore
    )
    
    add_custom_command(OUTPUT MaaUtils.xcframework
        COMMAND rm -rf MaaUtils.xcframework
        COMMAND xcodebuild -create-xcframework -library libMaaUtils.dylib -output MaaUtils.xcframework
        DEPENDS MaaUtils
    )

    add_custom_command(OUTPUT OpenCV.xcframework
        COMMAND rm -rf OpenCV.xcframework
        COMMAND xcodebuild -create-xcframework -library "${MAADEPS_DIR}/runtime/${MAADEPS_TRIPLET}/libopencv_world4.408.dylib" -output OpenCV.xcframework
    )

    add_custom_command(OUTPUT ONNXRuntime.xcframework
        COMMAND rm -rf ONNXRuntime.xcframework
        COMMAND xcodebuild -create-xcframework -library "${MAADEPS_DIR}/runtime/${MAADEPS_TRIPLET}/libonnxruntime.1.18.0.dylib" -output ONNXRuntime.xcframework
    )

    add_custom_command(OUTPUT fastdeploy_ppocr.xcframework
        COMMAND rm -rf fastdeploy_ppocr.xcframework
        COMMAND xcodebuild -create-xcframework -library "${MAADEPS_DIR}/runtime/${MAADEPS_TRIPLET}/libfastdeploy_ppocr.dylib" -output fastdeploy_ppocr.xcframework
    )

    add_custom_target(MaaXCFramework ALL
        DEPENDS MaaCore MaaCore.xcframework MaaUtils MaaUtils.xcframework OpenCV.xcframework ONNXRuntime.xcframework fastdeploy_ppocr.xcframework
    )
endif (BUILD_XCFRAMEWORK)

