#!/usr/bin/env bash
# Tags: long, no-random-settings, no-parallel, no-distributed-cache

CUR_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
# shellcheck source=../shell_config.sh
. "$CUR_DIR"/../shell_config.sh


$CLICKHOUSE_CLIENT -q """
create table t1(a UInt32) engine=MergeTree order by tuple() partition by a % 4 settings index_granularity = 8192, index_granularity_bytes = 10485760;

insert into t1 select number from numbers_mt(5e5);

optimize table t1 final;
"""

for _ in {1..100}; do
  ($CLICKHOUSE_CURL -sS "${CLICKHOUSE_URL}" -d """
    SELECT count()
    FROM
    (
        SELECT throwIf(countDistinct(a) != 2)
        FROM remote('127.0.0.{1,2}', currentDatabase(), t1)
        GROUP BY a
    )
    SETTINGS min_compress_block_size = 1359661, max_compress_block_size = 285547, max_block_size = 29402, min_external_table_block_size_bytes = 0, max_joined_block_size_rows = 13060, max_insert_threads = 3, max_threads = 8, max_parsing_threads = 1, max_read_buffer_size = 824114, connect_timeout_with_failover_ms = 2000, connect_timeout_with_failover_secure_ms = 3000, use_hedged_requests = false, idle_connection_timeout = 36000, s3_max_get_rps = 1000000, s3_max_get_burst = 2000000, s3_max_put_rps = 1000000, s3_max_put_burst = 2000000, s3_check_objects_after_upload = true, use_uncompressed_cache = true, max_remote_read_network_bandwidth = 1000000000000, max_remote_write_network_bandwidth = 1000000000000, max_local_read_bandwidth = 1000000000000, max_local_write_bandwidth = 1000000000000, stream_like_engine_allow_direct_select = true, enable_multiple_prewhere_read_steps = false, replication_wait_for_inactive_replica_timeout = 30, load_balancing = 'random', compile_expressions = false, compile_aggregate_expressions = false, min_count_to_compile_aggregate_expression = 0, group_by_two_level_threshold = 576680, group_by_two_level_threshold_bytes = 11919407, distributed_aggregation_memory_efficient = false, allow_nonconst_timezone_arguments = true, input_format_parallel_parsing = false, min_chunk_bytes_for_parallel_parsing = 3696781, merge_tree_coarse_index_granularity = 6, min_bytes_to_use_direct_io = 10737418240, min_bytes_to_use_mmap_io = 3701341818, log_queries = true, insert_quorum_timeout = 60000, memory_tracker_fault_probability = 0.001000000707805157, merge_tree_read_split_ranges_into_intersecting_and_non_intersecting_injection_probability = 0.3400000035762787, http_wait_end_of_query = true, http_response_buffer_size = 5560914, fsync_metadata = false, query_plan_join_swap_table = false, http_send_timeout = 60., http_receive_timeout = 60., use_index_for_in_with_subqueries_max_values = 1000000000, query_profiler_real_time_period_ns = 25000000, query_profiler_cpu_time_period_ns = 25000000, opentelemetry_start_trace_probability = 0.10000000149011612, enable_vertical_final = false, max_rows_to_read = 20000000, max_bytes_to_read = 1000000000000, max_bytes_to_read_leaf = 1000000000000, max_rows_to_group_by = 10000000000, max_bytes_before_external_group_by = 10737418240, max_bytes_ratio_before_external_group_by = 0., max_rows_to_sort = 10000000000, max_bytes_to_sort = 10000000000, prefer_external_sort_block_bytes = 1, max_bytes_before_external_sort = 10737418240, max_bytes_ratio_before_external_sort = 0., max_bytes_before_remerge_sort = 1083624574, max_result_rows = 1000000000, max_result_bytes = 1000000000, max_execution_speed = 100000000000, max_execution_speed_bytes = 10000000000000, timeout_before_checking_execution_speed = 300., max_estimated_execution_time = 600., max_columns_to_read = 20000, max_temporary_columns = 20000, max_temporary_non_const_columns = 20000, max_rows_in_set = 10000000000, max_bytes_in_set = 10000000000, max_rows_in_join = 10000000000, max_bytes_in_join = 10000000000, cross_join_min_rows_to_compress = 0,cross_join_min_bytes_to_compress = 0, max_rows_to_transfer = 1000000000, max_bytes_to_transfer = 1000000000, max_rows_in_distinct = 10000000000, max_bytes_in_distinct = 10000000000, max_memory_usage = 5000000000, max_memory_usage_for_user = 32000000000, max_untracked_memory = 1048576, memory_profiler_step = 1048576, max_network_bandwidth = 100000000000, max_network_bytes = 1000000000000, max_network_bandwidth_for_user = 100000000000, max_network_bandwidth_for_all_users = 100000000000, max_temporary_data_on_disk_size_for_user = 100000000000, max_temporary_data_on_disk_size_for_query = 100000000000, max_backup_bandwidth = 100000000000, log_comment = '03532_crash_in_aggregation_because_of_lost_exception.sh', send_logs_level = 'warning', prefer_localhost_replica = false, optimize_aggregation_in_order = true, aggregation_in_order_max_block_bytes = 11779820, read_in_order_two_level_merge_threshold = 65, max_hyperscan_regexp_length = 1000000, max_hyperscan_regexp_total_length = 10000000, allow_introspection_functions = true, database_atomic_wait_for_drop_and_detach_synchronously = true, optimize_or_like_chain = true, optimize_if_chain_to_multiif = true, optimize_if_transform_strings_to_enum = true, optimize_substitute_columns = true, lock_acquire_timeout = 60., query_cache_max_size_in_bytes = 10000000, query_cache_max_entries = 100000, use_query_condition_cache = false, distributed_ddl_entry_format_version = 6, external_storage_max_read_rows = 10000000000, external_storage_max_read_bytes = 10000000000, local_filesystem_read_method = 'mmap', merge_tree_min_bytes_per_task_for_remote_reading = 8388608, merge_tree_compact_parts_min_granules_to_multibuffer_read = 5, async_insert_busy_timeout_max_ms = 5000, enable_filesystem_cache = true, enable_filesystem_cache_on_write_operations = true, read_from_filesystem_cache_if_exists_otherwise_bypass_cache = true, filesystem_cache_segments_batch_size = 2, use_page_cache_for_disks_without_file_cache = true, load_marks_asynchronously = true, allow_prefetched_read_pool_for_remote_filesystem = false, allow_prefetched_read_pool_for_local_filesystem = false, filesystem_prefetch_step_marks = 50, filesystem_prefetch_max_memory_usage = 67108864, filesystem_prefetches_limit = 0, max_streams_for_merge_tree_reading = 1000, insert_keeper_max_retries = 100, insert_keeper_retry_initial_backoff_ms = 1, insert_keeper_retry_max_backoff_ms = 10, insert_keeper_fault_injection_probability = 0.009999999776482582, session_timezone = 'Mexico/BajaSur';
    """ > /dev/null 2>&1) &
done

wait ||:
