-- Row TTL with extended data types
DROP TABLE IF EXISTS ttl_03519_1 SYNC;
CREATE TABLE ttl_03519_1 (date Date32, date_key Int) ENGINE=MergeTree TTL date + INTERVAL 1 MONTH ORDER BY date;
INSERT INTO ttl_03519_1 VALUES ('2010-01-01', 2010);
INSERT INTO ttl_03519_1 VALUES ('1901-01-01', 1901);
INSERT INTO ttl_03519_1 VALUES ('2170-01-01', 2170);
OPTIMIZE TABLE ttl_03519_1 FINAL;
SELECT * FROM ttl_03519_1 ORDER BY date FORMAT CSV;
DROP TABLE ttl_03519_1 SYNC;

DROP TABLE IF EXISTS ttl_03519_2 SYNC;
CREATE TABLE ttl_03519_2 (date DateTime64(5, 'UTC'), date_key Int) ENGINE=MergeTree TTL date + INTERVAL 1 MONTH ORDER BY date;
INSERT INTO ttl_03519_2 VALUES ('2010-01-01 12:12:12.12345', 2010);
INSERT INTO ttl_03519_2 VALUES ('1901-01-01 12:12:12.12345', 1901);
INSERT INTO ttl_03519_2 VALUES ('2170-01-01 12:12:12.12345', 2170);
OPTIMIZE TABLE ttl_03519_2 FINAL;
SELECT * FROM ttl_03519_2 ORDER BY date FORMAT CSV;
DROP TABLE ttl_03519_2 SYNC;

-- Column TTL with extended data types

DROP TABLE IF EXISTS ttl_03519_3 SYNC;
CREATE TABLE ttl_03519_3 (date Date32, str String TTL date + INTERVAL 1 MONTH) ENGINE=MergeTree ORDER BY date;
INSERT INTO ttl_03519_3 VALUES ('2010-01-01', 'qwe');
INSERT INTO ttl_03519_3 VALUES ('1901-01-01', 'rty');
INSERT INTO ttl_03519_3 VALUES ('2170-01-01', 'uio');
OPTIMIZE TABLE ttl_03519_3 FINAL;
SELECT * FROM ttl_03519_3 ORDER BY date FORMAT CSV;
DROP TABLE ttl_03519_3 SYNC;

DROP TABLE IF EXISTS ttl_03519_4 SYNC;
CREATE TABLE ttl_03519_4 (date DateTime64(5, 'UTC'), str String TTL date + INTERVAL 1 MONTH) ENGINE=MergeTree ORDER BY date;
INSERT INTO ttl_03519_4 VALUES ('2010-01-01 12:12:12', 'qwe');
INSERT INTO ttl_03519_4 VALUES ('1901-01-01 12:12:12.12345', 'rty');
INSERT INTO ttl_03519_4 VALUES ('2170-01-01 12:12:12.12345', 'uio');
OPTIMIZE TABLE ttl_03519_4 FINAL;
SELECT * FROM ttl_03519_4 ORDER BY date FORMAT CSV;
DROP TABLE ttl_03519_4 SYNC;

