SET send_logs_level = 'fatal';

DROP TABLE IF EXISTS t_03291_collapsing_invalid_sign;

CREATE TABLE t_03291_collapsing_invalid_sign
(
    x int,
    sign Int8
)
ENGINE = CollapsingMergeTree(sign)
ORDER BY x;

INSERT INTO t_03291_collapsing_invalid_sign VALUES (1, 1), (1, -1), (1, 2), (1, 1); -- { serverError INCORRECT_DATA }

SET optimize_on_insert = 0;

INSERT INTO t_03291_collapsing_invalid_sign VALUES (1, 1), (1, -1), (1, 2), (1, 1);

-- Invalid sign does not show up in result of SELECT ... FINAL
SELECT * FROM t_03291_collapsing_invalid_sign FINAL;

-- But it is still there
SELECT * FROM t_03291_collapsing_invalid_sign WHERE sign = 2;

DROP TABLE t_03291_collapsing_invalid_sign;

DROP TABLE IF EXISTS t0;

-- From https://github.com/ClickHouse/ClickHouse/issues/70964
CREATE TABLE t0 (c0 Int64, c1 Int8) ENGINE = CollapsingMergeTree(c1) ORDER BY tuple();
INSERT INTO TABLE t0 (c0, c1) VALUES (3113015407243198120, 1), (-5920792414778679906, 1), (-5884299248894554057, -1), (-5350317157177243253, 1);
INSERT INTO TABLE t0 (c0, c1) VALUES (6441560602946720835, 1), (214113373379542270, 1), (3450274783568693535, 1), (1229915363377101410, 1), (NULL, 1), (-3790756411322064052, 1), (-6476097574609257986, -1), (8340200647406930909, 1), (901374356156240451, 1), (-7937301880510480569, -1), (2718049489997799810, 1), (-7046070647647655389, 1), (NULL, 1), (NULL, -1), (539551042235977697, 1), (-6680126182402620465, -1), (-545071884260589694, 1), (-1609843843077275108, -1), (-2307499311918146032, 1), (-5800479665755413671, -1), (3122130530598217471, -1), (-4898541304738768940, -1), (1800869867489008348, -1), (6828243795825354769, 1), (4633856863838964429, 1), (5387774862927778951, -1), (71439926420223535, DEFAULT), (-291862315794351910, -1), (5204497349871065609, 1), (2815893477348202253, 1), (-2025994286668060087, -1), (1292848446755680198, 1), (2319903341156302022, -1), (5957514701048533074, -1), (1640080969736049288, 1), (-3213144610890525779, 1), (3054901382518697286, 1), (-6476734360473598468, 1), (-4863659638853829529, -1), (-8396840173526540909, -1), (9064411074374728617, 1);
INSERT INTO TABLE t0 (c0, c1) VALUES (-7330260992317873624, -1), (-3940238436997132320, -1), (2067369422305733562, 1), (-2941185840448845891, -1), (-6558865023141323556, -1), (-5421824708847807728, 1), (NULL, 1), (312212090923478057, 1), (-6725679606605613683, -1), (1446537700060712436, -1), (8173868172223781772, 1), (-1681206259557367358, -1), (-4906346581586950660, 1), (4365639853271319101, -1), (NULL, 1), (-4789376951758674727, -1);
INSERT INTO TABLE t0 (c1, c0) VALUES (1, 8937762244024852571), (-1, 8950824945935547949), (1, -1959904094995983529), (-1, -409312721222347063), (-1, 7342321349808831741), (1, -8193843876476887514), (-1, 8137088644401983521), (1, -1958965057666766522), (-1, 3954120584133380877), (1, 365814659508092868), (-1, -3483686915076827837), (1, -2852016893620489384), (-1, -2559434526558052722), (1, -1393500976668128115), (-1, 3969045642355663450), (-1, -2350556058112780554), (1, -8338109442121810335);
INSERT INTO TABLE t0 (c1, c0) VALUES (1, -4892066199024209089), (-1, -5491182770048413687), (-1, -4018923873457626147), (1, 675764533488331690), (-1, 8420772111929760862), (1, -5937640180539735892), (-1, -4626474415721923630), (-1, 6769798025186732866), (-1, 5345456016261312976), (1, 1710841889478637274), (-1, -1266913271723499160), (-1, 1103743554745717673), (-1, NULL), (1, -2597305165640059095), (1, -6912729702612168562), (-1, -7186477069505009142), (1, 821404772064670938), (-1, -5463163374280298685), (1, 1394078067264958090), (-1, 1036875756161173151);
INSERT INTO TABLE t0 (c1, c0) VALUES (-1, 8482902059126745084), (-1, -7937110385117446797), (1, NULL), (1, -8431229851988407072), (1, 759760791731484731), (1, NULL), (1, -6184256087929051233), (1, -7330483878500565160), (-1, -7087214691055696530), (-1, 1889179400346464951), (-1, 6710360786486282081), (-1, NULL), (1, NULL), (-1, 13275412783444588), (-1, 479269188324861296), (1, -1081506768672197531), (-1, 7649822949489003927), (1, 8565342891848886719), (-1, -2415400797217663574), (1, NULL), (1, 6434701107584272949), (1, -5975572166119718758), (-1, 8053866671492250673), (-1, -1085746824172150211), (1, -1416598885201198302), (-1, 402267973706390353), (1, 6653089490664761997), (-1, 4832610248880324173), (-1, -3273236545927562170), (1, 6947739671971480893), (1, 5807108610187298768), (1, 2036765517915890303), (-1, 1913625072931392084), (1, 5149177015152753379), (-1, NULL), (-1, -217515546249929827), (-1, 1405490038821945609), (1, -4437589030189839929), (-1, 493190889810948579), (1, NULL), (1, -7914077003684076929);

-- Should only show the last inserted row with valid sign
SELECT * FROM t0 FINAL;

DELETE FROM t0 WHERE TRUE;

SELECT * FROM t0;

DROP TABLE t0;

-- CI found a LOGICAL_ERROR during vertical merge, testing for it here
DROP TABLE IF EXISTS t_03291_collapsing_invalid_sign_vertical_merge;

CREATE TABLE t_03291_collapsing_invalid_sign_vertical_merge (c0 Int64, c1 Int8) ENGINE = CollapsingMergeTree(c1) ORDER BY tuple()
SETTINGS enable_vertical_merge_algorithm = 1, vertical_merge_algorithm_min_rows_to_activate = 0, vertical_merge_algorithm_min_bytes_to_activate = 0, vertical_merge_algorithm_min_columns_to_activate = 0, min_bytes_for_wide_part = 0;

INSERT INTO TABLE t_03291_collapsing_invalid_sign_vertical_merge VALUES (1, 0);

INSERT INTO TABLE t_03291_collapsing_invalid_sign_vertical_merge VALUES (1, 0);

OPTIMIZE TABLE t_03291_collapsing_invalid_sign_vertical_merge;

DROP TABLE t_03291_collapsing_invalid_sign_vertical_merge;

-- CI found a SEGV, testing for it here: https://github.com/ClickHouse/ClickHouse/issues/74219
DROP TABLE IF EXISTS t0;

CREATE TABLE t0 (c0 Int8, c1 Int) ENGINE = CollapsingMergeTree(c0) ORDER BY (c1);

INSERT INTO TABLE t0 (c1, c0) VALUES (69938204, 1), (-968049277, 1), (-1302413209, -1), (1059244139, DEFAULT);

SELECT 1 FROM t0 FINAL;

DROP TABLE t0;
