SET enable_json_type = 1;
set enable_analyzer = 1;
set output_format_native_write_json_as_string = 0;

drop table if exists test;
create table test (json JSON(max_dynamic_paths=2)) engine=Memory;
insert into test format JSONAsObject
{"a" : {"b" : 1}, "b" : 1, "c" : {"d" : 1}, "d" : 1}
{"a" : {"b" : 2}, "b" : 2, "c" : {"d" : 2}, "d" : 2}
{"a" : {"b" : 3}, "b" : 3, "c" : {"d" : 3}, "d" : 3};

select 'skip a';
select json::JSON(SKIP a, max_dynamic_paths=2) from test;
select 'skip a.b';
select json::JSON(SKIP a.b, max_dynamic_paths=2) from test;
select 'skip b';
select json::JSON(SKIP b, max_dynamic_paths=2) from test;
select 'skip c';
select json::JSON(SKIP c, max_dynamic_paths=2) from test;
select 'skip c.d';
select json::JSON(SKIP c.d, max_dynamic_paths=2) from test;
select 'skip d';
select json::JSON(SKIP d, max_dynamic_paths=2) from test;
select 'skip a, skip b';
select json::JSON(SKIP a, SKIP b, max_dynamic_paths=2) from test;
select 'skip a, skip c';
select json::JSON(SKIP a, SKIP c, max_dynamic_paths=2) from test;
select 'skip a, skip c.d';
select json::JSON(SKIP a, SKIP c.d, max_dynamic_paths=2) from test;
select 'skip a, skip d';
select json::JSON(SKIP a, SKIP d, max_dynamic_paths=2) from test;
select 'skip a.b, skip b';
select json::JSON(SKIP a.b, SKIP b, max_dynamic_paths=2) from test;
select 'skip a.b, skip c';
select json::JSON(SKIP a.b, SKIP c, max_dynamic_paths=2) from test;
select 'skip a.b, skip c.d';
select json::JSON(SKIP a.b, SKIP c.d, max_dynamic_paths=2) from test;
select 'skip a.b, skip d';
select json::JSON(SKIP a.b, SKIP d, max_dynamic_paths=2) from test;
select 'skip b, skip c';
select json::JSON(SKIP b, SKIP c, max_dynamic_paths=2) from test;
select 'skip b, skip c.d';
select json::JSON(SKIP b, SKIP c.d, max_dynamic_paths=2) from test;
select 'skip b, skip d';
select json::JSON(SKIP b, SKIP d, max_dynamic_paths=2) from test;
select 'skip c, skip d';
select json::JSON(SKIP c, SKIP d, max_dynamic_paths=2) from test;
select 'skip a, skip b, skip c';
select json::JSON(SKIP a, SKIP b, SKIP c, max_dynamic_paths=2) from test;
select 'skip a, skip b, skip c.d';
select json::JSON(SKIP a, SKIP b, SKIP c.d, max_dynamic_paths=2) from test;
select 'skip a, skip b, skip d';
select json::JSON(SKIP a, SKIP b, SKIP d, max_dynamic_paths=2) from test;
select 'skip a, skip c, skip d';
select json::JSON(SKIP a, SKIP c, SKIP d, max_dynamic_paths=2) from test;
select 'skip a, skip c.d, skip d';
select json::JSON(SKIP a, SKIP c.d, SKIP d, max_dynamic_paths=2) from test;
select 'skip a.b, skip b, skip c';
select json::JSON(SKIP a.b, SKIP b, SKIP c, max_dynamic_paths=2) from test;
select 'skip a.b, skip b, skip c.d';
select json::JSON(SKIP a.b, SKIP b, SKIP c.d, max_dynamic_paths=2) from test;
select 'skip a.b, skip b, skip d';
select json::JSON(SKIP a.b, SKIP b, SKIP d, max_dynamic_paths=2) from test;
select 'skip a.b, skip c, skip d';
select json::JSON(SKIP a.b, SKIP c, SKIP d, max_dynamic_paths=2) from test;
select 'skip a.b, skip c.d, skip d';
select json::JSON(SKIP a.b, SKIP c.d, SKIP d, max_dynamic_paths=2) from test;
select 'skip b, skip c, skip d';
select json::JSON(SKIP b, SKIP c, SKIP d, max_dynamic_paths=2) from test;
select 'skip b, skip c.d, skip d';
select json::JSON(SKIP b, SKIP c.d, SKIP d, max_dynamic_paths=2) from test;
select 'skip regexp .*a.*';
select json::JSON(SKIP REGEXP '.*a.*', max_dynamic_paths=2) from test;
select 'skip regexp .*b.*';
select json::JSON(SKIP REGEXP '.*b.*', max_dynamic_paths=2) from test;
select 'skip regexp .*d.*';
select json::JSON(SKIP REGEXP '.*d.*', max_dynamic_paths=2) from test;
select 'skip regexp .*c.*';
select json::JSON(SKIP REGEXP '.*c.*', max_dynamic_paths=2) from test;

drop table test;
