-- Tags: no-fasttest, no-ordinary-database, no-parallel-replicas
-- no-parallel-replicas: The test really wants lower quality result to be returned from the index
--                       with rescoring=OFF. That is required to confirm binary quantization works
--                       as expected. In parallel replicas, rescoring is always ON.

-- Test for vector similarity index with binary quantization.
-- Also has good number of calls to reinterpret() to test conversion of native floats to Array(Float32)

SET enable_analyzer = 1;

DROP TABLE IF EXISTS dbpedia;

CREATE TABLE dbpedia
(
    id String,
    vec Array(Float32),
    INDEX vec_idx vec TYPE vector_similarity('hnsw', 'cosineDistance', 1536, 'b1', 64, 128)
) ENGINE = MergeTree
ORDER BY id
SETTINGS index_granularity = 2;

SELECT '-- INSERT 20 rows using the reinterpret() technique';

INSERT INTO dbpedia VALUES
('<dbpedia:Database_transaction>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Database_trigger>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Database_tuning>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Database_index>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Database_theory>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Bugatti_Automobiles>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Saab_Automobile>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Tata_Motors>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Honda>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Mercedes-AMG>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Mount_Everest>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Mount_Fuji>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Andes>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Alps>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Swiss_Alps>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Hamburger>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Pizza>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Idli>', reinterpret(x'e03eb7bc882739bc4a5c88bc60d8a23c25584fbd48b7bf3ce3ef423cfd8217bdc37435bca98e96bcec35bdbc1e3d3f3ce1f72fbc148553bc4b7c7bbc53c275bcb3e0d3b9d196253d7d3cf63aaa470f3cc909a43cdb2fea3b097a1d3d429cafbb1332093d9d97903b1b8c333bc3a78cbc4c21c4bc7de9abbcfb57adbbbe983fbcc8ea7c3c0f0f0c3d1994a0bcbddf463cac3f22bdb60bbe3ca4056b3d66b418bd9a4dffbcf740f33c2f8a19bd63892e3d68df82bd0424493bad4be53c8ebca73c261148bdc5e6a6bc351f883ce6a04e3cdd27fd3c45d35c3ccf9e123dd414da3ceeda853ddb2f6a3df09fc1bb2a016ebc241935bc791979bd8437133c22da1abcc0f6003d67260a3c3fb84cbc902e99bb11071f3d2e9ec93c9f0982bc36f8733dd48eb83c3c07413d4778a5bcbc59a5bce0b815bc1b0692bcaa14383deb9074bca52492bc6c9c51bc4e7f85bc8cc4943c810c293cf7877a3cc2bbbc3c1ae76abd2ca6363df1de5b3c0c2ba93df125e33c1eb71d3d815330bc8067603c59041abde03e373d0f62d6bc219b80ba9888433d3b819fbcfec1b1bcec7c443c4b68cbbcb6d866bc46f2833bf787fa3c21bb73bb5b2f84bd13ff31bd7e2846bd36a5293ce6e7d5bb8510ffbafe08b93bc4c7ffbb536f2bbc29f52abd9bbff0bc57a6583c29f52abd8186073de3efc23cba2e3b3d3433b8bc654eeabc63892e3d63bc053c755c2abc2750623d818687bcc8502bbc4e4c2e3cf125e3bcdfccc53caa14b83c92ac4d3ca6aa333cd024b43c536f2b3db11b983dad92ec3bad4b65bcf91813bdf409c63b6356d7bbe24afabc7faee73ad70ced3c27fd97ba6d554abd3d465bbc2274ecbccf9e123c71bfce3a2168a93c48cbef3c93989d3c882739bdf21133ba3fb84c3ab9ef203d01ed9b3c41b0dfbc67c05b3c3dac89ba56530ebd8d3606bd48cb6fbda796033d8933fcbc8304bc3c65c8c83b8c91bdbd979c73bc778714bda273063d67260a3d891309bbdd078abcfe08b9bbe0718e3b706c043dcd0d7a3cbb1a0bbddd5a543b7bf1183dcd40513c7ef5ee3c92f3d4bc6ccf28b945390bbdb83628bd1994a03cfb8a84bba405eb3a042449bc63892e3d2bedbd3c1b0612bc6f80343d570c873bf43c9dbc363f7b3cd3a2e8bbe845973c8f0ff23c93981d3d810ca93cd19625bc1e3d3f3d62e4e5bc61911bbd01ed1b3d9e1db23c4ddabcbc6442273c605281bc3cc039bc72ab1ebac909a43c809ab73cbe65e8ba86b547bdcd0d7a3b8e56f9bb517798bca0489c3c86fcce3a6ffa123c0d376c3d9cde17bc69eb453d26def0bc9e5089bd07d5543cbd129e3c5dc1e8bc362bcbbca44cf23cc8ca89391e84c63c89e031bd58e5723cab8629bd2ca636bcd130f73c36d8803cfc63703b98bb1abcc17ca2bcb989723ca0481c3ccf9e123ddd070abde951da3bd3d53f3d8dd0d7bbad7e3c3dbe983f3c15f7c43cd53381bdf383a4bc00ba44bdac0ccbbc18db27bd584ba13cbc5925bd4b15813df38324bb3dac093d0a8660bdf2647dba992d8c3c477825bcfad10b3b891309bdf211b3bcee2d503db6d8663d1c452c3d066363bc2cd98d3bb1b5e93b2b20153c7ea224bc9ae684bd7429d3bb1b59dc3bc71191bc71f225bde561343d2a016e3cbd121e3d3400e13cb1e8c03c429caf3bd21cc7bbbf840f3c5f99883d6aa4bebced218d3d1ae76abdf211b3bcff7a2abc6c16b0bbdc1bbabc351f88bd9081e3bcb4994c3b605281bd46bf2cbd9b259f3cd686cbbc6c16b0bbca8f45bb15f7c43b1e7096bca01545bbf211b3bc1e7096bc02f9debc89992abc4d0d943c9e70fc3c10e8f7bbe98431bbc0f680bb05dd413dd3d53f3cbcd3033dc42d2ebc4884e8bce84517bd1eb71d3c8dd0573dd70ced3b1a4d99bb17365f3c402a3ebc36f8f3b9fdd5613c1855863c5d2717bde27dd13d286f093d6c4907bcabb9003d80cd8ebc121362bc1379103a0d9d9abcc53971bccef9493d10c804bcb2a1b9bbb836a83c9365463cfb8a043d429c2f3d4dda3c3cfd1ce9bcf66707bd2a679cbd0aec8e3ceea7aebd4af6d93cb2a1b93c6fb30b3cb346023cd73fc43ba71ca53c3d79b23bd447313c0cc5fa3c3043123cd21cc7bba6775cbdb8d079bb48cbefbb23603c3ddb95983ca6dd8abdeeda85bcc17c22bd286f89bdd1aad53c74d608bd7787943cf0d2183b9b6ca63cf634303df667073d84f08b3cf57bb73cdf99eebb86b5c7bc3f3eeebcbf0ab13ccd40513c9cabc03caa470fbc65c8c8bca8a246bd362bcbbc36a529bb41168e3b5058f1bafa9e34bc1ba0e3bcfd4fc0bc6965243c468c55bca52412bd9e50093c63030d3c0cc57abcdb95183d7d6fcdbc5c824ebb90b4ba3c4b9ba23b07d554bc337abfbc7cfddbbc4970b83b8827393c77dade3b2de550bc073b03bcca5ceebccd0dfa3c4e4c2e3d9e1db23db2a1b9bc35ec30bd314fd5bb1eb71d3ddd070abcb63e153d3400e13c67c05bbdd87edebc967c803d508b48bd802059bd6b2ae03c3e322bbb843713bc2d2c58bdbc59a53bab53d2bb1a4d99bb212122bce3364a3d517718bd04f1f1bcda23273c8020d93b1246393ca240afbc09cd67ba6b900e3d87a117bb6e411a3c706c04bc57d92f3ca7632c3dca8fc5ba5ee08fbc0c5e00bdb11b18bd68ff75bdbc59a53be61aadbcb74a58bcdc1bbabb2f57c23c0f0f0cbd913adcbc666d113dc090d23c11d4473c8d032fbd9ed62a3d9f8fa33c8067e03b97cfcabb2d2cd8bcfdd561bc612b6dbbda76713c3c3a183dd53301bd854356bdc897b2bcb552c5bb0de4213caa0008bdf57b373df9b2e4bcf548603d46f2833cbfd7593c51116a3caa00083d0a86e03b68df823c7264173d10c8843d153e4c3d2525f8bc8fc86a3ce3bc6b3c43a8723af2fd823c6965a4bb77543dbdfcc99e3c185586bc7bf118bdb3ad7c3d980e653c8d7d8dbcec02e6394a29313c2d2c583d4659fe3b2393133cd1aad5bb7721663c4e1957bda7632c3d36d8003d8186873c8933fc3c4a2931bd666d113a5fb97bbca98e163df5f515bd5058f1bbef60a7bba6aab33c8c913d3dd7c5e5390424c9bceea7aeba16b0bdbc755caa3a7cfd5b3dcf9e123cc202c4bc0cf8513c508b483c68ac2b3d1cbf0abd6be358bc1a1ac2bcd11084bbde46243d9226ac3c8c4ab6bc6356d7bc3ac8a63c6e411a3dc625c1bce24a7abcec0266ba7a8b6a3c63d0353c7abec13c4e4c2e3d5c82cebc8067603cc81dd4bae0718ebbe24afabcbd129e3cf7734abc7039ad3c0457a0ba03b257bd6c16303d4a5c08bdfcc99ebb11071f3d46f2833c148553bd87a1173deea7aebbd87e5ebc9649293de03e373c67268abbc3415e3c20af303d5a8a3b3d9841bcbc8a5223bd0a33963c3feba33c7e28463da95bbf3c57d9af3c8fc8eabad21c473c6595f13b0510193caf8a7fbb916d33bdf918133c1b8c33bdddd4b239232de5bbeb49ed3cb346823d5cb525bc12c0973c8bd8443c772166bc601f2a3c9e70fc3cd47a883cec02e6bc0aec0ebc797f273caff0adbb5f335ab9d1634e3c5f66b13c0ef0e4bb3f85f5bcebc34bba663ababcba2ebbbc644227bdf2440abde898e1bc7e2846bc4ec60c3da763acba0e56133caa1438bdd130f7bbb2d410bc3c3a183d48ea163df72080bc5abd12bc4a29313d34668f3bf211333c52e989bb2ed1a0bc4fd2cfbb43db493d570c873a60d8223c8e5679bbde4624bd8a1f4c3d536f2b3cf7eda8bcd2e96f3c78f905bc88f4613cfcc99e3cbb1a0bbdb51feebb0ba507bdd02434bc3b819fbc95a460bcf06cea3cd48e38ba66b4983ba71c253c885a103d612bed3b2a48753c4c21c436dd8dabbcac3fa2bb663aba3cbd121ebc6c0280bca6775c3a4506b4bc8ba5ed3c7264973b08c124bc4bafd2bc89337c3ca6aa333df12563bd49a38f3c77dadebc837e9a3cb38d89bc945116bce0b8153c1c452c3b5bfcac3cbbb4dcba23603c3c7721e63b90e711bbee74573b06963abd6052013c34668f3b547beeba8d03afbc5a43b43b59d1423d3a954f3ceeda853cdd8dabbc8f75a03cdd5a543d157123bd6d8821bc2cd90d3a2750e23ca1ba8d3d7b4463bdfe8edabcbecb96bcd447313c700656bb7fe1be3beea72ebde898e1bb0c7e733d2525f8bc3b819f3c74f6fbb93e32abbc1961493c624a143d5bc955bd1eb71d3c1e3dbfbc60d8a2bc64dc783c9279f6bb74f67b3cc850abbce3229a3be00b60bc6d55cabb0c2b29bccac29cbcf383243c6fb30bbdcec6f23c1b8c33bdf5c2be3c20af30bc9649a93c33f41d3d7b44e3bbdd8dabbc5ead383d9bf247bd2419353b71f225bd74f6fbbc9ea3533c8d36863dd48eb83b6d554a3c75e24bbd9259833b1e7096394e9335bb992d0cbd7abec13ca1cebdbccd40d13b6389ae3c1994203dfc96c7bb244c8cbc10c884bcc8eafc3c43dbc93c9365463c806760bc3347e8bcc288653dfdd561bb192ef23b7b44e33cd3d5bf3c2274ec3cff7a2abdc89732bdf7ed28bd4884683d6c9cd1bcf82cc33c9a80d63cb327db3cb38d89bd4da7e5bc5fb9fbbcea7001bc7ef5eebc82c5213de9cbb83c6c02803ccac29cbc74a3b1bcc8502b3cc8ea7c3cd3a2e8bb89ad5a3c1e70963c152a9cbc073b03bc54e11c3d454dbb3c2d1828bcd45be13c4ec60c3c064fb3ba3cd469bb77543d3c7ad271bc5bfcacbca6dd8a3b125ae9bc59d1c2bbadb1933cd0578bbc9ed6aabb207c593dd24f1ebb4c549bbcca5ceebcea70813de9b708bd15c46d3c52835b3ab63e95bc5f9988bc3c3a183cffad813b62e465bc4ec68cbcbf840f3c3043123db691df3c71bf4e3ccf6b3b3ce4db923c71bf4ebb1bd3babb022c363d71bfce3cf72000bcaa14b83b39898cbce03e37bd5818ca3b53c275bcaf8a7f3c025f0d3a7fae67bbaacdb0ba53a2823c24d22d3c666d11bc18ef573cfef488bc8ba5edbcf91813bdd11004bdd99d853c941ebfbb1c7883bcaff02dbb7d3c763dfc63f03bf82cc3bbb5859c3b0fdc343d9e70fcbc1cbf8abc402abeb6430ea13b405d95bcc5e6263de9fe0f3bdc1bba3b6b5d373df82cc3bc4be2293cadf81abc85a984bc36a5a9bc1cbf0a3c3cd4e93cef19a0bbf7ed283b179c0dbc0de4a1bc7231c0bb00ce74bcb552c5bcf5ae0e3b9ae6043db26e623dba6112bd00ba44bcf548603cf211333cecaf9b3c36d800ba5bc9553deeda05bc0f0f8cbc6052813c185506bcf8f9ebbc03b2d73c0cf8d13c85a9043c941ebfbcf18b913c9b39cf3c62e465bc579228bd68fff5bc7721e6bb0d9d9abc31822cbd825ff3bb232de5bc2cd90d37c6f2e93b2168a93b10e8773db63e15bd9f0982bce898613c16e314bcc46005bc84f00bbd18222fbce64d84bc78408d3c3cd4e93c02f95ebd624a94bc6c16303c7a0549bdb34602bce8df683b1ba0e3bbb499cc3c3942053d533c54bc9a80d6bc1a1ac23c57a6d83b43db493c0e233cbd666d91bc7721e6bc21bbf3bad7721bbd2d2cd83c1c12553cd308173c5283dbbc24e6dd3b7f1416bc84bd343c950a8f3c84f08b3c731d103c9cabc0bc4af6d9ba2405853cad7e3cbc8c4ab6bbb989f23c87a117bd4506b4bcf5ae8ebc00ba44bcc2ee933c536fabbc2558cfbcec02e63b0cc5fabc3e65823c6595f1bc2928023d9e70fc3cfd1ce9bc9ea3d3bbf5f5153dbf0a31398d7d8d3bdce8e2bb036b50ba60ec52bc4a5c08bc78f905bd6c02803cffad813ce78c9e3c0457a03ca71ca5bcff47d3bcde134d3d01a6143d4a5c083d67c05bbca6aab339cc87d8bcaae160bbe5948b3c5818ca3c00876d3d394205bdb1e8c03c639dde3cbf3d88bcf57b37bc83043c3c809ab7bb12136239d45b61bd7d3c763caf2385bc63892ebd1994a03c2a48f53b405d95bc8bd8c4bc967c80bab02f483bf2440abce0710ebd4c549bbb67f332bb351f88bcd024b43c1e0a68bc10c8043dd8e40c3c9e50093d4a2931bda98e963ba4b2a0bc47454ebcaa470fbc9a80563c794cd0bc4e605ebc0f952d3dfb1026bccf9e123c843713bcf38324bceb90f43aca5cee3c3a62783ce0853e3cec35bd3ada76f13b624a143aa5bee3bbe64d04bbd0570bbb5cb5a5bcadc5c33ac17c223de52e5d3c4fd2cfbcb3ad7c3ddaa9c83c7231403c5d6e1ebc70d3febb4222d1bb5a768bbcea70013c9b6ca63852e989bc58e5f2bc101bcf3c0a3396bcc71111bdd6864bbd30fc8abc941ebfba91a00abc2d1828bbaae1e03c4f9ff83bab5352bcd1aa553c458012bd93989dbc3e32abbca0489c3c37b1ec3bf06cea3710c8843cd414da3a01a694bbfd4f40bc90e7913ca928e83ba3f9a73c85107fbcc202c43c232de53c92f3d43c4b9ba23ce3ef42bc5130913a213552bc9d3162b9c3415ebcab86a93c46597e3c809a373de78c1ebcb38d093ce64d843c1dcbcdbc5b967ebca677dcbccd0d7a3c2ca636bca8d59d3c513011bc75e24b3bfef408bd6c1630bcca8f453df383a4bc8f0f723be6d325bcf297d4bc7721e63c9259833c150bf5bb0663633c8e56f9bbbcf3763c337abfbbf125633ca3f9273cb63e95bcac3fa23cb38d093d5cb5253de1f7afbc54f5cc3c0ab9373bc65818bdc7deb93ab9bcc93b4b9ba23ce9cb38bce1f7af3c4b35743ccbcedf3b90b4ba3c323b25bd20afb03ce24a7aba98bb1abd9e70fc3cf409463c45398b3b92f3d4bc9855ec3c27fd17bd0cc57abc0c2b29bd913adc3bc5b3cf3cd4c10fbdb77dafbcb77dafbc27cac03cc8502b3d27b6103c6b5d37bc6356d7bb468cd53b6965a4bc57a6d8ba74f6fb3cf5f5953a5a768b3bc62541bd37179b3b025f0d3de3364a3b46f2833c9b39cf3cd196a53c0a86e0bb7d1c033d11d4473cab86293cc81d543c097a9dbc53c2f53b08c1243cd87edebc70d3febc6c4907bd5a57e43c48ea963c152a9cbb5bc9553c390f2ebdb11b18ba63bc05ba5f66b1bc0c5e803c394285bcf2440a3b9616523d9ae684bce475e4bba27386bcb6d8e6bb3010bbbc8304bc3b6ffa123ced218d3c8e56f9bbd24f1e3b4e19573cbc264e3c834b433b8ebca7bc78f9853cf7ba51bbfec1b1bcd45be1bbb499ccbc05ddc13c9d31e2392de550bafbddcebb449442bc3b1bf13b232de5b939235e3c6fb30bbdd414da3c8ba56dbc64dcf83cfd1ce9ba429caf3c8bd8c43ce72670bced210d3d96c3873c101bcfbc4a5c08bdab86a9bc2102fb3cf5ae8e3c668141bbc090d23c9a80d6bbfd8217bc99c75dbcf2caabbcd3a268bc311cfebc5abd923c4659febcef19a03c8067e038dd5a543c87e81ebb36f8733c6356d7bb0a33163d16b0bd3c6fb30b3d6c0200bd4c549bbb08c1a4bcaa9ad93a69ebc5bc33c1c6bccec6723b86fccebbd0578bbcb8d079bc967c80bc63d035bde475e4baba61123d78f9053c17365fbc7f14163ba3c6d03ceea72ebc0d6a433c7c630a3b2783393d0b3fd9bbf2caab3ccd0d7abc43dbc93c351f883caa470fbdd96a2ebcbe98bfbcaae160bc06c991bc3cd4e9bcd2e96f3cf5ae8e3c3dac09bd980e65bcc7deb93c2bedbdbc29f52abbed218d3caf23053cefb3f13c941e3f3cb691dfbcd308173b7d1c83b962e465ba22746c3bb4cca3bcc897b2bb599e6bbba52412bc3a62f8bbdd5ad4bbf634b0bc885a10bd33ad96bc726497bb2102fb39b63e953c0f0f0c3d584ba13c15f7c43b57d92fbc0ba5073d86fccebc63038d3b022c36b9aff02d3c179c0d3ca730d5bb6b2a60bc430e213c27b6103db0621fbddd8d2b3de84597bc0b3f59bc8cc4143c48ea163c0173bdbbe9515abc74a331bc5bfc2c3c8e5679bce0718e3b0cc57a3abc6d55bdb38d893c6d55cabceeda85bc07828a3ccbcedf3c68df823c5a760bbd14eb813c7039adbc5f99083c9b394fbbe9cbb8bcd4145a3c2750e23ce1c4d8bb56538e3ce4a8bb3c0f95ad3cf2ca2bbc179c8d3c0b3fd9bc67c0dbbc84bdb43bbc26cebab51f6e3d9590b0bb60d8223b2de5d0bccb340e3b252578bca1ba8dbcc116743c1e3dbf3c216829bd286f893d71bf4ebb3dac09bc3347e8bbc17c223b8c913dbc01ed9b3c3c8d62bc2a48753c1a4d99bc8b0b9cbb6d554a3a902e19bce475e43bdaa9c83c92accd3cf350cd3c3fa41cbde951dabc843713bd660763bcb51fee3bec353dbc390faebc90b4babc0173bd3bdda1db3b4745ce3b152a1c3bd45be13c76ce9b3ceb49ed3ce64d84bccb01373cf634b0bc90e7913b6e411abc2ca6b63b848addbbcd0dfa3c1cbf0abc780db63c896653bbe5948b3cf12563bce66df7bba7e94d3c2f5742bc4778a5bbd937d7bcf548e03b43a872bbe52e5dbd7515a33c30fc0a3cca8f453c4c549bbc624a14bda7b676bcb3e0533b22a7c33c27fd173c4c541bbcaacdb03b311cfe3bc42daebc570c873c4f9ff83c6d88213d4580123cc71111bc72ab1e3c87a117bdb975c2bc1a1a423c992d0c3b1e0ae8bce72670bc53c2f53c601faabb988843ba86b54739d4c10fbdd2e9ef3b36f8f3bccd0d7abcfb8a04bcfd8217bc559a153ca677dc3b4b7cfbbba0e2ed3b1b595cbc9e70fc3b311c7e3c3b1bf1bb65fb1f3c8c91bd3c3b1bf13baf8a7f3c7145f0bc15f7443db55245bde561b43ad0578b3cc8ca09bdf18b913bec6894bb451a64bd60a5cbba4af6d93c6a71673c89e031bd20af303b8c175f3a4884683c5058f13b', 'Array(Float32)')),
('<dbpedia:Pilaf>', reinterpret(x'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', 'Array(Float32)')),
('<dbpedia:Salad>', reinterpret(x'fb26243c631de33c78a4b4bcc686a53c64ca8dbc261ede3bde0432bce93c66bd4547a2bc4a45af3c791ce93b7fe5ad3c5da7a13bdb2b04bc239fd7ba31a9153d2600d1bccf99fa3c58a914bc3dac01bd32214a3db85eda3b3e60d03c8c7edb3cefc990bc24bde43c4a9fd63c5b4628bb7c2a0dbd08a2443d25c4b63b440b88bcf8dc653d6f3edc3b2aa4b6bc103d65bc35dc6a3ce681453ce888973b33ec01bdea079ebcec4a0a3de7bddfbc2f481cbc07b9ffbc90aa0c3d2f66a93b71633b3cb90b05bd11089dbc0fe33dbd6b0b873b57fce93c2381ca3c9fa4b3bc958a0c3d51a4b5bc741edc3cf1b979bdad08993c146996bc2d5f57bd35fa773cfa1fd23b2be0d0bb399e5d3c29bb713c287f573d6f3edcbc3b87a23c698c003dfa01453d741e5cbd5441c93c492722bd1fdd643bcab97abd070c033cb37edabc2f8436bd47e4b5bb89a5ad3a0143bebc4429953ce91ed93a9ed9fbbae86a8a3a366b88bd63e1483cd35b6d3c146916bcdb4911bde888173dd064b2ba681bf03d5aec003d9709133d31c7223d8d2b063d1d2916bd3abc6ab973c4343d4ca6a8bc4b4c81bd64ac803c1742c43aa44899bc6560cf3c4b4c813a8be899bd08481dbd2a681cbc9ac433bb9ccb053de5271ebdab8992bc05c996bc454722bde2197abcf7a0cb3cd9ca8a3b741edcbcffff51bca8997bbd368915bdedc23e3c2aa4363ce1652bbd294a0fbc2a689cbc490995bcd1dc663d0ae5b03c88bce83cbe09123d213ede3b9aa6a6bcab6b853cd64b043cda24b23d64ac80bc287fd7bc5fcc003cd2c5ab3ae183b83c177edebcdd1b6dbc3c1d64bc7b7d62bd5666283ca4c0cd3a14a5b0bbb2ca0b3cf55d5fbcba471f3d19c14a3c550c813de663b8bc559bf03bb704b33cae804dbc08c0d13c3dac81bd292c82bc6269143cac5b6ebd53c914bd3446293bcdc71e3da4c0cd3c97eb853c9fc2403d36a7223b920b06bd9ed97b3c1fbfd73b95e4333d2fc0503c674914ba478a0e3d9d7f54bc2cab08bd36e33c3cfe879dbcdca3b8bc2825b03b4909153b449af73cfee1443c366b083d00cb09bc4bf9fd3bc1c4b2bc5fea8dbcf05fd23c0866aa3cf62897bd8ea3babca899fbba69c81abceb43383decd979bdcbc0cc3c93833a3dd64b043d5e01c93c0641cb3bedc2bebc810a0d3d04fe5ebd3944363caabedaba13bc6b3b09dede3c03681d3c79e0ceba4802c3bbe86a0a3d375bf1bc27cb883b366b883bbce4b2bc9b5af5bc1985303ca68b05bc50d9fd3c6524b5bcb6df533b20c629bdc25a743cb34240bd45a149bdc3cb84bcfddaf2bc2e9b71bdfb26a4bbe91e593cac1f54bc958a0cbd5d6b07bc480243bd38797e3d53ab87bd2600d13c208a0f3d1949963c7c2a0d3d1baa8fbd724c803c27e915bd6ddde2bc42e6a83cf782bebc33997e3c915e5b3c7e1a763b9b5af53ce1652bbbfb2624bc3482433cf9c52a3d396243bd9881c7bcbd0240bd502c01bd970993bdb37eda3b2e9b71bd177e5e3c2e2a0fbcaf4b85bc394436bc03c244bd7ac9133d4820d0bcc443b93cd301463d78a4343d0aa9963c69c89abb597bf03bc54a0bbd8762413cb49ce7b9b37e5a3de3c6a43c45833cbd69e627bc263ceb3befc9903c5b4628bd0f89163bcf28183be5eb83bcb90b853bad08193d38081c3d95a8993bc16a0b3bcb48983dd544b23cd54432bcd1fa73bdd5804cbc61da76bcecd9f9ba04e051bdcb8432bb4f6149bd53c994bc01433ebc3a4b883b35dc6a3b72bd623c3e42c3bcc2004dbc0d82c43bccde59bdb1ff533dfddaf2bb2b1c6bbd71452e3b2e2a0fbd61daf63cd6bce63cdeaa0a3d654242bdd35b6dbc09de5e3de3c6243db7e625bc2fa2c33aa6c71fbc33997e3cb87c67bd0b3f583ce5eb033d08c051bbc97de0bbd06432bd846b86bc1afd64bc772c003d2be050bc103de53c5f089b3c398050bd9727203c676721bc2d41cabcf48b033ae2fbecbb2a86a93b3f2b083d7d489a3ce3a817bdc3cb843ccd8b04bdc200cd3c79fe5b3c8e85adbbe5eb83bd1244b7ba11cc82bd963edb3b588b87bc0ae5b03c6d6c803dc7fe593d134b093b70eb86bbb6fde03b9863ba3c8a597cbde8a6243d736a8d3c7d66273dd30146bd61bc69bd970993bca964b33c05e7a3bc626914bd1d2996bc90c819bd239fd7bcc668183dee3af3bc6542c2bb261edebc61bc69bc58a9943c5da7a1bc177ede3cc16a8b3dd046a53c4f61c9bbce7b6dbc6560cfbc1f197fbc368995baadea8bbc3ada773d58c7a1bc5b46283d719f55bdf7a0cbbcc3e9113a8987203d03a4373ceb43b83c261edeb9ad79fb3b239f57bc9fa4b3bcf4c71d3d628721bdf8dc653cf53f52bc4802433d807b6fbd5e1fd6bc38089c3b4bf9fdbb54233cbd88daf5bc0c281d3c550c013c93bfd4bc428c01bdba652cbdd26b043d1469163ae1479ebc803f553d9ac433bd64ca0dbc126244bcad08193cd064323d51a4b53ce45c663c174244bc4067223d22eb88bc012531bd4583bcbca77b6ebcb2e898ba0b21cb3cf9a79dbcdeaa0abcd0823fbd1baa8f3c846b8639929af5bae3e4b13c0da0d1bcd64b843cb342c03c0d82c43acdc71e3d6a404f3cac5beebc846b06bb4ee994bb9140ceb777bb6fbb325de4bc28433d3c900434bd36a7a2bd14a530bd16ac82bae86a8abcfec3b7bb83be5bbc68df55b9b92912bd7886273bcf0a8bbdca9b6d3dbaa146bd87804ebc6904b53c6a22c2baf57bec3cfec337bdea079eba628721bd6a5e5cbc25c4363ba44819bc807bef3ce402bf3bc7e0ccbc294a0f3ce50911bce7f979bbe43e593d103d65bc11ea8f3cf57becbcdc852b3d64ca0d3cc0db6d3c323fd73b2363bdbc86ea0c3d6d6c803c8f39fc3957fce9bbd35bedbcdb49913b45a1c9bc6904b5bc7d66a7bc189cebbc56c0cfbc4cc4b53ce7f9f9bceb252bba0cec82bd4a8149bda0fedabaa223babcdf7c663d35be5d3cee1ce6bc0a8b093b68dfd5b914c3bd3bb7e6a53cae804d3dae26263b9f68193d2120d1bcad797b3c3ba5af3ceb61c53cf4a9103c256a8fbabeeb843bf8faf2bce663383c04fedeb70d64b73c698c803ce91ed9bcd76991bb2600513de3e431bc182b09ba9d43ba3af7a0cbbb769de23c7c0c00bd4d5af73cb639fb3a4927a2bc16ca0f3d2e2a8f3b6e8a8d3bb069923c8c24343dda423f3c5b64b5bc1001cb3cbca8983c9b1edb3c5423bcbc7d489abc8021c83cf05f523cdec817bc78689abb103de5bc810a8d3c0d6437bb466c81bd4ca6283df8faf2bce50911bd05ab09baf7823e3abd7a743d449af73b5b46a8bb08a244bb50d9fd3cce3f53bb0f8996bcae6240bbdc679e3c9ac433bd970993bb5f081b3c5a281bbcb8404dbb0125b1bc9ebb6e3dfa01453c5d6b07bdc6c2bf3c56a242bcd2e3383c6d6c003deacb033bf284b1bc3e60d03cf28431bd8ec147bc57fce9bcd2a71ebd4909153bb92912bdc3079f3c5f089bbc50bbf03cb3604dbb47e4353ccde52bbd628721bc64ac80bc0cec02bd6a404f3c8c24343a5684353dd33de0bb2d233d3cf2a2be3c6a5e5c3ca223babcf3ded83cd8ffd23c091af9bb2cc9953ce5eb83bc8be8193c502c813cb2e818bc74004fbc8a1de23ba1ab85bc7fe5adbcb42b053d5fcc803c1b8c02bd12262a3b7cb9fc3c9a88193d00cb893b4067a2bb2e0c023ce183b83cdc671e3cd9e8173dab6b85bd7d6627bc550c013dfbea89bd89a52dbd067d65bd78689abc2a681c3bf7a04bbc22eb083dcf28183d772c00bd7c0c80bc24f97ebdd26b84bbe1a145bb25a6a9bbbf9f533b552a0ebdb37edabc72bde23cb5a3b9bc63ff55bd0edc6bbd6ea89abb4429953ce3c6a4bb5cfaf6bcd5623f3bd2c5ab3cc47f533a2d41cabbffff51bc3adaf73bed68173d2381cabb32033dbb5e1fd6bb5d8914bd08c0d13c9aa626bb371fd7ba1c5e5ebc1b8c823dfe871dbcb929923cdb2b84bbf48b033ddb9ce63c3e60d0bc9f86a6bc89a52dbd8a1de23ca32a0cbcfea52abceee04b3ceae9103d49eb873c04e0d13c60804fbbc200cdbcca2a8bbc5fcc00bd2e9b713b0007a43a631de3bcd7a52b3a16e81cbb66baf6bba75d61bbc6a4b2bb0505b1bcb49c673c4f25afbc072a103cefab833bf98910bc502c813c77d97c3b36a7223c791ce9bc70eb86bd6a22c2bc38cc013cbc8a0bbd2825303c0125b1bc8f1befba371fd7bb2a86293dd9ca8a3b9d9de1bbfb08973cae26263d3b69953c82a04ebc1469963cc49d60bd1f6c02bdb2ca8bbb2ce722bcfbea89bcbf63393db13bee3c9c07203d50d97dbcdb9ce6bc1c22443d08489dbc16ca0fbd40c149bc6a40cfbca75d613b1c04b73cb342c03c698c00bc2861ca3cca9b6dbcadea0b3df31a73bc5aec00bda6c71fbc95a8193ce2197a3c5d6b873c1f6c82bc00e9963ce3e4b1bc0c281dbd00cb893c406722bb6b29943c6cbf55bb6f02423cd59e593c76433bbcabe3393ddec817bc83bedbbcadea8bbb9863babca1ab85bcb5c146bd0505b13c148723bc874434bad1dce63c14c33d3d2e0c82bbc25a743cd544b2bb3e42c3bc1fbf57bcd7a5abbba466a6bb208a0fbce6452b3cfa3ddf3bf4e5aa3c478a8ebc8e6720bd4067223c261e5e3dcf2898ba8e85adbcb6dfd3bcca9b6db958c721bd4c889bbc6e8a8d3cf57b6c3c6ea81a3ca241c7bcc1a6a53c4a8149bd69aa0dbba5deda3bf24817bd929af53a9ce9923db5679f3cd8e1453da1c9923bc200cdba56481bbcdb9ce6bbd7a52bbd929a75bcdb4911bc1001cbbcfe871dbc2120513da448993c917ce83ca5de5abc559bf03c1afde43ce4023fbb78c2c13bb87c673c1d0b89bce029913c0efaf83afea52a3cedc23e3db7e6a53cc923393c213ede3cf48b03bca01c68ba0ac723bc194916bc1c04b7bb067d65bc0623be3bcba2bf3cbe279f3bcda911bb9b00ce3cc6c2bfbce91e593c325d64bb502c01bde00b04bce888173c700914bd8726273c9727203cac0147bc42c89bbb94fb6ebd4ee9143d1ea14abc373de43c072a10bd3abceabc1fbfd7bc7b233b3daf4b05ba070c83bcf07d5f3c371fd7bc6f204fbb5921c93b6f204fbc03862a3b1c04b7bb9ae2c03c1d0b093c4820503d97eb853c2d414abd78689abcf26624ba6767a13b9ac433bd0edc6b3bc47fd33c35be5dbc20a81cbc9d252d3c318b083cd7c338bcda42bf3a61bc693cd7871e3cd4ea0a3c5666a83ae8a6a4bc9fc2c03bcba23f3ca3b97b3c75e913bcefc990bb72dbefbbfc9ed83c9ccb85bb2600d13cff1d5f3c0a8b093db5c1c6bc2a8629bd9d7f54bd77bb6f3cc8ab843d64e81a3da1e71f3dd580cc3c64e89abc02bb723c55b9fd3bc1a6a53c483e5d3d4322433b9fc240bcb206a6bdeb7fd2bc99f9fb3c1adf573cfa0145bc62a5aebae50911bda5dedabb719fd5bbe95af33b466c013d920b063d25c4363c6e8a8dbbc188183d208a0f3d52e04f3c93bf543c46bfd63c6767a13c6026283c662b073d6044b5bb8c7edb3c86ea8c3c4c881bba0aa916bad064b2bb7da241bbbc8a8b3c900434bb6f7af6bcc188983b8f397c3c35be5d3c1d9af83cb7aa0b3cb342c03c9727a0bb72dbefbbbd7af43b6ec627b9a982c0bb101f583c552a0ebb5186a83cbca898bcb06912bcc7e0ccbcac01c7bc851fd5bb6c47a1bcecd979bc3482433d40c149bc698c00ba7efce8bc2363bdbc478a8ebc7b7de2bb6e8a0dbd8969133d5666283c16062a3d9347a03c7f8b86bca1e71fbb1179ff3c2e9b713c38cc013cba65ac3b62c33bbcc686a5bc4ca6283c4049153da1ab053d3e60503d172437bb5dc52e3d27e915bc9140cebc1bc89c3c14a530bcf98910bda98240bc5fcc80bd3b8722bc292c02bcd0a0ccbc11cc02bd3689153c8d49933c8ea3babbb0871fbc7d84343c7181c8bc4bf9fdb978689a3c4f433cbc64e89abc292c023d105bf2bb99db6ebd8501c83cf041c53c1e47a3bc3482c3bc0d64373b3d06a93cdb4911bc2e0c023dfa3ddf3c56a2c23cad08193de86a8abcf266a4bc6b29143df764313b0f6b893c6ddd62bcd83bed3b8c24b4ba64ac00bbcbc04c3d67a33b3c7c2a8dbc15597fbc793af63cb5c146bdb360cd3bdf7c66bbb1e1c63c0f6b89bc11ea0fbd9602c13b4a452fba72f97c3ce1bf523c96204ebc3c3b71bc301a78bb0505b13c227af8bc08662abc25a629bb8bca0c3c9f6819bb22eb08bd89c33a3cb0871f3dbf45ac3b0ac7233cde04323deae9103d900434bd490915bd9ccb05bcdb2b04bd1fdd64bc05e7a33cda2432bc5441c93a588b873c5b64b53c9ae2403c7c0c003ce69fd23c3e24b63c12262a3aa6a912bd31c7223c84c52dbc6ee4b4ba25e243bd51c2423cca2a0b3cf8dce5bb3f2b083c6ec6a7bce509913b62a52e3b9845ad3a8ea3babb95e4b33cc668183b73a6a7bc741edcbc662b87bcbcc6a53b71633b3cbc8a8b3d8ea33a3c7fe52dbcb90b853c4429153caabeda3c1d0b89bc6b2994bba721c7bbf989903cb5852c3d94197c3ce93ce63a03862abda73fd43c51a4b53cd6daf33b7aab86baeb9d5fbd95c626bc13bc6b3c28433d3d922993bb5de3bb3b0cec82bc318b08bb1606aabce7f9f93cb61b6e3c718148bc81281abba964b3bc3dac013db5c1463caba79f3c9ce992bcb87c67bccf2818bbfb26243cdf22bf3c58c7213c27e9153dc7fe59bc2600d13a8fdf54bc08a2c4bc40852fbdce0339bc73a6273d46dde3bb31c722bd5dc5ae39eacb033d8affd4bb7ae7a03ca39b6e3cc6c2bfbcb2e898bc772c803cbbdd603c4ce2c23c38cc81bc49eb07bd67a3bb3cd64b04bd0edcebbc72f97c3b3d06293c769d623c22eb083ceae910bc700914bcd4ea0a3d00e996bbb44912bd4820503ce50911bceb9ddfbb69aa8dbc0ae5b0bcd7a52bbd631de3ba6406283c0edceb3b58c7213d36e3bcbce00b043c95a819bc958a0c3b2b1ceb3c287fd73cb61b6ebcbf452cbc4ca6a83b597bf0bc42aa0e3c9ce992bc5fea0dbdedc23ebc58a914bc1e65b03c83dc68bb101fd83b14c33dba09fc6b3c3399fe3a4d5af73cc3cb84bc37014abc4ecb87bba6a992ba373de43b5de3bbbbf60a0abc2fa2c33cf53fd23ca946a63c674994bcc5d9fa3c8b06a73bb3604d3c2f66a93b6406a83c8fdf543de645ab3cd2a79ebb5a99fdbb6dfbef3a0fa723ba3689153d3446a93c03c244bdfc62be3b00e996bba94626bd6767a13bc443b93c9845ad3c66ba763bc3cb84bb8c7e5b3c47e4353cb42b85bbe1bf523c14c33dbc11797f3b0fc530bc6a7ce93c884b863c8b06a73b3464363cb6dfd33955b9fd3b33997e3bfb08973c4cc4b5bc1afde4ba3926a93c741e5cbc4a452fbdd408983cac1fd4bcd1bed9bca80a8cbce8a6243b47c628bd97eb85bb0ebede3ce09a733c77d97c3aa4c0cdbb75cb863c1ea1caba11ea8f3c25a6a93c091af9babb197b3c4ee9943c492722bcc73a74bc79e0cebcb99af4bc091a79bc83dce83b24dbf13c769d62bb2d41cabc8f1bef3ce86a8abc75e913bda6c71f3c915e5b3d194916bc0b033e3cd769913a68fd62bcdc852bbcd408183c6b9a763c4ca6a8bc8987a0b94c6a0ebc4c6a8ebb4429153c0ae5b03c0ac7a3bb24dbf1bb2d41cabc4f6149bc2cc995bb81281abc7625ae3ceae9903bcd8b843c4ecb07bd8987a0bced86a43c67a3bb3c5aec803cf284b13c602628bdbca818bbc94146bcf57bec3b9ebb6e3cc5bb6dbc84c5ad3ce402bfbb017fd8bbb7aa0bbc256a0f3d239fd7bbfa0145bccb6625bc19a3bd3b6f3e5c3c83dc68bc146916bde681c5bc42c81bbcce03b93cdca3b8bb5d8914bdcda911bc38ea8e3c934720bdd906a53c375bf13b38cc013ceefe58bd2cc9153cd7871e3c1e47233c404995bb325d64bb3689953ba32a0c3b51c242bc8264b43caabedabc75cb06bdb85eda3cfb08173cecd9f9ba3ce1c93b02bbf23b3ba5af3c176051bc72dbef39cf2898bbe681c5bcc5bbed3ca8997bbb884b863a571a77bc1a397f3c11ea8f3c8d49133d89a52dbd9d7fd4bb8501c8bcf4e52a3c1b8c823cab6b053d215cebbb767f553c73881a3dfd4b03bdfea52a3ca448193bc805acbb478a8e3c9b3c683cfe6990bc070c03bd0d8244bc88da75bc6f5ce9bce1479e3c6a404fbbe681453c51a4353c2a8629bceb7fd2bb35faf7bbba652cbc2eb9febc6d19fd3cfe879d3b5b4628bd4ecb87bd1487a3bc4a9f563c08662abb4bbde33cf266a4bc42aa0ebc40a3bcbc7cb97c3c4909953c2bfe5dbc69aa0d3b0aa996bb884b86bbc54a8b3cb2e8983b606242bc428c013b4a9fd63c5a281b3d25c436bc63ff553c0884b73c6a5edcbc22eb08bd2600d13c47c6a8bc6ea89abc6b2914bc6044b5bca0e04d3c9c07203caf4b853ced68173d40c1493c0c289d3c244c82bcf3ded8bbbcc6253cb2ca0b3d9e4a0cbd8282c1bca32a0cbcf48b83bc36a7a2bb72f9fcbb6c652ebdc1a6a5bcd7a5ab3b2e2a8fbcd59e59bc466c01bc16ac823cda7e59bc75e993bc1967233dd1dce63c0ac7a33cb37e5abcd81d60bc67c1c8b99a88993c83be5bbc11ea0f3a153bf2bcc71c67bc2fc0503d0fc5b0bbc46146bc3464b6ba294a8f3c55b9fd3afe879dbc4c889b3c8ec147bcc0dbedbc4b4c01bd504a0ebd485c6a3b6839fdbc4a9fd6bb76252ebc75e913bc95e4b33c', 'Array(Float32)'));

SELECT '-- Brute-force scan';

SELECT id FROM dbpedia
ORDER BY cosineDistance(vec, (SELECT vec FROM dbpedia WHERE id = '<dbpedia:Honda>'))
LIMIT 4
SETTINGS use_skip_indexes = 0;

SELECT '-- Approximate nearest neighbor search';

SELECT id FROM dbpedia
ORDER BY cosineDistance(vec, (SELECT vec FROM dbpedia WHERE id = '<dbpedia:Honda>'))
LIMIT 4;

SELECT '-- Verify the vector index is used';

SELECT trimLeft(explain) AS explain FROM (
    EXPLAIN indexes = 1
    SELECT id FROM dbpedia
    ORDER BY cosineDistance(vec, (SELECT vec FROM dbpedia WHERE id = '<dbpedia:Honda>'))
    LIMIT 4
)
WHERE explain LIKE '%vector_similarity%';

SELECT '-- Run a couple more ANN queries';

SELECT id FROM dbpedia
ORDER BY cosineDistance(vec, (SELECT vec FROM dbpedia WHERE id = '<dbpedia:Pizza>'))
LIMIT 4;

SELECT id FROM dbpedia
ORDER BY cosineDistance(vec, (SELECT vec FROM dbpedia WHERE id = '<dbpedia:Database_theory>'))
LIMIT 4;

SELECT '-- Verify the index is small';
-- Check that an index with binary quantization (1 bit / dimension) is smaller than an index with BFloat16 (2 bytes / dimension)

SELECT if(data_uncompressed_bytes < (20 * 1536 * 2), 'Good', toString(data_uncompressed_bytes))
FROM system.data_skipping_indices
WHERE database = currentDatabase() AND name = 'vec_idx';

DROP TABLE dbpedia;

-- Now test that a rescoring multiplier > 1.0 helps with search accuracy
DROP TABLE IF EXISTS tab;
CREATE TABLE tab
(
    id Int32,
    vec Array(Float32),
    INDEX vec_idx vec TYPE vector_similarity('hnsw', 'cosineDistance', 8, 'b1', 64, 128)
) ENGINE = MergeTree
ORDER BY id
SETTINGS index_granularity = 1;

INSERT INTO tab VALUES
    (1, [-0.50, 0.50, -0.75, 0.95, 0.9, 0.9, 0.9, 0.9]),
    (2, [-0.20, 0.30, -0.05, -0.08, 0.9, 0.9, 0.9, 0.9]),
    (3, [-0.25, -0.25, -0.25, -0.25, 0.9, 0.9, 0.9, 0.9]),
    (4, [0.20, -0.50, -0.75, -0.95, 0.9, 0.9, 0.9, 0.9]);

-- Binary quantization of above vectors :
-- 1, [0, 1, 0, 1, 1, 1, 1, 1]
-- 2, [0, 1, 0, 0, 1, 1, 1, 1]
-- 3, [0, 0, 0, 0, 1, 1, 1, 1]
-- 4, [1, 0, 0, 0, 1, 1, 1, 1]

-- Query vector is [0, 1, 1, 1, 1, 1, 1, 1]
-- As per hamming distance used in bq index, Row #1 is at distance 1 from the query vector and
-- Row #2 is at distance 2 from the query vector. But Row #2 is nearer as per cosine similarity on
-- full precision vector. By rescoring, we will get the correct nearest neighbour as 2.

SELECT '-- Result without rescoring';
-- Expect 1.
SELECT id,
FROM tab
ORDER by cosineDistance(vec, [-0.25, 0.25, 0.10, 0.10, 0.9, 0.9, 0.9, 0.9])
LIMIT 1
SETTINGS vector_search_with_rescoring = 0;

SELECT '-- Result with rescoring';
-- Expect 2
SELECT id
FROM tab
ORDER by cosineDistance(vec, [-0.25, 0.25, 0.10, 0.10, 0.9, 0.9, 0.9, 0.9])
LIMIT 1
SETTINGS vector_search_with_rescoring = 1,
         vector_search_index_fetch_multiplier = 4;

DROP TABLE tab;
