DROP TABLE IF EXISTS fct_rt_dc_shop_sku_vender_day;

create table fct_rt_dc_shop_sku_vender_day
(
    stat_year UInt16,
    stat_month UInt32,
    stat_day Date,
    out_buid UInt8,
    out_shop_id String,
    in_shop_id LowCardinality(String),
    datasource UInt8,
    venderid String,
    categorytreeid UInt8,
    categoryid String,
    goodsid LowCardinality(String),
    logistics UInt8,
    buntype UInt8,
    dctype UInt8,
    shopformid UInt8,
    rt_qty Decimal(18,4),
    rt_cost Decimal(18,4),
    rt_taxcost Decimal(18,4),
    rt_boxes Decimal(18,4),
    rt_shops Nullable(String),
    rt_drygood_qty Decimal(18,4),
    rt_drygood_cost Decimal(18,4),
    rt_drygood_boxes Decimal(18,4),
    rt_drygood_shops LowCardinality(Nullable(String)),
    rt_fresh_qty Decimal(18,4),
    rt_fresh_cost Decimal(18,4),
    rt_fresh_shops LowCardinality(Nullable(String)),
    rt_supshop_cost Decimal(18,4),
    rt_supshop_qty Decimal(18,4),
    rt_supshop_boxes Decimal(18,4),
    rt_supshop_shops LowCardinality(Nullable(String)),
    rt_smallshop_cost Decimal(18,4),
    rt_smallshop_qty Decimal(18,4),
    rt_smallshop_boxes Decimal(18,4),
    rt_smallshop_shops LowCardinality(Nullable(String)),
    rt_dc_cost Decimal(18,4),
    rt_dc_qty Decimal(18,4),
    rt_dc_boxes Decimal(18,4),
    rt_dc_shops LowCardinality(Nullable(String)),
    rt_drygood_supshop_cost Decimal(18,4),
    rt_drygood_supshop_qty Decimal(18,4),
    rt_drygood_supshop_boxes Decimal(18,4),
    rt_drygood_supshop_shops LowCardinality(Nullable(String)),
    rt_drygood_smallshop_cost Decimal(18,4),
    rt_drygood_smallshop_qty Decimal(18,4),
    rt_drygood_smallshop_boxes Decimal(18,4),
    rt_drygood_smallshop_shops LowCardinality(Nullable(String)),
    rt_drygood_dc_cost Decimal(18,4),
    rt_drygood_dc_qty Decimal(18,4),
    rt_drygood_dc_boxes Decimal(18,4),
    rt_drygood_dc_shops LowCardinality(Nullable(String)),
    rt_fresh_supshop_cost Decimal(18,4),
    rt_fresh_supshop_qty Decimal(18,4),
    rt_fresh_supshop_shops LowCardinality(Nullable(String)),
    rt_fresh_smallshop_cost Decimal(18,4),
    rt_fresh_smallshop_qty Decimal(18,4),
    rt_fresh_smallshop_shops LowCardinality(Nullable(String)),
    rt_fresh_dc_cost Decimal(18,4),
    rt_fresh_dc_qty Decimal(18,4),
    rt_fresh_dc_shops LowCardinality(Nullable(String)),
    stat_day_num String default formatDateTime(stat_day, '%F')
)
engine = MergeTree PARTITION BY toYYYYMM(stat_day) ORDER BY (stat_day, out_shop_id) SETTINGS index_granularity = 8192
;


select stat_year,
       stat_month,
       out_buid,
       out_shop_id,
       in_shop_id,
       datasource,
       venderid,
       categorytreeid,
       categoryid,
       goodsid,
       logistics,
       buntype,
       dctype,
       shopformid,
       sum(rt_qty),
       sum(rt_cost),
       sum(rt_taxcost),
       sum(rt_boxes),
       max(rt_shops),
       sum(rt_drygood_qty),
       sum(rt_drygood_cost),
       sum(rt_drygood_boxes),
       max(rt_drygood_shops),
       sum(rt_fresh_qty),
       sum(rt_fresh_cost),
       max(rt_fresh_shops),
       sum(rt_supshop_cost),
       sum(rt_supshop_qty),
       sum(rt_supshop_boxes),
       max(rt_supshop_shops),
       sum(rt_smallshop_cost),
       sum(rt_smallshop_qty),
       sum(rt_smallshop_boxes),
       max(rt_smallshop_shops),
       sum(rt_dc_cost),
       sum(rt_dc_qty),
       sum(rt_dc_boxes),
       max(rt_dc_shops),
       sum(rt_drygood_supshop_cost),
       sum(rt_drygood_supshop_qty),
       sum(rt_drygood_supshop_boxes),
       max(rt_drygood_supshop_shops),
       sum(rt_drygood_smallshop_cost),
       sum(rt_drygood_smallshop_qty),
       sum(rt_drygood_smallshop_boxes),
       max(rt_drygood_smallshop_shops),
       sum(rt_drygood_dc_cost),
       sum(rt_drygood_dc_qty),
       sum(rt_drygood_dc_boxes),
       max(rt_drygood_dc_shops),
       sum(rt_fresh_supshop_cost),
       sum(rt_fresh_supshop_qty),
       max(rt_fresh_supshop_shops),
       sum(rt_fresh_smallshop_cost),
       sum(rt_fresh_smallshop_qty),
       max(rt_fresh_smallshop_shops),
       sum(rt_fresh_dc_cost),
       sum(rt_fresh_dc_qty),
       max(rt_fresh_dc_shops)
from fct_rt_dc_shop_sku_vender_day frdssvd
where stat_day >= toDate('2016-01-01')
  and stat_day < addMonths(toDate('2016-01-01'), 1)
group by stat_year,
         stat_month,
         out_buid,
         out_shop_id,
         in_shop_id,
         datasource,
         venderid,
         categorytreeid,
         categoryid,
         goodsid,
         logistics,
         buntype,
         dctype,
         shopformid;

DROP TABLE fct_rt_dc_shop_sku_vender_day;
