#!/usr/bin/env bash

CURDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
CLICKHOUSE_CLIENT_SERVER_LOGS_LEVEL=none
# shellcheck source=../shell_config.sh
. "$CURDIR"/../shell_config.sh

$CLICKHOUSE_CLIENT --query="""
	SELECT * FROM (SELECT number % 5 AS a, count() AS b, c FROM numbers(10)
		ARRAY JOIN [1,2] AS c GROUP BY a,c) AS table
	ORDER BY a LIMIT 3 WITH TIES BY a""" 2>&1 | grep -q "Code: 498." && echo 'OK' || echo 'FAIL' ||:

$CLICKHOUSE_CLIENT --query="""
	SELECT * FROM VALUES('Phrase String, Payload String',
		('hello', 'x'), ('world', 'x'), ('hello', 'z'),
		('upyachka', 'a'), ('test', 'b'), ('foo', 'c'),
		('bar', 'd'))
	ORDER BY Payload LIMIT 1 WITH TIES BY Phrase LIMIT 5;""" 2>&1 | grep -q "Code: 498." && echo 'OK' || echo 'FAIL' ||:

$CLICKHOUSE_CLIENT --query="""
	SELECT * FROM
	(
		SELECT * FROM VALUES('Phrase String, Payload String',
				('hello', 'x'), ('world', 'x'), ('hello', 'z'),
				('upyachka', 'a'), ('test', 'b'), ('foo', 'c'),
				('bar', 'd'))
		ORDER BY Payload LIMIT 1 BY Phrase LIMIT 5 WITH TIES
	) ORDER BY Payload, Phrase
	"""

$CLICKHOUSE_CLIENT --query="""
	SELECT * FROM
	(
		SELECT TOP 5 WITH TIES * FROM VALUES('Phrase String, Payload String',
				('hello', 'x'), ('world', 'x'), ('hello', 'z'),
				('upyachka', 'a'), ('test', 'b'), ('foo', 'c'),
				('bar', 'd'))
		ORDER BY Payload LIMIT 1 BY Phrase
	) ORDER BY Payload, Phrase
	"""
