# Простые задачи

## Недостатки юзабилити, если пользователь не может прочитать конфиг клиента.

`programs/client/Client.cpp`

Делаем `chmod 000 /etc/clickhouse-client/config.xml` и смотрим, что получится.

## + Уменьшать max_memory_usage, если на сервере мало оперативки.

Смотрим, сколько на сервере оперативки. Если `max_memory_usage`, `max_memory_usage_for_all_queries` ограничены, но больше 90% (настройка) от имеющейся оперативки, то уменьшать их и выводить предупреждение в лог..

`programs/server/Server.cpp` - инициализация сервера, установка размера кэшей

`getMemoryAmount.h` - информация о доступной оперативке

`context.setSetting` - для выставления `max_memory_usage` и других.

## + Битовые операции для FixedString.

bitAnd, bitOr, bitNot, bitXor для значения типа FixedString, интерпретируемого как набор бит.

Сделайте сначала в C++ побитовые функции для работы с куском памяти:
```
void memoryBitAnd(const char * a, const char * b, char * result, size_t size);
```
Потом используйте их в вашей функции.

## + Добавить generic вариант функций least, greatest.

`SELECT least(123, 456)` - работает.

`SELECT least('123', '456')` - не работает. Надо сделать.

Делаем с помощью `IColumn::compareAt` для одинаковых типов и с помощью `castColumn`, `getLeastSuperType` для разных.

## При ATTACH кусков, проверять владельца файлов.

Смотрим, что все файлы в прикрепляемых кусках от правильного пользователя.

## + COLLATE должно работать для Nullable(String).

В ClickHouse есть возможность указать collation для сортировки строк. Это не работает для `Nullable(String)`.

## + Запретить чтение значений типа AggregateFunction по-умолчанию и добавить настройку.

Состояния агрегатных функций могут быть записаны в дамп и считаны из него. Но десериализация состояний агрегатных функций небезопасна. Аккуратно выбранные пользовательские данные могут привести к segfault или порче памяти. Поэтому нужно просто сделать настройку, которая запрещает читать AggregateFunction из пользовательских данных.

Upd: сделали по-другому: теперь всё безопасно.

## + В статистику jemalloc добавить информацию по arenas.

В `system.asynchronous_metrics` - суммарный размер арен.

# Более сложные задачи

## + Layout внешних словарей "direct".

Как cache, но без кэша — всегда прямой запрос в источник.

## + Функции randomFixedString, randomBinaryString, fuzzBits, fuzzBytes.

## + Агрегатные функции для статистических тестов (e.g. тест нормальности распределения) и статистик.

## + Функции создания и обновления состояния агрегатной функции по одному кортежу аргументов.

В ClickHouse есть понятие - состояние вычисления агрегатной функции. Состояния агрегатных функций можно записывать в таблицы, складывать, финализировать и т. п. https://clickhouse.com/docs/ru/data_types/nested_data_structures/aggregatefunction/

Получить состояние агрегатной функции можно с помощью комбинатора State: https://clickhouse.com/docs/ru/query_language/agg_functions/combinators/#-state Но хотелось бы добавить ещё более простой способ получения состояния агрегатной функции.

Например:

`createAggregationState('groupArray')` - создать пустое (начальное) состояние агрегатной функции.

`createAggregationState('groupArray', 1)` - создать состояние агрегатной функции, в котором агрегировано одно значение 1.

`createAggregationState('argMax', ('hello', 123))` - то же самое для агрегатных функций, принимающих несколько аргументов.

## LEFT ONLY JOIN

## + Функции makeDate, makeDateTime.

`makeDate(year, month, day)`
`makeDateTime(year, month, day, hour, minute, second, [timezone])`

## Функции changeYear, changeMonth, ...

`changeYear(datetime, 2019)`

## + Исправить мерцание прогресс-бара в clickhouse-client.

Это заметно при работе с серверами с большим пингом.
Прогресс бар не должен мерцать.
Наверное, надо просто вместо очистки строки, перемещать курсор в начало, не очищая её.

## Функция rowNumberForKey.

Возвращает инкрементальное число для повторно встречающихся значений key.

## Функции DATE_ADD, DATE_SUB как синонимы для совместимости с SQL.

https://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html#function_date-add

## Функции positionReverse, positionUTF8Reverse, positionCaseInsensitiveReverse, positionCaseInsensitiveUTF8Reverse.

position с конца строки.

## + Функция indexOf должна поддерживать Enum-ы без cast-а.

`indexOf(arr, 'hello')`, `indexOf(arr, 1)` должны работать, если arr имеет тип `Array(Enum8('hello' = 1, 'world' = 2))`

## + Комбинатор агрегатных функций Distinct.

Пример: `avgDistinct(x)` - вычислить среднее по всем различным переданным значениям.

## + Метрики количества ошибок.

Добавляем счётчики всех ошибок (ErrorCodes) по аналогии с ProfileEvents. Кроме количества запоминаем также время последней ошибки, стек трейс, сообщение. Добавляем системную таблицу system.errors. Отправка в Graphite.

## + Добавить Lizard, LZSSE и density в качестве вариантов алгоритмов сжатия.

Экспериментальные алгоритмы сжатия. Сейчас ClickHouse поддерживает только lz4 и zstd.

## + Запрос CREATE OR REPLACE TABLE

Атомарно удаляет таблицу перед созданием новой, если такая была.

## + Приведение типов для IN (subquery).

`SELECT 1 IN (SELECT -1 UNION ALL SELECT 1)`

- сейчас не работает.

## Возможность вставки значений типа AggregateFunction в виде кортежа значений аргументов, а не бинарного дампа состояния, под настройкой.

Во входных данных в запросе INSERT должна быть возможность передать значение типа AggregateFunction не в виде сериализованного состояния, а в виде аргументов, которые будут агрегированы, для формирования этого состояния.

## Возможность использовать ALIAS столбцы при INSERT.

https://clickhouse.com/docs/query_language/create/#create-table

`INSERT INTO table (column1, column2, ...)`

- если column - это ALIAS столбец, и если выражение для ALIAS тривиально (просто ссылается на другой столбец), то разрешить использовать его вместо другого столбца в запросе INSERT.

## Запрос ALTER TABLE LOCK/UNLOCK PARTITION.

Запретить модификацию данных в партиции. На партицию ставится флаг, что она заблокирована. В неё нельзя делать INSERT и ALTER. С файлов снимается доступ на запись.

Upd: не нужно.

## Настройка join_use_nulls: поддержка для LEFT ARRAY JOIN.

## + Внешние словари из Aerospike/Couchbase/Cassandra (на выбор).

Подключить одну из key-value БД как источник.

Upd: сделали Redis, Cassandra, MongoDB.

## + Движок таблиц Mongo, табличная функция mongo.

Возможность легко импортировать данные из MongoDB.

## Корректная обработка multiline значений в Pretty форматах.
SELECT 'hello\nworld' AS x, 123 AS y
```
┌─x──────────┬───y─┐
│ hello
world │ 123 │
└────────────┴─────┘
```
А надо так:
```
┌─x─────┬───y─┐
│ hello…│ 123 │
│…world │     │
└───────┴─────┘
```

## Работоспособность внешних данных на время сессии.

https://clickhouse.com/docs/operations/table_engines/external_data/

Не работает, если открыть clickhouse-client в интерактивном режиме и делать несколько запросов.

## Настройка для возможности получить частичный результат при cancel-е.

Хотим по Ctrl+C получить те данные, которые успели обработаться.

## Раскрытие кортежей в функциях высшего порядка.

## + Табличная функция loop.

`SELECT * FROM loop(database, table)`

Читает данные из таблицы в бесконечном цикле.

## Возможность ATTACH партиции с меньшим или большим количеством столбцов.

## + Поддержка неконстантного аргумента с тайм-зоной у некоторых функций для работы с датой и временем.

## + Возможность задавать параметры соединений для табличных функций, движков таблиц и для реплик из отдельных разделов конфигурации.

## + Настройка rollup_use_nulls.

Upd: it is named "group_by_use_nulls".

## + Настройка cast_keep_nullable.

## Функция bitEquals для сравнения произвольных типов данных побитово

## Функция serialize для implementation specific non portable non backwards compatible сериализации любого типа данных в набор байт.
