#pragma once

#include <DataTypes/IDataType.h>
#include <Interpreters/StorageID.h>
#include <Parsers/Prometheus/PrometheusQueryTree.h>
#include <Storages/TimeSeries/PrometheusQueryEvaluationRange.h>


namespace DB
{
class ColumnsDescription;

/// Converts a parsed prometheus query to SQL.
class PrometheusQueryToSQLConverter
{
public:
    /// Information about a TimeSeries table.
    struct TimeSeriesTableInfo
    {
        StorageID storage_id = StorageID::createEmpty();
        DataTypePtr timestamp_data_type;
        DataTypePtr value_data_type;
    };

    PrometheusQueryToSQLConverter(const PrometheusQueryTree & promql_,
                                  const TimeSeriesTableInfo & time_series_table_info_,
                                  const Field & lookback_delta_,
                                  const Field & default_resolution_);

    /// Sets the evaluation time.
    void setEvaluationTime(const Field & time_);

    /// Sets that the query should be evaluated over a range of time.
    void setEvaluationRange(const PrometheusQueryEvaluationRange & range_);

    /// Builds an AST to execute this prometheus query.
    ASTPtr getSQL() const;

    /// Returns the names and types of columns returned by the SQL query generated by function getSQL().
    ColumnsDescription getResultColumns() const;

private:
    class ASTBuilder;

    PrometheusQueryTree promql;
    TimeSeriesTableInfo time_series_table_info;
    Field lookback_delta;
    Field default_resolution;

    Field evaluation_time;
    PrometheusQueryEvaluationRange evaluation_range;

    PrometheusQueryResultType result_type;
};

}
