---
description: 'Documentation for Comparison Functions'
sidebar_label: 'Comparison'
slug: /sql-reference/functions/comparison-functions
title: 'Comparison Functions'
---

# Comparison functions

## Comparison rules {#comparison-rules}

The comparison functions below return `0` or `1` with type [UInt8](/sql-reference/data-types/int-uint). Only values within the same group can be 
compared (e.g. `UInt16` and `UInt64`) but not across groups (e.g. `UInt16` and `DateTime`). 
Comparison of numbers and strings are possible, as is comparison of strings with dates and dates with times. 
For tuples and arrays, the comparison is lexicographic meaning that the comparison is made for each corresponding 
element of the left side and right side tuple/array. 

The following types can be compared:
- numbers and decimals
- strings and fixed strings
- dates
- dates with times
- tuples (lexicographic comparison)
- arrays (lexicographic comparison)

:::note
Strings are compared byte-by-byte. This may lead to unexpected results if one of the strings contains UTF-8 encoded multi-byte characters.
A string S1 which has another string S2 as prefix is considered longer than S2.
:::

<!-- 
The inner content of the tags below are replaced at doc framework build time with 
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->
